/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.dynamic.zaa;
import com.google.android.gms.dynamic.zab;
import com.google.android.gms.dynamic.zac;
import com.google.android.gms.dynamic.zad;
import com.google.android.gms.dynamic.zae;
import com.google.android.gms.dynamic.zaf;
import com.google.android.gms.dynamic.zag;
import com.google.android.gms.dynamic.zah;
import java.util.LinkedList;

@KeepForSdk
public abstract class DeferredLifecycleHelper<T extends LifecycleDelegate> {
    private LifecycleDelegate zaa;
    @Nullable
    private Bundle zab;
    private LinkedList zac;
    private final OnDelegateCreatedListener zad;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        void var3_3;
        void var2_2;
        void var1_1;
        FrameLayout frameLayout = new FrameLayout(var1_1.getContext());
        zad zad2 = new zad(this, frameLayout, (LayoutInflater)var1_1, (ViewGroup)var2_2, (Bundle)var3_3);
        this.zaf((Bundle)var3_3, zad2);
        if (this.zaa == null) {
            this.handleGooglePlayUnavailable(frameLayout);
        }
        return frameLayout;
    }

    @KeepForSdk
    @NonNull
    public T getDelegate() {
        return (T)this.zaa;
    }

    @KeepForSdk
    public DeferredLifecycleHelper() {
        zaa zaa2 = new zaa(this);
        this.zad = zaa2;
    }

    @KeepForSdk
    protected abstract void createDelegate(@NonNull OnDelegateCreatedListener<T> var1);

    @KeepForSdk
    protected void handleGooglePlayUnavailable(@NonNull FrameLayout parent) {
        DeferredLifecycleHelper.showGooglePlayUnavailableMessage(parent);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void onCreate(@Nullable Bundle savedInstanceState) {
        void var1_1;
        zac zac2 = new zac(this, (Bundle)var1_1);
        this.zaf((Bundle)var1_1, zac2);
    }

    @KeepForSdk
    public void onDestroy() {
        LifecycleDelegate lifecycleDelegate = this.zaa;
        if (lifecycleDelegate != null) {
            lifecycleDelegate.onDestroy();
            return;
        }
        this.zae(1);
    }

    @KeepForSdk
    public void onDestroyView() {
        LifecycleDelegate lifecycleDelegate = this.zaa;
        if (lifecycleDelegate != null) {
            lifecycleDelegate.onDestroyView();
            return;
        }
        this.zae(2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void onInflate(@NonNull Activity activity, @NonNull Bundle attrs, @Nullable Bundle savedInstanceState) {
        void var3_3;
        void var2_2;
        void var1_1;
        zab zab2 = new zab(this, (Activity)var1_1, (Bundle)var2_2, (Bundle)var3_3);
        this.zaf((Bundle)var3_3, zab2);
    }

    @KeepForSdk
    public void onLowMemory() {
        LifecycleDelegate this_ = ((DeferredLifecycleHelper)((Object)this_)).zaa;
        if (this_ != null) {
            this_.onLowMemory();
            return;
        }
    }

    @KeepForSdk
    public void onPause() {
        LifecycleDelegate lifecycleDelegate = this.zaa;
        if (lifecycleDelegate != null) {
            lifecycleDelegate.onPause();
            return;
        }
        this.zae(5);
    }

    @KeepForSdk
    public void onResume() {
        zag zag2 = new zag(this);
        this.zaf(null, zag2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void onSaveInstanceState(@NonNull Bundle outState) {
        void var1_1;
        LifecycleDelegate lifecycleDelegate = ((DeferredLifecycleHelper)((Object)this_)).zaa;
        if (lifecycleDelegate != null) {
            lifecycleDelegate.onSaveInstanceState((Bundle)var1_1);
            return;
        }
        Bundle this_ = ((DeferredLifecycleHelper)((Object)this_)).zab;
        if (this_ != null) {
            var1_1.putAll(this_);
            return;
        }
    }

    @KeepForSdk
    public void onStart() {
        zaf zaf2 = new zaf(this);
        this.zaf(null, zaf2);
    }

    @KeepForSdk
    public void onStop() {
        LifecycleDelegate lifecycleDelegate = this.zaa;
        if (lifecycleDelegate != null) {
            lifecycleDelegate.onStop();
            return;
        }
        this.zae(4);
    }

    @KeepForSdk
    public static void showGooglePlayUnavailableMessage(@NonNull FrameLayout parent) {
        Object object;
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        Context context = object.getContext();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        String string2 = com.google.android.gms.common.internal.zac.zad(context, n);
        String string3 = com.google.android.gms.common.internal.zac.zac(context, n);
        LinearLayout linearLayout = new LinearLayout(object.getContext());
        linearLayout.setOrientation(1);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        object.addView((View)linearLayout);
        layoutParams = new TextView(object.getContext());
        object = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.setLayoutParams((ViewGroup.LayoutParams)object);
        layoutParams.setText((CharSequence)string2);
        linearLayout.addView((View)layoutParams);
        object = googleApiAvailability.getErrorResolutionIntent(context, n, null);
        if (object != null) {
            googleApiAvailability = new Button(context);
            googleApiAvailability.setId(16908313);
            Object object2 = new FrameLayout.LayoutParams(-2, -2);
            googleApiAvailability.setLayoutParams((ViewGroup.LayoutParams)object2);
            googleApiAvailability.setText(string3);
            linearLayout.addView((View)((Object)googleApiAvailability));
            object2 = new zae(context, (Intent)object);
            googleApiAvailability.setOnClickListener((View.OnClickListener)object2);
            return;
        }
    }

    static /* bridge */ /* synthetic */ LifecycleDelegate zaa(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zaa;
    }

    static /* bridge */ /* synthetic */ LinkedList zab(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zac;
    }

    static /* bridge */ /* synthetic */ void zac(DeferredLifecycleHelper deferredLifecycleHelper, LifecycleDelegate lifecycleDelegate) {
        deferredLifecycleHelper.zaa = lifecycleDelegate;
    }

    static /* bridge */ /* synthetic */ void zad(DeferredLifecycleHelper deferredLifecycleHelper, Bundle bundle) {
        deferredLifecycleHelper.zab = null;
    }

    private final void zae(int n) {
        while (!this.zac.isEmpty() && ((zah)this.zac.getLast()).zaa() >= n) {
            this.zac.removeLast();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zaf(@Nullable Bundle bundle, zah object) {
        Object object2 = this.zaa;
        if (object2 != null) {
            object.zab((LifecycleDelegate)object2);
            return;
        }
        if (this.zac == null) {
            this.zac = object2 = new Object();
        }
        this.zac.add(object);
        if (bundle != null) {
            object = this.zab;
            if (object == null) {
                this.zab = (Bundle)bundle.clone();
            } else {
                object.putAll(bundle);
            }
        }
        this.createDelegate(this.zad);
    }
}

