/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.Storage;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zat;
import com.google.android.gms.signin.internal.zae;
import com.google.android.gms.signin.internal.zaf;
import com.google.android.gms.signin.internal.zai;
import com.google.android.gms.signin.internal.zak;

@KeepForSdk
public class SignInClientImpl
extends GmsClient<zaf>
implements com.google.android.gms.signin.zae {
    private final boolean zab;
    private final ClientSettings zac;
    private final Bundle zad;
    @Nullable
    private final Integer zae;
    public static final /* synthetic */ int zaa;

    @Override
    public final int getMinApkVersion() {
        return 12451000;
    }

    @KeepForSdk
    @NonNull
    public static Bundle createBundleFromClientSettings(@NonNull ClientSettings clientSettings) {
        ClientSettings clientSettings2;
        clientSettings.zaa();
        Integer n = clientSettings2.zab();
        Bundle bundle = new Bundle();
        bundle.putParcelable("com.google.android.gms.signin.internal.clientRequestedAccount", (Parcelable)clientSettings2.getAccount());
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n);
        }
        bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", false);
        bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", false);
        bundle.putString("com.google.android.gms.signin.internal.serverClientId", null);
        bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", true);
        bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", false);
        bundle.putString("com.google.android.gms.signin.internal.hostedDomain", null);
        bundle.putString("com.google.android.gms.signin.internal.logSessionId", null);
        bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", false);
        return bundle;
    }

    @Override
    @NonNull
    protected final Bundle getGetServiceRequestExtraArgs() {
        Object object = this.zac;
        object = ((ClientSettings)object).getRealClientPackageName();
        if (!this.getContext().getPackageName().equals(object)) {
            this.zad.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zac.getRealClientPackageName());
        }
        return this.zad;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NonNull
    protected final /* synthetic */ IInterface createServiceInterface(@NonNull IBinder iBinder) {
        if (iBinder == null) {
            return null;
        }
        IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.signin.internal.ISignInService");
        if (!(iInterface instanceof zaf)) return new zaf(iBinder);
        return (zaf)iInterface;
    }

    @Override
    @NonNull
    protected final String getServiceDescriptor() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    @Override
    @NonNull
    protected final String getStartServiceAction() {
        return "com.google.android.gms.signin.service.START";
    }

    public SignInClientImpl(@NonNull Context context, @NonNull Looper looper, boolean bl, @NonNull ClientSettings clientSettings, @NonNull Bundle bundle, @NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks, @NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zab = true;
        this.zac = clientSettings;
        this.zad = bundle;
        this.zae = clientSettings.zab();
    }

    @Override
    public final boolean requiresSignIn() {
        return this.zab;
    }

    @Override
    public final void zaa() {
        try {
            ((zaf)this.getService()).zae(Preconditions.checkNotNull(this.zae));
            return;
        }
        catch (RemoteException remoteException) {
            Log.w("SignInClientImpl", "Remote service probably died when clearAccountFromSessionStore is called");
            return;
        }
    }

    @Override
    public final void zab() {
        BaseGmsClient.LegacyClientCallbackAdapter legacyClientCallbackAdapter = new BaseGmsClient.LegacyClientCallbackAdapter(this);
        this.connect(legacyClientCallbackAdapter);
    }

    @Override
    public final void zac(@NonNull IAccountAccessor iAccountAccessor, boolean bl) {
        try {
            ((zaf)this.getService()).zaf(iAccountAccessor, Preconditions.checkNotNull(this.zae), bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w("SignInClientImpl", "Remote service probably died when saveDefaultAccount is called");
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void zad(zae zae2) {
        Preconditions.checkNotNull(zae2, "Expecting a valid ISignInCallbacks");
        try {
            void var2_7;
            Account account = ((SignInClientImpl)((Object)zaf2)).zac.getAccountOrDefault();
            boolean bl = "<<default account>>".equals(account.name);
            if (bl) {
                GoogleSignInAccount googleSignInAccount = Storage.getInstance(((BaseGmsClient)((Object)zaf2)).getContext()).getSavedDefaultGoogleSignInAccount();
            } else {
                Object var2_9 = null;
            }
            Integer n = ((SignInClientImpl)((Object)zaf2)).zae;
            zat zat2 = new zat(account, Preconditions.checkNotNull(n), (GoogleSignInAccount)var2_7);
            zaf zaf2 = (zaf)((BaseGmsClient)((Object)zaf2)).getService();
            zai zai2 = new zai(1, zat2);
            zaf2.zag(zai2, zae2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w("SignInClientImpl", "Remote service probably died when signIn is called");
            try {
                ConnectionResult connectionResult = new ConnectionResult(8, null);
                zak zak2 = new zak(1, connectionResult, null);
                zae2.zab(zak2);
                return;
            }
            catch (RemoteException remoteException2) {
                Log.wtf("SignInClientImpl", "ISignInCallbacks#onSignInComplete should be executed from the same process, unexpected RemoteException.", remoteException);
                return;
            }
        }
    }
}

