/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics.connector;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface AnalyticsConnector {
    @KeepForSdk
    public void logEvent(@NonNull String var1, @NonNull String var2, Bundle var3);

    @KeepForSdk
    public void setUserProperty(@NonNull String var1, @NonNull String var2, Object var3);

    @WorkerThread
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean var1);

    @KeepForSdk
    public AnalyticsConnectorHandle registerAnalyticsConnectorListener(String var1, AnalyticsConnectorListener var2);

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull ConditionalUserProperty var1);

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String var1, @Nullable String var2, @Nullable Bundle var3);

    @WorkerThread
    @KeepForSdk
    public List<ConditionalUserProperty> getConditionalUserProperties(@NonNull String var1, @Nullable @Size(min=1L, max=23L) String var2);

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String var1);

    @KeepForSdk
    public static class ConditionalUserProperty {
        @KeepForSdk
        public String origin;
        @KeepForSdk
        public String name;
        @KeepForSdk
        public Object value;
        @KeepForSdk
        public String triggerEventName;
        @KeepForSdk
        public long triggerTimeout;
        @KeepForSdk
        public String timedOutEventName;
        @KeepForSdk
        public Bundle timedOutEventParams;
        @KeepForSdk
        public String triggeredEventName;
        @KeepForSdk
        public Bundle triggeredEventParams;
        @KeepForSdk
        public long timeToLive;
        @KeepForSdk
        public String expiredEventName;
        @KeepForSdk
        public Bundle expiredEventParams;
        @KeepForSdk
        public long creationTimestamp;
        @KeepForSdk
        public boolean active;
        @KeepForSdk
        public long triggeredTimestamp;
    }

    @KeepForSdk
    public static interface AnalyticsConnectorHandle {
        @KeepForSdk
        public void unregister();

        @KeepForSdk
        public void registerEventNames(Set<String> var1);

        @KeepForSdk
        public void unregisterEventNames();
    }

    @KeepForSdk
    public static interface AnalyticsConnectorListener {
        @KeepForSdk
        public void onMessageTriggered(int var1, @Nullable Bundle var2);
    }
}

