/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.FirebaseApp;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.annotations.concurrent.UiThread;
import com.google.firebase.appcheck.FirebaseAppCheck;
import com.google.firebase.appcheck.internal.DefaultFirebaseAppCheck;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.Dependency;
import com.google.firebase.components.Qualified;
import com.google.firebase.heartbeatinfo.HeartBeatConsumerComponent;
import com.google.firebase.heartbeatinfo.HeartBeatController;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@KeepForSdk
public class FirebaseAppCheckRegistrar
implements ComponentRegistrar {
    private static final String LIBRARY_NAME = "fire-app-check";

    @Override
    public List<Component<?>> getComponents() {
        Qualified<Executor> uiExecutor = Qualified.qualified(UiThread.class, Executor.class);
        Qualified<Executor> liteExecutor = Qualified.qualified(Lightweight.class, Executor.class);
        Qualified<Executor> backgroundExecutor = Qualified.qualified(Background.class, Executor.class);
        Qualified<ScheduledExecutorService> blockingScheduledExecutorService = Qualified.qualified(Blocking.class, ScheduledExecutorService.class);
        return Arrays.asList(Component.builder(FirebaseAppCheck.class, InteropAppCheckTokenProvider.class).name(LIBRARY_NAME).add(Dependency.required(FirebaseApp.class)).add(Dependency.required(uiExecutor)).add(Dependency.required(liteExecutor)).add(Dependency.required(backgroundExecutor)).add(Dependency.required(blockingScheduledExecutorService)).add(Dependency.optionalProvider(HeartBeatController.class)).factory(container -> new DefaultFirebaseAppCheck(container.get(FirebaseApp.class), container.getProvider(HeartBeatController.class), (Executor)container.get(uiExecutor), (Executor)container.get(liteExecutor), (Executor)container.get(backgroundExecutor), (ScheduledExecutorService)container.get(blockingScheduledExecutorService))).alwaysEager().build(), HeartBeatConsumerComponent.create(), LibraryVersionComponent.create(LIBRARY_NAME, "17.1.1"));
    }
}

