/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.appcheck.internal.DefaultFirebaseAppCheck;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DefaultTokenRefresher {
    private static final long UNSET_DELAY = -1L;
    @VisibleForTesting
    static final long INITIAL_DELAY_SECONDS = 30L;
    @VisibleForTesting
    static final long MAX_DELAY_SECONDS = 960L;
    private final DefaultFirebaseAppCheck firebaseAppCheck;
    private final Executor liteExecutor;
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile ScheduledFuture<?> refreshFuture;
    private volatile long delayAfterFailureSeconds;

    DefaultTokenRefresher(@NonNull DefaultFirebaseAppCheck firebaseAppCheck, @Lightweight Executor liteExecutor, @Blocking ScheduledExecutorService scheduledExecutorService) {
        this.firebaseAppCheck = Preconditions.checkNotNull(firebaseAppCheck);
        this.liteExecutor = liteExecutor;
        this.scheduledExecutorService = scheduledExecutorService;
        this.delayAfterFailureSeconds = -1L;
    }

    public void scheduleRefresh(long timeToRefreshMillis) {
        this.cancel();
        this.delayAfterFailureSeconds = -1L;
        this.refreshFuture = this.scheduledExecutorService.schedule(this::onRefresh, Math.max(0L, timeToRefreshMillis), TimeUnit.MILLISECONDS);
    }

    private void scheduleRefreshAfterFailure() {
        this.cancel();
        this.delayAfterFailureSeconds = this.getNextRefreshMillis();
        this.refreshFuture = this.scheduledExecutorService.schedule(this::onRefresh, this.delayAfterFailureSeconds, TimeUnit.SECONDS);
    }

    private long getNextRefreshMillis() {
        if (this.delayAfterFailureSeconds == -1L) {
            return 30L;
        }
        if (this.delayAfterFailureSeconds * 2L < 960L) {
            return this.delayAfterFailureSeconds * 2L;
        }
        return 960L;
    }

    private void onRefresh() {
        this.firebaseAppCheck.fetchTokenFromProvider().addOnFailureListener(this.liteExecutor, e -> this.scheduleRefreshAfterFailure());
    }

    public void cancel() {
        if (this.refreshFuture != null && !this.refreshFuture.isDone()) {
            this.refreshFuture.cancel(false);
        }
    }
}

