/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.concurrent;

import com.google.firebase.components.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

class LimitedConcurrencyExecutor
implements Executor {
    private final Executor delegate;
    private final Semaphore semaphore;
    private final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();

    LimitedConcurrencyExecutor(Executor delegate, int concurrency) {
        Preconditions.checkArgument(concurrency > 0, "concurrency must be positive.");
        this.delegate = delegate;
        this.semaphore = new Semaphore(concurrency, true);
    }

    @Override
    public void execute(Runnable command) {
        this.queue.offer(command);
        this.maybeEnqueueNext();
    }

    private void maybeEnqueueNext() {
        while (this.semaphore.tryAcquire()) {
            Runnable next = this.queue.poll();
            if (next != null) {
                this.delegate.execute(this.decorate(next));
                continue;
            }
            this.semaphore.release();
            break;
        }
    }

    private Runnable decorate(Runnable command) {
        return () -> {
            try {
                command.run();
            }
            finally {
                this.semaphore.release();
                this.maybeEnqueueNext();
            }
        };
    }
}

