/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.util;

import com.google.firebase.database.util.JsonMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GAuthToken {
    private final String token;
    private final Map<String, Object> auth;
    private static final String TOKEN_PREFIX = "gauth|";
    private static final String AUTH_KEY = "auth";
    private static final String TOKEN_KEY = "token";

    public GAuthToken(String token, Map<String, Object> auth) {
        this.token = token;
        this.auth = auth;
    }

    public static GAuthToken tryParseFromString(String rawToken) {
        if (!rawToken.startsWith(TOKEN_PREFIX)) {
            return null;
        }
        String gauthToken = rawToken.substring(TOKEN_PREFIX.length());
        try {
            Map<String, Object> tokenMap = JsonMapper.parseJson(gauthToken);
            String token = (String)tokenMap.get(TOKEN_KEY);
            Map auth = (Map)tokenMap.get(AUTH_KEY);
            return new GAuthToken(token, auth);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse gauth token", e);
        }
    }

    public String serializeToString() {
        HashMap<String, Object> tokenMap = new HashMap<String, Object>();
        tokenMap.put(TOKEN_KEY, this.token);
        tokenMap.put(AUTH_KEY, this.auth);
        try {
            String json = JsonMapper.serializeJson(tokenMap);
            return TOKEN_PREFIX + json;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize gauth token", e);
        }
    }

    public String getToken() {
        return this.token;
    }

    public Map<String, Object> getAuth() {
        return this.auth;
    }
}

