/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.auth;

import android.annotation.SuppressLint;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.appcheck.AppCheckTokenResult;
import com.google.firebase.appcheck.interop.AppCheckTokenListener;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.firestore.auth.CredentialsProvider;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Listener;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.inject.Deferred;

public final class FirebaseAppCheckTokenProvider
extends CredentialsProvider<String> {
    private static final String LOG_TAG = "FirebaseAppCheckTokenProvider";
    @Nullable
    @GuardedBy(value="this")
    private Listener<String> changeListener;
    @Nullable
    @GuardedBy(value="this")
    private InteropAppCheckTokenProvider interopAppCheckTokenProvider;
    @GuardedBy(value="this")
    private boolean forceRefresh;
    private final AppCheckTokenListener tokenListener = result -> this.onTokenChanged(result);

    @SuppressLint(value={"ProviderAssignment"})
    public FirebaseAppCheckTokenProvider(Deferred<InteropAppCheckTokenProvider> deferredAppCheckTokenProvider) {
        deferredAppCheckTokenProvider.whenAvailable(provider -> {
            FirebaseAppCheckTokenProvider firebaseAppCheckTokenProvider = this;
            synchronized (firebaseAppCheckTokenProvider) {
                this.interopAppCheckTokenProvider = (InteropAppCheckTokenProvider)provider.get();
                if (this.interopAppCheckTokenProvider != null) {
                    this.interopAppCheckTokenProvider.addAppCheckTokenListener(this.tokenListener);
                }
            }
        });
    }

    private synchronized void onTokenChanged(@NonNull AppCheckTokenResult result) {
        if (result.getError() != null) {
            Logger.warn(LOG_TAG, "Error getting App Check token; using placeholder token instead. Error: " + result.getError(), new Object[0]);
        }
        if (this.changeListener != null) {
            this.changeListener.onValue(result.getToken());
        }
    }

    @Override
    public synchronized Task<String> getToken() {
        if (this.interopAppCheckTokenProvider == null) {
            return Tasks.forException(new FirebaseApiNotAvailableException("AppCheck is not available"));
        }
        Task<AppCheckTokenResult> res = this.interopAppCheckTokenProvider.getToken(this.forceRefresh);
        this.forceRefresh = false;
        return res.continueWithTask(Executors.DIRECT_EXECUTOR, task -> {
            if (task.isSuccessful()) {
                return Tasks.forResult(((AppCheckTokenResult)task.getResult()).getToken());
            }
            return Tasks.forException(task.getException());
        });
    }

    @Override
    public synchronized void invalidateToken() {
        this.forceRefresh = true;
    }

    @Override
    public synchronized void removeChangeListener() {
        this.changeListener = null;
        if (this.interopAppCheckTokenProvider != null) {
            this.interopAppCheckTokenProvider.removeAppCheckTokenListener(this.tokenListener);
        }
    }

    @Override
    public synchronized void setChangeListener(@NonNull Listener<String> changeListener) {
        this.changeListener = changeListener;
    }
}

