/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import androidx.annotation.Nullable;
import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.FieldFilter;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Query {
    private static final OrderBy KEY_ORDERING_ASC = OrderBy.getInstance(OrderBy.Direction.ASCENDING, FieldPath.KEY_PATH);
    private static final OrderBy KEY_ORDERING_DESC = OrderBy.getInstance(OrderBy.Direction.DESCENDING, FieldPath.KEY_PATH);
    private final List<OrderBy> explicitSortOrder;
    private List<OrderBy> memoizedNormalizedOrderBys;
    @Nullable
    private Target memoizedTarget;
    @Nullable
    private Target memoizedAggregateTarget;
    private final List<Filter> filters;
    private final ResourcePath path;
    @Nullable
    private final String collectionGroup;
    private final long limit;
    private final LimitType limitType;
    @Nullable
    private final Bound startAt;
    @Nullable
    private final Bound endAt;

    public static Query atPath(ResourcePath path) {
        return new Query(path, null);
    }

    public Query(ResourcePath path, @Nullable String collectionGroup, List<Filter> filters, List<OrderBy> explicitSortOrder, long limit, LimitType limitType, @Nullable Bound startAt, @Nullable Bound endAt) {
        this.path = path;
        this.collectionGroup = collectionGroup;
        this.explicitSortOrder = explicitSortOrder;
        this.filters = filters;
        this.limit = limit;
        this.limitType = limitType;
        this.startAt = startAt;
        this.endAt = endAt;
    }

    public Query(ResourcePath path, @Nullable String collectionGroup) {
        this(path, collectionGroup, Collections.emptyList(), Collections.emptyList(), -1L, LimitType.LIMIT_TO_FIRST, null, null);
    }

    public ResourcePath getPath() {
        return this.path;
    }

    @Nullable
    public String getCollectionGroup() {
        return this.collectionGroup;
    }

    public boolean isDocumentQuery() {
        return DocumentKey.isDocumentKey(this.path) && this.collectionGroup == null && this.filters.isEmpty();
    }

    public boolean isCollectionGroupQuery() {
        return this.collectionGroup != null;
    }

    public boolean matchesAllDocuments() {
        return this.filters.isEmpty() && this.limit == -1L && this.startAt == null && this.endAt == null && (this.getExplicitOrderBy().isEmpty() || this.getExplicitOrderBy().size() == 1 && this.getExplicitOrderBy().get((int)0).field.isKeyField());
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean hasLimit() {
        return this.limit != -1L;
    }

    public LimitType getLimitType() {
        return this.limitType;
    }

    @Nullable
    public Bound getStartAt() {
        return this.startAt;
    }

    @Nullable
    public Bound getEndAt() {
        return this.endAt;
    }

    public SortedSet<FieldPath> getInequalityFilterFields() {
        TreeSet<FieldPath> result = new TreeSet<FieldPath>();
        for (Filter filter : this.getFilters()) {
            for (FieldFilter subFilter : filter.getFlattenedFilters()) {
                if (!subFilter.isInequality()) continue;
                result.add(subFilter.getField());
            }
        }
        return result;
    }

    public Query filter(Filter filter) {
        Assert.hardAssert(!this.isDocumentQuery(), "No filter is allowed for document query", new Object[0]);
        ArrayList<Filter> updatedFilter = new ArrayList<Filter>(this.filters);
        updatedFilter.add(filter);
        return new Query(this.path, this.collectionGroup, updatedFilter, this.explicitSortOrder, this.limit, this.limitType, this.startAt, this.endAt);
    }

    public Query orderBy(OrderBy order) {
        Assert.hardAssert(!this.isDocumentQuery(), "No ordering is allowed for document query", new Object[0]);
        ArrayList<OrderBy> updatedSortOrder = new ArrayList<OrderBy>(this.explicitSortOrder);
        updatedSortOrder.add(order);
        return new Query(this.path, this.collectionGroup, this.filters, updatedSortOrder, this.limit, this.limitType, this.startAt, this.endAt);
    }

    public Query limitToFirst(long limit) {
        return new Query(this.path, this.collectionGroup, this.filters, this.explicitSortOrder, limit, LimitType.LIMIT_TO_FIRST, this.startAt, this.endAt);
    }

    public Query limitToLast(long limit) {
        return new Query(this.path, this.collectionGroup, this.filters, this.explicitSortOrder, limit, LimitType.LIMIT_TO_LAST, this.startAt, this.endAt);
    }

    public Query startAt(Bound bound) {
        return new Query(this.path, this.collectionGroup, this.filters, this.explicitSortOrder, this.limit, this.limitType, bound, this.endAt);
    }

    public Query endAt(Bound bound) {
        return new Query(this.path, this.collectionGroup, this.filters, this.explicitSortOrder, this.limit, this.limitType, this.startAt, bound);
    }

    public Query asCollectionQueryAtPath(ResourcePath path) {
        return new Query(path, null, this.filters, this.explicitSortOrder, this.limit, this.limitType, this.startAt, this.endAt);
    }

    public List<OrderBy> getExplicitOrderBy() {
        return this.explicitSortOrder;
    }

    public synchronized List<OrderBy> getNormalizedOrderBy() {
        if (this.memoizedNormalizedOrderBys == null) {
            ArrayList<OrderBy> res = new ArrayList<OrderBy>();
            HashSet<String> fieldsNormalized = new HashSet<String>();
            for (OrderBy explicit : this.explicitSortOrder) {
                res.add(explicit);
                fieldsNormalized.add(explicit.field.canonicalString());
            }
            OrderBy.Direction lastDirection = this.explicitSortOrder.size() > 0 ? this.explicitSortOrder.get(this.explicitSortOrder.size() - 1).getDirection() : OrderBy.Direction.ASCENDING;
            SortedSet<FieldPath> inequalityFields = this.getInequalityFilterFields();
            for (FieldPath field : inequalityFields) {
                if (fieldsNormalized.contains(field.canonicalString()) || field.isKeyField()) continue;
                res.add(OrderBy.getInstance(lastDirection, field));
            }
            if (!fieldsNormalized.contains(FieldPath.KEY_PATH.canonicalString())) {
                res.add(lastDirection.equals((Object)OrderBy.Direction.ASCENDING) ? KEY_ORDERING_ASC : KEY_ORDERING_DESC);
            }
            this.memoizedNormalizedOrderBys = Collections.unmodifiableList(res);
        }
        return this.memoizedNormalizedOrderBys;
    }

    private boolean matchesPathAndCollectionGroup(Document doc) {
        ResourcePath docPath = doc.getKey().getPath();
        if (this.collectionGroup != null) {
            return doc.getKey().hasCollectionId(this.collectionGroup) && this.path.isPrefixOf(docPath);
        }
        if (DocumentKey.isDocumentKey(this.path)) {
            return this.path.equals(docPath);
        }
        return this.path.isPrefixOf(docPath) && this.path.length() == docPath.length() - 1;
    }

    private boolean matchesFilters(Document doc) {
        for (Filter filter : this.filters) {
            if (filter.matches(doc)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesOrderBy(Document doc) {
        for (OrderBy order : this.getNormalizedOrderBy()) {
            if (order.getField().equals(FieldPath.KEY_PATH) || doc.getField(order.field) != null) continue;
            return false;
        }
        return true;
    }

    private boolean matchesBounds(Document doc) {
        if (this.startAt != null && !this.startAt.sortsBeforeDocument(this.getNormalizedOrderBy(), doc)) {
            return false;
        }
        return this.endAt == null || this.endAt.sortsAfterDocument(this.getNormalizedOrderBy(), doc);
    }

    public boolean matches(Document doc) {
        return doc.isFoundDocument() && this.matchesPathAndCollectionGroup(doc) && this.matchesOrderBy(doc) && this.matchesFilters(doc) && this.matchesBounds(doc);
    }

    public Comparator<Document> comparator() {
        return new QueryComparator(this.getNormalizedOrderBy());
    }

    public synchronized Target toTarget() {
        if (this.memoizedTarget == null) {
            this.memoizedTarget = this.toTarget(this.getNormalizedOrderBy());
        }
        return this.memoizedTarget;
    }

    private synchronized Target toTarget(List<OrderBy> orderBys) {
        if (this.limitType == LimitType.LIMIT_TO_FIRST) {
            return new Target(this.getPath(), this.getCollectionGroup(), this.getFilters(), orderBys, this.limit, this.getStartAt(), this.getEndAt());
        }
        ArrayList<OrderBy> newOrderBy = new ArrayList<OrderBy>();
        for (OrderBy orderBy : orderBys) {
            OrderBy.Direction dir = orderBy.getDirection() == OrderBy.Direction.DESCENDING ? OrderBy.Direction.ASCENDING : OrderBy.Direction.DESCENDING;
            newOrderBy.add(OrderBy.getInstance(dir, orderBy.getField()));
        }
        Bound newStartAt = this.endAt != null ? new Bound(this.endAt.getPosition(), this.endAt.isInclusive()) : null;
        Bound newEndAt = this.startAt != null ? new Bound(this.startAt.getPosition(), this.startAt.isInclusive()) : null;
        return new Target(this.getPath(), this.getCollectionGroup(), this.getFilters(), newOrderBy, this.limit, newStartAt, newEndAt);
    }

    public synchronized Target toAggregateTarget() {
        if (this.memoizedAggregateTarget == null) {
            this.memoizedAggregateTarget = this.toTarget(this.explicitSortOrder);
        }
        return this.memoizedAggregateTarget;
    }

    public String getCanonicalId() {
        return this.toTarget().getCanonicalId() + "|lt:" + (Object)((Object)this.limitType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        if (this.limitType != query.limitType) {
            return false;
        }
        return this.toTarget().equals(query.toTarget());
    }

    public int hashCode() {
        return 31 * this.toTarget().hashCode() + this.limitType.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Query(target=");
        builder.append(this.toTarget().toString());
        builder.append(";limitType=");
        builder.append(this.limitType.toString());
        builder.append(")");
        return builder.toString();
    }

    private static class QueryComparator
    implements Comparator<Document> {
        private final List<OrderBy> sortOrder;

        QueryComparator(List<OrderBy> order) {
            boolean hasKeyOrdering = false;
            for (OrderBy orderBy : order) {
                hasKeyOrdering = hasKeyOrdering || orderBy.getField().equals(FieldPath.KEY_PATH);
            }
            if (!hasKeyOrdering) {
                throw new IllegalArgumentException("QueryComparator needs to have a key ordering");
            }
            this.sortOrder = order;
        }

        @Override
        public int compare(Document doc1, Document doc2) {
            for (OrderBy order : this.sortOrder) {
                int comp = order.compare(doc1, doc2);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }

    public static enum LimitType {
        LIMIT_TO_FIRST,
        LIMIT_TO_LAST;

    }
}

