/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.Target;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.MemoryPersistence;
import com.google.firebase.firestore.local.ReferenceDelegate;
import com.google.firebase.firestore.local.ReferenceSet;
import com.google.firebase.firestore.local.TargetCache;
import com.google.firebase.firestore.local.TargetData;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.util.Consumer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class MemoryTargetCache
implements TargetCache {
    private final Map<Target, TargetData> targets = new HashMap<Target, TargetData>();
    private final ReferenceSet references = new ReferenceSet();
    private int highestTargetId;
    private SnapshotVersion lastRemoteSnapshotVersion = SnapshotVersion.NONE;
    private long highestSequenceNumber = 0L;
    private final MemoryPersistence persistence;

    MemoryTargetCache(MemoryPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public int getHighestTargetId() {
        return this.highestTargetId;
    }

    @Override
    public long getTargetCount() {
        return this.targets.size();
    }

    @Override
    public void forEachTarget(Consumer<TargetData> consumer) {
        for (TargetData targetData : this.targets.values()) {
            consumer.accept(targetData);
        }
    }

    @Override
    public long getHighestListenSequenceNumber() {
        return this.highestSequenceNumber;
    }

    @Override
    public SnapshotVersion getLastRemoteSnapshotVersion() {
        return this.lastRemoteSnapshotVersion;
    }

    @Override
    public void setLastRemoteSnapshotVersion(SnapshotVersion snapshotVersion) {
        this.lastRemoteSnapshotVersion = snapshotVersion;
    }

    @Override
    public void addTargetData(TargetData targetData) {
        this.targets.put(targetData.getTarget(), targetData);
        int targetId = targetData.getTargetId();
        if (targetId > this.highestTargetId) {
            this.highestTargetId = targetId;
        }
        if (targetData.getSequenceNumber() > this.highestSequenceNumber) {
            this.highestSequenceNumber = targetData.getSequenceNumber();
        }
    }

    @Override
    public void updateTargetData(TargetData targetData) {
        this.addTargetData(targetData);
    }

    @Override
    public void removeTargetData(TargetData targetData) {
        this.targets.remove(targetData.getTarget());
        this.references.removeReferencesForId(targetData.getTargetId());
    }

    int removeQueries(long upperBound, SparseArray<?> activeTargetIds) {
        int removed = 0;
        Iterator<Map.Entry<Target, TargetData>> it = this.targets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Target, TargetData> entry = it.next();
            int targetId = entry.getValue().getTargetId();
            long sequenceNumber = entry.getValue().getSequenceNumber();
            if (sequenceNumber > upperBound || activeTargetIds.get(targetId) != null) continue;
            it.remove();
            this.removeMatchingKeysForTargetId(targetId);
            ++removed;
        }
        return removed;
    }

    @Override
    @Nullable
    public TargetData getTargetData(Target target) {
        return this.targets.get(target);
    }

    @Override
    public void addMatchingKeys(ImmutableSortedSet<DocumentKey> keys, int targetId) {
        this.references.addReferences(keys, targetId);
        ReferenceDelegate referenceDelegate = this.persistence.getReferenceDelegate();
        for (DocumentKey key : keys) {
            referenceDelegate.addReference(key);
        }
    }

    @Override
    public void removeMatchingKeys(ImmutableSortedSet<DocumentKey> keys, int targetId) {
        this.references.removeReferences(keys, targetId);
        ReferenceDelegate referenceDelegate = this.persistence.getReferenceDelegate();
        for (DocumentKey key : keys) {
            referenceDelegate.removeReference(key);
        }
    }

    @Override
    public void removeMatchingKeysForTargetId(int targetId) {
        this.references.removeReferencesForId(targetId);
    }

    @Override
    public ImmutableSortedSet<DocumentKey> getMatchingKeysForTargetId(int targetId) {
        return this.references.referencesForId(targetId);
    }

    @Override
    public boolean containsKey(DocumentKey key) {
        return this.references.containsKey(key);
    }

    long getByteSize(LocalSerializer serializer2) {
        long count = 0L;
        for (Map.Entry<Target, TargetData> entry : this.targets.entrySet()) {
            count += (long)serializer2.encodeTargetData(entry.getValue()).getSerializedSize();
        }
        return count;
    }
}

