/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import androidx.annotation.NonNull;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.Assert;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class DocumentKey
implements Comparable<DocumentKey> {
    public static final String KEY_FIELD_NAME = "__name__";
    private static final Comparator<DocumentKey> COMPARATOR = DocumentKey::compareTo;
    private static final ImmutableSortedSet<DocumentKey> EMPTY_KEY_SET = new ImmutableSortedSet<DocumentKey>(Collections.emptyList(), COMPARATOR);
    private final ResourcePath path;

    public static Comparator<DocumentKey> comparator() {
        return COMPARATOR;
    }

    public static ImmutableSortedSet<DocumentKey> emptyKeySet() {
        return EMPTY_KEY_SET;
    }

    public static DocumentKey empty() {
        return DocumentKey.fromSegments(Collections.emptyList());
    }

    public static DocumentKey fromName(String name) {
        ResourcePath resourceName = ResourcePath.fromString(name);
        Assert.hardAssert(resourceName.length() > 4 && resourceName.getSegment(0).equals("projects") && resourceName.getSegment(2).equals("databases") && resourceName.getSegment(4).equals("documents"), "Tried to parse an invalid key: %s", resourceName);
        return DocumentKey.fromPath((ResourcePath)resourceName.popFirst(5));
    }

    public static DocumentKey fromPath(ResourcePath path) {
        return new DocumentKey(path);
    }

    public static DocumentKey fromSegments(List<String> segments) {
        return new DocumentKey(ResourcePath.fromSegments(segments));
    }

    public static DocumentKey fromPathString(String path) {
        return new DocumentKey(ResourcePath.fromString(path));
    }

    public static boolean isDocumentKey(ResourcePath path) {
        return path.length() % 2 == 0;
    }

    private DocumentKey(ResourcePath path) {
        Assert.hardAssert(DocumentKey.isDocumentKey(path), "Not a document key path: %s", path);
        this.path = path;
    }

    public ResourcePath getPath() {
        return this.path;
    }

    public String getCollectionGroup() {
        return this.path.getSegment(this.path.length() - 2);
    }

    public ResourcePath getCollectionPath() {
        return (ResourcePath)this.path.popLast();
    }

    public String getDocumentId() {
        return this.path.getLastSegment();
    }

    public boolean hasCollectionId(String collectionId) {
        return this.path.length() >= 2 && ((String)this.path.segments.get(this.path.length() - 2)).equals(collectionId);
    }

    @Override
    public int compareTo(@NonNull DocumentKey another) {
        return this.path.compareTo(another.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentKey that = (DocumentKey)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path.toString();
    }
}

