/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import androidx.annotation.GuardedBy;
import com.google.firebase.functions.FirebaseFunctions;
import com.google.firebase.functions.dagger.assisted.Assisted;
import com.google.firebase.functions.dagger.assisted.AssistedFactory;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class FunctionsMultiResourceComponent {
    @GuardedBy(value="this")
    private final Map<String, FirebaseFunctions> instances = new HashMap<String, FirebaseFunctions>();
    private final FirebaseFunctionsFactory functionsFactory;

    @Inject
    FunctionsMultiResourceComponent(FirebaseFunctionsFactory functionsFactory) {
        this.functionsFactory = functionsFactory;
    }

    synchronized FirebaseFunctions get(String regionOrCustomDomain) {
        FirebaseFunctions functions = this.instances.get(regionOrCustomDomain);
        if (functions == null) {
            functions = this.functionsFactory.create(regionOrCustomDomain);
            this.instances.put(regionOrCustomDomain, functions);
        }
        return functions;
    }

    @AssistedFactory
    static interface FirebaseFunctionsFactory {
        public FirebaseFunctions create(@Assisted String var1);
    }
}

