/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import com.google.firebase.FirebaseApp;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.remoteconfig.ConfigUpdateListener;
import com.google.firebase.remoteconfig.ConfigUpdateListenerRegistration;
import com.google.firebase.remoteconfig.internal.ConfigCacheClient;
import com.google.firebase.remoteconfig.internal.ConfigFetchHandler;
import com.google.firebase.remoteconfig.internal.ConfigMetadataClient;
import com.google.firebase.remoteconfig.internal.ConfigRealtimeHttpClient;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;

public class ConfigRealtimeHandler {
    @GuardedBy(value="this")
    private final Set<ConfigUpdateListener> listeners = new LinkedHashSet<ConfigUpdateListener>();
    @GuardedBy(value="this")
    private final ConfigRealtimeHttpClient configRealtimeHttpClient;
    private final ConfigFetchHandler configFetchHandler;
    private final FirebaseApp firebaseApp;
    private final FirebaseInstallationsApi firebaseInstallations;
    private final ConfigCacheClient activatedCacheClient;
    private final Context context;
    private final String namespace;
    private final ConfigMetadataClient metadataClient;
    private final ScheduledExecutorService scheduledExecutorService;

    public ConfigRealtimeHandler(FirebaseApp firebaseApp, FirebaseInstallationsApi firebaseInstallations, ConfigFetchHandler configFetchHandler, ConfigCacheClient activatedCacheClient, Context context, String namespace, ConfigMetadataClient metadataClient, ScheduledExecutorService scheduledExecutorService) {
        this.configRealtimeHttpClient = new ConfigRealtimeHttpClient(firebaseApp, firebaseInstallations, configFetchHandler, activatedCacheClient, context, namespace, this.listeners, metadataClient, scheduledExecutorService);
        this.firebaseApp = firebaseApp;
        this.configFetchHandler = configFetchHandler;
        this.firebaseInstallations = firebaseInstallations;
        this.activatedCacheClient = activatedCacheClient;
        this.context = context;
        this.namespace = namespace;
        this.metadataClient = metadataClient;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    private synchronized void beginRealtime() {
        if (!this.listeners.isEmpty()) {
            this.configRealtimeHttpClient.startHttpConnection();
        }
    }

    @NonNull
    public synchronized ConfigUpdateListenerRegistration addRealtimeConfigUpdateListener(@NonNull ConfigUpdateListener configUpdateListener) {
        this.listeners.add(configUpdateListener);
        this.beginRealtime();
        return new ConfigUpdateListenerRegistrationInternal(configUpdateListener);
    }

    public synchronized void setBackgroundState(boolean isInBackground) {
        this.configRealtimeHttpClient.setRealtimeBackgroundState(isInBackground);
        if (!isInBackground) {
            this.beginRealtime();
        }
    }

    private synchronized void removeRealtimeConfigUpdateListener(ConfigUpdateListener listener2) {
        this.listeners.remove(listener2);
    }

    public class ConfigUpdateListenerRegistrationInternal
    implements ConfigUpdateListenerRegistration {
        private final ConfigUpdateListener listener;

        public ConfigUpdateListenerRegistrationInternal(ConfigUpdateListener listener2) {
            this.listener = listener2;
        }

        @Override
        public void remove() {
            ConfigRealtimeHandler.this.removeRealtimeConfigUpdateListener(this.listener);
        }
    }
}

