/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.CancellationTokenSource;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.storage.ControllableTask;
import com.google.firebase.storage.OnPausedListener;
import com.google.firebase.storage.OnProgressListener;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTaskManager;
import com.google.firebase.storage.TaskListenerImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

public abstract class StorageTask<ResultT extends ProvideError>
extends ControllableTask<ResultT> {
    private static final String TAG = "StorageTask";
    static final int INTERNAL_STATE_NOT_STARTED = 1;
    static final int INTERNAL_STATE_QUEUED = 2;
    static final int INTERNAL_STATE_IN_PROGRESS = 4;
    static final int INTERNAL_STATE_PAUSING = 8;
    static final int INTERNAL_STATE_PAUSED = 16;
    static final int INTERNAL_STATE_CANCELING = 32;
    static final int INTERNAL_STATE_FAILURE = 64;
    static final int INTERNAL_STATE_SUCCESS = 128;
    static final int INTERNAL_STATE_CANCELED = 256;
    static final int STATES_SUCCESS = 128;
    static final int STATES_PAUSED = 16;
    static final int STATES_FAILURE = 64;
    static final int STATES_CANCELED = 256;
    static final int STATES_COMPLETE = 448;
    static final int STATES_INPROGRESS = -465;
    private static final HashMap<Integer, HashSet<Integer>> ValidUserInitiatedStateChanges = new HashMap();
    private static final HashMap<Integer, HashSet<Integer>> ValidTaskInitiatedStateChanges = new HashMap();
    protected final Object syncObject = new Object();
    @VisibleForTesting
    final TaskListenerImpl<OnSuccessListener<? super ResultT>, ResultT> successManager = new TaskListenerImpl<OnSuccessListener, ProvideError>(this, 128, (listener2, snappedState) -> {
        StorageTaskManager.getInstance().unRegister(this);
        listener2.onSuccess(snappedState);
    });
    @VisibleForTesting
    final TaskListenerImpl<OnFailureListener, ResultT> failureManager = new TaskListenerImpl<OnFailureListener, ProvideError>(this, 64, (listener2, snappedState) -> {
        StorageTaskManager.getInstance().unRegister(this);
        listener2.onFailure(snappedState.getError());
    });
    @VisibleForTesting
    final TaskListenerImpl<OnCompleteListener<ResultT>, ResultT> completeListener = new TaskListenerImpl<OnCompleteListener, ProvideError>(this, 448, (listener2, snappedState) -> {
        StorageTaskManager.getInstance().unRegister(this);
        listener2.onComplete(this);
    });
    @VisibleForTesting
    final TaskListenerImpl<OnCanceledListener, ResultT> cancelManager = new TaskListenerImpl<OnCanceledListener, ProvideError>(this, 256, (listener2, snappedState) -> {
        StorageTaskManager.getInstance().unRegister(this);
        listener2.onCanceled();
    });
    @VisibleForTesting
    final TaskListenerImpl<OnProgressListener<? super ResultT>, ResultT> progressManager = new TaskListenerImpl<OnProgressListener, ProvideError>(this, -465, OnProgressListener::onProgress);
    @VisibleForTesting
    final TaskListenerImpl<OnPausedListener<? super ResultT>, ResultT> pausedManager = new TaskListenerImpl<OnPausedListener, ProvideError>(this, 16, OnPausedListener::onPaused);
    private volatile int currentState = 1;
    private ResultT finalResult;

    protected StorageTask() {
    }

    @VisibleForTesting
    boolean queue() {
        if (this.tryChangeState(2, false)) {
            this.schedule();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    void resetState() {
    }

    @VisibleForTesting
    abstract StorageReference getStorage();

    @VisibleForTesting
    abstract void schedule();

    @Override
    public boolean resume() {
        if (this.tryChangeState(2, true)) {
            this.resetState();
            this.schedule();
            return true;
        }
        return false;
    }

    @Override
    public boolean pause() {
        return this.tryChangeState(new int[]{16, 8}, true);
    }

    @Override
    public boolean cancel() {
        return this.tryChangeState(new int[]{256, 32}, true);
    }

    @Override
    public boolean isComplete() {
        return (this.getInternalState() & 0x1C0) != 0;
    }

    @Override
    public boolean isSuccessful() {
        return (this.getInternalState() & 0x80) != 0;
    }

    @Override
    public boolean isCanceled() {
        return this.getInternalState() == 256;
    }

    @Override
    public boolean isInProgress() {
        return (this.getInternalState() & 0xFFFFFE2F) != 0;
    }

    @Override
    public boolean isPaused() {
        return (this.getInternalState() & 0x10) != 0;
    }

    @Override
    @NonNull
    public ResultT getResult() {
        if (this.getFinalResult() == null) {
            throw new IllegalStateException();
        }
        Exception t = this.getFinalResult().getError();
        if (t != null) {
            throw new RuntimeExecutionException(t);
        }
        return this.getFinalResult();
    }

    @Override
    @NonNull
    public <X extends Throwable> ResultT getResult(@NonNull Class<X> exceptionType) throws X {
        if (this.getFinalResult() == null) {
            throw new IllegalStateException();
        }
        if (exceptionType.isInstance(this.getFinalResult().getError())) {
            throw (Throwable)exceptionType.cast(this.getFinalResult().getError());
        }
        Exception t = this.getFinalResult().getError();
        if (t != null) {
            throw new RuntimeExecutionException(t);
        }
        return this.getFinalResult();
    }

    @Override
    @Nullable
    public Exception getException() {
        if (this.getFinalResult() == null) {
            return null;
        }
        return this.getFinalResult().getError();
    }

    @NonNull
    public ResultT getSnapshot() {
        return this.snapState();
    }

    @VisibleForTesting
    int getInternalState() {
        return this.currentState;
    }

    @VisibleForTesting
    Object getSyncObject() {
        return this.syncObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @VisibleForTesting
    ResultT snapState() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.snapStateImpl();
        }
    }

    @NonNull
    @VisibleForTesting
    abstract ResultT snapStateImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean tryChangeState(int[] requestedStates, boolean userInitiated) {
        HashMap<Integer, HashSet<Integer>> table = userInitiated ? ValidUserInitiatedStateChanges : ValidTaskInitiatedStateChanges;
        Object object = this.syncObject;
        synchronized (object) {
            for (int newState : requestedStates) {
                HashSet<Integer> validStates = table.get(this.getInternalState());
                if (validStates == null || !validStates.contains(newState)) continue;
                this.currentState = newState;
                switch (this.currentState) {
                    case 2: {
                        StorageTaskManager.getInstance().ensureRegistered(this);
                        this.onQueued();
                        break;
                    }
                    case 4: {
                        this.onProgress();
                        break;
                    }
                    case 16: {
                        this.onPaused();
                        break;
                    }
                    case 64: {
                        this.onFailure();
                        break;
                    }
                    case 128: {
                        this.onSuccess();
                        break;
                    }
                    case 256: {
                        this.onCanceled();
                        break;
                    }
                }
                this.successManager.onInternalStateChanged();
                this.failureManager.onInternalStateChanged();
                this.cancelManager.onInternalStateChanged();
                this.completeListener.onInternalStateChanged();
                this.pausedManager.onInternalStateChanged();
                this.progressManager.onInternalStateChanged();
                if (Log.isLoggable(TAG, 3)) {
                    Log.d(TAG, "changed internal state to: " + this.getStateString(newState) + " isUser: " + userInitiated + " from state:" + this.getStateString(this.currentState));
                }
                return true;
            }
            Log.w(TAG, "unable to change internal state to: " + this.getStateString(requestedStates) + " isUser: " + userInitiated + " from state:" + this.getStateString(this.currentState));
            return false;
        }
    }

    @VisibleForTesting
    boolean tryChangeState(int newState, boolean userInitiated) {
        return this.tryChangeState(new int[]{newState}, userInitiated);
    }

    protected void onQueued() {
    }

    protected void onProgress() {
    }

    protected void onPaused() {
    }

    protected void onFailure() {
    }

    protected void onSuccess() {
    }

    protected void onCanceled() {
    }

    private ResultT getFinalResult() {
        if (this.finalResult != null) {
            return this.finalResult;
        }
        if (!this.isComplete()) {
            return null;
        }
        if (this.finalResult == null) {
            this.finalResult = this.snapState();
        }
        return this.finalResult;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnPausedListener(@NonNull OnPausedListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        this.pausedManager.addListener(null, null, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnPausedListener(@NonNull Executor executor, @NonNull OnPausedListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        Preconditions.checkNotNull(executor);
        this.pausedManager.addListener(null, executor, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnPausedListener(@NonNull Activity activity, @NonNull OnPausedListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        Preconditions.checkNotNull(activity);
        this.pausedManager.addListener(activity, null, listener2);
        return this;
    }

    @NonNull
    public StorageTask<ResultT> removeOnPausedListener(@NonNull OnPausedListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        this.pausedManager.removeListener(listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnProgressListener(@NonNull OnProgressListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        this.progressManager.addListener(null, null, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnProgressListener(@NonNull Executor executor, @NonNull OnProgressListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        Preconditions.checkNotNull(executor);
        this.progressManager.addListener(null, executor, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnProgressListener(@NonNull Activity activity, @NonNull OnProgressListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        Preconditions.checkNotNull(activity);
        this.progressManager.addListener(activity, null, listener2);
        return this;
    }

    @NonNull
    public StorageTask<ResultT> removeOnProgressListener(@NonNull OnProgressListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        this.progressManager.removeListener(listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnSuccessListener(@NonNull OnSuccessListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        this.successManager.addListener(null, null, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(listener2);
        this.successManager.addListener(null, executor, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(activity);
        Preconditions.checkNotNull(listener2);
        this.successManager.addListener(activity, null, listener2);
        return this;
    }

    @NonNull
    public StorageTask<ResultT> removeOnSuccessListener(@NonNull OnSuccessListener<? super ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        this.successManager.removeListener(listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnFailureListener(@NonNull OnFailureListener listener2) {
        Preconditions.checkNotNull(listener2);
        this.failureManager.addListener(null, null, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener listener2) {
        Preconditions.checkNotNull(listener2);
        Preconditions.checkNotNull(executor);
        this.failureManager.addListener(null, executor, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener listener2) {
        Preconditions.checkNotNull(listener2);
        Preconditions.checkNotNull(activity);
        this.failureManager.addListener(activity, null, listener2);
        return this;
    }

    @NonNull
    public StorageTask<ResultT> removeOnFailureListener(@NonNull OnFailureListener listener2) {
        Preconditions.checkNotNull(listener2);
        this.failureManager.removeListener(listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnCompleteListener(@NonNull OnCompleteListener<ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        this.completeListener.addListener(null, null, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        Preconditions.checkNotNull(executor);
        this.completeListener.addListener(null, executor, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        Preconditions.checkNotNull(activity);
        this.completeListener.addListener(activity, null, listener2);
        return this;
    }

    @NonNull
    public StorageTask<ResultT> removeOnCompleteListener(@NonNull OnCompleteListener<ResultT> listener2) {
        Preconditions.checkNotNull(listener2);
        this.completeListener.removeListener(listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnCanceledListener(@NonNull OnCanceledListener listener2) {
        Preconditions.checkNotNull(listener2);
        this.cancelManager.addListener(null, null, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnCanceledListener(@NonNull Executor executor, @NonNull OnCanceledListener listener2) {
        Preconditions.checkNotNull(listener2);
        Preconditions.checkNotNull(executor);
        this.cancelManager.addListener(null, executor, listener2);
        return this;
    }

    @Override
    @NonNull
    public StorageTask<ResultT> addOnCanceledListener(@NonNull Activity activity, @NonNull OnCanceledListener listener2) {
        Preconditions.checkNotNull(listener2);
        Preconditions.checkNotNull(activity);
        this.cancelManager.addListener(activity, null, listener2);
        return this;
    }

    @NonNull
    public StorageTask<ResultT> removeOnCanceledListener(@NonNull OnCanceledListener listener2) {
        Preconditions.checkNotNull(listener2);
        this.cancelManager.removeListener(listener2);
        return this;
    }

    @Override
    @NonNull
    public <ContinuationResultT> Task<ContinuationResultT> continueWith(@NonNull Continuation<ResultT, ContinuationResultT> continuation) {
        return this.continueWithImpl(null, continuation);
    }

    @Override
    @NonNull
    public <ContinuationResultT> Task<ContinuationResultT> continueWith(@NonNull Executor executor, @NonNull Continuation<ResultT, ContinuationResultT> continuation) {
        return this.continueWithImpl(executor, continuation);
    }

    @NonNull
    private <ContinuationResultT> Task<ContinuationResultT> continueWithImpl(@Nullable Executor executor, @NonNull Continuation<ResultT, ContinuationResultT> continuation) {
        TaskCompletionSource source = new TaskCompletionSource();
        this.completeListener.addListener(null, executor, task -> {
            Object result;
            try {
                result = continuation.then(this);
            }
            catch (RuntimeExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    source.setException((Exception)e.getCause());
                } else {
                    source.setException(e);
                }
                return;
            }
            catch (Exception e) {
                source.setException(e);
                return;
            }
            if (!source.getTask().isComplete()) {
                source.setResult(result);
            }
        });
        return source.getTask();
    }

    @Override
    @NonNull
    public <ContinuationResultT> Task<ContinuationResultT> continueWithTask(@NonNull Continuation<ResultT, Task<ContinuationResultT>> continuation) {
        return this.continueWithTaskImpl(null, continuation);
    }

    @Override
    @NonNull
    public <ContinuationResultT> Task<ContinuationResultT> continueWithTask(@NonNull Executor executor, @NonNull Continuation<ResultT, Task<ContinuationResultT>> continuation) {
        return this.continueWithTaskImpl(executor, continuation);
    }

    @Override
    @NonNull
    public <ContinuationResultT> Task<ContinuationResultT> onSuccessTask(@NonNull SuccessContinuation<ResultT, ContinuationResultT> continuation) {
        return this.successTaskImpl(null, continuation);
    }

    @Override
    @NonNull
    public <ContinuationResultT> Task<ContinuationResultT> onSuccessTask(@NonNull Executor executor, @NonNull SuccessContinuation<ResultT, ContinuationResultT> continuation) {
        return this.successTaskImpl(executor, continuation);
    }

    @SuppressLint(value={"TaskMainThread"})
    @NonNull
    private <ContinuationResultT> Task<ContinuationResultT> continueWithTaskImpl(@Nullable Executor executor, @NonNull Continuation<ResultT, Task<ContinuationResultT>> continuation) {
        CancellationTokenSource cancellationTokenSource = new CancellationTokenSource();
        CancellationToken cancellationToken = cancellationTokenSource.getToken();
        TaskCompletionSource source = new TaskCompletionSource(cancellationToken);
        this.completeListener.addListener(null, executor, task -> {
            Task resultTask;
            try {
                resultTask = (Task)continuation.then(this);
            }
            catch (RuntimeExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    source.setException((Exception)e.getCause());
                } else {
                    source.setException(e);
                }
                return;
            }
            catch (Exception e) {
                source.setException(e);
                return;
            }
            if (!source.getTask().isComplete()) {
                if (resultTask == null) {
                    source.setException(new NullPointerException("Continuation returned null"));
                    return;
                }
                resultTask.addOnSuccessListener(source::setResult);
                resultTask.addOnFailureListener(source::setException);
                resultTask.addOnCanceledListener(cancellationTokenSource::cancel);
            }
        });
        return source.getTask();
    }

    @SuppressLint(value={"TaskMainThread"})
    @NonNull
    private <ContinuationResultT> Task<ContinuationResultT> successTaskImpl(@Nullable Executor executor, @NonNull SuccessContinuation<ResultT, ContinuationResultT> continuation) {
        CancellationTokenSource cancellationTokenSource = new CancellationTokenSource();
        CancellationToken cancellationToken = cancellationTokenSource.getToken();
        TaskCompletionSource source = new TaskCompletionSource(cancellationToken);
        this.successManager.addListener(null, executor, result -> {
            Task resultTask;
            try {
                resultTask = continuation.then(result);
            }
            catch (RuntimeExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    source.setException((Exception)e.getCause());
                } else {
                    source.setException(e);
                }
                return;
            }
            catch (Exception e) {
                source.setException(e);
                return;
            }
            resultTask.addOnSuccessListener(source::setResult);
            resultTask.addOnFailureListener(source::setException);
            resultTask.addOnCanceledListener(cancellationTokenSource::cancel);
        });
        return source.getTask();
    }

    @VisibleForTesting
    abstract void run();

    @VisibleForTesting
    Runnable getRunnable() {
        return () -> {
            try {
                this.run();
            }
            finally {
                this.ensureFinalState();
            }
        };
    }

    private void ensureFinalState() {
        if (!(this.isComplete() || this.isPaused() || this.getInternalState() == 2 || this.tryChangeState(256, false))) {
            this.tryChangeState(64, false);
        }
    }

    private String getStateString(int[] states) {
        if (states.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int state : states) {
            builder.append(this.getStateString(state)).append(", ");
        }
        return builder.substring(0, builder.length() - 2);
    }

    private String getStateString(int state) {
        switch (state) {
            case 1: {
                return "INTERNAL_STATE_NOT_STARTED";
            }
            case 2: {
                return "INTERNAL_STATE_QUEUED";
            }
            case 4: {
                return "INTERNAL_STATE_IN_PROGRESS";
            }
            case 8: {
                return "INTERNAL_STATE_PAUSING";
            }
            case 16: {
                return "INTERNAL_STATE_PAUSED";
            }
            case 32: {
                return "INTERNAL_STATE_CANCELING";
            }
            case 64: {
                return "INTERNAL_STATE_FAILURE";
            }
            case 128: {
                return "INTERNAL_STATE_SUCCESS";
            }
            case 256: {
                return "INTERNAL_STATE_CANCELED";
            }
        }
        return "Unknown Internal State!";
    }

    static {
        ValidUserInitiatedStateChanges.put(1, new HashSet<Integer>(Arrays.asList(16, 256)));
        ValidUserInitiatedStateChanges.put(2, new HashSet<Integer>(Arrays.asList(8, 32)));
        ValidUserInitiatedStateChanges.put(4, new HashSet<Integer>(Arrays.asList(8, 32)));
        ValidUserInitiatedStateChanges.put(16, new HashSet<Integer>(Arrays.asList(2, 256)));
        ValidUserInitiatedStateChanges.put(64, new HashSet<Integer>(Arrays.asList(2, 256)));
        ValidTaskInitiatedStateChanges.put(1, new HashSet<Integer>(Arrays.asList(2, 64)));
        ValidTaskInitiatedStateChanges.put(2, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        ValidTaskInitiatedStateChanges.put(4, new HashSet<Integer>(Arrays.asList(4, 64, 128)));
        ValidTaskInitiatedStateChanges.put(8, new HashSet<Integer>(Arrays.asList(16, 64, 128)));
        ValidTaskInitiatedStateChanges.put(32, new HashSet<Integer>(Arrays.asList(256, 64, 128)));
    }

    public class SnapshotBase
    implements ProvideError {
        private final Exception error;

        public SnapshotBase(Exception error) {
            this.error = error == null ? (StorageTask.this.isCanceled() ? StorageException.fromErrorStatus(Status.RESULT_CANCELED) : (StorageTask.this.getInternalState() == 64 ? StorageException.fromErrorStatus(Status.RESULT_INTERNAL_ERROR) : null)) : error;
        }

        @NonNull
        public StorageTask<ResultT> getTask() {
            return StorageTask.this;
        }

        @NonNull
        public StorageReference getStorage() {
            return this.getTask().getStorage();
        }

        @Override
        @Nullable
        public Exception getError() {
            return this.error;
        }
    }

    protected static interface ProvideError {
        public Exception getError();
    }
}

