/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageException;
import com.google.firebase.storage.StorageMetadata;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.StorageTaskScheduler;
import com.google.firebase.storage.internal.AdaptiveStreamBuffer;
import com.google.firebase.storage.internal.ExponentialBackoffSender;
import com.google.firebase.storage.internal.Sleeper;
import com.google.firebase.storage.internal.SleeperImpl;
import com.google.firebase.storage.internal.Util;
import com.google.firebase.storage.network.NetworkRequest;
import com.google.firebase.storage.network.ResumableUploadByteRequest;
import com.google.firebase.storage.network.ResumableUploadCancelRequest;
import com.google.firebase.storage.network.ResumableUploadQueryRequest;
import com.google.firebase.storage.network.ResumableUploadStartRequest;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;

public class UploadTask
extends StorageTask<TaskSnapshot> {
    @VisibleForTesting
    static final int PREFERRED_CHUNK_SIZE = 262144;
    private static final int MAXIMUM_CHUNK_SIZE = 0x2000000;
    private static final String TAG = "UploadTask";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String X_GOOG_UPLOAD_URL = "X-Goog-Upload-URL";
    private static final String RESUMABLE_FINAL_STATUS = "final";
    private final StorageReference mStorageRef;
    private final Uri mUri;
    private final long mTotalByteCount;
    private final AdaptiveStreamBuffer mStreamBuffer;
    private final AtomicLong mBytesUploaded;
    @Nullable
    private final InternalAuthProvider mAuthProvider;
    @Nullable
    private final InteropAppCheckTokenProvider mAppCheckProvider;
    private int mCurrentChunkSize;
    private ExponentialBackoffSender mSender;
    private boolean mIsStreamOwned;
    private volatile StorageMetadata mMetadata;
    private volatile Uri mUploadUri;
    private volatile Exception mException;
    private volatile Exception mServerException;
    private volatile int mResultCode;
    private volatile String mServerStatus;
    private volatile long maxSleepTime;
    private static final Random random = new Random();
    static Sleeper sleeper = new SleeperImpl();
    static Clock clock = DefaultClock.getInstance();
    private int sleepTime;
    private final int minimumSleepInterval = 1000;

    UploadTask(StorageReference targetRef, StorageMetadata metadata, byte[] bytes) {
        this.mBytesUploaded = new AtomicLong(0L);
        this.mCurrentChunkSize = 262144;
        this.mUploadUri = null;
        this.mException = null;
        this.mServerException = null;
        this.mResultCode = 0;
        this.sleepTime = 0;
        this.minimumSleepInterval = 1000;
        Preconditions.checkNotNull(targetRef);
        Preconditions.checkNotNull(bytes);
        FirebaseStorage storage = targetRef.getStorage();
        this.mTotalByteCount = bytes.length;
        this.mStorageRef = targetRef;
        this.mMetadata = metadata;
        this.mAuthProvider = storage.getAuthProvider();
        this.mAppCheckProvider = storage.getAppCheckProvider();
        this.mUri = null;
        this.mStreamBuffer = new AdaptiveStreamBuffer(new ByteArrayInputStream(bytes), 262144);
        this.mIsStreamOwned = true;
        this.maxSleepTime = storage.getMaxChunkUploadRetry();
        this.mSender = new ExponentialBackoffSender(storage.getApp().getApplicationContext(), this.mAuthProvider, this.mAppCheckProvider, storage.getMaxDownloadRetryTimeMillis());
    }

    UploadTask(StorageReference targetRef, StorageMetadata metadata, Uri file, Uri existingUploadUri) {
        long size;
        InputStream inputStream;
        block10: {
            this.mBytesUploaded = new AtomicLong(0L);
            this.mCurrentChunkSize = 262144;
            this.mUploadUri = null;
            this.mException = null;
            this.mServerException = null;
            this.mResultCode = 0;
            this.sleepTime = 0;
            this.minimumSleepInterval = 1000;
            Preconditions.checkNotNull(targetRef);
            Preconditions.checkNotNull(file);
            FirebaseStorage storage = targetRef.getStorage();
            this.mStorageRef = targetRef;
            this.mMetadata = metadata;
            this.mAuthProvider = storage.getAuthProvider();
            this.mAppCheckProvider = storage.getAppCheckProvider();
            this.mUri = file;
            inputStream = null;
            this.maxSleepTime = storage.getMaxChunkUploadRetry();
            this.mSender = new ExponentialBackoffSender(this.mStorageRef.getApp().getApplicationContext(), this.mAuthProvider, this.mAppCheckProvider, storage.getMaxUploadRetryTimeMillis());
            size = -1L;
            try {
                ContentResolver resolver = this.mStorageRef.getStorage().getApp().getApplicationContext().getContentResolver();
                ParcelFileDescriptor fd = null;
                try {
                    fd = resolver.openFileDescriptor(this.mUri, "r");
                    if (fd != null) {
                        size = fd.getStatSize();
                        fd.close();
                    }
                }
                catch (NullPointerException npe) {
                    Log.w(TAG, "NullPointerException during file size calculation.", npe);
                    size = -1L;
                }
                catch (IOException checkSizeError) {
                    Log.w(TAG, "could not retrieve file size for upload " + this.mUri.toString(), checkSizeError);
                }
                inputStream = resolver.openInputStream(this.mUri);
                if (inputStream == null) break block10;
                if (size == -1L) {
                    try {
                        int streamSize = inputStream.available();
                        if (streamSize >= 0) {
                            size = streamSize;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (FileNotFoundException e) {
                Log.e(TAG, "could not locate file for uploading:" + this.mUri.toString());
                this.mException = e;
            }
        }
        this.mTotalByteCount = size;
        this.mStreamBuffer = new AdaptiveStreamBuffer(inputStream, 262144);
        this.mIsStreamOwned = true;
        this.mUploadUri = existingUploadUri;
    }

    UploadTask(StorageReference targetRef, StorageMetadata metadata, InputStream stream) {
        this.mBytesUploaded = new AtomicLong(0L);
        this.mCurrentChunkSize = 262144;
        this.mUploadUri = null;
        this.mException = null;
        this.mServerException = null;
        this.mResultCode = 0;
        this.sleepTime = 0;
        this.minimumSleepInterval = 1000;
        Preconditions.checkNotNull(targetRef);
        Preconditions.checkNotNull(stream);
        FirebaseStorage storage = targetRef.getStorage();
        this.mTotalByteCount = -1L;
        this.mStorageRef = targetRef;
        this.mMetadata = metadata;
        this.mAuthProvider = storage.getAuthProvider();
        this.mAppCheckProvider = storage.getAppCheckProvider();
        this.mStreamBuffer = new AdaptiveStreamBuffer(stream, 262144);
        this.mIsStreamOwned = false;
        this.mUri = null;
        this.maxSleepTime = storage.getMaxChunkUploadRetry();
        this.mSender = new ExponentialBackoffSender(this.mStorageRef.getApp().getApplicationContext(), this.mAuthProvider, this.mAppCheckProvider, storage.getMaxUploadRetryTimeMillis());
    }

    @Override
    StorageReference getStorage() {
        return this.mStorageRef;
    }

    long getTotalByteCount() {
        return this.mTotalByteCount;
    }

    @Override
    protected void schedule() {
        StorageTaskScheduler.getInstance().scheduleUpload(this.getRunnable());
    }

    @Override
    void run() {
        this.mSender.reset();
        if (!this.tryChangeState(4, false)) {
            Log.d(TAG, "The upload cannot continue as it is not in a valid state.");
            return;
        }
        if (this.mStorageRef.getParent() == null) {
            this.mException = new IllegalArgumentException("Cannot upload to getRoot. You should upload to a storage location such as .getReference('image.png').putFile...");
        }
        if (this.mException != null) {
            return;
        }
        if (this.mUploadUri == null) {
            this.beginResumableUpload();
        } else {
            this.recoverStatus(false);
        }
        boolean shouldContinueToRun = this.shouldContinue();
        while (shouldContinueToRun) {
            this.uploadChunk();
            shouldContinueToRun = this.shouldContinue();
            if (!shouldContinueToRun) continue;
            this.tryChangeState(4, false);
        }
        if (this.mIsStreamOwned && this.getInternalState() != 16) {
            try {
                this.mStreamBuffer.close();
            }
            catch (IOException e) {
                Log.e(TAG, "Unable to close stream.", e);
            }
        }
    }

    @Override
    protected void resetState() {
        this.mException = null;
        this.mServerException = null;
        this.mResultCode = 0;
        this.mServerStatus = null;
    }

    private void beginResumableUpload() {
        ResumableUploadStartRequest startRequest;
        String mimeType = null;
        if (this.mMetadata != null) {
            mimeType = this.mMetadata.getContentType();
        }
        if (this.mUri != null && TextUtils.isEmpty(mimeType)) {
            Context context = this.mStorageRef.getStorage().getApp().getApplicationContext();
            mimeType = context.getContentResolver().getType(this.mUri);
        }
        if (TextUtils.isEmpty(mimeType)) {
            mimeType = APPLICATION_OCTET_STREAM;
        }
        if (!this.sendWithRetry(startRequest = new ResumableUploadStartRequest(this.mStorageRef.getStorageReferenceUri(), this.mStorageRef.getApp(), this.mMetadata != null ? this.mMetadata.createJSONObject() : null, mimeType))) {
            return;
        }
        String uploadURL = startRequest.getResultString(X_GOOG_UPLOAD_URL);
        if (!TextUtils.isEmpty(uploadURL)) {
            this.mUploadUri = Uri.parse(uploadURL);
        }
    }

    private boolean shouldContinue() {
        if (this.getInternalState() == 128) {
            return false;
        }
        if (Thread.interrupted()) {
            this.mException = new InterruptedException();
            this.tryChangeState(64, false);
            return false;
        }
        if (this.getInternalState() == 32) {
            this.tryChangeState(256, false);
            return false;
        }
        if (this.getInternalState() == 8) {
            this.tryChangeState(16, false);
            return false;
        }
        if (!this.serverStateValid()) {
            return false;
        }
        if (this.mUploadUri == null) {
            if (this.mException == null) {
                this.mException = new IllegalStateException("Unable to obtain an upload URL.");
            }
            this.tryChangeState(64, false);
            return false;
        }
        if (this.mException != null) {
            this.tryChangeState(64, false);
            return false;
        }
        boolean inErrorState = this.mServerException != null || this.mResultCode < 200 || this.mResultCode >= 300;
        long deadLine = clock.elapsedRealtime() + this.maxSleepTime;
        long currentTime = clock.elapsedRealtime() + (long)this.sleepTime;
        if (inErrorState) {
            if (currentTime > deadLine || !this.recoverStatus(true)) {
                if (this.serverStateValid()) {
                    this.tryChangeState(64, false);
                }
                return false;
            }
            this.sleepTime = Math.max(this.sleepTime * 2, 1000);
        }
        return true;
    }

    private boolean serverStateValid() {
        if (RESUMABLE_FINAL_STATUS.equals(this.mServerStatus)) {
            if (this.mException == null) {
                this.mException = new IOException("The server has terminated the upload session", this.mServerException);
            }
            this.tryChangeState(64, false);
            return false;
        }
        return true;
    }

    private boolean recoverStatus(boolean withRetry) {
        ResumableUploadQueryRequest queryRequest = new ResumableUploadQueryRequest(this.mStorageRef.getStorageReferenceUri(), this.mStorageRef.getApp(), this.mUploadUri);
        if (RESUMABLE_FINAL_STATUS.equals(this.mServerStatus)) {
            return false;
        }
        if (withRetry ? !this.sendWithRetry(queryRequest) : !this.send(queryRequest)) {
            return false;
        }
        if (RESUMABLE_FINAL_STATUS.equals(queryRequest.getResultString("X-Goog-Upload-Status"))) {
            this.mException = new IOException("The server has terminated the upload session");
            return false;
        }
        String bytes = queryRequest.getResultString("X-Goog-Upload-Size-Received");
        long newBytesUploaded = !TextUtils.isEmpty(bytes) ? Long.parseLong(bytes) : 0L;
        long currentBytes = this.mBytesUploaded.get();
        if (currentBytes > newBytesUploaded) {
            this.mException = new IOException("Unexpected error. The server lost a chunk update.");
            return false;
        }
        if (currentBytes < newBytesUploaded) {
            try {
                if ((long)this.mStreamBuffer.advance((int)(newBytesUploaded - currentBytes)) != newBytesUploaded - currentBytes) {
                    this.mException = new IOException("Unexpected end of stream encountered.");
                    return false;
                }
                if (!this.mBytesUploaded.compareAndSet(currentBytes, newBytesUploaded)) {
                    Log.e(TAG, "Somehow, the uploaded bytes changed during an uploaded.  This should nothappen");
                    this.mException = new IllegalStateException("uploaded bytes changed unexpectedly.");
                    return false;
                }
            }
            catch (IOException e) {
                Log.e(TAG, "Unable to recover position in Stream during resumable upload", e);
                this.mException = e;
                return false;
            }
        }
        return true;
    }

    private boolean delaySend(NetworkRequest request) {
        try {
            Log.d(TAG, "Waiting " + this.sleepTime + " milliseconds");
            sleeper.sleep(this.sleepTime + random.nextInt(250));
        }
        catch (InterruptedException e) {
            Log.w(TAG, "thread interrupted during exponential backoff.");
            Thread.currentThread().interrupt();
            this.mServerException = e;
            return false;
        }
        boolean sendRes = this.send(request);
        if (sendRes) {
            this.sleepTime = 0;
        }
        return sendRes;
    }

    private void uploadChunk() {
        block7: {
            try {
                this.mStreamBuffer.fill(this.mCurrentChunkSize);
                int bytesToUpload = Math.min(this.mCurrentChunkSize, this.mStreamBuffer.available());
                ResumableUploadByteRequest uploadRequest = new ResumableUploadByteRequest(this.mStorageRef.getStorageReferenceUri(), this.mStorageRef.getApp(), this.mUploadUri, this.mStreamBuffer.get(), this.mBytesUploaded.get(), bytesToUpload, this.mStreamBuffer.isFinished());
                if (!this.delaySend(uploadRequest)) {
                    this.mCurrentChunkSize = 262144;
                    Log.d(TAG, "Resetting chunk size to " + this.mCurrentChunkSize);
                    return;
                }
                this.mBytesUploaded.getAndAdd(bytesToUpload);
                if (!this.mStreamBuffer.isFinished()) {
                    this.mStreamBuffer.advance(bytesToUpload);
                    if (this.mCurrentChunkSize < 0x2000000) {
                        this.mCurrentChunkSize *= 2;
                        Log.d(TAG, "Increasing chunk size to " + this.mCurrentChunkSize);
                    }
                    break block7;
                }
                try {
                    this.mMetadata = new StorageMetadata.Builder(uploadRequest.getResultBody(), this.mStorageRef).build();
                }
                catch (JSONException e) {
                    Log.e(TAG, "Unable to parse resulting metadata from upload:" + uploadRequest.getRawResult(), e);
                    this.mException = e;
                    return;
                }
                this.tryChangeState(4, false);
                this.tryChangeState(128, false);
            }
            catch (IOException e) {
                Log.e(TAG, "Unable to read bytes for uploading", e);
                this.mException = e;
            }
        }
    }

    private boolean isValidHttpResponseCode(int code) {
        return code == 308 || code >= 200 && code < 300;
    }

    private boolean send(NetworkRequest request) {
        request.performRequest(Util.getCurrentAuthToken(this.mAuthProvider), Util.getCurrentAppCheckToken(this.mAppCheckProvider), this.mStorageRef.getApp().getApplicationContext());
        return this.processResultValid(request);
    }

    private boolean sendWithRetry(NetworkRequest request) {
        this.mSender.sendWithExponentialBackoff(request);
        return this.processResultValid(request);
    }

    private boolean processResultValid(NetworkRequest request) {
        int resultCode = request.getResultCode();
        this.mResultCode = this.mSender.isRetryableError(resultCode) ? -2 : resultCode;
        this.mServerException = request.getException();
        this.mServerStatus = request.getResultString("X-Goog-Upload-Status");
        return this.isValidHttpResponseCode(this.mResultCode) && this.mServerException == null;
    }

    @Override
    protected void onCanceled() {
        this.mSender.cancel();
        ResumableUploadCancelRequest cancelRequest = null;
        if (this.mUploadUri != null) {
            cancelRequest = new ResumableUploadCancelRequest(this.mStorageRef.getStorageReferenceUri(), this.mStorageRef.getApp(), this.mUploadUri);
        }
        if (cancelRequest != null) {
            final ResumableUploadCancelRequest finalCancelRequest = cancelRequest;
            StorageTaskScheduler.getInstance().scheduleCommand(new Runnable(){

                @Override
                public void run() {
                    finalCancelRequest.performRequest(Util.getCurrentAuthToken(UploadTask.this.mAuthProvider), Util.getCurrentAppCheckToken(UploadTask.this.mAppCheckProvider), UploadTask.this.mStorageRef.getApp().getApplicationContext());
                }
            });
        }
        this.mException = StorageException.fromErrorStatus(Status.RESULT_CANCELED);
        super.onCanceled();
    }

    @Override
    @NonNull
    TaskSnapshot snapStateImpl() {
        Exception error = this.mException != null ? this.mException : this.mServerException;
        return new TaskSnapshot(StorageException.fromExceptionAndHttpCode(error, this.mResultCode), this.mBytesUploaded.get(), this.mUploadUri, this.mMetadata);
    }

    public class TaskSnapshot
    extends StorageTask.SnapshotBase {
        private final long mBytesUploaded;
        private final Uri mUploadUri;
        private final StorageMetadata mMetadata;

        TaskSnapshot(Exception error, long bytesuploaded, Uri uploadUri, StorageMetadata metadata) {
            super(error);
            this.mBytesUploaded = bytesuploaded;
            this.mUploadUri = uploadUri;
            this.mMetadata = metadata;
        }

        public long getBytesTransferred() {
            return this.mBytesUploaded;
        }

        public long getTotalByteCount() {
            return UploadTask.this.getTotalByteCount();
        }

        @Nullable
        public Uri getUploadSessionUri() {
            return this.mUploadUri;
        }

        @Nullable
        public StorageMetadata getMetadata() {
            return this.mMetadata;
        }
    }
}

