/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.internal;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;

public class AdaptiveStreamBuffer {
    private static final String TAG = "AdaptiveStreamBuffer";
    private static final Runtime runtime = Runtime.getRuntime();
    private final InputStream source;
    private byte[] buffer;
    private int availableBytes;
    private boolean reachedEnd;
    private boolean adaptiveMode;

    public AdaptiveStreamBuffer(InputStream source, int initialBufferSize) {
        this.source = source;
        this.buffer = new byte[initialBufferSize];
        this.availableBytes = 0;
        this.adaptiveMode = true;
        this.reachedEnd = false;
    }

    public int available() {
        return this.availableBytes;
    }

    public byte[] get() {
        return this.buffer;
    }

    public int advance(int bytes) throws IOException {
        int bytesAdvanced;
        if (bytes <= this.availableBytes) {
            this.availableBytes -= bytes;
            System.arraycopy(this.buffer, bytes, this.buffer, 0, this.availableBytes);
            bytesAdvanced = bytes;
        } else {
            bytesAdvanced = this.availableBytes = 0;
            while (bytesAdvanced < bytes) {
                int currentSkip = (int)this.source.skip(bytes - bytesAdvanced);
                if (currentSkip > 0) {
                    bytesAdvanced += currentSkip;
                    continue;
                }
                if (currentSkip != 0) continue;
                if (this.source.read() == -1) break;
                ++bytesAdvanced;
            }
        }
        return bytesAdvanced;
    }

    public int fill(int targetSize) throws IOException {
        if (targetSize > this.buffer.length) {
            targetSize = Math.min(targetSize, this.resize(targetSize));
        }
        while (this.availableBytes < targetSize) {
            int currentRead = this.source.read(this.buffer, this.availableBytes, targetSize - this.availableBytes);
            if (currentRead == -1) {
                this.reachedEnd = true;
                break;
            }
            this.availableBytes += currentRead;
        }
        return this.availableBytes;
    }

    private int resize(int targetSize) {
        int newBufferSize = Math.max(this.buffer.length * 2, targetSize);
        long currentFootprint = runtime.totalMemory() - runtime.freeMemory();
        long availableMemory = runtime.maxMemory() - currentFootprint;
        if (this.adaptiveMode && (long)newBufferSize < availableMemory) {
            try {
                byte[] chunkBuffer = new byte[newBufferSize];
                System.arraycopy(this.buffer, 0, chunkBuffer, 0, this.availableBytes);
                this.buffer = chunkBuffer;
            }
            catch (OutOfMemoryError e) {
                Log.w(TAG, "Turning off adaptive buffer resizing due to low memory.");
                this.adaptiveMode = false;
            }
        } else {
            Log.w(TAG, "Turning off adaptive buffer resizing to conserve memory.");
        }
        return this.buffer.length;
    }

    public boolean isFinished() {
        return this.reachedEnd;
    }

    public void close() throws IOException {
        this.source.close();
    }
}

