/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage.internal;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.emulators.EmulatedServiceSettings;
import com.google.firebase.storage.internal.Slashes;
import com.google.firebase.storage.network.NetworkRequest;

public class StorageReferenceUri {
    private final Uri httpBaseUri;
    private final Uri httpUri;
    private final Uri gsUri;

    public StorageReferenceUri(@NonNull Uri gsUri) {
        this(gsUri, null);
    }

    public StorageReferenceUri(@NonNull Uri gsUri, @Nullable EmulatedServiceSettings emulatorSettings) {
        this.gsUri = gsUri;
        this.httpBaseUri = emulatorSettings == null ? NetworkRequest.PROD_BASE_URL : Uri.parse("http://" + emulatorSettings.getHost() + ":" + emulatorSettings.getPort() + "/v0");
        String bucket = gsUri.getAuthority();
        Uri.Builder httpBuilder = this.httpBaseUri.buildUpon().appendPath("b").appendEncodedPath(bucket);
        String path = Slashes.normalizeSlashes(gsUri.getPath());
        if (path.length() > 0 && !"/".equals(path)) {
            httpBuilder = httpBuilder.appendPath("o").appendPath(path);
        }
        this.httpUri = httpBuilder.build();
    }

    @NonNull
    public Uri getHttpBaseUri() {
        return this.httpBaseUri;
    }

    @NonNull
    public Uri getHttpUri() {
        return this.httpUri;
    }

    @NonNull
    public Uri getGsUri() {
        return this.gsUri;
    }
}

