/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import android.app.Activity;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.storage.StorageTask;
import com.google.firebase.storage.internal.ActivityLifecycleListener;
import com.google.firebase.storage.internal.SmartHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;

class TaskListenerImpl<ListenerTypeT, ResultT extends StorageTask.ProvideError> {
    private final Queue<ListenerTypeT> listenerQueue = new ConcurrentLinkedQueue<ListenerTypeT>();
    private final HashMap<ListenerTypeT, SmartHandler> handlerMap = new HashMap();
    private StorageTask<ResultT> task;
    private int targetStates;
    private OnRaise<ListenerTypeT, ResultT> onRaise;

    public TaskListenerImpl(@NonNull StorageTask<ResultT> task, int targetInternalStates, @NonNull OnRaise<ListenerTypeT, ResultT> onRaise) {
        this.task = task;
        this.targetStates = targetInternalStates;
        this.onRaise = onRaise;
    }

    public int getListenerCount() {
        return Math.max(this.listenerQueue.size(), this.handlerMap.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@Nullable Activity activity, @Nullable Executor executor, @NonNull ListenerTypeT listener2) {
        SmartHandler handler;
        Preconditions.checkNotNull(listener2);
        boolean shouldFire = false;
        Object object = this.task.getSyncObject();
        synchronized (object) {
            if ((this.task.getInternalState() & this.targetStates) != 0) {
                shouldFire = true;
            }
            this.listenerQueue.add(listener2);
            handler = new SmartHandler(executor);
            this.handlerMap.put(listener2, handler);
            if (activity != null) {
                if (Build.VERSION.SDK_INT >= 17) {
                    Preconditions.checkArgument(!activity.isDestroyed(), "Activity is already destroyed!");
                }
                ActivityLifecycleListener.getInstance().runOnActivityStopped(activity, listener2, () -> this.removeListener(listener2));
            }
        }
        if (shouldFire) {
            ResultT snappedState = this.task.snapState();
            handler.callBack(() -> this.onRaise.raise(listener2, (StorageTask.ProvideError)snappedState));
        }
    }

    public void onInternalStateChanged() {
        if ((this.task.getInternalState() & this.targetStates) != 0) {
            ResultT snappedState = this.task.snapState();
            Iterator iterator = this.listenerQueue.iterator();
            while (iterator.hasNext()) {
                Object c;
                Object finalCallback = c = iterator.next();
                SmartHandler handler = this.handlerMap.get(c);
                if (handler == null) continue;
                handler.callBack(() -> this.onRaise.raise(finalCallback, (StorageTask.ProvideError)snappedState));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NonNull ListenerTypeT listener2) {
        Preconditions.checkNotNull(listener2);
        Object object = this.task.getSyncObject();
        synchronized (object) {
            this.handlerMap.remove(listener2);
            this.listenerQueue.remove(listener2);
            ActivityLifecycleListener.getInstance().removeCookie(listener2);
        }
    }

    static interface OnRaise<ListenerTypeT, ResultT> {
        public void raise(@NonNull ListenerTypeT var1, @NonNull ResultT var2);
    }
}

