(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-diff-utils-node'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-diff-utils-node'.");
    }root['kotlin-diff-utils-node'] = factory(typeof this['kotlin-diff-utils-node'] === 'undefined' ? {} : this['kotlin-diff-utils-node'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var lines = Kotlin.kotlin.text.lines_gw00vp$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var iterator = Kotlin.kotlin.text.iterator_gw00vp$;
  var unboxChar = Kotlin.unboxChar;
  var ensureNotNull = Kotlin.ensureNotNull;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var startsWith = Kotlin.kotlin.text.startsWith_7epoxm$;
  var equals = Kotlin.equals;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var toString = Kotlin.toString;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_mqih57$;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var toList = Kotlin.kotlin.collections.toList_us0mfu$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var L1 = Kotlin.Long.ONE;
  var Exception = Kotlin.kotlin.Exception;
  var Exception_init = Kotlin.kotlin.Exception_init;
  var Exception_init_0 = Kotlin.kotlin.Exception_init_pdl1vj$;
  var Unit = Kotlin.kotlin.Unit;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var StringBuilder = Kotlin.kotlin.text.StringBuilder;
  var Triple = Kotlin.kotlin.Triple;
  var throwCCE = Kotlin.throwCCE;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var ArrayList_init_1 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var sortWith = Kotlin.kotlin.collections.sortWith_nqfjgj$;
  var wrapFunction = Kotlin.wrapFunction;
  var Comparator = Kotlin.kotlin.Comparator;
  var toList_0 = Kotlin.kotlin.collections.toList_7wnvza$;
  var reverse = Kotlin.kotlin.collections.reverse_vvxzk3$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var Math_0 = Math;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var replace = Kotlin.kotlin.text.replace_680rmw$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var firstOrNull = Kotlin.kotlin.collections.firstOrNull_2p1efm$;
  DiffException.prototype = Object.create(Exception.prototype);
  DiffException.prototype.constructor = DiffException;
  DifferentiationFailedException.prototype = Object.create(DiffException.prototype);
  DifferentiationFailedException.prototype.constructor = DifferentiationFailedException;
  ChangeDelta.prototype = Object.create(AbstractDelta.prototype);
  ChangeDelta.prototype.constructor = ChangeDelta;
  DeleteDelta.prototype = Object.create(AbstractDelta.prototype);
  DeleteDelta.prototype.constructor = DeleteDelta;
  DeltaType.prototype = Object.create(Enum.prototype);
  DeltaType.prototype.constructor = DeltaType;
  DiffException_0.prototype = Object.create(Exception.prototype);
  DiffException_0.prototype.constructor = DiffException_0;
  InsertDelta.prototype = Object.create(AbstractDelta.prototype);
  InsertDelta.prototype.constructor = InsertDelta;
  PatchFailedException.prototype = Object.create(DiffException_0.prototype);
  PatchFailedException.prototype.constructor = PatchFailedException;
  DiffRow$Tag.prototype = Object.create(Enum.prototype);
  DiffRow$Tag.prototype.constructor = DiffRow$Tag;
  function DiffUtils() {
    DiffUtils_instance = this;
  }
  DiffUtils.prototype.diff_zfbf80$ = function (original, revised, progress) {
    return this.diff_zksj4$(original, revised, MyersDiff_init(), progress);
  };
  DiffUtils.prototype.diff_s9r2lo$ = function (original, revised) {
    return this.diff_zksj4$(original, revised, MyersDiff_init(), null);
  };
  DiffUtils.prototype.diff_te2xd8$ = function (sourceText, targetText, progress) {
    return this.diff_zfbf80$(lines(sourceText), lines(targetText), progress);
  };
  DiffUtils.prototype.diff_7p8tlw$ = function (source, target, equalizer) {
    var tmp$;
    if (equalizer != null) {
      tmp$ = this.diff_46jce1$(source, target, MyersDiff_init_0(equalizer));
    } else
      tmp$ = this.diff_46jce1$(source, target, MyersDiff_init());
    return tmp$;
  };
  DiffUtils.prototype.diff_zksj4$ = function (original, revised, algorithm, progress) {
    return Patch$Companion_getInstance().generate_avxn3$(original, revised, algorithm.computeDiff_s9mzjv$(original, revised, progress));
  };
  DiffUtils.prototype.diff_46jce1$ = function (original, revised, algorithm) {
    return this.diff_zksj4$(original, revised, algorithm, null);
  };
  DiffUtils.prototype.diffInline_puj7f4$ = function (original, revised) {
    var tmp$, tmp$_0, tmp$_1;
    var origList = ArrayList_init();
    var revList = ArrayList_init();
    tmp$ = iterator(original);
    while (tmp$.hasNext()) {
      var character = unboxChar(tmp$.next());
      origList.add_11rb$(String.fromCharCode(character));
    }
    tmp$_0 = iterator(revised);
    while (tmp$_0.hasNext()) {
      var character_0 = unboxChar(tmp$_0.next());
      revList.add_11rb$(String.fromCharCode(character_0));
    }
    var patch = this.diff_s9r2lo$(origList, revList);
    tmp$_1 = patch.getDeltas().iterator();
    while (tmp$_1.hasNext()) {
      var delta = tmp$_1.next();
      delta.source.lines = this.compressLines_0(ensureNotNull(delta.source.lines), '');
      delta.target.lines = this.compressLines_0(ensureNotNull(delta.target.lines), '');
    }
    return patch;
  };
  DiffUtils.prototype.compressLines_0 = function (lines, delimiter) {
    var tmp$;
    if (lines.isEmpty()) {
      tmp$ = emptyList();
    } else
      tmp$ = listOf(joinToString(lines, delimiter));
    return tmp$;
  };
  DiffUtils.prototype.patch_1pcrgs$ = function (original, patch) {
    return patch.applyTo_4ezy5m$(original);
  };
  DiffUtils.prototype.unpatch_1pcrgs$ = function (revised, patch) {
    return patch.restore_4ezy5m$(revised);
  };
  DiffUtils.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'DiffUtils',
    interfaces: []
  };
  var DiffUtils_instance = null;
  function DiffUtils_getInstance() {
    if (DiffUtils_instance === null) {
      new DiffUtils();
    }return DiffUtils_instance;
  }
  function UnifiedDiffUtils() {
    UnifiedDiffUtils_instance = this;
    this.UNIFIED_DIFF_CHUNK_REGEXP_0 = Regex_init('^@@\\s+-(?:(\\d+)(?:,(\\d+))?)\\s+\\+(?:(\\d+)(?:,(\\d+))?)\\s+@@$');
  }
  UnifiedDiffUtils.prototype.parseUnifiedDiff_mhpeer$ = function (diff) {
    var tmp$, tmp$_0, tmp$_1;
    var inPrelude = true;
    var rawChunk = ArrayList_init();
    var patch = new Patch();
    var old_ln = 0;
    var new_ln = 0;
    var tag;
    var rest;
    tmp$ = diff.iterator();
    while (tmp$.hasNext()) {
      var line = tmp$.next();
      if (inPrelude) {
        if (startsWith(line, '+++')) {
          inPrelude = false;
        }continue;
      }var m = this.UNIFIED_DIFF_CHUNK_REGEXP_0.find_905azu$(line);
      if (m != null) {
        if (!rawChunk.isEmpty()) {
          var oldChunkLines = ArrayList_init();
          var newChunkLines = ArrayList_init();
          tmp$_0 = rawChunk.iterator();
          while (tmp$_0.hasNext()) {
            var raw_line = tmp$_0.next();
            tag = raw_line[0];
            rest = raw_line[1];
            if (equals(' ', tag) || equals('-', tag)) {
              oldChunkLines.add_11rb$(rest);
            }if (equals(' ', tag) || equals('+', tag)) {
              newChunkLines.add_11rb$(rest);
            }}
          patch.addDelta_p6ifei$(new ChangeDelta(Chunk_init(old_ln - 1 | 0, oldChunkLines), Chunk_init(new_ln - 1 | 0, newChunkLines)));
          rawChunk.clear();
        }old_ln = m.groups.get_za3lpa$(1) == null ? 1 : toInt(m.groupValues.get_za3lpa$(1));
        new_ln = m.groups.get_za3lpa$(3) == null ? 1 : toInt(m.groupValues.get_za3lpa$(3));
        if (old_ln === 0) {
          old_ln = 1;
        }if (new_ln === 0) {
          new_ln = 1;
        }} else {
        if (line.length > 0) {
          tag = line.substring(0, 1);
          rest = line.substring(1);
          if (equals(' ', tag) || equals('+', tag) || equals('-', tag)) {
            rawChunk.add_11rb$([tag, rest]);
          }} else {
          rawChunk.add_11rb$([' ', '']);
        }
      }
    }
    if (!rawChunk.isEmpty()) {
      var oldChunkLines_0 = ArrayList_init();
      var newChunkLines_0 = ArrayList_init();
      tmp$_1 = rawChunk.iterator();
      while (tmp$_1.hasNext()) {
        var raw_line_0 = tmp$_1.next();
        tag = raw_line_0[0];
        rest = raw_line_0[1];
        if (equals(' ', tag) || equals('-', tag)) {
          oldChunkLines_0.add_11rb$(rest);
        }if (equals(' ', tag) || equals('+', tag)) {
          newChunkLines_0.add_11rb$(rest);
        }}
      patch.addDelta_p6ifei$(new ChangeDelta(Chunk_init(old_ln - 1 | 0, oldChunkLines_0), Chunk_init(new_ln - 1 | 0, newChunkLines_0)));
      rawChunk.clear();
    }return patch;
  };
  UnifiedDiffUtils.prototype.generateUnifiedDiff_pweja4$ = function (originalFileName, revisedFileName, originalLines, patch, contextSize) {
    var tmp$;
    if (!patch.getDeltas().isEmpty()) {
      var ret = ArrayList_init();
      ret.add_11rb$('--- ' + toString(originalFileName));
      ret.add_11rb$('+++ ' + toString(revisedFileName));
      var patchDeltas = ArrayList_init_0(patch.getDeltas());
      var deltas = ArrayList_init();
      var delta = patchDeltas.get_za3lpa$(0);
      deltas.add_11rb$(delta);
      if (patchDeltas.size > 1) {
        tmp$ = patchDeltas.size;
        for (var i = 1; i < tmp$; i++) {
          var position = delta.source.position;
          var nextDelta = patchDeltas.get_za3lpa$(i);
          if ((position + delta.source.size() + contextSize | 0) >= (nextDelta.source.position - contextSize | 0)) {
            deltas.add_11rb$(nextDelta);
          } else {
            var curBlock = this.processDeltas_0(originalLines, deltas, contextSize);
            ret.addAll_brywnq$(curBlock);
            deltas.clear();
            deltas.add_11rb$(nextDelta);
          }
          delta = nextDelta;
        }
      }var curBlock_0 = this.processDeltas_0(originalLines, deltas, contextSize);
      ret.addAll_brywnq$(curBlock_0);
      return ret;
    }return ArrayList_init();
  };
  UnifiedDiffUtils.prototype.processDeltas_0 = function (origLines, deltas, contextSize) {
    var buffer = ArrayList_init();
    var origTotal = 0;
    var revTotal = 0;
    var line;
    var curDelta = deltas.get_za3lpa$(0);
    var origStart = curDelta.source.position + 1 - contextSize | 0;
    if (origStart < 1) {
      origStart = 1;
    }var revStart = curDelta.target.position + 1 - contextSize | 0;
    if (revStart < 1) {
      revStart = 1;
    }var contextStart = curDelta.source.position - contextSize | 0;
    if (contextStart < 0) {
      contextStart = 0;
    }line = contextStart;
    while (line < curDelta.source.position) {
      buffer.add_11rb$(' ' + origLines.get_za3lpa$(line));
      origTotal = origTotal + 1 | 0;
      revTotal = revTotal + 1 | 0;
      line = line + 1 | 0;
    }
    buffer.addAll_brywnq$(this.getDeltaText_0(curDelta));
    origTotal = origTotal + ensureNotNull(curDelta.source.lines).size | 0;
    revTotal = revTotal + ensureNotNull(curDelta.target.lines).size | 0;
    var deltaIndex = 1;
    while (deltaIndex < deltas.size) {
      var nextDelta = deltas.get_za3lpa$(deltaIndex);
      var intermediateStart = curDelta.source.position + ensureNotNull(curDelta.source.lines).size | 0;
      line = intermediateStart;
      while (line < nextDelta.source.position) {
        buffer.add_11rb$(' ' + origLines.get_za3lpa$(line));
        origTotal = origTotal + 1 | 0;
        revTotal = revTotal + 1 | 0;
        line = line + 1 | 0;
      }
      buffer.addAll_brywnq$(this.getDeltaText_0(nextDelta));
      origTotal = origTotal + ensureNotNull(nextDelta.source.lines).size | 0;
      revTotal = revTotal + ensureNotNull(nextDelta.target.lines).size | 0;
      curDelta = nextDelta;
      deltaIndex = deltaIndex + 1 | 0;
    }
    contextStart = curDelta.source.position + ensureNotNull(curDelta.source.lines).size | 0;
    line = contextStart;
    while (line < (contextStart + contextSize | 0) && line < origLines.size) {
      buffer.add_11rb$(' ' + origLines.get_za3lpa$(line));
      origTotal = origTotal + 1 | 0;
      revTotal = revTotal + 1 | 0;
      line = line + 1 | 0;
    }
    var header = StringBuilder_init();
    header.append_pdl1vj$('@@ -');
    header.append_s8jyv4$(origStart);
    header.append_pdl1vj$(',');
    header.append_s8jyv4$(origTotal);
    header.append_pdl1vj$(' +');
    header.append_s8jyv4$(revStart);
    header.append_pdl1vj$(',');
    header.append_s8jyv4$(revTotal);
    header.append_pdl1vj$(' @@');
    buffer.add_wxm5ur$(0, header.toString());
    return buffer;
  };
  UnifiedDiffUtils.prototype.getDeltaText_0 = function (delta) {
    var tmp$, tmp$_0;
    var buffer = ArrayList_init();
    tmp$ = ensureNotNull(delta.source.lines).iterator();
    while (tmp$.hasNext()) {
      var line = tmp$.next();
      buffer.add_11rb$('-' + line);
    }
    tmp$_0 = ensureNotNull(delta.target.lines).iterator();
    while (tmp$_0.hasNext()) {
      var line_0 = tmp$_0.next();
      buffer.add_11rb$('+' + line_0);
    }
    return buffer;
  };
  UnifiedDiffUtils.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'UnifiedDiffUtils',
    interfaces: []
  };
  var UnifiedDiffUtils_instance = null;
  function UnifiedDiffUtils_getInstance() {
    if (UnifiedDiffUtils_instance === null) {
      new UnifiedDiffUtils();
    }return UnifiedDiffUtils_instance;
  }
  function Change(deltaType, startOriginal, endOriginal, startRevised, endRevised) {
    this.deltaType = deltaType;
    this.startOriginal = startOriginal;
    this.endOriginal = endOriginal;
    this.startRevised = startRevised;
    this.endRevised = endRevised;
  }
  Change.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Change',
    interfaces: []
  };
  function DiffAlgorithmI() {
  }
  DiffAlgorithmI.prototype.computeDiff_t0eakh$ = function (source, target, progress) {
    return this.computeDiff_s9mzjv$(toList(source), toList(target), progress);
  };
  DiffAlgorithmI.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DiffAlgorithmI',
    interfaces: []
  };
  function DiffAlgorithmListener() {
  }
  DiffAlgorithmListener.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DiffAlgorithmListener',
    interfaces: []
  };
  function DiffException() {
    DiffException$Companion_getInstance();
    this.name = 'DiffException';
  }
  function DiffException$Companion() {
    DiffException$Companion_instance = this;
    this.serialVersionUID_0 = L1;
  }
  DiffException$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var DiffException$Companion_instance = null;
  function DiffException$Companion_getInstance() {
    if (DiffException$Companion_instance === null) {
      new DiffException$Companion();
    }return DiffException$Companion_instance;
  }
  DiffException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DiffException',
    interfaces: [Exception]
  };
  function DiffException_init($this) {
    $this = $this || Object.create(DiffException.prototype);
    Exception_init($this);
    DiffException.call($this);
    return $this;
  }
  function DiffException_init_0(msg, $this) {
    $this = $this || Object.create(DiffException.prototype);
    Exception_init_0(msg, $this);
    DiffException.call($this);
    return $this;
  }
  function DifferentiationFailedException() {
    DifferentiationFailedException$Companion_getInstance();
    this.name = 'DifferentiationFailedException';
  }
  function DifferentiationFailedException$Companion() {
    DifferentiationFailedException$Companion_instance = this;
    this.serialVersionUID_0 = L1;
  }
  DifferentiationFailedException$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var DifferentiationFailedException$Companion_instance = null;
  function DifferentiationFailedException$Companion_getInstance() {
    if (DifferentiationFailedException$Companion_instance === null) {
      new DifferentiationFailedException$Companion();
    }return DifferentiationFailedException$Companion_instance;
  }
  DifferentiationFailedException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DifferentiationFailedException',
    interfaces: [DiffException]
  };
  function DifferentiationFailedException_init($this) {
    $this = $this || Object.create(DifferentiationFailedException.prototype);
    DiffException_init($this);
    DifferentiationFailedException.call($this);
    return $this;
  }
  function DifferentiationFailedException_init_0(msg, $this) {
    $this = $this || Object.create(DifferentiationFailedException.prototype);
    DiffException_init_0(msg, $this);
    DifferentiationFailedException.call($this);
    return $this;
  }
  function MyersDiff() {
    this.DEFAULT_EQUALIZER_0 = MyersDiff$DEFAULT_EQUALIZER$lambda;
    this.equalizer_0 = null;
  }
  MyersDiff.prototype.computeDiff_s9mzjv$ = function (source, target, progress) {
    progress != null ? (progress.diffStart(), Unit) : null;
    var path = this.buildPath_0(source, target, progress);
    var result = this.buildRevision_0(path, source, target);
    progress != null ? (progress.diffEnd(), Unit) : null;
    return result;
  };
  MyersDiff.prototype.buildPath_0 = function (orig, rev, progress) {
    var N = orig.size;
    var M = rev.size;
    var MAX = N + M + 1 | 0;
    var size = 1 + (2 * MAX | 0) | 0;
    var middle = size / 2 | 0;
    var diagonal = Kotlin.newArray(size, null);
    diagonal[middle + 1 | 0] = new PathNode(0, -1, true, true, null);
    for (var d = 0; d < MAX; d++) {
      progress != null ? (progress.diffStep_vux9f0$(d, MAX), Unit) : null;
      var k = -d | 0;
      while (k <= d) {
        var kmiddle = middle + k | 0;
        var kplus = kmiddle + 1 | 0;
        var kminus = kmiddle - 1 | 0;
        var prev;
        var i;
        if (k === (-d | 0) || (k !== d && ensureNotNull(diagonal[kminus]).i < ensureNotNull(diagonal[kplus]).i)) {
          i = ensureNotNull(diagonal[kplus]).i;
          prev = ensureNotNull(diagonal[kplus]);
        } else {
          i = ensureNotNull(diagonal[kminus]).i + 1 | 0;
          prev = ensureNotNull(diagonal[kminus]);
        }
        diagonal[kminus] = null;
        var j = i - k | 0;
        var node = new PathNode(i, j, false, false, prev);
        while (i < N && j < M && this.equalizer_0(orig.get_za3lpa$(i), rev.get_za3lpa$(j))) {
          i = i + 1 | 0;
          j = j + 1 | 0;
        }
        if (i !== node.i) {
          node = new PathNode(i, j, true, false, node);
        }diagonal[kmiddle] = node;
        if (i >= N && j >= M) {
          return ensureNotNull(diagonal[kmiddle]);
        }k = k + 2 | 0;
      }
      diagonal[middle + d - 1 | 0] = null;
    }
    throw DifferentiationFailedException_init_0('could not find a diff path');
  };
  MyersDiff.prototype.buildRevision_0 = function (actualPath, orig, rev) {
    var path = actualPath;
    var changes = ArrayList_init();
    if (ensureNotNull(path).isSnake) {
      path = path.prev;
    }while (path != null && path.prev != null && ensureNotNull(path.prev).j >= 0) {
      if (path.isSnake) {
        throw IllegalStateException_init('bad diffpath: found snake when looking for diff');
      }var i = path.i;
      var j = path.j;
      path = path.prev;
      var ianchor = ensureNotNull(path).i;
      var janchor = path.j;
      if (ianchor === i && janchor !== j) {
        changes.add_11rb$(new Change(DeltaType$INSERT_getInstance(), ianchor, i, janchor, j));
      } else if (ianchor !== i && janchor === j) {
        changes.add_11rb$(new Change(DeltaType$DELETE_getInstance(), ianchor, i, janchor, j));
      } else {
        changes.add_11rb$(new Change(DeltaType$CHANGE_getInstance(), ianchor, i, janchor, j));
      }
      if (path.isSnake) {
        path = path.prev;
      }}
    return changes;
  };
  function MyersDiff$DEFAULT_EQUALIZER$lambda(obj1, obj2) {
    return equals(obj1, obj2);
  }
  MyersDiff.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MyersDiff',
    interfaces: [DiffAlgorithmI]
  };
  function MyersDiff_init($this) {
    $this = $this || Object.create(MyersDiff.prototype);
    MyersDiff.call($this);
    $this.equalizer_0 = $this.DEFAULT_EQUALIZER_0;
    return $this;
  }
  function MyersDiff_init_0(equalizer, $this) {
    $this = $this || Object.create(MyersDiff.prototype);
    MyersDiff.call($this);
    $this.equalizer_0 = equalizer;
    return $this;
  }
  function PathNode(i, j, isSnake, isBootstrap, prev) {
    this.i = i;
    this.j = j;
    this.isSnake = isSnake;
    this.isBootstrap = isBootstrap;
    this.prev = null;
    if (this.isSnake) {
      this.prev = prev;
    } else {
      this.prev = prev != null ? prev.previousSnake() : null;
    }
  }
  PathNode.prototype.previousSnake = function () {
    var tmp$;
    if (this.isBootstrap) {
      return null;
    }if (!this.isSnake && this.prev != null) {
      tmp$ = this.prev.previousSnake();
    } else
      tmp$ = this;
    return tmp$;
  };
  PathNode.prototype.toString = function () {
    var buf = new StringBuilder('[');
    var node = this;
    while (node != null) {
      buf.append_pdl1vj$('(');
      buf.append_s8jyv4$(node.i);
      buf.append_pdl1vj$(',');
      buf.append_s8jyv4$(node.j);
      buf.append_pdl1vj$(')');
      node = node.prev;
    }
    buf.append_pdl1vj$(']');
    return buf.toString();
  };
  PathNode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PathNode',
    interfaces: []
  };
  function AbstractDelta(type, source, target) {
    this.type = type;
    this.source = source;
    this.target = target;
  }
  AbstractDelta.prototype.verifyChunk_4ezy5m$ = function (target) {
    this.source.verify_4ezy5m$(target);
  };
  AbstractDelta.prototype.hashCode = function () {
    return (new Triple(this.source, this.target, this.type)).hashCode();
  };
  AbstractDelta.prototype.equals = function (obj) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    if (this === obj) {
      return true;
    }if (obj == null) {
      return false;
    }if (!((tmp$ = Kotlin.getKClassFromExpression(this)) != null ? tmp$.equals(Kotlin.getKClassFromExpression(obj)) : null)) {
      return false;
    }var other = (tmp$_0 = obj) == null || Kotlin.isType(tmp$_0, AbstractDelta) ? tmp$_0 : throwCCE();
    if (!((tmp$_1 = this.source) != null ? tmp$_1.equals(ensureNotNull(other).source) : null)) {
      return false;
    }if (!((tmp$_2 = this.target) != null ? tmp$_2.equals(other.target) : null)) {
      return false;
    }if (this.type !== other.type) {
      tmp$_3 = false;
    } else
      tmp$_3 = true;
    return tmp$_3;
  };
  AbstractDelta.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AbstractDelta',
    interfaces: []
  };
  function ChangeDelta(source, target) {
    AbstractDelta.call(this, DeltaType$CHANGE_getInstance(), source, target);
  }
  ChangeDelta.prototype.applyTo_ufm9l7$ = function (t) {
    var tmp$;
    this.verifyChunk_4ezy5m$(t);
    var position = this.source.position;
    var size = this.source.size();
    for (var i = 0; i < size; i++) {
      t.removeAt_za3lpa$(position);
    }
    var i_0 = 0;
    tmp$ = ensureNotNull(this.target.lines).iterator();
    while (tmp$.hasNext()) {
      var line = tmp$.next();
      t.add_wxm5ur$(position + i_0 | 0, line);
      i_0 = i_0 + 1 | 0;
    }
  };
  ChangeDelta.prototype.restore_ufm9l7$ = function (t) {
    var tmp$;
    var position = this.target.position;
    var size = this.target.size();
    for (var i = 0; i < size; i++) {
      t.removeAt_za3lpa$(position);
    }
    var i_0 = 0;
    tmp$ = ensureNotNull(this.source.lines).iterator();
    while (tmp$.hasNext()) {
      var line = tmp$.next();
      t.add_wxm5ur$(position + i_0 | 0, line);
      i_0 = i_0 + 1 | 0;
    }
  };
  ChangeDelta.prototype.toString = function () {
    return '[ChangeDelta, position: ' + toString(this.source.position) + ', lines: ' + toString(this.source.lines) + ' to ' + toString(this.target.lines) + ']';
  };
  ChangeDelta.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChangeDelta',
    interfaces: [AbstractDelta]
  };
  function Chunk() {
    this.position = 0;
    this.lines = null;
  }
  Chunk.prototype.verify_4ezy5m$ = function (target) {
    var tmp$;
    if (this.position > target.size || this.last() > target.size) {
      throw PatchFailedException_init_0('Incorrect Chunk: the position of chunk > target size');
    }tmp$ = this.size();
    for (var i = 0; i < tmp$; i++) {
      if (!equals(target.get_za3lpa$(this.position + i | 0), ensureNotNull(this.lines).get_za3lpa$(i))) {
        throw PatchFailedException_init_0("Incorrect Chunk: the chunk content doesn't match the target");
      }}
  };
  Chunk.prototype.size = function () {
    return ensureNotNull(this.lines).size;
  };
  Chunk.prototype.last = function () {
    return this.position + this.size() - 1 | 0;
  };
  Chunk.prototype.hashCode = function () {
    return (new Triple(this.lines, this.position, this.size())).hashCode();
  };
  Chunk.prototype.equals = function (obj) {
    var tmp$, tmp$_0;
    if (this === obj) {
      return true;
    }if (obj == null) {
      return false;
    }if (!((tmp$ = Kotlin.getKClassFromExpression(this)) != null ? tmp$.equals(Kotlin.getKClassFromExpression(obj)) : null)) {
      return false;
    }var other = (tmp$_0 = obj) == null || Kotlin.isType(tmp$_0, Chunk) ? tmp$_0 : throwCCE();
    if (this.lines == null) {
      if (ensureNotNull(other).lines != null) {
        return false;
      }} else if (!equals(this.lines, ensureNotNull(other).lines)) {
      return false;
    }return this.position === other.position;
  };
  Chunk.prototype.toString = function () {
    return '[position: ' + toString(this.position) + ', size: ' + toString(this.size()) + ', lines: ' + toString(this.lines) + ']';
  };
  Chunk.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Chunk',
    interfaces: []
  };
  function Chunk_init(position, lines, $this) {
    $this = $this || Object.create(Chunk.prototype);
    Chunk.call($this);
    $this.position = position;
    $this.lines = ArrayList_init_0(lines);
    return $this;
  }
  function Chunk_init_0(position, lines, $this) {
    $this = $this || Object.create(Chunk.prototype);
    Chunk.call($this);
    $this.position = position;
    $this.lines = toList(lines);
    return $this;
  }
  function DeleteDelta(original, revised) {
    AbstractDelta.call(this, DeltaType$DELETE_getInstance(), original, revised);
  }
  DeleteDelta.prototype.applyTo_ufm9l7$ = function (target) {
    this.verifyChunk_4ezy5m$(target);
    var position = this.source.position;
    var size = this.source.size();
    for (var i = 0; i < size; i++) {
      target.removeAt_za3lpa$(position);
    }
  };
  DeleteDelta.prototype.restore_ufm9l7$ = function (target) {
    var tmp$;
    var position = this.target.position;
    var lines = this.source.lines;
    tmp$ = ensureNotNull(lines);
    for (var i = 0; i !== tmp$.size; ++i) {
      target.add_wxm5ur$(position + i | 0, lines.get_za3lpa$(i));
    }
  };
  DeleteDelta.prototype.toString = function () {
    return '[DeleteDelta, position: ' + toString(this.source.position) + ', lines: ' + toString(this.source.lines) + ']';
  };
  DeleteDelta.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DeleteDelta',
    interfaces: [AbstractDelta]
  };
  function DeltaType(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function DeltaType_initFields() {
    DeltaType_initFields = function () {
    };
    DeltaType$CHANGE_instance = new DeltaType('CHANGE', 0);
    DeltaType$DELETE_instance = new DeltaType('DELETE', 1);
    DeltaType$INSERT_instance = new DeltaType('INSERT', 2);
    DeltaType$EQUAL_instance = new DeltaType('EQUAL', 3);
  }
  var DeltaType$CHANGE_instance;
  function DeltaType$CHANGE_getInstance() {
    DeltaType_initFields();
    return DeltaType$CHANGE_instance;
  }
  var DeltaType$DELETE_instance;
  function DeltaType$DELETE_getInstance() {
    DeltaType_initFields();
    return DeltaType$DELETE_instance;
  }
  var DeltaType$INSERT_instance;
  function DeltaType$INSERT_getInstance() {
    DeltaType_initFields();
    return DeltaType$INSERT_instance;
  }
  var DeltaType$EQUAL_instance;
  function DeltaType$EQUAL_getInstance() {
    DeltaType_initFields();
    return DeltaType$EQUAL_instance;
  }
  DeltaType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DeltaType',
    interfaces: [Enum]
  };
  function DeltaType$values() {
    return [DeltaType$CHANGE_getInstance(), DeltaType$DELETE_getInstance(), DeltaType$INSERT_getInstance(), DeltaType$EQUAL_getInstance()];
  }
  DeltaType.values = DeltaType$values;
  function DeltaType$valueOf(name) {
    switch (name) {
      case 'CHANGE':
        return DeltaType$CHANGE_getInstance();
      case 'DELETE':
        return DeltaType$DELETE_getInstance();
      case 'INSERT':
        return DeltaType$INSERT_getInstance();
      case 'EQUAL':
        return DeltaType$EQUAL_getInstance();
      default:throwISE('No enum constant dev.gitlive.difflib.patch.DeltaType.' + name);
    }
  }
  DeltaType.valueOf_61zpoe$ = DeltaType$valueOf;
  function DiffException_0() {
    DiffException$Companion_getInstance_0();
    this.name = 'DiffException';
  }
  function DiffException$Companion_0() {
    DiffException$Companion_instance_0 = this;
    this.serialVersionUID_0 = L1;
  }
  DiffException$Companion_0.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var DiffException$Companion_instance_0 = null;
  function DiffException$Companion_getInstance_0() {
    if (DiffException$Companion_instance_0 === null) {
      new DiffException$Companion_0();
    }return DiffException$Companion_instance_0;
  }
  DiffException_0.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DiffException',
    interfaces: [Exception]
  };
  function DiffException_init_1($this) {
    $this = $this || Object.create(DiffException_0.prototype);
    Exception_init($this);
    DiffException_0.call($this);
    return $this;
  }
  function DiffException_init_2(msg, $this) {
    $this = $this || Object.create(DiffException_0.prototype);
    Exception_init_0(msg, $this);
    DiffException_0.call($this);
    return $this;
  }
  function InsertDelta(original, revised) {
    AbstractDelta.call(this, DeltaType$INSERT_getInstance(), original, revised);
  }
  InsertDelta.prototype.applyTo_ufm9l7$ = function (target) {
    var tmp$;
    this.verifyChunk_4ezy5m$(target);
    var position = this.source.position;
    var lines = this.target.lines;
    tmp$ = ensureNotNull(lines);
    for (var i = 0; i !== tmp$.size; ++i) {
      target.add_wxm5ur$(position + i | 0, lines.get_za3lpa$(i));
    }
  };
  InsertDelta.prototype.restore_ufm9l7$ = function (t) {
    var position = this.target.position;
    var size = this.target.size();
    for (var i = 0; i < size; i++) {
      t.removeAt_za3lpa$(position);
    }
  };
  InsertDelta.prototype.toString = function () {
    return '[InsertDelta, position: ' + toString(this.source.position) + ', lines: ' + toString(this.target.lines) + ']';
  };
  InsertDelta.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InsertDelta',
    interfaces: [AbstractDelta]
  };
  var compareBy$lambda = wrapFunction(function () {
    var compareValues = Kotlin.kotlin.comparisons.compareValues_s00gnj$;
    return function (closure$selector) {
      return function (a, b) {
        var selector = closure$selector;
        return compareValues(selector(a), selector(b));
      };
    };
  });
  function Patch(estimatedPatchSize) {
    Patch$Companion_getInstance();
    if (estimatedPatchSize === void 0)
      estimatedPatchSize = 10;
    this.deltas_8be2vx$ = null;
    this.deltas_8be2vx$ = ArrayList_init_1(estimatedPatchSize);
  }
  Patch.prototype.applyTo_4ezy5m$ = function (target) {
    var result = ArrayList_init_0(target);
    var it = this.getDeltas().listIterator_za3lpa$(this.deltas_8be2vx$.size);
    while (it.hasPrevious()) {
      var delta = it.previous();
      delta.applyTo_ufm9l7$(result);
    }
    return result;
  };
  Patch.prototype.restore_4ezy5m$ = function (target) {
    var result = ArrayList_init_0(target);
    var it = this.getDeltas().listIterator_za3lpa$(this.deltas_8be2vx$.size);
    while (it.hasPrevious()) {
      var delta = it.previous();
      delta.restore_ufm9l7$(result);
    }
    return result;
  };
  Patch.prototype.addDelta_p6ifei$ = function (delta) {
    this.deltas_8be2vx$.add_11rb$(delta);
  };
  function Patch$getDeltas$lambda(d) {
    return d.source.position;
  }
  Patch.prototype.getDeltas = function () {
    var $receiver = this.deltas_8be2vx$;
    if ($receiver.size > 1) {
      sortWith($receiver, new Comparator(compareBy$lambda(Patch$getDeltas$lambda)));
    }return this.deltas_8be2vx$;
  };
  Patch.prototype.toString = function () {
    return 'Patch{deltas=' + this.deltas_8be2vx$ + '}';
  };
  function Patch$Companion() {
    Patch$Companion_instance = this;
  }
  Patch$Companion.prototype.generate_avxn3$ = function (original, revised, changes) {
    var tmp$;
    var patch = new Patch(changes.size);
    tmp$ = changes.iterator();
    while (tmp$.hasNext()) {
      var change = tmp$.next();
      var orgChunk = Chunk_init(change.startOriginal, ArrayList_init_0(original.subList_vux9f0$(change.startOriginal, change.endOriginal)));
      var revChunk = Chunk_init(change.startRevised, ArrayList_init_0(revised.subList_vux9f0$(change.startRevised, change.endRevised)));
      switch (change.deltaType.name) {
        case 'DELETE':
          patch.addDelta_p6ifei$(new DeleteDelta(orgChunk, revChunk));
          break;
        case 'INSERT':
          patch.addDelta_p6ifei$(new InsertDelta(orgChunk, revChunk));
          break;
        case 'CHANGE':
          patch.addDelta_p6ifei$(new ChangeDelta(orgChunk, revChunk));
          break;
      }
    }
    return patch;
  };
  Patch$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Patch$Companion_instance = null;
  function Patch$Companion_getInstance() {
    if (Patch$Companion_instance === null) {
      new Patch$Companion();
    }return Patch$Companion_instance;
  }
  Patch.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Patch',
    interfaces: []
  };
  function PatchFailedException() {
    PatchFailedException$Companion_getInstance();
    this.name = 'PatchFailedException';
  }
  function PatchFailedException$Companion() {
    PatchFailedException$Companion_instance = this;
    this.serialVersionUID_0 = L1;
  }
  PatchFailedException$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PatchFailedException$Companion_instance = null;
  function PatchFailedException$Companion_getInstance() {
    if (PatchFailedException$Companion_instance === null) {
      new PatchFailedException$Companion();
    }return PatchFailedException$Companion_instance;
  }
  PatchFailedException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PatchFailedException',
    interfaces: [DiffException_0]
  };
  function PatchFailedException_init($this) {
    $this = $this || Object.create(PatchFailedException.prototype);
    DiffException_init_1($this);
    PatchFailedException.call($this);
    return $this;
  }
  function PatchFailedException_init_0(msg, $this) {
    $this = $this || Object.create(PatchFailedException.prototype);
    DiffException_init_2(msg, $this);
    PatchFailedException.call($this);
    return $this;
  }
  function DiffRow(tag, oldLine, newLine) {
    this.tag = tag;
    this.oldLine = oldLine;
    this.newLine = newLine;
  }
  function DiffRow$Tag(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function DiffRow$Tag_initFields() {
    DiffRow$Tag_initFields = function () {
    };
    DiffRow$Tag$INSERT_instance = new DiffRow$Tag('INSERT', 0);
    DiffRow$Tag$DELETE_instance = new DiffRow$Tag('DELETE', 1);
    DiffRow$Tag$CHANGE_instance = new DiffRow$Tag('CHANGE', 2);
    DiffRow$Tag$EQUAL_instance = new DiffRow$Tag('EQUAL', 3);
  }
  var DiffRow$Tag$INSERT_instance;
  function DiffRow$Tag$INSERT_getInstance() {
    DiffRow$Tag_initFields();
    return DiffRow$Tag$INSERT_instance;
  }
  var DiffRow$Tag$DELETE_instance;
  function DiffRow$Tag$DELETE_getInstance() {
    DiffRow$Tag_initFields();
    return DiffRow$Tag$DELETE_instance;
  }
  var DiffRow$Tag$CHANGE_instance;
  function DiffRow$Tag$CHANGE_getInstance() {
    DiffRow$Tag_initFields();
    return DiffRow$Tag$CHANGE_instance;
  }
  var DiffRow$Tag$EQUAL_instance;
  function DiffRow$Tag$EQUAL_getInstance() {
    DiffRow$Tag_initFields();
    return DiffRow$Tag$EQUAL_instance;
  }
  DiffRow$Tag.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Tag',
    interfaces: [Enum]
  };
  function DiffRow$Tag$values() {
    return [DiffRow$Tag$INSERT_getInstance(), DiffRow$Tag$DELETE_getInstance(), DiffRow$Tag$CHANGE_getInstance(), DiffRow$Tag$EQUAL_getInstance()];
  }
  DiffRow$Tag.values = DiffRow$Tag$values;
  function DiffRow$Tag$valueOf(name) {
    switch (name) {
      case 'INSERT':
        return DiffRow$Tag$INSERT_getInstance();
      case 'DELETE':
        return DiffRow$Tag$DELETE_getInstance();
      case 'CHANGE':
        return DiffRow$Tag$CHANGE_getInstance();
      case 'EQUAL':
        return DiffRow$Tag$EQUAL_getInstance();
      default:throwISE('No enum constant dev.gitlive.difflib.text.DiffRow.Tag.' + name);
    }
  }
  DiffRow$Tag.valueOf_61zpoe$ = DiffRow$Tag$valueOf;
  DiffRow.prototype.hashCode = function () {
    return (new Triple(this.newLine, this.oldLine, this.tag)).hashCode();
  };
  DiffRow.prototype.equals = function (obj) {
    var tmp$, tmp$_0;
    if (this === obj) {
      return true;
    }if (obj == null) {
      return false;
    }if (!((tmp$ = Kotlin.getKClassFromExpression(this)) != null ? tmp$.equals(Kotlin.getKClassFromExpression(obj)) : null)) {
      return false;
    }var other = (tmp$_0 = obj) == null || Kotlin.isType(tmp$_0, DiffRow) ? tmp$_0 : throwCCE();
    if (this.newLine == null) {
      if (ensureNotNull(other).newLine != null) {
        return false;
      }} else if (!equals(this.newLine, ensureNotNull(other).newLine)) {
      return false;
    }if (this.oldLine == null) {
      if (other.oldLine != null) {
        return false;
      }} else if (!equals(this.oldLine, other.oldLine)) {
      return false;
    }if (this.tag == null) {
      if (other.tag != null) {
        return false;
      }} else if (!equals(this.tag, other.tag)) {
      return false;
    }return true;
  };
  DiffRow.prototype.toString = function () {
    return '[' + toString(this.tag) + ',' + this.oldLine + ',' + this.newLine + ']';
  };
  DiffRow.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DiffRow',
    interfaces: []
  };
  function DiffRowGenerator(builder) {
    DiffRowGenerator$Companion_getInstance();
    this.columnWidth_0 = 0;
    this.equalizer_0 = null;
    this.ignoreWhiteSpaces_0 = false;
    this.inlineDiffSplitter_0 = null;
    this.mergeOriginalRevised_0 = false;
    this.newTag_0 = null;
    this.oldTag_0 = null;
    this.reportLinesUnchanged_0 = false;
    this.lineNormalizer_0 = null;
    this.showInlineDiffs_0 = false;
    this.showInlineDiffs_0 = builder.showInlineDiffs_8be2vx$;
    this.ignoreWhiteSpaces_0 = builder.ignoreWhiteSpaces_8be2vx$;
    this.oldTag_0 = builder.oldTag_8be2vx$;
    this.newTag_0 = builder.newTag_8be2vx$;
    this.columnWidth_0 = builder.columnWidth_8be2vx$;
    this.mergeOriginalRevised_0 = builder.mergeOriginalRevised_8be2vx$;
    this.inlineDiffSplitter_0 = builder.inlineDiffSplitter_8be2vx$;
    this.equalizer_0 = this.ignoreWhiteSpaces_0 ? DiffRowGenerator$Companion_getInstance().IGNORE_WHITESPACE_EQUALIZER : DiffRowGenerator$Companion_getInstance().DEFAULT_EQUALIZER;
    this.reportLinesUnchanged_0 = builder.reportLinesUnchanged_8be2vx$;
    this.lineNormalizer_0 = builder.lineNormalizer_8be2vx$;
  }
  DiffRowGenerator.prototype.generateDiffRows_2mkhiy$ = function (original, revised) {
    return this.generateDiffRows_qs7qra$(original, DiffUtils_getInstance().diff_7p8tlw$(original, revised, this.equalizer_0));
  };
  DiffRowGenerator.prototype.generateDiffRows_qs7qra$ = function (original, patch) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    var diffRows = ArrayList_init();
    var endPos = 0;
    var deltaList = patch.getDeltas();
    tmp$ = deltaList.iterator();
    while (tmp$.hasNext()) {
      var delta = tmp$.next();
      var orig = delta.source;
      var rev = delta.target;
      tmp$_0 = original.subList_vux9f0$(endPos, orig.position).iterator();
      while (tmp$_0.hasNext()) {
        var line = tmp$_0.next();
        diffRows.add_11rb$(this.buildDiffRow_0(DiffRow$Tag$EQUAL_getInstance(), line, line));
      }
      if (Kotlin.isType(delta, InsertDelta)) {
        endPos = orig.last() + 1 | 0;
        tmp$_1 = ensureNotNull(rev.lines).iterator();
        while (tmp$_1.hasNext()) {
          var line_0 = tmp$_1.next();
          diffRows.add_11rb$(this.buildDiffRow_0(DiffRow$Tag$INSERT_getInstance(), '', line_0));
        }
        continue;
      }if (Kotlin.isType(delta, DeleteDelta)) {
        endPos = orig.last() + 1 | 0;
        tmp$_2 = ensureNotNull(orig.lines).iterator();
        while (tmp$_2.hasNext()) {
          var line_1 = tmp$_2.next();
          diffRows.add_11rb$(this.buildDiffRow_0(DiffRow$Tag$DELETE_getInstance(), line_1, ''));
        }
        continue;
      }if (this.showInlineDiffs_0) {
        diffRows.addAll_brywnq$(this.generateInlineDiffs_0(delta));
      } else {
        var a = orig.size();
        var b = rev.size();
        tmp$_3 = Math_0.max(a, b);
        for (var j = 0; j < tmp$_3; j++) {
          diffRows.add_11rb$(this.buildDiffRow_0(DiffRow$Tag$CHANGE_getInstance(), ensureNotNull(orig.lines).size > j ? ensureNotNull(orig.lines).get_za3lpa$(j) : '', ensureNotNull(rev.lines).size > j ? ensureNotNull(rev.lines).get_za3lpa$(j) : ''));
        }
      }
      endPos = orig.last() + 1 | 0;
    }
    tmp$_4 = original.subList_vux9f0$(endPos, original.size).iterator();
    while (tmp$_4.hasNext()) {
      var line_2 = tmp$_4.next();
      diffRows.add_11rb$(this.buildDiffRow_0(DiffRow$Tag$EQUAL_getInstance(), line_2, line_2));
    }
    return diffRows;
  };
  DiffRowGenerator.prototype.buildDiffRow_0 = function (type, orgline, newline) {
    if (this.reportLinesUnchanged_0) {
      return new DiffRow(type, orgline, newline);
    } else {
      var wrapOrg = this.preprocessLine_0(orgline);
      if (DiffRow$Tag$DELETE_getInstance() === type) {
        if (this.mergeOriginalRevised_0 || this.showInlineDiffs_0) {
          wrapOrg = this.oldTag_0(true) + wrapOrg + this.oldTag_0(false);
        }}var wrapNew = this.preprocessLine_0(newline);
      if (DiffRow$Tag$INSERT_getInstance() === type) {
        if (this.mergeOriginalRevised_0) {
          wrapOrg = this.newTag_0(true) + wrapNew + this.newTag_0(false);
        } else if (this.showInlineDiffs_0) {
          wrapNew = this.newTag_0(true) + wrapNew + this.newTag_0(false);
        }}return new DiffRow(type, wrapOrg, wrapNew);
    }
  };
  DiffRowGenerator.prototype.buildDiffRowWithoutNormalizing_0 = function (type, orgline, newline) {
    return new DiffRow(type, StringUtils_getInstance().wrapText_bm4lxs$(orgline, this.columnWidth_0), StringUtils_getInstance().wrapText_bm4lxs$(newline, this.columnWidth_0));
  };
  DiffRowGenerator.prototype.normalizeLines_mhpeer$ = function (list) {
    var destination = ArrayList_init_1(collectionSizeOrDefault(list, 10));
    var tmp$;
    tmp$ = list.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(this.lineNormalizer_0(item));
    }
    return toList_0(destination);
  };
  DiffRowGenerator.prototype.generateInlineDiffs_0 = function (delta) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var orig = this.normalizeLines_mhpeer$(ensureNotNull(delta.source.lines));
    var rev = this.normalizeLines_mhpeer$(ensureNotNull(delta.target.lines));
    var origList;
    var revList;
    var joinedOrig = joinToString(orig, '\n');
    var joinedRev = joinToString(rev, '\n');
    origList = this.inlineDiffSplitter_0(joinedOrig);
    revList = this.inlineDiffSplitter_0(joinedRev);
    var inlineDeltas = DiffUtils_getInstance().diff_s9r2lo$(origList, revList).getDeltas();
    reverse(inlineDeltas);
    tmp$ = inlineDeltas.iterator();
    while (tmp$.hasNext()) {
      var inlineDelta = tmp$.next();
      var inlineOrig = inlineDelta.source;
      var inlineRev = inlineDelta.target;
      if (Kotlin.isType(inlineDelta, DeleteDelta)) {
        DiffRowGenerator$Companion_getInstance().wrapInTag_h0gvmm$(origList, inlineOrig.position, inlineOrig.position + inlineOrig.size() | 0, this.oldTag_0);
      } else if (Kotlin.isType(inlineDelta, InsertDelta)) {
        if (this.mergeOriginalRevised_0) {
          origList.addAll_u57x28$(inlineOrig.position, revList.subList_vux9f0$(inlineRev.position, inlineRev.position + inlineRev.size() | 0));
          DiffRowGenerator$Companion_getInstance().wrapInTag_h0gvmm$(origList, inlineOrig.position, inlineOrig.position + inlineRev.size() | 0, this.newTag_0);
        } else {
          DiffRowGenerator$Companion_getInstance().wrapInTag_h0gvmm$(revList, inlineRev.position, inlineRev.position + inlineRev.size() | 0, this.newTag_0);
        }
      } else if (Kotlin.isType(inlineDelta, ChangeDelta)) {
        if (this.mergeOriginalRevised_0) {
          origList.addAll_u57x28$(inlineOrig.position + inlineOrig.size() | 0, revList.subList_vux9f0$(inlineRev.position, inlineRev.position + inlineRev.size() | 0));
          DiffRowGenerator$Companion_getInstance().wrapInTag_h0gvmm$(origList, inlineOrig.position + inlineOrig.size() | 0, inlineOrig.position + inlineOrig.size() + inlineRev.size() | 0, this.newTag_0);
        } else {
          DiffRowGenerator$Companion_getInstance().wrapInTag_h0gvmm$(revList, inlineRev.position, inlineRev.position + inlineRev.size() | 0, this.newTag_0);
        }
        DiffRowGenerator$Companion_getInstance().wrapInTag_h0gvmm$(origList, inlineOrig.position, inlineOrig.position + inlineOrig.size() | 0, this.oldTag_0);
      }}
    var origResult = StringBuilder_init();
    var revResult = StringBuilder_init();
    tmp$_0 = origList.iterator();
    while (tmp$_0.hasNext()) {
      var character = tmp$_0.next();
      origResult.append_pdl1vj$(character);
    }
    tmp$_1 = revList.iterator();
    while (tmp$_1.hasNext()) {
      var character_0 = tmp$_1.next();
      revResult.append_pdl1vj$(character_0);
    }
    var original = lines(origResult.toString());
    var revised = lines(revResult.toString());
    var diffRows = ArrayList_init();
    var a = original.size;
    var b = revised.size;
    tmp$_2 = Math_0.max(a, b);
    for (var j = 0; j < tmp$_2; j++) {
      diffRows.add_11rb$(this.buildDiffRowWithoutNormalizing_0(DiffRow$Tag$CHANGE_getInstance(), original.size > j ? original.get_za3lpa$(j) : '', revised.size > j ? revised.get_za3lpa$(j) : ''));
    }
    return diffRows;
  };
  DiffRowGenerator.prototype.preprocessLine_0 = function (line) {
    var tmp$;
    if (this.columnWidth_0 === 0) {
      tmp$ = this.lineNormalizer_0(line);
    } else {
      tmp$ = StringUtils_getInstance().wrapText_bm4lxs$(this.lineNormalizer_0(line), this.columnWidth_0);
    }
    return tmp$;
  };
  function DiffRowGenerator$Builder() {
    this.showInlineDiffs_8be2vx$ = false;
    this.ignoreWhiteSpaces_8be2vx$ = false;
    this.oldTag_8be2vx$ = DiffRowGenerator$Builder$oldTag$lambda;
    this.newTag_8be2vx$ = DiffRowGenerator$Builder$newTag$lambda;
    this.columnWidth_8be2vx$ = 0;
    this.mergeOriginalRevised_8be2vx$ = false;
    this.reportLinesUnchanged_8be2vx$ = false;
    this.inlineDiffSplitter_8be2vx$ = DiffRowGenerator$Companion_getInstance().SPLITTER_BY_CHARACTER;
    this.lineNormalizer_8be2vx$ = DiffRowGenerator$Companion_getInstance().LINE_NORMALIZER_FOR_HTML;
  }
  DiffRowGenerator$Builder.prototype.showInlineDiffs_6taknv$ = function (val) {
    this.showInlineDiffs_8be2vx$ = val;
    return this;
  };
  DiffRowGenerator$Builder.prototype.ignoreWhiteSpaces_6taknv$ = function (val) {
    this.ignoreWhiteSpaces_8be2vx$ = val;
    return this;
  };
  DiffRowGenerator$Builder.prototype.reportLinesUnchanged_6taknv$ = function (val) {
    this.reportLinesUnchanged_8be2vx$ = val;
    return this;
  };
  DiffRowGenerator$Builder.prototype.oldTag_m857mf$ = function (generator) {
    this.oldTag_8be2vx$ = generator;
    return this;
  };
  DiffRowGenerator$Builder.prototype.newTag_m857mf$ = function (generator) {
    this.newTag_8be2vx$ = generator;
    return this;
  };
  DiffRowGenerator$Builder.prototype.columnWidth_za3lpa$ = function (width) {
    if (width >= 0) {
      this.columnWidth_8be2vx$ = width;
    }return this;
  };
  DiffRowGenerator$Builder.prototype.build = function () {
    return new DiffRowGenerator(this);
  };
  DiffRowGenerator$Builder.prototype.mergeOriginalRevised_6taknv$ = function (mergeOriginalRevised) {
    this.mergeOriginalRevised_8be2vx$ = mergeOriginalRevised;
    return this;
  };
  DiffRowGenerator$Builder.prototype.inlineDiffByWord_6taknv$ = function (inlineDiffByWord) {
    this.inlineDiffSplitter_8be2vx$ = inlineDiffByWord ? DiffRowGenerator$Companion_getInstance().SPLITTER_BY_WORD : DiffRowGenerator$Companion_getInstance().SPLITTER_BY_CHARACTER;
    return this;
  };
  DiffRowGenerator$Builder.prototype.inlineDiffBySplitter_9ia9wg$ = function (inlineDiffSplitter) {
    this.inlineDiffSplitter_8be2vx$ = inlineDiffSplitter;
    return this;
  };
  DiffRowGenerator$Builder.prototype.lineNormalizer_v9wleo$ = function (lineNormalizer) {
    this.lineNormalizer_8be2vx$ = lineNormalizer;
    return this;
  };
  function DiffRowGenerator$Builder$oldTag$lambda(f) {
    return f ? '<span class="editOldInline">' : '<\/span>';
  }
  function DiffRowGenerator$Builder$newTag$lambda(f) {
    return f ? '<span class="editNewInline">' : '<\/span>';
  }
  DiffRowGenerator$Builder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Builder',
    interfaces: []
  };
  function DiffRowGenerator$Companion() {
    DiffRowGenerator$Companion_instance = this;
    this.DEFAULT_EQUALIZER = DiffRowGenerator$Companion$DEFAULT_EQUALIZER$lambda;
    this.IGNORE_WHITESPACE_EQUALIZER = DiffRowGenerator$Companion$IGNORE_WHITESPACE_EQUALIZER$lambda(this);
    this.LINE_NORMALIZER_FOR_HTML = DiffRowGenerator$Companion$LINE_NORMALIZER_FOR_HTML$lambda;
    this.SPLITTER_BY_CHARACTER = DiffRowGenerator$Companion$SPLITTER_BY_CHARACTER$lambda;
    this.SPLIT_BY_WORD_PATTERN = Regex_init('\\s+|[,.\\[\\](){}/\\\\*+\\-#]');
    this.SPLITTER_BY_WORD = DiffRowGenerator$Companion$SPLITTER_BY_WORD$lambda(this);
    this.WHITESPACE_PATTERN = Regex_init('\\s+');
  }
  DiffRowGenerator$Companion.prototype.create = function () {
    return new DiffRowGenerator$Builder();
  };
  DiffRowGenerator$Companion.prototype.adjustWhitespace_0 = function (raw) {
    var tmp$ = this.WHITESPACE_PATTERN;
    var tmp$_0;
    var $receiver_0 = Kotlin.isCharSequence(tmp$_0 = raw) ? tmp$_0 : throwCCE();
    var startIndex = 0;
    var endIndex = $receiver_0.length - 1 | 0;
    var startFound = false;
    while (startIndex <= endIndex) {
      var index = !startFound ? startIndex : endIndex;
      var match = unboxChar(toBoxedChar($receiver_0.charCodeAt(index))) <= 32;
      if (!startFound) {
        if (!match)
          startFound = true;
        else
          startIndex = startIndex + 1 | 0;
      } else {
        if (!match)
          break;
        else
          endIndex = endIndex - 1 | 0;
      }
    }
    return tmp$.replace_x2uqeu$(Kotlin.subSequence($receiver_0, startIndex, endIndex + 1 | 0).toString(), ' ');
  };
  DiffRowGenerator$Companion.prototype.splitStringPreserveDelimiter_mco96w$ = function (str, SPLIT_PATTERN) {
    var tmp$;
    var list = ArrayList_init();
    if (str != null) {
      var results = SPLIT_PATTERN.findAll_905azu$(str);
      var pos = 0;
      tmp$ = results.iterator();
      while (tmp$.hasNext()) {
        var result = tmp$.next();
        if (pos < result.range.first) {
          var startIndex = pos;
          var endIndex = result.range.first;
          list.add_11rb$(str.substring(startIndex, endIndex));
        }list.add_11rb$(result.value);
        pos = result.range.last + 1 | 0;
      }
      if (pos < str.length) {
        var startIndex_0 = pos;
        list.add_11rb$(str.substring(startIndex_0));
      }}return list;
  };
  DiffRowGenerator$Companion.prototype.wrapInTag_h0gvmm$ = function (sequence, startPosition, endPosition, tagGenerator) {
    var endPos = endPosition;
    while (endPos >= startPosition) {
      while (endPos > startPosition && equals('\n', sequence.get_za3lpa$(endPos - 1 | 0))) {
        endPos = endPos - 1 | 0;
      }
      if (endPos === startPosition) {
        break;
      }sequence.add_wxm5ur$(endPos, tagGenerator(false));
      endPos = endPos - 1 | 0;
      while (endPos > startPosition && !equals('\n', sequence.get_za3lpa$(endPos - 1 | 0))) {
        endPos = endPos - 1 | 0;
      }
      sequence.add_wxm5ur$(endPos, tagGenerator(true));
      endPos = endPos - 1 | 0;
    }
  };
  function DiffRowGenerator$Companion$DEFAULT_EQUALIZER$lambda(obj1, obj2) {
    return equals(obj1, obj2);
  }
  function DiffRowGenerator$Companion$IGNORE_WHITESPACE_EQUALIZER$lambda(this$DiffRowGenerator$) {
    return function (original, revised) {
      return equals(this$DiffRowGenerator$.adjustWhitespace_0(original), this$DiffRowGenerator$.adjustWhitespace_0(revised));
    };
  }
  function DiffRowGenerator$Companion$LINE_NORMALIZER_FOR_HTML$lambda(it) {
    return StringUtils_getInstance().normalize_61zpoe$(it);
  }
  function DiffRowGenerator$Companion$SPLITTER_BY_CHARACTER$lambda(line) {
    var tmp$;
    var list = ArrayList_init_1(line.length);
    tmp$ = iterator(line);
    while (tmp$.hasNext()) {
      var character = unboxChar(tmp$.next());
      list.add_11rb$(String.fromCharCode(character));
    }
    return list;
  }
  function DiffRowGenerator$Companion$SPLITTER_BY_WORD$lambda(this$DiffRowGenerator$) {
    return function (line) {
      return this$DiffRowGenerator$.splitStringPreserveDelimiter_mco96w$(line, this$DiffRowGenerator$.SPLIT_BY_WORD_PATTERN);
    };
  }
  DiffRowGenerator$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var DiffRowGenerator$Companion_instance = null;
  function DiffRowGenerator$Companion_getInstance() {
    if (DiffRowGenerator$Companion_instance === null) {
      new DiffRowGenerator$Companion();
    }return DiffRowGenerator$Companion_instance;
  }
  DiffRowGenerator.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DiffRowGenerator',
    interfaces: []
  };
  function StringUtils() {
    StringUtils_instance = this;
  }
  StringUtils.prototype.htmlEntites_61zpoe$ = function (str) {
    return replace(replace(str, '<', '&lt;'), '>', '&gt;');
  };
  StringUtils.prototype.normalize_61zpoe$ = function (str) {
    return replace(this.htmlEntites_61zpoe$(str), '\t', '    ');
  };
  StringUtils.prototype.wrapText_udy8vv$ = function (list, columnWidth) {
    var destination = ArrayList_init_1(collectionSizeOrDefault(list, 10));
    var tmp$;
    tmp$ = list.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(this.wrapText_bm4lxs$(item, columnWidth));
    }
    return toList_0(destination);
  };
  StringUtils.prototype.wrapText_bm4lxs$ = function (line, columnWidth) {
    if (columnWidth < 0) {
      throw IllegalArgumentException_init('columnWidth may not be less 0');
    }if (columnWidth === 0) {
      return line;
    }var length = line.length;
    var b = StringBuilder_init();
    var count = 0;
    while ((Kotlin.imul(count, columnWidth) + columnWidth | 0) < length) {
      b.append_gw00v9$(line.substring(Kotlin.imul(columnWidth, count), Kotlin.imul(columnWidth, (count = count + 1 | 0, count))));
      b.append_pdl1vj$('<br/>');
    }
    b.append_gw00v9$(line.substring(Kotlin.imul(columnWidth, count), length));
    return b.toString();
  };
  StringUtils.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'StringUtils',
    interfaces: []
  };
  var StringUtils_instance = null;
  function StringUtils_getInstance() {
    if (StringUtils_instance === null) {
      new StringUtils();
    }return StringUtils_instance;
  }
  function UnifiedDiff() {
    UnifiedDiff$Companion_getInstance();
    this.header = null;
    this.tail_g1xnmt$_0 = null;
    this.files_8be2vx$ = ArrayList_init();
  }
  Object.defineProperty(UnifiedDiff.prototype, 'tail', {
    configurable: true,
    get: function () {
      return this.tail_g1xnmt$_0;
    },
    set: function (tail) {
      this.tail_g1xnmt$_0 = tail;
    }
  });
  UnifiedDiff.prototype.addFile_7l1tbv$ = function (file) {
    this.files_8be2vx$.add_11rb$(file);
  };
  UnifiedDiff.prototype.getFiles = function () {
    return this.files_8be2vx$;
  };
  UnifiedDiff.prototype.setTailTxt_61zpoe$ = function (tailTxt) {
    this.tail = tailTxt;
  };
  UnifiedDiff.prototype.spplyPatchTo_wte48a$ = function (findFile, originalLines) {
    var tmp$;
    var $receiver = this.files_8be2vx$;
    var destination = ArrayList_init();
    var tmp$_0;
    tmp$_0 = $receiver.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      if (findFile(ensureNotNull(element.fromFile)))
        destination.add_11rb$(element);
    }
    var file = firstOrNull(destination);
    if (file != null) {
      tmp$ = file.patch.applyTo_4ezy5m$(originalLines);
    } else {
      tmp$ = originalLines;
    }
    return tmp$;
  };
  function UnifiedDiff$Companion() {
    UnifiedDiff$Companion_instance = this;
  }
  UnifiedDiff$Companion.prototype.from_s101we$ = function (header, tail, files) {
    var tmp$;
    var diff = new UnifiedDiff();
    diff.header = header;
    diff.setTailTxt_61zpoe$(tail);
    for (tmp$ = 0; tmp$ !== files.length; ++tmp$) {
      var file = files[tmp$];
      diff.addFile_7l1tbv$(file);
    }
    return diff;
  };
  UnifiedDiff$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var UnifiedDiff$Companion_instance = null;
  function UnifiedDiff$Companion_getInstance() {
    if (UnifiedDiff$Companion_instance === null) {
      new UnifiedDiff$Companion();
    }return UnifiedDiff$Companion_instance;
  }
  UnifiedDiff.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnifiedDiff',
    interfaces: []
  };
  function UnifiedDiffFile() {
    UnifiedDiffFile$Companion_getInstance();
    this.diffCommand = null;
    this.fromFile = null;
    this.toFile = null;
    this.index = null;
    this.patch_e0mpiz$_0 = new Patch();
  }
  Object.defineProperty(UnifiedDiffFile.prototype, 'patch', {
    configurable: true,
    get: function () {
      return this.patch_e0mpiz$_0;
    },
    set: function (patch) {
      this.patch_e0mpiz$_0 = patch;
    }
  });
  function UnifiedDiffFile$Companion() {
    UnifiedDiffFile$Companion_instance = this;
  }
  UnifiedDiffFile$Companion.prototype.from_7nusjx$ = function (fromFile, toFile, patch) {
    var file = new UnifiedDiffFile();
    file.fromFile = fromFile;
    file.toFile = toFile;
    file.patch = patch;
    return file;
  };
  UnifiedDiffFile$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var UnifiedDiffFile$Companion_instance = null;
  function UnifiedDiffFile$Companion_getInstance() {
    if (UnifiedDiffFile$Companion_instance === null) {
      new UnifiedDiffFile$Companion();
    }return UnifiedDiffFile$Companion_instance;
  }
  UnifiedDiffFile.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnifiedDiffFile',
    interfaces: []
  };
  var package$dev = _.dev || (_.dev = {});
  var package$gitlive = package$dev.gitlive || (package$dev.gitlive = {});
  var package$difflib = package$gitlive.difflib || (package$gitlive.difflib = {});
  Object.defineProperty(package$difflib, 'DiffUtils', {
    get: DiffUtils_getInstance
  });
  Object.defineProperty(package$difflib, 'UnifiedDiffUtils', {
    get: UnifiedDiffUtils_getInstance
  });
  var package$algorithm = package$difflib.algorithm || (package$difflib.algorithm = {});
  package$algorithm.Change = Change;
  package$algorithm.DiffAlgorithmI = DiffAlgorithmI;
  package$algorithm.DiffAlgorithmListener = DiffAlgorithmListener;
  Object.defineProperty(DiffException, 'Companion', {
    get: DiffException$Companion_getInstance
  });
  package$algorithm.DiffException_init = DiffException_init;
  package$algorithm.DiffException_init_61zpoe$ = DiffException_init_0;
  package$algorithm.DiffException = DiffException;
  Object.defineProperty(DifferentiationFailedException, 'Companion', {
    get: DifferentiationFailedException$Companion_getInstance
  });
  package$algorithm.DifferentiationFailedException_init = DifferentiationFailedException_init;
  package$algorithm.DifferentiationFailedException_init_61zpoe$ = DifferentiationFailedException_init_0;
  package$algorithm.DifferentiationFailedException = DifferentiationFailedException;
  var package$myers = package$algorithm.myers || (package$algorithm.myers = {});
  package$myers.MyersDiff_init_287e2$ = MyersDiff_init;
  package$myers.MyersDiff_init_8se3zj$ = MyersDiff_init_0;
  package$myers.MyersDiff = MyersDiff;
  package$myers.PathNode = PathNode;
  var package$patch = package$difflib.patch || (package$difflib.patch = {});
  package$patch.AbstractDelta = AbstractDelta;
  package$patch.ChangeDelta = ChangeDelta;
  package$patch.Chunk_init_2iazkl$ = Chunk_init;
  package$patch.Chunk_init_uzs9p4$ = Chunk_init_0;
  package$patch.Chunk = Chunk;
  package$patch.DeleteDelta = DeleteDelta;
  Object.defineProperty(DeltaType, 'CHANGE', {
    get: DeltaType$CHANGE_getInstance
  });
  Object.defineProperty(DeltaType, 'DELETE', {
    get: DeltaType$DELETE_getInstance
  });
  Object.defineProperty(DeltaType, 'INSERT', {
    get: DeltaType$INSERT_getInstance
  });
  Object.defineProperty(DeltaType, 'EQUAL', {
    get: DeltaType$EQUAL_getInstance
  });
  package$patch.DeltaType = DeltaType;
  Object.defineProperty(DiffException_0, 'Companion', {
    get: DiffException$Companion_getInstance_0
  });
  package$patch.DiffException_init = DiffException_init_1;
  package$patch.DiffException_init_61zpoe$ = DiffException_init_2;
  package$patch.DiffException = DiffException_0;
  package$patch.InsertDelta = InsertDelta;
  Object.defineProperty(Patch, 'Companion', {
    get: Patch$Companion_getInstance
  });
  package$patch.Patch = Patch;
  Object.defineProperty(PatchFailedException, 'Companion', {
    get: PatchFailedException$Companion_getInstance
  });
  package$patch.PatchFailedException_init = PatchFailedException_init;
  package$patch.PatchFailedException_init_61zpoe$ = PatchFailedException_init_0;
  package$patch.PatchFailedException = PatchFailedException;
  Object.defineProperty(DiffRow$Tag, 'INSERT', {
    get: DiffRow$Tag$INSERT_getInstance
  });
  Object.defineProperty(DiffRow$Tag, 'DELETE', {
    get: DiffRow$Tag$DELETE_getInstance
  });
  Object.defineProperty(DiffRow$Tag, 'CHANGE', {
    get: DiffRow$Tag$CHANGE_getInstance
  });
  Object.defineProperty(DiffRow$Tag, 'EQUAL', {
    get: DiffRow$Tag$EQUAL_getInstance
  });
  DiffRow.Tag = DiffRow$Tag;
  var package$text = package$difflib.text || (package$difflib.text = {});
  package$text.DiffRow = DiffRow;
  DiffRowGenerator.Builder = DiffRowGenerator$Builder;
  Object.defineProperty(DiffRowGenerator, 'Companion', {
    get: DiffRowGenerator$Companion_getInstance
  });
  package$text.DiffRowGenerator = DiffRowGenerator;
  Object.defineProperty(package$text, 'StringUtils', {
    get: StringUtils_getInstance
  });
  Object.defineProperty(UnifiedDiff, 'Companion', {
    get: UnifiedDiff$Companion_getInstance
  });
  var package$unifieddiff = package$difflib.unifieddiff || (package$difflib.unifieddiff = {});
  package$unifieddiff.UnifiedDiff = UnifiedDiff;
  Object.defineProperty(UnifiedDiffFile, 'Companion', {
    get: UnifiedDiffFile$Companion_getInstance
  });
  package$unifieddiff.UnifiedDiffFile = UnifiedDiffFile;
  MyersDiff.prototype.computeDiff_t0eakh$ = DiffAlgorithmI.prototype.computeDiff_t0eakh$;
  Kotlin.defineModule('kotlin-diff-utils-node', _);
  return _;
}));

//# sourceMappingURL=kotlin-diff-utils-node.js.map
