/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import dev.goquick.sqlitenow.gradle.AnnotatedExecuteStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.AnnotationsKt;
import dev.goquick.sqlitenow.gradle.FieldAnnotationMerger;
import dev.goquick.sqlitenow.gradle.FieldAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.FieldAnnotationResolver;
import dev.goquick.sqlitenow.gradle.SqlFileProcessor;
import dev.goquick.sqlitenow.gradle.StatementAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.inspect.DeleteStatement;
import dev.goquick.sqlitenow.gradle.inspect.ExecuteStatement;
import dev.goquick.sqlitenow.gradle.inspect.InsertStatement;
import dev.goquick.sqlitenow.gradle.inspect.SelectStatement;
import dev.goquick.sqlitenow.gradle.inspect.UpdateStatement;
import dev.goquick.sqlitenow.gradle.sqlite.SqlSingleStatement;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eJ\"\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u000b0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b2\u0006\u0010\u0016\u001a\u00020\nH\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0015H\u0002JD\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2 \u0010#\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\t2\u0006\u0010$\u001a\u00020%2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ldev/goquick/sqlitenow/gradle/StatementProcessingHelper;", "", "conn", "Ljava/sql/Connection;", "annotationResolver", "Ldev/goquick/sqlitenow/gradle/FieldAnnotationResolver;", "<init>", "(Ljava/sql/Connection;Ldev/goquick/sqlitenow/gradle/FieldAnnotationResolver;)V", "processQueriesDirectory", "", "", "", "Ldev/goquick/sqlitenow/gradle/AnnotatedStatement;", "queriesDir", "Ljava/io/File;", "processQueryFile", "file", "scanQueriesByNamespace", "validateSqlStatements", "", "sqlStatements", "Ldev/goquick/sqlitenow/gradle/sqlite/SqlSingleStatement;", "fileName", "createAnnotatedSelectStatement", "Ldev/goquick/sqlitenow/gradle/AnnotatedSelectStatement;", "stmtName", "parsedStatement", "Lnet/sf/jsqlparser/statement/select/PlainSelect;", "sqlStatement", "createAnnotatedExecuteStatement", "Ldev/goquick/sqlitenow/gradle/AnnotatedExecuteStatement;", "mergeFieldAnnotations", "Ldev/goquick/sqlitenow/gradle/FieldAnnotationOverrides;", "column", "Ldev/goquick/sqlitenow/gradle/inspect/SelectStatement$FieldSource;", "selectFieldAnnotations", "selectStatement", "Ldev/goquick/sqlitenow/gradle/inspect/SelectStatement;", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nStatementProcessingHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatementProcessingHelper.kt\ndev/goquick/sqlitenow/gradle/StatementProcessingHelper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,224:1\n126#2:225\n153#2,2:226\n155#2:232\n1557#3:228\n1628#3,3:229\n1187#3,2:236\n1261#3,2:238\n1264#3:243\n1557#3:244\n1628#3,3:245\n3829#4:233\n4344#4,2:234\n3829#4:240\n4344#4,2:241\n*S KotlinDebug\n*F\n+ 1 StatementProcessingHelper.kt\ndev/goquick/sqlitenow/gradle/StatementProcessingHelper\n*L\n35#1:225\n35#1:226,2\n35#1:232\n36#1:228\n36#1:229,3\n98#1:236,2\n98#1:238,2\n98#1:243\n142#1:244\n142#1:245,3\n97#1:233\n97#1:234,2\n101#1:240\n101#1:241,2\n*E\n"})
public final class StatementProcessingHelper {
    @NotNull
    private final Connection conn;
    @Nullable
    private final FieldAnnotationResolver annotationResolver;

    public StatementProcessingHelper(@NotNull Connection conn, @Nullable FieldAnnotationResolver annotationResolver) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        this.conn = conn;
        this.annotationResolver = annotationResolver;
    }

    public /* synthetic */ StatementProcessingHelper(Connection connection, FieldAnnotationResolver fieldAnnotationResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            fieldAnnotationResolver = null;
        }
        this(connection, fieldAnnotationResolver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<AnnotatedStatement>> processQueriesDirectory(@NotNull File queriesDir) {
        void $this$mapTo$iv$iv;
        Map<String, List<File>> nsWithFiles;
        Intrinsics.checkNotNullParameter((Object)queriesDir, (String)"queriesDir");
        Map<String, List<File>> $this$map$iv = nsWithFiles = this.scanQueriesByNamespace(queriesDir);
        boolean $i$f$map = false;
        Map<String, List<File>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String namespace = (String)entry.getKey();
            List files = (List)entry.getValue();
            Iterable iterable = files;
            String string = namespace;
            boolean $i$f$map2 = false;
            void var17_17 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                AnnotatedStatement annotatedStatement;
                void file;
                File file2 = (File)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                try {
                    annotatedStatement = this.processQueryFile((File)file);
                }
                catch (Exception e) {
                    System.err.println("*** Failed to process query file: " + file.getAbsolutePath());
                    e.printStackTrace();
                    throw e;
                }
                collection2.add(annotatedStatement);
            }
            collection.add(TuplesKt.to((Object)string, (Object)((List)destination$iv$iv2)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final AnnotatedStatement processQueryFile(@NotNull File file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String stmtName = FilesKt.getNameWithoutExtension((File)file);
        List<SqlSingleStatement> sqlStatements = SqlFileProcessor.INSTANCE.parseAllSqlFiles(CollectionsKt.listOf((Object)file));
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.validateSqlStatements(sqlStatements, string);
        SqlSingleStatement sqlStatement = (SqlSingleStatement)CollectionsKt.first(sqlStatements);
        Statement parsedStatement = CCJSqlParserUtil.parse((String)sqlStatement.getSql());
        try {
            AnnotatedStatement annotatedStatement;
            object = parsedStatement;
            if (object instanceof PlainSelect) {
                annotatedStatement = this.createAnnotatedSelectStatement(stmtName, (PlainSelect)parsedStatement, sqlStatement);
            } else if (object instanceof Insert || object instanceof Delete || object instanceof Update) {
                annotatedStatement = this.createAnnotatedExecuteStatement(stmtName, parsedStatement, sqlStatement);
            } else {
                throw new RuntimeException("Unsupported statement type in " + file.getName());
            }
            object = annotatedStatement;
        }
        catch (Exception e) {
            System.err.println("\nFailed to process statement:\n\n" + CollectionsKt.joinToString$default((Iterable)sqlStatement.getTopComments(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n" + sqlStatement.getSql() + "\n");
            throw e;
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private final Map<String, List<File>> scanQueriesByNamespace(File queriesDir) {
        block9: {
            block6: {
                if (!queriesDir.exists() || !queriesDir.isDirectory()) {
                    return MapsKt.emptyMap();
                }
                var2_2 = queriesDir.listFiles();
                if (var2_2 == null) break block6;
                $this$filter$iv = var2_2;
                $i$f$filter = false;
                var5_6 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var9_14 = ((void)$this$filterTo$iv$iv).length;
                for (var8_12 = 0; var8_12 < var9_14; ++var8_12) {
                    it = element$iv$iv = $this$filterTo$iv$iv[var8_12];
                    $i$a$-filter-StatementProcessingHelper$scanQueriesByNamespace$1 = false;
                    if (!it.isDirectory()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $i$f$filter = (List)destination$iv$iv;
                $i$f$associate = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                $i$f$filterTo = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    block8: {
                        block7: {
                            var12_18 = destination$iv$iv;
                            namespaceDir = (File)element$iv$iv;
                            $i$a$-associate-StatementProcessingHelper$scanQueriesByNamespace$2 = false;
                            namespace = namespaceDir.getName();
                            var16_22 = namespaceDir.listFiles();
                            if (var16_22 == null) break block7;
                            var17_23 = var16_22;
                            $i$f$filter = false;
                            var19_25 = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            var23_29 = ((void)$this$filterTo$iv$iv).length;
                            for (var22_28 = 0; var22_28 < var23_29; ++var22_28) {
                                it = element$iv$iv = $this$filterTo$iv$iv[var22_28];
                                $i$a$-filter-StatementProcessingHelper$scanQueriesByNamespace$2$sqlFiles$1 = false;
                                if (!it.isFile()) ** GOTO lbl-1000
                                Intrinsics.checkNotNull((Object)it);
                                if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"sql")) {
                                    v0 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v0 = false;
                                }
                                if (!v0) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            v1 = (List)destination$iv$iv;
                            break block8;
                        }
                        v1 = CollectionsKt.emptyList();
                    }
                    sqlFiles = v1;
                    var13_19 = TuplesKt.to((Object)namespace, (Object)sqlFiles);
                    var12_18.put(var13_19.getFirst(), var13_19.getSecond());
                }
                v2 = destination$iv$iv;
                break block9;
            }
            v2 = MapsKt.emptyMap();
        }
        return v2;
    }

    private final void validateSqlStatements(List<SqlSingleStatement> sqlStatements, String fileName) {
        if (sqlStatements.isEmpty()) {
            throw new RuntimeException("No SQL statements found in file: " + fileName);
        }
        if (sqlStatements.size() > 1) {
            throw new RuntimeException("Only one SQL statement per file is supported: " + fileName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final AnnotatedSelectStatement createAnnotatedSelectStatement(String stmtName, PlainSelect parsedStatement, SqlSingleStatement sqlStatement) {
        void $this$mapTo$iv$iv;
        SelectStatement stmt = SelectStatement.Companion.parse(this.conn, parsedStatement);
        StatementAnnotationOverrides statementAnnotations = StatementAnnotationOverrides.Companion.parse(AnnotationsKt.extractAnnotations(sqlStatement.getTopComments()));
        Map<String, Map<String, Object>> fieldAnnotations = AnnotationsKt.extractFieldAssociatedAnnotations(sqlStatement.getInnerComments());
        Iterable $this$map$iv = stmt.getFields();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void column;
            SelectStatement.FieldSource fieldSource = (SelectStatement.FieldSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FieldAnnotationOverrides annotations = this.mergeFieldAnnotations((SelectStatement.FieldSource)column, fieldAnnotations, stmt, this.annotationResolver);
            collection.add(new AnnotatedSelectStatement.Field((SelectStatement.FieldSource)column, annotations));
        }
        List fields = (List)destination$iv$iv;
        return new AnnotatedSelectStatement(stmtName, stmt, statementAnnotations, fields);
    }

    private final AnnotatedExecuteStatement createAnnotatedExecuteStatement(String stmtName, Object parsedStatement, SqlSingleStatement sqlStatement) {
        ExecuteStatement executeStatement;
        Object object = parsedStatement;
        if (object instanceof Insert) {
            executeStatement = InsertStatement.Companion.parse((Insert)parsedStatement, this.conn);
        } else if (object instanceof Delete) {
            executeStatement = DeleteStatement.Companion.parse((Delete)parsedStatement, this.conn);
        } else if (object instanceof Update) {
            executeStatement = UpdateStatement.Companion.parse((Update)parsedStatement, this.conn);
        } else {
            throw new UnsupportedOperationException("Unsupported statement type");
        }
        ExecuteStatement stmt = executeStatement;
        return AnnotatedExecuteStatement.Companion.parse(stmtName, stmt, sqlStatement.getTopComments());
    }

    private final FieldAnnotationOverrides mergeFieldAnnotations(SelectStatement.FieldSource column, Map<String, ? extends Map<String, ? extends Object>> selectFieldAnnotations, SelectStatement selectStatement, FieldAnnotationResolver annotationResolver) {
        Map map;
        Map mergedAnnotations = new LinkedHashMap();
        String fromTable = selectStatement.getFromTable();
        if (fromTable != null && annotationResolver != null) {
            FieldAnnotationOverrides resolvedAnnotations;
            FieldAnnotationOverrides fieldAnnotationOverrides = annotationResolver.getFieldAnnotations(fromTable, column.getFieldName());
            if (fieldAnnotationOverrides == null) {
                fieldAnnotationOverrides = annotationResolver.getFieldAnnotations(fromTable, column.getOriginalColumnName());
            }
            if ((resolvedAnnotations = fieldAnnotationOverrides) != null) {
                FieldAnnotationMerger.INSTANCE.mergeFieldAnnotations(mergedAnnotations, resolvedAnnotations);
            }
        }
        if ((map = selectFieldAnnotations.get(column.getFieldName())) == null) {
            map = MapsKt.emptyMap();
        }
        Map selectAnnotations = map;
        mergedAnnotations.putAll(selectAnnotations);
        return FieldAnnotationOverrides.Companion.parse(mergedAnnotations);
    }
}

