/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import dev.goquick.sqlitenow.gradle.SqlFileProcessor;
import dev.goquick.sqlitenow.gradle.sqlite.SqlSingleStatement;
import java.io.File;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014R9\u0010\u0006\u001a*\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007j\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Ldev/goquick/sqlitenow/gradle/MigrationInspector;", "", "sqlDirectory", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "sqlStatements", "Ljava/util/LinkedHashMap;", "", "", "Ldev/goquick/sqlitenow/gradle/sqlite/SqlSingleStatement;", "Lkotlin/collections/LinkedHashMap;", "getSqlStatements", "()Ljava/util/LinkedHashMap;", "latestVersion", "getLatestVersion", "()I", "parseVersionFromFilename", "filename", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationInspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationInspector.kt\ndev/goquick/sqlitenow/gradle/MigrationInspector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1053#2:84\n*S KotlinDebug\n*F\n+ 1 MigrationInspector.kt\ndev/goquick/sqlitenow/gradle/MigrationInspector\n*L\n39#1:84\n*E\n"})
public final class MigrationInspector {
    @NotNull
    private final LinkedHashMap<Integer, List<SqlSingleStatement>> sqlStatements;
    private final int latestVersion;

    public MigrationInspector(@NotNull File sqlDirectory) {
        Intrinsics.checkNotNullParameter((Object)sqlDirectory, (String)"sqlDirectory");
        SqlFileProcessor.INSTANCE.validateDirectory(sqlDirectory, "Migration");
        List<File> sqlFiles = SqlFileProcessor.INSTANCE.findSqlFiles(sqlDirectory);
        LinkedHashMap statementsMap = new LinkedHashMap();
        int maxVersion = 0;
        Iterable $this$sortedBy$iv = sqlFiles;
        boolean $i$f$sortedBy = false;
        for (File file : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        })) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Integer n = this.parseVersionFromFilename(string);
            if (n == null) {
                throw new IllegalArgumentException("Migration files must have numeric names (e.g., 0001.sql). Invalid file: " + file.getName());
            }
            int version = n;
            if (statementsMap.containsKey(version)) {
                throw new IllegalArgumentException("Duplicate migration version " + version + " found. File: " + file.getName());
            }
            List<SqlSingleStatement> fileStatements = SqlFileProcessor.INSTANCE.parseAllSqlFiles(CollectionsKt.listOf((Object)file));
            Integer n2 = version;
            ((Map)statementsMap).put(n2, fileStatements);
            if (version <= maxVersion) continue;
            maxVersion = version;
        }
        this.sqlStatements = statementsMap;
        this.latestVersion = maxVersion;
    }

    @NotNull
    public final LinkedHashMap<Integer, List<SqlSingleStatement>> getSqlStatements() {
        return this.sqlStatements;
    }

    public final int getLatestVersion() {
        return this.latestVersion;
    }

    private final Integer parseVersionFromFilename(String filename) {
        Integer n;
        String nameWithoutExtension = StringsKt.substringBeforeLast$default((String)filename, (String)".sql", null, (int)2, null);
        try {
            n = Integer.parseInt(nameWithoutExtension);
        }
        catch (NumberFormatException e) {
            System.out.println((Object)("File name does not match the expected format (ignored): " + filename));
            n = null;
        }
        return n;
    }
}

