/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.TypeName;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Ldev/goquick/sqlitenow/gradle/SqliteTypeToKotlinCodeConverter;", "", "<init>", "()V", "Companion", "sqlitenow-gradle-plugin"})
public final class SqliteTypeToKotlinCodeConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, ClassName> SQL_TO_KOTLIN_TYPE_MAP;
    @NotNull
    private static final ClassName DEFAULT_TYPE;
    @NotNull
    private static final List<String> KOTLIN_STDLIB_TYPES;

    static {
        Object[] objectArray = new Pair[25];
        String[] stringArray = new String[]{"Long"};
        objectArray[0] = TuplesKt.to((Object)"INTEGER", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Long"};
        objectArray[1] = TuplesKt.to((Object)"INT", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Byte"};
        objectArray[2] = TuplesKt.to((Object)"TINYINT", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Int"};
        objectArray[3] = TuplesKt.to((Object)"SMALLINT", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Int"};
        objectArray[4] = TuplesKt.to((Object)"MEDIUMINT", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Long"};
        objectArray[5] = TuplesKt.to((Object)"BIGINT", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Long"};
        objectArray[6] = TuplesKt.to((Object)"UNSIGNED BIG INT", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"String"};
        objectArray[7] = TuplesKt.to((Object)"TEXT", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"String"};
        objectArray[8] = TuplesKt.to((Object)"CHARACTER", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"String"};
        objectArray[9] = TuplesKt.to((Object)"VARCHAR", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"String"};
        objectArray[10] = TuplesKt.to((Object)"VARYING CHARACTER", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"String"};
        objectArray[11] = TuplesKt.to((Object)"NCHAR", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"String"};
        objectArray[12] = TuplesKt.to((Object)"NATIVE CHARACTER", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"String"};
        objectArray[13] = TuplesKt.to((Object)"NVARCHAR", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"String"};
        objectArray[14] = TuplesKt.to((Object)"CLOB", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Double"};
        objectArray[15] = TuplesKt.to((Object)"REAL", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Double"};
        objectArray[16] = TuplesKt.to((Object)"DOUBLE", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Double"};
        objectArray[17] = TuplesKt.to((Object)"DOUBLE PRECISION", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Float"};
        objectArray[18] = TuplesKt.to((Object)"FLOAT", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Long"};
        objectArray[19] = TuplesKt.to((Object)"NUMERIC", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Long"};
        objectArray[20] = TuplesKt.to((Object)"DECIMAL", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"Boolean"};
        objectArray[21] = TuplesKt.to((Object)"BOOLEAN", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"String"};
        objectArray[22] = TuplesKt.to((Object)"DATE", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"String"};
        objectArray[23] = TuplesKt.to((Object)"DATETIME", (Object)new ClassName("kotlin", stringArray));
        stringArray = new String[]{"ByteArray"};
        objectArray[24] = TuplesKt.to((Object)"BLOB", (Object)new ClassName("kotlin", stringArray));
        SQL_TO_KOTLIN_TYPE_MAP = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{"String"};
        DEFAULT_TYPE = new ClassName("kotlin", (String[])objectArray);
        objectArray = new String[]{"String", "Int", "Long", "Double", "Float", "Boolean", "Byte", "Short", "Char", "Any", "Unit", "Nothing"};
        KOTLIN_STDLIB_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Ldev/goquick/sqlitenow/gradle/SqliteTypeToKotlinCodeConverter$Companion;", "", "<init>", "()V", "SQL_TO_KOTLIN_TYPE_MAP", "", "", "Lcom/squareup/kotlinpoet/ClassName;", "DEFAULT_TYPE", "getDEFAULT_TYPE", "()Lcom/squareup/kotlinpoet/ClassName;", "KOTLIN_STDLIB_TYPES", "", "getKOTLIN_STDLIB_TYPES", "()Ljava/util/List;", "mapSqlTypeToKotlinType", "Lcom/squareup/kotlinpoet/TypeName;", "sqlType", "determinePropertyType", "baseType", "propertyType", "isNullable", "", "sqlitenow-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClassName getDEFAULT_TYPE() {
            return DEFAULT_TYPE;
        }

        @NotNull
        public final List<String> getKOTLIN_STDLIB_TYPES() {
            return KOTLIN_STDLIB_TYPES;
        }

        @NotNull
        public final TypeName mapSqlTypeToKotlinType(@NotNull String sqlType) {
            Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
            String string = sqlType.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String upperCaseSqlType = string;
            ClassName className = (ClassName)SQL_TO_KOTLIN_TYPE_MAP.get(upperCaseSqlType);
            return className != null ? (TypeName)className : (TypeName)this.getDEFAULT_TYPE();
        }

        @NotNull
        public final TypeName determinePropertyType(@NotNull TypeName baseType, @Nullable String propertyType, boolean isNullable) {
            ClassName typeFromAnnotation;
            ClassName className;
            Intrinsics.checkNotNullParameter((Object)baseType, (String)"baseType");
            String string = propertyType;
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (Companion.getKOTLIN_STDLIB_TYPES().contains(it)) {
                    String[] stringArray = new String[]{it};
                    ClassName className2 = new ClassName("kotlin", stringArray);
                    className = className2;
                } else {
                    className = ClassName.Companion.bestGuess(it);
                }
            } else {
                className = null;
            }
            ClassName className3 = typeFromAnnotation = className;
            TypeName finalType = className3 != null ? (TypeName)className3 : baseType;
            return isNullable ? TypeName.copy$default((TypeName)finalType, (boolean)true, null, (int)2, null) : finalType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

