/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import dev.goquick.sqlitenow.gradle.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedExecuteStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.ColumnLookup;
import dev.goquick.sqlitenow.gradle.PropertyNameGeneratorType;
import dev.goquick.sqlitenow.gradle.SelectFieldCodeGenerator;
import dev.goquick.sqlitenow.gradle.SqliteTypeToKotlinCodeConverter;
import dev.goquick.sqlitenow.gradle.StatementUtils;
import dev.goquick.sqlitenow.gradle.inspect.SelectStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.internal.extensions.stdlib.CharSequenceExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u000b\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010!\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\"\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010H\u0002J\u000e\u0010%\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ldev/goquick/sqlitenow/gradle/AdapterConfig;", "", "columnLookup", "Ldev/goquick/sqlitenow/gradle/ColumnLookup;", "createTableStatements", "", "Ldev/goquick/sqlitenow/gradle/AnnotatedCreateTableStatement;", "<init>", "(Ldev/goquick/sqlitenow/gradle/ColumnLookup;Ljava/util/List;)V", "collectAllParamConfigs", "Ldev/goquick/sqlitenow/gradle/AdapterConfig$ParamConfig;", "statement", "Ldev/goquick/sqlitenow/gradle/AnnotatedStatement;", "collectInputParamConfigs", "processedAdapters", "", "", "collectOutputParamConfigs", "Ldev/goquick/sqlitenow/gradle/AnnotatedSelectStatement;", "createInputParamConfig", "parameterName", "adapterFunctionName", "column", "Ldev/goquick/sqlitenow/gradle/AnnotatedCreateTableStatement$Column;", "createOutputParamConfig", "field", "Ldev/goquick/sqlitenow/gradle/AnnotatedSelectStatement$Field;", "propertyNameGenerator", "Ldev/goquick/sqlitenow/gradle/PropertyNameGeneratorType;", "selectFieldGenerator", "Ldev/goquick/sqlitenow/gradle/SelectFieldCodeGenerator;", "isFieldNullable", "", "hasAdapterAnnotation", "getPropertyName", "getInputAdapterFunctionName", "propertyName", "getOutputAdapterFunctionName", "ParamConfig", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAdapterConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdapterConfig.kt\ndev/goquick/sqlitenow/gradle/AdapterConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1863#2:246\n1864#2:254\n1863#2,2:257\n381#3,7:247\n216#4,2:255\n1#5:259\n*S KotlinDebug\n*F\n+ 1 AdapterConfig.kt\ndev/goquick/sqlitenow/gradle/AdapterConfig\n*L\n62#1:246\n62#1:254\n105#1:257,2\n66#1:247,7\n71#1:255,2\n*E\n"})
public final class AdapterConfig {
    @NotNull
    private final ColumnLookup columnLookup;
    @NotNull
    private final List<AnnotatedCreateTableStatement> createTableStatements;

    public AdapterConfig(@NotNull ColumnLookup columnLookup, @NotNull List<AnnotatedCreateTableStatement> createTableStatements) {
        Intrinsics.checkNotNullParameter((Object)columnLookup, (String)"columnLookup");
        Intrinsics.checkNotNullParameter(createTableStatements, (String)"createTableStatements");
        this.columnLookup = columnLookup;
        this.createTableStatements = createTableStatements;
    }

    @NotNull
    public final List<ParamConfig> collectAllParamConfigs(@NotNull AnnotatedStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        List configs = new ArrayList();
        Set processedAdapters = new LinkedHashSet();
        AnnotatedStatement annotatedStatement = statement;
        if (annotatedStatement instanceof AnnotatedSelectStatement) {
            configs.addAll((Collection)this.collectInputParamConfigs(statement, processedAdapters));
            configs.addAll((Collection)this.collectOutputParamConfigs((AnnotatedSelectStatement)statement, processedAdapters));
        } else if (annotatedStatement instanceof AnnotatedExecuteStatement) {
            configs.addAll((Collection)this.collectInputParamConfigs(statement, processedAdapters));
        } else if (!(annotatedStatement instanceof AnnotatedCreateTableStatement) && !(annotatedStatement instanceof AnnotatedCreateViewStatement)) {
            throw new NoWhenBranchMatchedException();
        }
        return configs;
    }

    private final List<ParamConfig> collectInputParamConfigs(AnnotatedStatement statement, Set<String> processedAdapters) {
        Object element$iv;
        List configs = new ArrayList();
        List uniqueParameters = CollectionsKt.distinct((Iterable)StatementUtils.INSTANCE.getNamedParameters(statement));
        Map columnToParameters = new LinkedHashMap();
        Object $this$forEach$iv = uniqueParameters;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            element$iv = iterator.next();
            String paramName = (String)element$iv;
            boolean bl = false;
            AnnotatedCreateTableStatement.Column column = this.columnLookup.findColumnForParameter(statement, paramName);
            if (column == null || !column.getAnnotations().containsKey("adapter")) continue;
            String columnKey = column.getSrc().getName() + "_" + column.getSrc().getDataType();
            Map $this$getOrPut$iv = columnToParameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(columnKey);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(columnKey, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(paramName);
        }
        $this$forEach$iv = columnToParameters;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            AnnotatedCreateTableStatement.Column column;
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String columnKey = (String)object.getKey();
            List paramNames = (List)object.getValue();
            String firstParamName = (String)CollectionsKt.first((List)paramNames);
            Intrinsics.checkNotNull((Object)this.columnLookup.findColumnForParameter(statement, firstParamName));
            String columnName = PropertyNameGeneratorType.LOWER_CAMEL_CASE.convertToPropertyName(column.getSrc().getName());
            String adapterFunctionName = this.getInputAdapterFunctionName(columnName);
            if (processedAdapters.contains(adapterFunctionName)) continue;
            processedAdapters.add(adapterFunctionName);
            ParamConfig config = this.createInputParamConfig(firstParamName, adapterFunctionName, column);
            configs.add(config);
        }
        return configs;
    }

    private final List<ParamConfig> collectOutputParamConfigs(AnnotatedSelectStatement statement, Set<String> processedAdapters) {
        List configs = new ArrayList();
        SelectFieldCodeGenerator selectFieldGenerator = new SelectFieldCodeGenerator(this.createTableStatements);
        Iterable $this$forEach$iv = statement.getFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String columnName;
            String adapterFunctionName;
            AnnotatedSelectStatement.Field field = (AnnotatedSelectStatement.Field)element$iv;
            boolean bl = false;
            if (!this.hasAdapterAnnotation(field) || processedAdapters.contains(adapterFunctionName = this.getOutputAdapterFunctionName(columnName = PropertyNameGeneratorType.LOWER_CAMEL_CASE.convertToPropertyName(field.getSrc().getOriginalColumnName())))) continue;
            processedAdapters.add(adapterFunctionName);
            ParamConfig config = this.createOutputParamConfig(field, adapterFunctionName, statement.getAnnotations().getPropertyNameGenerator(), selectFieldGenerator);
            configs.add(config);
        }
        return configs;
    }

    private final ParamConfig createInputParamConfig(String parameterName, String adapterFunctionName, AnnotatedCreateTableStatement.Column column) {
        TypeName baseType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(column.getSrc().getDataType());
        String propertyType = column.getAnnotations().get("propertyType");
        boolean isNullable = column.isNullable();
        TypeName targetType = SqliteTypeToKotlinCodeConverter.Companion.determinePropertyType(baseType, propertyType, isNullable);
        TypeName inputType = TypeName.copy$default((TypeName)targetType, (boolean)isNullable, null, (int)2, null);
        TypeName outputType = TypeName.copy$default((TypeName)baseType, (boolean)isNullable, null, (int)2, null);
        return new ParamConfig(parameterName, adapterFunctionName, inputType, outputType, isNullable);
    }

    private final ParamConfig createOutputParamConfig(AnnotatedSelectStatement.Field field, String adapterFunctionName, PropertyNameGeneratorType propertyNameGenerator, SelectFieldCodeGenerator selectFieldGenerator) {
        PropertySpec property = selectFieldGenerator.generateProperty(field, propertyNameGenerator);
        TypeName targetType = property.getType();
        boolean inputNullable = this.isFieldNullable(field, selectFieldGenerator);
        TypeName underlyingType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(field.getSrc().getDataType());
        TypeName inputType = TypeName.copy$default((TypeName)underlyingType, (boolean)inputNullable, null, (int)2, null);
        return new ParamConfig(field.getSrc().getFieldName(), adapterFunctionName, inputType, targetType, inputNullable);
    }

    private final boolean isFieldNullable(AnnotatedSelectStatement.Field field, SelectFieldCodeGenerator selectFieldGenerator) {
        PropertySpec property = selectFieldGenerator.generateProperty(field, PropertyNameGeneratorType.LOWER_CAMEL_CASE);
        return property.getType().isNullable();
    }

    public final boolean hasAdapterAnnotation(@NotNull AnnotatedSelectStatement.Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (Intrinsics.areEqual((Object)field.getAnnotations().getAdapter(), (Object)true)) {
            return true;
        }
        SelectStatement.FieldSource fieldSource = field.getSrc();
        if (((CharSequence)fieldSource.getTableName()).length() > 0 && ((CharSequence)fieldSource.getOriginalColumnName()).length() > 0) {
            AnnotatedCreateTableStatement.Column column;
            Object v0;
            block4: {
                Iterable iterable = this.createTableStatements;
                for (Object t : iterable) {
                    AnnotatedCreateTableStatement it = (AnnotatedCreateTableStatement)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSrc().getTableName(), (Object)fieldSource.getTableName())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            AnnotatedCreateTableStatement createTableStatement = v0;
            if (createTableStatement != null && (column = createTableStatement.findColumnByName(fieldSource.getOriginalColumnName())) != null) {
                return column.getAnnotations().containsKey("adapter");
            }
        }
        return false;
    }

    @NotNull
    public final String getPropertyName(@NotNull AnnotatedSelectStatement.Field field, @NotNull PropertyNameGeneratorType propertyNameGenerator, @NotNull SelectFieldCodeGenerator selectFieldGenerator) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)propertyNameGenerator), (String)"propertyNameGenerator");
        Intrinsics.checkNotNullParameter((Object)selectFieldGenerator, (String)"selectFieldGenerator");
        PropertySpec property = selectFieldGenerator.generateProperty(field, propertyNameGenerator);
        return property.getName();
    }

    private final String getInputAdapterFunctionName(String propertyName) {
        return propertyName + "ToSqlColumn";
    }

    @NotNull
    public final String getOutputAdapterFunctionName(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return "sqlColumnTo" + CharSequenceExtensionsKt.capitalized((CharSequence)propertyName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0012\u00a8\u0006\u001e"}, d2={"Ldev/goquick/sqlitenow/gradle/AdapterConfig$ParamConfig;", "", "paramName", "", "adapterFunctionName", "inputType", "Lcom/squareup/kotlinpoet/TypeName;", "outputType", "isNullable", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/squareup/kotlinpoet/TypeName;Lcom/squareup/kotlinpoet/TypeName;Z)V", "getParamName", "()Ljava/lang/String;", "getAdapterFunctionName", "getInputType", "()Lcom/squareup/kotlinpoet/TypeName;", "getOutputType", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "sqlitenow-gradle-plugin"})
    public static final class ParamConfig {
        @NotNull
        private final String paramName;
        @NotNull
        private final String adapterFunctionName;
        @NotNull
        private final TypeName inputType;
        @NotNull
        private final TypeName outputType;
        private final boolean isNullable;

        public ParamConfig(@NotNull String paramName, @NotNull String adapterFunctionName, @NotNull TypeName inputType, @NotNull TypeName outputType, boolean isNullable) {
            Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
            Intrinsics.checkNotNullParameter((Object)adapterFunctionName, (String)"adapterFunctionName");
            Intrinsics.checkNotNullParameter((Object)inputType, (String)"inputType");
            Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
            this.paramName = paramName;
            this.adapterFunctionName = adapterFunctionName;
            this.inputType = inputType;
            this.outputType = outputType;
            this.isNullable = isNullable;
        }

        @NotNull
        public final String getParamName() {
            return this.paramName;
        }

        @NotNull
        public final String getAdapterFunctionName() {
            return this.adapterFunctionName;
        }

        @NotNull
        public final TypeName getInputType() {
            return this.inputType;
        }

        @NotNull
        public final TypeName getOutputType() {
            return this.outputType;
        }

        public final boolean isNullable() {
            return this.isNullable;
        }

        @NotNull
        public final String component1() {
            return this.paramName;
        }

        @NotNull
        public final String component2() {
            return this.adapterFunctionName;
        }

        @NotNull
        public final TypeName component3() {
            return this.inputType;
        }

        @NotNull
        public final TypeName component4() {
            return this.outputType;
        }

        public final boolean component5() {
            return this.isNullable;
        }

        @NotNull
        public final ParamConfig copy(@NotNull String paramName, @NotNull String adapterFunctionName, @NotNull TypeName inputType, @NotNull TypeName outputType, boolean isNullable) {
            Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
            Intrinsics.checkNotNullParameter((Object)adapterFunctionName, (String)"adapterFunctionName");
            Intrinsics.checkNotNullParameter((Object)inputType, (String)"inputType");
            Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
            return new ParamConfig(paramName, adapterFunctionName, inputType, outputType, isNullable);
        }

        public static /* synthetic */ ParamConfig copy$default(ParamConfig paramConfig, String string, String string2, TypeName typeName, TypeName typeName2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = paramConfig.paramName;
            }
            if ((n & 2) != 0) {
                string2 = paramConfig.adapterFunctionName;
            }
            if ((n & 4) != 0) {
                typeName = paramConfig.inputType;
            }
            if ((n & 8) != 0) {
                typeName2 = paramConfig.outputType;
            }
            if ((n & 0x10) != 0) {
                bl = paramConfig.isNullable;
            }
            return paramConfig.copy(string, string2, typeName, typeName2, bl);
        }

        @NotNull
        public String toString() {
            return "ParamConfig(paramName=" + this.paramName + ", adapterFunctionName=" + this.adapterFunctionName + ", inputType=" + this.inputType + ", outputType=" + this.outputType + ", isNullable=" + this.isNullable + ")";
        }

        public int hashCode() {
            int result = this.paramName.hashCode();
            result = result * 31 + this.adapterFunctionName.hashCode();
            result = result * 31 + this.inputType.hashCode();
            result = result * 31 + this.outputType.hashCode();
            result = result * 31 + Boolean.hashCode(this.isNullable);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParamConfig)) {
                return false;
            }
            ParamConfig paramConfig = (ParamConfig)other;
            if (!Intrinsics.areEqual((Object)this.paramName, (Object)paramConfig.paramName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.adapterFunctionName, (Object)paramConfig.adapterFunctionName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.inputType, (Object)paramConfig.inputType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputType, (Object)paramConfig.outputType)) {
                return false;
            }
            return this.isNullable == paramConfig.isNullable;
        }
    }
}

