/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import dev.goquick.sqlitenow.gradle.AdapterConfig;
import dev.goquick.sqlitenow.gradle.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedExecuteStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.ColumnLookup;
import dev.goquick.sqlitenow.gradle.SharedResultManager;
import dev.goquick.sqlitenow.gradle.SharedResultTypeUtils;
import dev.goquick.sqlitenow.gradle.StatementUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.internal.extensions.stdlib.CharSequenceExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00019BU\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00050\u0003H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005H\u0002J\u001e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J:\u0010!\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\"2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J6\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020#2\u0006\u0010%\u001a\u00020\u00062\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u00052\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004H\u0002J \u0010,\u001a\u00020(2\u0006\u0010%\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u0010%\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0018\u00102\u001a\u00020(2\u0006\u0010%\u001a\u00020-2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0018\u00103\u001a\u0002002\u0006\u0010%\u001a\u00020-2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J(\u00104\u001a\u00020\u00042\u0006\u0010%\u001a\u00020-2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u00105\u001a\u000206H\u0002J(\u00107\u001a\u00020\u00042\u0006\u0010%\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u00105\u001a\u000206H\u0002J\u0014\u00108\u001a\u00020\u0004*\u00020-2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Ldev/goquick/sqlitenow/gradle/DatabaseCodeGenerator;", "", "nsWithStatements", "", "", "", "Ldev/goquick/sqlitenow/gradle/AnnotatedStatement;", "createTableStatements", "Ldev/goquick/sqlitenow/gradle/AnnotatedCreateTableStatement;", "createViewStatements", "Ldev/goquick/sqlitenow/gradle/AnnotatedCreateViewStatement;", "packageName", "outputDir", "Ljava/io/File;", "databaseClassName", "<init>", "(Ljava/util/Map;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;)V", "adapterConfig", "Ldev/goquick/sqlitenow/gradle/AdapterConfig;", "sharedResultManager", "Ldev/goquick/sqlitenow/gradle/SharedResultManager;", "collectAdaptersByNamespace", "Ldev/goquick/sqlitenow/gradle/DatabaseCodeGenerator$UniqueAdapter;", "deduplicateAdaptersForNamespace", "adapters", "generateDatabaseClass", "", "generateMainDatabaseClass", "Lcom/squareup/kotlinpoet/TypeSpec;", "generateAdapterClass", "namespace", "generateRouterClass", "statements", "createMethodBuilder", "Lkotlin/Pair;", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "methodName", "statement", "className", "generateMethodBody", "Lcom/squareup/kotlinpoet/FunSpec;", "methodBuilder", "namedParameters", "methodCall", "generateSelectMethod", "Ldev/goquick/sqlitenow/gradle/AnnotatedSelectStatement;", "methodType", "generateExecuteRunnersProperty", "Lcom/squareup/kotlinpoet/PropertySpec;", "Ldev/goquick/sqlitenow/gradle/AnnotatedExecuteStatement;", "generateFlowMethod", "generateSelectRunnersProperty", "generateSelectRunnersObjectExpression", "hasParams", "", "generateExecuteRunnersObjectExpression", "getResultTypeName", "UniqueAdapter", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDatabaseCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/DatabaseCodeGenerator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,586:1\n216#2:587\n217#2:605\n216#2:620\n217#2:632\n216#2,2:640\n216#2,2:644\n216#2,2:646\n808#3,11:588\n1863#3,2:599\n1863#3:601\n1863#3,2:602\n1864#3:604\n1485#3:606\n1510#3,3:607\n1513#3,3:617\n1663#3,8:621\n1863#3:629\n1864#3:631\n1863#3,2:642\n1863#3,2:648\n1863#3,2:650\n1863#3,2:652\n1863#3,2:654\n1863#3,2:656\n1863#3,2:658\n381#4,7:610\n535#4:633\n520#4,6:634\n1#5:630\n*S KotlinDebug\n*F\n+ 1 DatabaseCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/DatabaseCodeGenerator\n*L\n53#1:587\n53#1:605\n102#1:620\n102#1:632\n157#1:640,2\n185#1:644,2\n191#1:646,2\n58#1:588,11\n58#1:599,2\n62#1:601\n75#1:602,2\n62#1:604\n99#1:606\n99#1:607,3\n99#1:617,3\n103#1:621,8\n110#1:629\n110#1:631\n176#1:642,2\n208#1:648,2\n245#1:650,2\n310#1:652,2\n422#1:654,2\n491#1:656,2\n551#1:658,2\n99#1:610,7\n149#1:633\n149#1:634,6\n*E\n"})
public final class DatabaseCodeGenerator {
    @NotNull
    private final Map<String, List<AnnotatedStatement>> nsWithStatements;
    @NotNull
    private final List<AnnotatedCreateTableStatement> createTableStatements;
    @NotNull
    private final String packageName;
    @NotNull
    private final File outputDir;
    @NotNull
    private final String databaseClassName;
    @NotNull
    private final AdapterConfig adapterConfig;
    @NotNull
    private final SharedResultManager sharedResultManager;

    public DatabaseCodeGenerator(@NotNull Map<String, ? extends List<? extends AnnotatedStatement>> nsWithStatements, @NotNull List<AnnotatedCreateTableStatement> createTableStatements, @NotNull List<AnnotatedCreateViewStatement> createViewStatements, @NotNull String packageName, @NotNull File outputDir, @NotNull String databaseClassName) {
        Intrinsics.checkNotNullParameter(nsWithStatements, (String)"nsWithStatements");
        Intrinsics.checkNotNullParameter(createTableStatements, (String)"createTableStatements");
        Intrinsics.checkNotNullParameter(createViewStatements, (String)"createViewStatements");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)databaseClassName, (String)"databaseClassName");
        this.nsWithStatements = nsWithStatements;
        this.createTableStatements = createTableStatements;
        this.packageName = packageName;
        this.outputDir = outputDir;
        this.databaseClassName = databaseClassName;
        this.adapterConfig = new AdapterConfig(new ColumnLookup(this.createTableStatements, createViewStatements), this.createTableStatements);
        this.sharedResultManager = new SharedResultManager();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<UniqueAdapter>> collectAdaptersByNamespace() {
        Map adaptersByNamespace = new LinkedHashMap();
        Map<String, List<AnnotatedStatement>> $this$forEach$iv = this.nsWithStatements;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<AnnotatedStatement>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterable $this$forEach$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            Map.Entry<String, List<AnnotatedStatement>> element$iv;
            Map.Entry<String, List<AnnotatedStatement>> entry = element$iv = iterator.next();
            boolean bl = false;
            String namespace = entry.getKey();
            List<AnnotatedStatement> statements = entry.getValue();
            List namespaceAdapters = new ArrayList();
            Set processedSharedResults = new LinkedHashSet();
            Iterable $this$filterIsInstance$iv = statements;
            boolean $i$f$filterIsInstance = false;
            Iterator iterator2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof AnnotatedSelectStatement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AnnotatedSelectStatement statement = (AnnotatedSelectStatement)element$iv2;
                boolean bl2 = false;
                this.sharedResultManager.registerSharedResult(statement, namespace);
            }
            $this$forEach$iv2 = statements;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AnnotatedStatement statement = (AnnotatedStatement)element$iv2;
                boolean bl3 = false;
                if (statement instanceof AnnotatedSelectStatement && ((AnnotatedSelectStatement)statement).getAnnotations().getSharedResult() != null) {
                    String sharedResultKey = namespace + "." + ((AnnotatedSelectStatement)statement).getAnnotations().getSharedResult();
                    if (processedSharedResults.contains(sharedResultKey)) continue;
                    processedSharedResults.add(sharedResultKey);
                }
                List<AdapterConfig.ParamConfig> statementAdapters = this.adapterConfig.collectAllParamConfigs(statement);
                Iterable $this$forEach$iv3 = statementAdapters;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    AdapterConfig.ParamConfig config = (AdapterConfig.ParamConfig)element$iv3;
                    boolean bl4 = false;
                    namespaceAdapters.add(new UniqueAdapter(config.getAdapterFunctionName(), config.getInputType(), config.getOutputType(), config.isNullable()));
                }
            }
            List<UniqueAdapter> deduplicatedAdapters = this.deduplicateAdaptersForNamespace(namespaceAdapters);
            adaptersByNamespace.put(namespace, CollectionsKt.toMutableList((Collection)deduplicatedAdapters));
        }
        return adaptersByNamespace;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UniqueAdapter> deduplicateAdaptersForNamespace(List<UniqueAdapter> adapters) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = adapters;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            UniqueAdapter it = (UniqueAdapter)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getFunctionName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map adaptersByName = destination$iv$iv;
        List result = new ArrayList();
        Map $this$forEach$iv = adaptersByName;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            Map.Entry entry = element$iv;
            boolean bl = false;
            String functionName = (String)entry.getKey();
            List adapterList = (List)entry.getValue();
            Iterable $this$distinctBy$iv = adapterList;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                UniqueAdapter it = (UniqueAdapter)e$iv;
                boolean bl3 = false;
                String key$iv = it.signatureKey();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            List uniqueSignatures = list$iv;
            if (uniqueSignatures.size() == 1) {
                result.add(CollectionsKt.first((List)uniqueSignatures));
                continue;
            }
            Iterable $this$forEach$iv2 = uniqueSignatures;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String string;
                UniqueAdapter adapter = (UniqueAdapter)element$iv2;
                boolean bl4 = false;
                String inputTypeName = StringsKt.substringAfterLast$default((String)adapter.getInputType().toString(), (char)'.', null, (int)2, null);
                String string2 = adapter.getFunctionName();
                String string3 = inputTypeName;
                if (((CharSequence)string3).length() > 0) {
                    void it;
                    char c = string3.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    String string4 = string2;
                    boolean bl5 = false;
                    String string5 = String.valueOf((char)it);
                    Intrinsics.checkNotNull((Object)string5, (String)"null cannot be cast to non-null type java.lang.String");
                    String string6 = string5.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
                    CharSequence charSequence = string6;
                    string2 = string4;
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
                    String string7 = string3;
                    int n = 1;
                    String string8 = string7.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                    string = stringBuilder2.append(string8).toString();
                } else {
                    string = string3;
                }
                String uniqueName = string2 + "For" + string;
                result.add(UniqueAdapter.copy$default(adapter, uniqueName, null, null, false, 14, null));
            }
        }
        return result;
    }

    public final void generateDatabaseClass() {
        FileSpec.Builder fileBuilder = FileSpec.Companion.builder(this.packageName, this.databaseClassName).addFileComment("Generated database class with unified adapter management", new Object[0]).addFileComment("Do not modify this file manually", new Object[0]);
        String[] stringArray = new String[]{"DatabaseMigrations"};
        fileBuilder.addImport("dev.goquick.sqlitenow.core", stringArray);
        stringArray = new String[]{"SqliteNowDatabase"};
        fileBuilder.addImport("dev.goquick.sqlitenow.core", stringArray);
        stringArray = new String[]{"SelectRunners"};
        fileBuilder.addImport("dev.goquick.sqlitenow.core", stringArray);
        stringArray = new String[]{"ExecuteRunners"};
        fileBuilder.addImport("dev.goquick.sqlitenow.core", stringArray);
        stringArray = new String[]{"Flow"};
        fileBuilder.addImport("kotlinx.coroutines.flow", stringArray);
        TypeSpec databaseClass = this.generateMainDatabaseClass();
        fileBuilder.addType(databaseClass);
        fileBuilder.build().writeTo(this.outputDir);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec generateMainDatabaseClass() {
        String namespace;
        void $this$filterTo$iv$iv;
        Map<String, List<UniqueAdapter>> adaptersByNamespace;
        Object[] objectArray = new KModifier[]{KModifier.PUBLIC};
        TypeSpec.Builder builder = TypeSpec.Companion.classBuilder(this.databaseClassName).addModifiers(objectArray);
        objectArray = new String[]{"SqliteNowDatabase"};
        TypeSpec.Builder classBuilder = builder.superclass((TypeName)new ClassName("dev.goquick.sqlitenow.core", (String[])objectArray));
        Map<String, List<UniqueAdapter>> $this$filter$iv = adaptersByNamespace = this.collectAdaptersByNamespace();
        boolean $i$f$filter232 = false;
        Map<String, List<UniqueAdapter>> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean bl = false;
        Map.Entry<Object, Object> entry = $this$filterTo$iv$iv.entrySet().iterator();
        while (entry.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry2 = element$iv$iv = entry.next();
            boolean bl2 = false;
            List adapters = (List)entry2.getValue();
            boolean bl3 = !((Collection)adapters).isEmpty();
            if (!bl3) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map namespacesWithAdapters = destination$iv$iv;
        String[] $i$f$filter232 = new String[]{"DatabaseMigrations"};
        FunSpec.Builder constructorBuilder = FunSpec.Companion.constructorBuilder().addParameter("dbName", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).addParameter("migration", (TypeName)new ClassName("dev.goquick.sqlitenow.core", $i$f$filter232), new KModifier[0]);
        Map<String, List<AnnotatedStatement>> $this$forEach$iv = namespacesWithAdapters;
        boolean $i$f$forEach = false;
        for (Map.Entry entry2 : $this$forEach$iv.entrySet()) {
            entry = entry2;
            boolean bl4 = false;
            namespace = (String)entry.getKey();
            List adapters = (List)entry.getValue();
            String adapterClassName = CharSequenceExtensionsKt.capitalized((CharSequence)namespace) + "Adapters";
            String[] stringArray = new String[]{adapterClassName};
            constructorBuilder.addParameter(namespace + "Adapters", (TypeName)new ClassName("", stringArray), new KModifier[0]);
            String[] stringArray2 = new String[]{adapterClassName};
            ClassName className = new ClassName("", stringArray2);
            stringArray2 = new KModifier[]{KModifier.PRIVATE};
            PropertySpec propertySpec = PropertySpec.Companion.builder(namespace + "Adapters", (TypeName)className, new KModifier[0]).addModifiers((KModifier[])stringArray2).initializer(namespace + "Adapters", new Object[0]).build();
            classBuilder.addProperty(propertySpec);
        }
        classBuilder.primaryConstructor(constructorBuilder.build());
        classBuilder.addSuperclassConstructorParameter("dbName = dbName", new Object[0]);
        classBuilder.addSuperclassConstructorParameter("migration = migration", new Object[0]);
        $this$forEach$iv = this.nsWithStatements.keySet();
        $i$f$forEach = false;
        Iterator<Map.Entry<Object, Object>> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry3 = iterator.next();
            String namespace2 = (String)((Object)entry3);
            boolean bl5 = false;
            String routerClassName = CharSequenceExtensionsKt.capitalized((CharSequence)namespace2) + "Router";
            String[] adapters = new String[]{routerClassName};
            PropertySpec routerProperty = PropertySpec.Companion.builder(namespace2, (TypeName)new ClassName("", adapters), new KModifier[0]).initializer(routerClassName + "(ref = this)", new Object[0]).build();
            classBuilder.addProperty(routerProperty);
        }
        $this$forEach$iv = namespacesWithAdapters;
        $i$f$forEach = false;
        for (Map.Entry entry4 : $this$forEach$iv.entrySet()) {
            entry = entry4;
            boolean bl6 = false;
            namespace = (String)entry.getKey();
            List adapters = (List)entry.getValue();
            TypeSpec adapterClass = this.generateAdapterClass(namespace, adapters);
            classBuilder.addType(adapterClass);
        }
        $this$forEach$iv = this.nsWithStatements;
        $i$f$forEach = false;
        for (Map.Entry<Object, Object> entry5 : $this$forEach$iv.entrySet()) {
            entry = entry5;
            boolean bl7 = false;
            namespace = (String)entry.getKey();
            List statements = (List)entry.getValue();
            TypeSpec routerClass = this.generateRouterClass(namespace, statements);
            classBuilder.addType(routerClass);
        }
        return classBuilder.build();
    }

    private final TypeSpec generateAdapterClass(String namespace, List<UniqueAdapter> adapters) {
        String adapterClassName = CharSequenceExtensionsKt.capitalized((CharSequence)namespace) + "Adapters";
        KModifier[] kModifierArray = new KModifier[]{KModifier.PUBLIC, KModifier.DATA};
        TypeSpec.Builder classBuilder = TypeSpec.Companion.classBuilder(adapterClassName).addModifiers(kModifierArray);
        FunSpec.Builder constructorBuilder = FunSpec.Companion.constructorBuilder();
        Iterable $this$forEach$iv = adapters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UniqueAdapter adapter = (UniqueAdapter)element$iv;
            boolean bl = false;
            ParameterSpec paramSpec = adapter.toParameterSpec();
            constructorBuilder.addParameter(paramSpec);
            PropertySpec propertySpec = PropertySpec.Companion.builder(adapter.getFunctionName(), adapter.toParameterSpec().getType(), new KModifier[0]).initializer(adapter.getFunctionName(), new Object[0]).build();
            classBuilder.addProperty(propertySpec);
        }
        classBuilder.primaryConstructor(constructorBuilder.build());
        return classBuilder.build();
    }

    private final TypeSpec generateRouterClass(String namespace, List<? extends AnnotatedStatement> statements) {
        String routerClassName = CharSequenceExtensionsKt.capitalized((CharSequence)namespace) + "Router";
        KModifier[] kModifierArray = new KModifier[]{KModifier.PUBLIC};
        TypeSpec.Builder classBuilder = TypeSpec.Companion.classBuilder(routerClassName).addModifiers(kModifierArray);
        String[] stringArray = new String[]{this.databaseClassName};
        FunSpec.Builder constructorBuilder = FunSpec.Companion.constructorBuilder().addParameter("ref", (TypeName)new ClassName("", stringArray), new KModifier[0]);
        classBuilder.primaryConstructor(constructorBuilder.build());
        String[] stringArray2 = new String[]{this.databaseClassName};
        ClassName className = new ClassName("", stringArray2);
        stringArray2 = new KModifier[]{KModifier.PRIVATE};
        PropertySpec refProperty = PropertySpec.Companion.builder("ref", (TypeName)className, new KModifier[0]).initializer("ref", new Object[0]).addModifiers((KModifier[])stringArray2).build();
        classBuilder.addProperty(refProperty);
        Iterable $this$forEach$iv = statements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnnotatedStatement statement = (AnnotatedStatement)element$iv;
            boolean bl = false;
            AnnotatedStatement annotatedStatement = statement;
            Object object = annotatedStatement instanceof AnnotatedSelectStatement ? classBuilder.addProperty(this.generateSelectRunnersProperty((AnnotatedSelectStatement)statement, namespace)) : (annotatedStatement instanceof AnnotatedExecuteStatement ? classBuilder.addProperty(this.generateExecuteRunnersProperty((AnnotatedExecuteStatement)statement, namespace)) : Unit.INSTANCE);
        }
        return classBuilder.build();
    }

    private final Pair<FunSpec.Builder, List<String>> createMethodBuilder(String methodName, AnnotatedStatement statement, String className, String namespace) {
        KModifier[] kModifierArray = new KModifier[]{KModifier.SUSPEND};
        FunSpec.Builder methodBuilder = FunSpec.Companion.builder(methodName).addModifiers(kModifierArray);
        List<String> namedParameters = StatementUtils.INSTANCE.getNamedParameters(statement);
        if (!((Collection)namedParameters).isEmpty()) {
            String[] stringArray = new String[]{CharSequenceExtensionsKt.capitalized((CharSequence)namespace)};
            ClassName paramsType = new ClassName(this.packageName, stringArray).nestedClass(className).nestedClass("Params");
            methodBuilder.addParameter("params", (TypeName)paramsType, new KModifier[0]);
        }
        return TuplesKt.to((Object)methodBuilder, namedParameters);
    }

    private final FunSpec generateMethodBody(FunSpec.Builder methodBuilder, AnnotatedStatement statement, List<String> namedParameters, String namespace, String methodCall) {
        List<AdapterConfig.ParamConfig> statementAdapters;
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(methodCall);
        codeBuilder.append("    conn = ref.connection(),\n");
        if (!((Collection)namedParameters).isEmpty()) {
            codeBuilder.append("    params = params,\n");
        }
        if (!((Collection)(statementAdapters = this.adapterConfig.collectAllParamConfigs(statement))).isEmpty()) {
            Iterable $this$forEach$iv = statementAdapters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdapterConfig.ParamConfig config = (AdapterConfig.ParamConfig)element$iv;
                boolean bl = false;
                codeBuilder.append("    " + config.getAdapterFunctionName() + " = ref." + namespace + "Adapters." + config.getAdapterFunctionName() + ",\n");
            }
        }
        codeBuilder.append(")");
        String string = codeBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        methodBuilder.addStatement(string, new Object[0]);
        return methodBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final FunSpec generateSelectMethod(AnnotatedSelectStatement statement, String methodType, String namespace) {
        Object object;
        Pair<FunSpec.Builder, List<String>> className = statement.getDataClassName();
        Pair<FunSpec.Builder, List<String>> pair = className;
        if (((CharSequence)pair).length() > 0) {
            void it22;
            char c = pair.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            String string = String.valueOf((char)it22);
            Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type java.lang.String");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string2);
            Pair<FunSpec.Builder, List<String>> it22 = pair;
            n = 1;
            String string3 = it22.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            object = stringBuilder2.append(string3).toString();
        } else {
            object = pair;
        }
        String methodName = (String)object + StringsKt.removePrefix((String)methodType, (CharSequence)"execute");
        pair = this.createMethodBuilder(methodName, statement, (String)className, namespace);
        FunSpec.Builder methodBuilder = (FunSpec.Builder)pair.component1();
        List namedParameters = (List)pair.component2();
        ClassName resultType = SharedResultTypeUtils.INSTANCE.createResultTypeName(this.packageName, namespace, statement);
        TypeName returnType = switch (methodType) {
            case "executeAsList" -> {
                String[] var12_14 = new String[]{"List"};
                ClassName v5 = new ClassName("kotlin.collections", var12_14);
                var12_14 = new TypeName[]{resultType};
                yield (TypeName)ParameterizedTypeName.Companion.get(v5, (TypeName[])var12_14);
            }
            case "executeAsOne" -> (TypeName)resultType;
            case "executeAsOneOrNull" -> TypeName.copy$default((TypeName)((TypeName)resultType), (boolean)true, null, (int)2, null);
            default -> (TypeName)resultType;
        };
        FunSpec.Builder.returns$default((FunSpec.Builder)methodBuilder, (TypeName)returnType, null, (int)2, null);
        String methodCall = "return " + CharSequenceExtensionsKt.capitalized((CharSequence)namespace) + "." + className + "." + methodType + "(\n";
        return this.generateMethodBody(methodBuilder, statement, namedParameters, namespace, methodCall);
    }

    /*
     * WARNING - void declaration
     */
    private final PropertySpec generateExecuteRunnersProperty(AnnotatedExecuteStatement statement, String namespace) {
        TypeName typeName;
        boolean hasParams;
        String string;
        String className = statement.getDataClassName();
        String string2 = className;
        if (((CharSequence)string2).length() > 0) {
            void it22;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            String string3 = String.valueOf((char)it22);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String it22 = string2;
            n = 1;
            String string5 = it22.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        String propertyName = string;
        List<String> namedParameters = StatementUtils.INSTANCE.getNamedParameters(statement);
        boolean bl = hasParams = !((Collection)namedParameters).isEmpty();
        if (hasParams) {
            String[] stringArray = new String[]{CharSequenceExtensionsKt.capitalized((CharSequence)namespace)};
            paramsType = new ClassName(this.packageName, stringArray).nestedClass(className).nestedClass("Params");
            String[] stringArray2 = new String[]{"ExecuteRunners"};
            ClassName executeRunnersType = new ClassName("dev.goquick.sqlitenow.core", stringArray2);
            stringArray2 = new TypeName[]{paramsType};
            typeName = (TypeName)LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, null, (TypeName[])stringArray2, (TypeName)((TypeName)executeRunnersType), (int)1, null);
        } else {
            paramsType = new String[]{"ExecuteRunners"};
            typeName = (TypeName)new ClassName("dev.goquick.sqlitenow.core", paramsType);
        }
        TypeName propertyType = typeName;
        String objectExpression = this.generateExecuteRunnersObjectExpression(statement, namespace, className, hasParams);
        return PropertySpec.Companion.builder(propertyName, propertyType, new KModifier[0]).initializer(objectExpression, new Object[0]).build();
    }

    /*
     * WARNING - void declaration
     */
    private final FunSpec generateFlowMethod(AnnotatedSelectStatement statement, String namespace) {
        List<AdapterConfig.ParamConfig> statementAdapters;
        String string;
        String className = statement.getDataClassName();
        String string2 = className;
        if (((CharSequence)string2).length() > 0) {
            void it22;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            String string3 = String.valueOf((char)it22);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String it22 = string2;
            n = 1;
            String string5 = it22.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        String methodName = string + "Flow";
        FunSpec.Builder methodBuilder = FunSpec.Companion.builder(methodName).addKdoc("Creates a reactive Flow that emits " + className + " results whenever the underlying data changes.", new Object[0]);
        List<String> namedParameters = StatementUtils.INSTANCE.getNamedParameters(statement);
        if (!((Collection)namedParameters).isEmpty()) {
            String[] stringArray = new String[]{CharSequenceExtensionsKt.capitalized((CharSequence)namespace)};
            ClassName paramsType = new ClassName(this.packageName, stringArray).nestedClass(className).nestedClass("Params");
            methodBuilder.addParameter("params", (TypeName)paramsType, new KModifier[0]);
        }
        ClassName resultType = SharedResultTypeUtils.INSTANCE.createResultTypeName(this.packageName, namespace, statement);
        String[] stringArray = new String[]{"Flow"};
        ClassName className2 = new ClassName("kotlinx.coroutines.flow", stringArray);
        stringArray = new TypeName[1];
        String[] stringArray2 = new String[]{"List"};
        ClassName className3 = new ClassName("kotlin.collections", stringArray2);
        stringArray2 = new TypeName[]{resultType};
        stringArray[0] = ParameterizedTypeName.Companion.get(className3, (TypeName[])stringArray2);
        ParameterizedTypeName returnType = ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray);
        FunSpec.Builder.returns$default((FunSpec.Builder)methodBuilder, (TypeName)((TypeName)returnType), null, (int)2, null);
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("return ref.createReactiveQueryFlow(\n");
        codeBuilder.append("    affectedTables = " + CharSequenceExtensionsKt.capitalized((CharSequence)namespace) + "." + className + ".affectedTables,\n");
        codeBuilder.append("    queryExecutor = {\n");
        codeBuilder.append("        " + CharSequenceExtensionsKt.capitalized((CharSequence)namespace) + "." + className + ".executeAsList(\n");
        codeBuilder.append("            conn = ref.connection(),\n");
        if (!((Collection)namedParameters).isEmpty()) {
            codeBuilder.append("            params = params,\n");
        }
        if (!((Collection)(statementAdapters = this.adapterConfig.collectAllParamConfigs(statement))).isEmpty()) {
            Iterable $this$forEach$iv = statementAdapters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdapterConfig.ParamConfig config = (AdapterConfig.ParamConfig)element$iv;
                boolean bl = false;
                codeBuilder.append("            " + config.getAdapterFunctionName() + " = ref." + namespace + "Adapters." + config.getAdapterFunctionName() + ",\n");
            }
        }
        codeBuilder.append("        )\n");
        codeBuilder.append("    }\n");
        codeBuilder.append(")");
        String string6 = codeBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        methodBuilder.addStatement(string6, new Object[0]);
        return methodBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final PropertySpec generateSelectRunnersProperty(AnnotatedSelectStatement statement, String namespace) {
        TypeName typeName;
        boolean hasParams;
        String string;
        String className = statement.getDataClassName();
        String string2 = className;
        if (((CharSequence)string2).length() > 0) {
            void it22;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            String string3 = String.valueOf((char)it22);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String it22 = string2;
            n = 1;
            String string5 = it22.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        String propertyName = string;
        ClassName resultType = SharedResultTypeUtils.INSTANCE.createResultTypeName(this.packageName, namespace, statement);
        List<String> namedParameters = StatementUtils.INSTANCE.getNamedParameters(statement);
        boolean bl = hasParams = !((Collection)namedParameters).isEmpty();
        if (hasParams) {
            String[] stringArray = new String[]{CharSequenceExtensionsKt.capitalized((CharSequence)namespace)};
            paramsType = new ClassName(this.packageName, stringArray).nestedClass(className).nestedClass("Params");
            String[] stringArray2 = new String[]{"SelectRunners"};
            ClassName className2 = new ClassName("dev.goquick.sqlitenow.core", stringArray2);
            stringArray2 = new TypeName[]{resultType};
            ParameterizedTypeName selectRunnersType = ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray2);
            stringArray2 = new TypeName[]{paramsType};
            typeName = (TypeName)LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, null, (TypeName[])stringArray2, (TypeName)((TypeName)selectRunnersType), (int)1, null);
        } else {
            paramsType = new String[]{"SelectRunners"};
            ClassName className3 = new ClassName("dev.goquick.sqlitenow.core", paramsType);
            paramsType = new TypeName[]{resultType};
            typeName = (TypeName)ParameterizedTypeName.Companion.get(className3, (TypeName[])paramsType);
        }
        TypeName propertyType = typeName;
        String objectExpression = this.generateSelectRunnersObjectExpression(statement, namespace, className, hasParams);
        return PropertySpec.Companion.builder(propertyName, propertyType, new KModifier[0]).initializer(objectExpression, new Object[0]).build();
    }

    private final String generateSelectRunnersObjectExpression(AnnotatedSelectStatement statement, String namespace, String className, boolean hasParams) {
        StringBuilder stringBuilder;
        String capitalizedNamespace = CharSequenceExtensionsKt.capitalized((CharSequence)namespace);
        List<AdapterConfig.ParamConfig> statementAdapters = this.adapterConfig.collectAllParamConfigs(statement);
        boolean hasAdapters = !((Collection)statementAdapters).isEmpty();
        StringBuilder $this$generateSelectRunnersObjectExpression_u24lambda_u2423 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateSelectRunnersObjectExpression_u24lambda_u2423.append("conn = ref.connection()");
        if (hasParams) {
            $this$generateSelectRunnersObjectExpression_u24lambda_u2423.append(",\n                params = params");
        }
        if (hasAdapters) {
            Iterable $this$forEach$iv = statementAdapters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdapterConfig.ParamConfig config = (AdapterConfig.ParamConfig)element$iv;
                boolean bl2 = false;
                $this$generateSelectRunnersObjectExpression_u24lambda_u2423.append(",\n                " + config.getAdapterFunctionName() + " = ref." + namespace + "Adapters." + config.getAdapterFunctionName());
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String commonParams = string;
        StringBuilder $this$generateSelectRunnersObjectExpression_u24lambda_u2424 = stringBuilder = new StringBuilder();
        boolean bl3 = false;
        StringBuilder stringBuilder2 = hasParams ? $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("{ params -> object : SelectRunners<" + this.getResultTypeName(statement, namespace) + "> {\n") : $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("object : SelectRunners<" + this.getResultTypeName(statement, namespace) + "> {\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("        override suspend fun asList() = " + capitalizedNamespace + "." + className + ".executeAsList(\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("            " + commonParams + "\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("        )\n\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("        override suspend fun asOne() = " + capitalizedNamespace + "." + className + ".executeAsOne(\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("            " + commonParams + "\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("        )\n\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("        override suspend fun asOneOrNull() = " + capitalizedNamespace + "." + className + ".executeAsOneOrNull(\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("            " + commonParams + "\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("        )\n\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("        override fun asFlow() = ref.createReactiveQueryFlow(\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("            affectedTables = " + capitalizedNamespace + "." + className + ".affectedTables,\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("            queryExecutor = {\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("                " + capitalizedNamespace + "." + className + ".executeAsList(\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("                    " + commonParams + "\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("                )\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("            }\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("        )\n");
        $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("    }");
        if (hasParams) {
            $this$generateSelectRunnersObjectExpression_u24lambda_u2424.append("\n}");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String generateExecuteRunnersObjectExpression(AnnotatedExecuteStatement statement, String namespace, String className, boolean hasParams) {
        StringBuilder stringBuilder;
        String capitalizedNamespace = CharSequenceExtensionsKt.capitalized((CharSequence)namespace);
        List<AdapterConfig.ParamConfig> statementAdapters = this.adapterConfig.collectAllParamConfigs(statement);
        boolean hasAdapters = !((Collection)statementAdapters).isEmpty();
        StringBuilder $this$generateExecuteRunnersObjectExpression_u24lambda_u2426 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateExecuteRunnersObjectExpression_u24lambda_u2426.append("conn = ref.connection()");
        if (hasParams) {
            $this$generateExecuteRunnersObjectExpression_u24lambda_u2426.append(",\n                params = params");
        }
        if (hasAdapters) {
            Iterable $this$forEach$iv = statementAdapters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdapterConfig.ParamConfig config = (AdapterConfig.ParamConfig)element$iv;
                boolean bl2 = false;
                $this$generateExecuteRunnersObjectExpression_u24lambda_u2426.append(",\n                " + config.getAdapterFunctionName() + " = ref." + namespace + "Adapters." + config.getAdapterFunctionName());
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String commonParams = string;
        StringBuilder $this$generateExecuteRunnersObjectExpression_u24lambda_u2427 = stringBuilder = new StringBuilder();
        boolean bl3 = false;
        StringBuilder stringBuilder2 = hasParams ? $this$generateExecuteRunnersObjectExpression_u24lambda_u2427.append("{ params -> object : ExecuteRunners {\n") : $this$generateExecuteRunnersObjectExpression_u24lambda_u2427.append("object : ExecuteRunners {\n");
        $this$generateExecuteRunnersObjectExpression_u24lambda_u2427.append("        override suspend fun execute() {\n");
        $this$generateExecuteRunnersObjectExpression_u24lambda_u2427.append("            " + capitalizedNamespace + "." + className + ".execute(\n");
        $this$generateExecuteRunnersObjectExpression_u24lambda_u2427.append("                " + commonParams + "\n");
        $this$generateExecuteRunnersObjectExpression_u24lambda_u2427.append("            )\n");
        $this$generateExecuteRunnersObjectExpression_u24lambda_u2427.append("            // Notify listeners that tables have changed\n");
        $this$generateExecuteRunnersObjectExpression_u24lambda_u2427.append("            ref.notifyTablesChanged(" + capitalizedNamespace + "." + className + ".affectedTables)\n");
        $this$generateExecuteRunnersObjectExpression_u24lambda_u2427.append("        }\n");
        $this$generateExecuteRunnersObjectExpression_u24lambda_u2427.append("    }");
        if (hasParams) {
            $this$generateExecuteRunnersObjectExpression_u24lambda_u2427.append("\n}");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String getResultTypeName(AnnotatedSelectStatement $this$getResultTypeName, String namespace) {
        ClassName resultType = SharedResultTypeUtils.INSTANCE.createResultTypeName(this.packageName, namespace, $this$getResultTypeName);
        return resultType.toString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0010\u00a8\u0006\u001e"}, d2={"Ldev/goquick/sqlitenow/gradle/DatabaseCodeGenerator$UniqueAdapter;", "", "functionName", "", "inputType", "Lcom/squareup/kotlinpoet/TypeName;", "outputType", "isNullable", "", "<init>", "(Ljava/lang/String;Lcom/squareup/kotlinpoet/TypeName;Lcom/squareup/kotlinpoet/TypeName;Z)V", "getFunctionName", "()Ljava/lang/String;", "getInputType", "()Lcom/squareup/kotlinpoet/TypeName;", "getOutputType", "()Z", "toParameterSpec", "Lcom/squareup/kotlinpoet/ParameterSpec;", "signatureKey", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "sqlitenow-gradle-plugin"})
    public static final class UniqueAdapter {
        @NotNull
        private final String functionName;
        @NotNull
        private final TypeName inputType;
        @NotNull
        private final TypeName outputType;
        private final boolean isNullable;

        public UniqueAdapter(@NotNull String functionName, @NotNull TypeName inputType, @NotNull TypeName outputType, boolean isNullable) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)inputType, (String)"inputType");
            Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
            this.functionName = functionName;
            this.inputType = inputType;
            this.outputType = outputType;
            this.isNullable = isNullable;
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        @NotNull
        public final TypeName getInputType() {
            return this.inputType;
        }

        @NotNull
        public final TypeName getOutputType() {
            return this.outputType;
        }

        public final boolean isNullable() {
            return this.isNullable;
        }

        @NotNull
        public final ParameterSpec toParameterSpec() {
            TypeName[] typeNameArray = new TypeName[]{this.inputType};
            LambdaTypeName lambdaType = LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, null, (TypeName[])typeNameArray, (TypeName)this.outputType, (int)1, null);
            return ParameterSpec.Companion.builder(this.functionName, (TypeName)lambdaType, new KModifier[0]).build();
        }

        @NotNull
        public final String signatureKey() {
            return this.inputType + "__" + this.outputType;
        }

        @NotNull
        public final String component1() {
            return this.functionName;
        }

        @NotNull
        public final TypeName component2() {
            return this.inputType;
        }

        @NotNull
        public final TypeName component3() {
            return this.outputType;
        }

        public final boolean component4() {
            return this.isNullable;
        }

        @NotNull
        public final UniqueAdapter copy(@NotNull String functionName, @NotNull TypeName inputType, @NotNull TypeName outputType, boolean isNullable) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)inputType, (String)"inputType");
            Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
            return new UniqueAdapter(functionName, inputType, outputType, isNullable);
        }

        public static /* synthetic */ UniqueAdapter copy$default(UniqueAdapter uniqueAdapter, String string, TypeName typeName, TypeName typeName2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = uniqueAdapter.functionName;
            }
            if ((n & 2) != 0) {
                typeName = uniqueAdapter.inputType;
            }
            if ((n & 4) != 0) {
                typeName2 = uniqueAdapter.outputType;
            }
            if ((n & 8) != 0) {
                bl = uniqueAdapter.isNullable;
            }
            return uniqueAdapter.copy(string, typeName, typeName2, bl);
        }

        @NotNull
        public String toString() {
            return "UniqueAdapter(functionName=" + this.functionName + ", inputType=" + this.inputType + ", outputType=" + this.outputType + ", isNullable=" + this.isNullable + ")";
        }

        public int hashCode() {
            int result = this.functionName.hashCode();
            result = result * 31 + this.inputType.hashCode();
            result = result * 31 + this.outputType.hashCode();
            result = result * 31 + Boolean.hashCode(this.isNullable);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UniqueAdapter)) {
                return false;
            }
            UniqueAdapter uniqueAdapter = (UniqueAdapter)other;
            if (!Intrinsics.areEqual((Object)this.functionName, (Object)uniqueAdapter.functionName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.inputType, (Object)uniqueAdapter.inputType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputType, (Object)uniqueAdapter.outputType)) {
                return false;
            }
            return this.isNullable == uniqueAdapter.isNullable;
        }
    }
}

