/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import dev.goquick.sqlitenow.gradle.sqlite.SqlSingleStatement;
import dev.goquick.sqlitenow.gradle.sqlite.SqlStatementParserKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u0007\u001a\u00020\u0006J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Ldev/goquick/sqlitenow/gradle/SqlFileProcessor;", "", "<init>", "()V", "findSqlFiles", "", "Ljava/io/File;", "directory", "parseAllSqlFiles", "Ldev/goquick/sqlitenow/gradle/sqlite/SqlSingleStatement;", "sqlFiles", "parseAllSqlFilesInDirectory", "validateDirectory", "", "name", "", "mandatory", "", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSqlFileProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlFileProcessor.kt\ndev/goquick/sqlitenow/gradle/SqlFileProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n6479#2:76\n1863#3,2:77\n*S KotlinDebug\n*F\n+ 1 SqlFileProcessor.kt\ndev/goquick/sqlitenow/gradle/SqlFileProcessor\n*L\n23#1:76\n35#1:77,2\n*E\n"})
public final class SqlFileProcessor {
    @NotNull
    public static final SqlFileProcessor INSTANCE = new SqlFileProcessor();

    private SqlFileProcessor() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<File> findSqlFiles(@NotNull File directory) {
        List list;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        File[] fileArray = directory.listFiles(SqlFileProcessor::findSqlFiles$lambda$0);
        if (fileArray != null) {
            void $this$sortedBy$iv;
            File[] fileArray2 = fileArray;
            boolean $i$f$sortedBy = false;
            List list2 = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    File it = (File)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
            if (list2 != null) {
                list = list2;
                return list;
            }
        }
        list = CollectionsKt.emptyList();
        return list;
    }

    @NotNull
    public final List<SqlSingleStatement> parseAllSqlFiles(@NotNull List<? extends File> sqlFiles) {
        Intrinsics.checkNotNullParameter(sqlFiles, (String)"sqlFiles");
        List allStatements = new ArrayList();
        Iterable $this$forEach$iv = sqlFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File sqlFile = (File)element$iv;
            boolean bl = false;
            String sqlContent = FilesKt.readText$default((File)sqlFile, null, (int)1, null);
            List<SqlSingleStatement> fileStatements = SqlStatementParserKt.parseSqlStatements(sqlContent);
            allStatements.addAll((Collection)fileStatements);
        }
        return allStatements;
    }

    @NotNull
    public final List<SqlSingleStatement> parseAllSqlFilesInDirectory(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        List<File> sqlFiles = this.findSqlFiles(directory);
        return this.parseAllSqlFiles(sqlFiles);
    }

    public final void validateDirectory(@NotNull File directory, @NotNull String name, boolean mandatory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!mandatory && !directory.exists()) {
            return;
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException(name + " directory does not exist: " + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Path is not a directory: " + directory.getAbsolutePath());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findSqlFiles$lambda$0(File file) {
        if (!file.isFile()) return false;
        Intrinsics.checkNotNull((Object)file);
        if (!StringsKt.equals((String)FilesKt.getExtension((File)file), (String)"sql", (boolean)true)) return false;
        return true;
    }
}

