/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import dev.goquick.sqlitenow.gradle.GenerateDatabaseFilesTaskKt;
import java.io.File;
import java.io.FileNotFoundException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00020\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u00020\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u0013\u0010\u0015\u001a\u00020\u00168G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Ldev/goquick/sqlitenow/gradle/GenerateDatabaseFilesTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "<init>", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/ProjectLayout;)V", "dbName", "Lorg/gradle/api/provider/Property;", "", "getDbName", "()Lorg/gradle/api/provider/Property;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "sqlDir", "getSqlDir", "packageName", "getPackageName", "schemaDatabaseFile", "Lorg/gradle/api/file/RegularFileProperty;", "getSchemaDatabaseFile", "()Lorg/gradle/api/file/RegularFileProperty;", "generate", "", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenerateDatabaseFilesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateDatabaseFilesTask.kt\ndev/goquick/sqlitenow/gradle/GenerateDatabaseFilesTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public abstract class GenerateDatabaseFilesTask
extends DefaultTask {
    @NotNull
    private final DirectoryProperty outputDir;
    @NotNull
    private final DirectoryProperty sqlDir;
    @NotNull
    private final RegularFileProperty schemaDatabaseFile;

    @Inject
    public GenerateDatabaseFilesTask(@NotNull ObjectFactory objects, @NotNull ProjectLayout layout) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        DirectoryProperty directoryProperty = objects.directoryProperty().convention(layout.getBuildDirectory().dir("generated/sqlitenow/code"));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"convention(...)");
        this.outputDir = directoryProperty;
        DirectoryProperty directoryProperty2 = objects.directoryProperty().convention(layout.getProjectDirectory().dir("src/commonMain/sql"));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"convention(...)");
        this.sqlDir = directoryProperty2;
        RegularFileProperty regularFileProperty = objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"fileProperty(...)");
        this.schemaDatabaseFile = regularFileProperty;
    }

    @Input
    @NotNull
    public abstract Property<String> getDbName();

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @InputDirectory
    @Optional
    @NotNull
    public final DirectoryProperty getSqlDir() {
        return this.sqlDir;
    }

    @Input
    @NotNull
    public abstract Property<String> getPackageName();

    @OutputFile
    @Optional
    @NotNull
    public final RegularFileProperty getSchemaDatabaseFile() {
        return this.schemaDatabaseFile;
    }

    @TaskAction
    public final void generate() {
        Object object = this.outputDir.getAsFile().get();
        File $this$generate_u24lambda_u240 = (File)object;
        boolean bl = false;
        $this$generate_u24lambda_u240.mkdirs();
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"apply(...)");
        File outDir = (File)object2;
        Provider dbDir = this.sqlDir.dir((String)this.getDbName().get());
        if (!((Directory)dbDir.get()).getAsFile().exists()) {
            throw new FileNotFoundException("SQL database directory '" + ((Directory)dbDir.get()).getAsFile().getPath() + "' not found");
        }
        File dbFile = this.schemaDatabaseFile.isPresent() ? (File)this.schemaDatabaseFile.getAsFile().get() : null;
        File sqlDir = ((Directory)dbDir.get()).getAsFile();
        String packageName = (String)this.getPackageName().get();
        Object object3 = this.getDbName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        String string = (String)object3;
        Intrinsics.checkNotNull((Object)sqlDir);
        Intrinsics.checkNotNull((Object)packageName);
        GenerateDatabaseFilesTaskKt.generateDatabaseFiles(string, sqlDir, packageName, outDir, dbFile);
    }
}

