/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle;

import dev.goquick.sqlitenow.gradle.LoggerKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0007J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\r2\b\b\u0002\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Ldev/goquick/sqlitenow/gradle/StandardErrorHandler;", "", "<init>", "()V", "handleSqlParsingError", "", "sql", "", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "context", "handleSqlExecutionError", "", "formatSqlWithLineNumbers", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nStandardErrorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardErrorHandler.kt\ndev/goquick/sqlitenow/gradle/StandardErrorHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1567#2:57\n1598#2,4:58\n*S KotlinDebug\n*F\n+ 1 StandardErrorHandler.kt\ndev/goquick/sqlitenow/gradle/StandardErrorHandler\n*L\n50#1:57\n50#1:58,4\n*E\n"})
public final class StandardErrorHandler {
    @NotNull
    public static final StandardErrorHandler INSTANCE = new StandardErrorHandler();

    private StandardErrorHandler() {
    }

    @NotNull
    public final Void handleSqlParsingError(@NotNull String sql, @NotNull Exception error, @NotNull String context) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object contextInfo = ((CharSequence)context).length() > 0 ? " in " + context : "";
        LoggerKt.getLogger().error("Failed to parse SQL statement" + (String)contextInfo + ": " + error.getMessage());
        LoggerKt.getLogger().error("SQL statement:\n" + this.formatSqlWithLineNumbers(sql));
        throw new RuntimeException("SQL parsing failed" + (String)contextInfo, error);
    }

    public static /* synthetic */ Void handleSqlParsingError$default(StandardErrorHandler standardErrorHandler, String string, Exception exception, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        return standardErrorHandler.handleSqlParsingError(string, exception, string2);
    }

    @NotNull
    public final Void handleSqlExecutionError(@NotNull String sql, @NotNull Throwable error, @NotNull String context) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object contextInfo = ((CharSequence)context).length() > 0 ? " in " + context : "";
        LoggerKt.getLogger().error("Failed to execute SQL statement" + (String)contextInfo + ": " + error.getMessage());
        LoggerKt.getLogger().error("SQL statement:\n" + this.formatSqlWithLineNumbers(sql));
        throw new RuntimeException("SQL execution failed" + (String)contextInfo, error);
    }

    public static /* synthetic */ Void handleSqlExecutionError$default(StandardErrorHandler standardErrorHandler, String string, Throwable throwable, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        return standardErrorHandler.handleSqlExecutionError(string, throwable, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final String formatSqlWithLineNumbers(String sql) {
        void $this$mapIndexedTo$iv$iv;
        List lines = StringsKt.lines((CharSequence)sql);
        if (lines.isEmpty()) {
            return "<empty SQL>";
        }
        int width = String.valueOf(lines.size()).length();
        Iterable $this$mapIndexed$iv = lines;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void line;
            String lineNumber;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Locale locale = Locale.US;
            String string2 = "%" + width + "d";
            Object[] objectArray = new Object[]{(int)(index + true)};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
            collection.add(lineNumber + " | " + (String)line);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }
}

