/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.generator.query;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import dev.goquick.sqlitenow.gradle.context.AdapterParameterEmitter;
import dev.goquick.sqlitenow.gradle.generator.query.QueryFunctionScaffolder;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedExecuteStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.processing.SharedResultTypeUtils;
import dev.goquick.sqlitenow.gradle.processing.StatementUtils;
import dev.goquick.sqlitenow.gradle.util.IndentedCodeBuilder;
import dev.goquick.sqlitenow.gradle.util.SqliteTypeToKotlinCodeConverter;
import dev.goquick.sqlitenow.gradle.util.StringUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001Bo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000b\u00122\u0010\f\u001a.\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0003J \u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00192\b\b\u0002\u0010\u0017\u001a\u00020\u0003J0\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\b\u0010\u001f\u001a\u00020\u0003H\u0002J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J0\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J0\u0010%\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u000eH\u0002J0\u0010'\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0018\u0010*\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010)2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\f\u001a.\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldev/goquick/sqlitenow/gradle/generator/query/QueryExecuteEmitter;", "", "packageName", "", "debug", "", "scaffolder", "Ldev/goquick/sqlitenow/gradle/generator/query/QueryFunctionScaffolder;", "adapterParameterEmitter", "Ldev/goquick/sqlitenow/gradle/context/AdapterParameterEmitter;", "queryNamespaceName", "Lkotlin/Function1;", "collectionMappingBuilder", "Lkotlin/Function6;", "Ldev/goquick/sqlitenow/gradle/util/IndentedCodeBuilder;", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedSelectStatement;", "", "<init>", "(Ljava/lang/String;ZLdev/goquick/sqlitenow/gradle/generator/query/QueryFunctionScaffolder;Ldev/goquick/sqlitenow/gradle/context/AdapterParameterEmitter;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function6;)V", "generateSelectQueryFunction", "Lcom/squareup/kotlinpoet/FunSpec;", "namespace", "statement", "functionName", "generateExecuteQueryFunction", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedExecuteStatement;", "addSqlStatementProcessing", "fnBld", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedStatement;", "className", "withContextHeader", "prepareAndMaybeBindParamsLines", "", "capitalizedNamespace", "addSqlExecutionImplementationToBuilder", "builder", "addSelectExecutionImplementationToBuilder", "addExecuteStatementImplementationToBuilder", "addExecuteReturningStatementImplementationToBuilder", "resolvePublicResultType", "Lcom/squareup/kotlinpoet/TypeName;", "resolvePublicResultTypeString", "resolveBaseResultType", "Lcom/squareup/kotlinpoet/ClassName;", "resolveMapToType", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nQueryExecuteEmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryExecuteEmitter.kt\ndev/goquick/sqlitenow/gradle/generator/query/QueryExecuteEmitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n1863#2,2:397\n*S KotlinDebug\n*F\n+ 1 QueryExecuteEmitter.kt\ndev/goquick/sqlitenow/gradle/generator/query/QueryExecuteEmitter\n*L\n132#1:397,2\n*E\n"})
public final class QueryExecuteEmitter {
    @NotNull
    private final String packageName;
    private final boolean debug;
    @NotNull
    private final QueryFunctionScaffolder scaffolder;
    @NotNull
    private final AdapterParameterEmitter adapterParameterEmitter;
    @NotNull
    private final Function1<String, String> queryNamespaceName;
    @NotNull
    private final Function6<IndentedCodeBuilder, AnnotatedSelectStatement, String, String, String, String, Unit> collectionMappingBuilder;

    public QueryExecuteEmitter(@NotNull String packageName, boolean debug, @NotNull QueryFunctionScaffolder scaffolder, @NotNull AdapterParameterEmitter adapterParameterEmitter, @NotNull Function1<? super String, String> queryNamespaceName, @NotNull Function6<? super IndentedCodeBuilder, ? super AnnotatedSelectStatement, ? super String, ? super String, ? super String, ? super String, Unit> collectionMappingBuilder) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)scaffolder, (String)"scaffolder");
        Intrinsics.checkNotNullParameter((Object)adapterParameterEmitter, (String)"adapterParameterEmitter");
        Intrinsics.checkNotNullParameter(queryNamespaceName, (String)"queryNamespaceName");
        Intrinsics.checkNotNullParameter(collectionMappingBuilder, (String)"collectionMappingBuilder");
        this.packageName = packageName;
        this.debug = debug;
        this.scaffolder = scaffolder;
        this.adapterParameterEmitter = adapterParameterEmitter;
        this.queryNamespaceName = queryNamespaceName;
        this.collectionMappingBuilder = collectionMappingBuilder;
    }

    @NotNull
    public final FunSpec generateSelectQueryFunction(@NotNull String namespace, @NotNull AnnotatedSelectStatement statement, @NotNull String functionName) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        String className = statement.getDataClassName();
        String kdoc = switch (functionName) {
            case "executeAsList" -> "Executes the " + statement.getName() + " SELECT query and returns results as a list.";
            case "executeAsOne" -> "Executes the " + statement.getName() + " SELECT query and returns exactly one result. Throws an exception if no results are found.";
            case "executeAsOneOrNull" -> "Executes the " + statement.getName() + " SELECT query and returns one result or null if no results are found.";
            default -> "Executes the " + statement.getName() + " SELECT query.";
        };
        KModifier[] kModifierArray = new KModifier[]{KModifier.SUSPEND};
        FunSpec.Builder fnBld = FunSpec.Companion.builder(functionName).addModifiers(kModifierArray).addKdoc(kdoc, new Object[0]);
        this.scaffolder.setupExecuteFunctionStructure(fnBld, statement, namespace, className);
        TypeName publicResultType = this.resolvePublicResultType(namespace, statement);
        TypeName returnType = switch (functionName) {
            case "executeAsList" -> {
                String[] var10_9 = new String[]{"List"};
                ClassName v1 = new ClassName("kotlin.collections", var10_9);
                var10_9 = new TypeName[]{publicResultType};
                yield (TypeName)ParameterizedTypeName.Companion.get(v1, (TypeName[])var10_9);
            }
            case "executeAsOne" -> publicResultType;
            case "executeAsOneOrNull" -> TypeName.copy$default((TypeName)publicResultType, (boolean)true, null, (int)2, null);
            default -> publicResultType;
        };
        FunSpec.Builder.returns$default((FunSpec.Builder)fnBld, (TypeName)returnType, null, (int)2, null);
        this.addSqlStatementProcessing(fnBld, statement, namespace, className, functionName);
        return fnBld.build();
    }

    @NotNull
    public final FunSpec generateExecuteQueryFunction(@NotNull String namespace, @NotNull AnnotatedExecuteStatement statement, @NotNull String functionName) {
        FunSpec.Builder fnBld;
        String className;
        block17: {
            FunSpec.Builder builder;
            block15: {
                Object object;
                Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
                className = statement.getDataClassName();
                boolean hasReturning = statement.hasReturningClause();
                KModifier[] kModifierArray = new KModifier[]{KModifier.SUSPEND};
                fnBld = FunSpec.Companion.builder(functionName).addModifiers(kModifierArray).addKdoc((hasReturning ? "Executes and returns results from" : "Executes") + " the " + statement.getName() + " query.", new Object[0]);
                this.scaffolder.setupExecuteFunctionStructure(fnBld, statement, namespace, className);
                if (!hasReturning) break block15;
                if (statement.getAnnotations().getQueryResult() != null) {
                    String string = statement.getAnnotations().getQueryResult();
                    object = string;
                    Intrinsics.checkNotNull((Object)string);
                } else {
                    object = StringUtilsKt.pascalize(namespace) + className + "Result";
                }
                Object resultClassName = object;
                Object object2 = new String[]{resultClassName};
                ClassName resultType = new ClassName(this.packageName, (String[])object2);
                switch (functionName) {
                    case "executeReturningList": {
                        String[] stringArray = new String[]{"List"};
                        ClassName className2 = new ClassName("kotlin.collections", stringArray);
                        stringArray = new TypeName[]{resultType};
                        builder = FunSpec.Builder.returns$default((FunSpec.Builder)fnBld, (TypeName)((TypeName)ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray)), null, (int)2, null);
                        break;
                    }
                    case "executeReturningOne": {
                        builder = FunSpec.Builder.returns$default((FunSpec.Builder)fnBld, (TypeName)((TypeName)resultType), null, (int)2, null);
                        break;
                    }
                    case "executeReturningOneOrNull": {
                        builder = FunSpec.Builder.returns$default((FunSpec.Builder)fnBld, (TypeName)TypeName.copy$default((TypeName)((TypeName)resultType), (boolean)true, null, (int)2, null), null, (int)2, null);
                        break;
                    }
                    default: {
                        builder = FunSpec.Builder.returns$default((FunSpec.Builder)fnBld, (TypeName)((TypeName)resultType), null, (int)2, null);
                        break;
                    }
                }
                break block17;
            }
            builder = FunSpec.Builder.returns$default((FunSpec.Builder)fnBld, (KClass)Reflection.getOrCreateKotlinClass(Unit.class), null, (int)2, null);
        }
        this.addSqlStatementProcessing(fnBld, statement, namespace, className, functionName);
        return fnBld.build();
    }

    public static /* synthetic */ FunSpec generateExecuteQueryFunction$default(QueryExecuteEmitter queryExecuteEmitter2, String string, AnnotatedExecuteStatement annotatedExecuteStatement, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = annotatedExecuteStatement.hasReturningClause() ? "executeReturningList" : "execute";
        }
        return queryExecuteEmitter2.generateExecuteQueryFunction(string, annotatedExecuteStatement, string2);
    }

    private final void addSqlStatementProcessing(FunSpec.Builder fnBld, AnnotatedStatement statement, String namespace, String className, String functionName) {
        String capitalizedNamespace = (String)this.queryNamespaceName.invoke((Object)namespace);
        IndentedCodeBuilder builder = new IndentedCodeBuilder(0, 1, null);
        builder.line(this.withContextHeader());
        builder.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> QueryExecuteEmitter.addSqlStatementProcessing$lambda$0(this, namespace, statement, capitalizedNamespace, className, functionName, arg_0)));
        builder.line("}");
        fnBld.addStatement(builder.build(), new Object[0]);
    }

    private final String withContextHeader() {
        return this.debug ? "return conn.withContextAndTrace {" : "return withContext(conn.dispatcher) {";
    }

    private final List<String> prepareAndMaybeBindParamsLines(String namespace, AnnotatedStatement statement, String capitalizedNamespace, String className) {
        List lines = new ArrayList();
        ((Collection)lines).add("val sql = " + capitalizedNamespace + "." + className + ".SQL");
        ((Collection)lines).add("val statement = conn.prepare(sql)");
        List<String> namedParameters = StatementUtils.INSTANCE.getNamedParameters(statement);
        if (!((Collection)namedParameters).isEmpty()) {
            Object[] objectArray = new String[]{"statement", "params"};
            List params = CollectionsKt.mutableListOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)params, (Iterable)this.adapterParameterEmitter.parameterBindingAdapterNames(namespace, statement));
            ((Collection)lines).add(capitalizedNamespace + "." + className + ".bindStatementParams(" + CollectionsKt.joinToString$default((Iterable)params, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")");
        }
        return lines;
    }

    private final void addSqlExecutionImplementationToBuilder(IndentedCodeBuilder builder, AnnotatedStatement statement, String namespace, String className, String functionName) {
        AnnotatedStatement annotatedStatement = statement;
        if (annotatedStatement instanceof AnnotatedSelectStatement) {
            this.addSelectExecutionImplementationToBuilder(builder, (AnnotatedSelectStatement)statement, namespace, className, functionName);
        } else if (annotatedStatement instanceof AnnotatedExecuteStatement) {
            if (((AnnotatedExecuteStatement)statement).hasReturningClause()) {
                this.addExecuteReturningStatementImplementationToBuilder(builder, (AnnotatedExecuteStatement)statement, namespace, className, functionName);
            } else {
                this.addExecuteStatementImplementationToBuilder(builder);
            }
        } else if (annotatedStatement instanceof AnnotatedCreateTableStatement || annotatedStatement instanceof AnnotatedCreateViewStatement) {
            builder.line("TODO(\"Unimplemented\")");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void addSelectExecutionImplementationToBuilder(IndentedCodeBuilder builder, AnnotatedSelectStatement statement, String namespace, String className, String functionName) {
        String capitalizedNamespace = (String)this.queryNamespaceName.invoke((Object)namespace);
        String resultType = this.resolvePublicResultTypeString(namespace, statement);
        String joinedParams = CollectionsKt.joinToString$default((Iterable)this.adapterParameterEmitter.buildJoinedReadParamsList(namespace, statement), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        String readParams = CollectionsKt.joinToString$default((Iterable)this.adapterParameterEmitter.buildReadStatementParamsList(namespace, statement), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        String mapAdapterName = this.adapterParameterEmitter.mapToAdapterParameterName(namespace, statement);
        builder.line("statement.use { statement ->");
        builder.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> QueryExecuteEmitter.addSelectExecutionImplementationToBuilder$lambda$0(functionName, statement, this, namespace, className, joinedParams, mapAdapterName, resultType, capitalizedNamespace, readParams, arg_0)));
        builder.line("}");
    }

    private final void addExecuteStatementImplementationToBuilder(IndentedCodeBuilder builder) {
        builder.line("statement.use { statement ->");
        builder.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)QueryExecuteEmitter::addExecuteStatementImplementationToBuilder$lambda$0));
        builder.line("}");
    }

    private final void addExecuteReturningStatementImplementationToBuilder(IndentedCodeBuilder builder, AnnotatedExecuteStatement statement, String namespace, String className, String functionName) {
        String capitalizedNamespace = (String)this.queryNamespaceName.invoke((Object)namespace);
        String paramsString = CollectionsKt.joinToString$default((Iterable)this.adapterParameterEmitter.buildExecuteReadParamsList(statement), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        String resultTypeString = SharedResultTypeUtils.INSTANCE.createResultTypeStringForExecute(namespace, statement);
        switch (functionName) {
            case "executeReturningList": {
                builder.line("statement.use { statement ->");
                builder.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> QueryExecuteEmitter.addExecuteReturningStatementImplementationToBuilder$lambda$0(resultTypeString, capitalizedNamespace, className, paramsString, arg_0)));
                builder.line("}");
                break;
            }
            case "executeReturningOne": {
                builder.line("statement.use { statement ->");
                builder.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> QueryExecuteEmitter.addExecuteReturningStatementImplementationToBuilder$lambda$1(capitalizedNamespace, className, paramsString, arg_0)));
                builder.line("}");
                break;
            }
            case "executeReturningOneOrNull": {
                builder.line("statement.use { statement ->");
                builder.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> QueryExecuteEmitter.addExecuteReturningStatementImplementationToBuilder$lambda$2(capitalizedNamespace, className, paramsString, arg_0)));
                builder.line("}");
                break;
            }
            default: {
                builder.line("statement.use { statement ->");
                builder.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> QueryExecuteEmitter.addExecuteReturningStatementImplementationToBuilder$lambda$3(capitalizedNamespace, className, paramsString, arg_0)));
                builder.line("}");
            }
        }
    }

    private final TypeName resolvePublicResultType(String namespace, AnnotatedSelectStatement statement) {
        TypeName typeName = this.resolveMapToType(statement);
        if (typeName == null) {
            typeName = (TypeName)this.resolveBaseResultType(namespace, statement);
        }
        return typeName;
    }

    private final String resolvePublicResultTypeString(String namespace, AnnotatedSelectStatement statement) {
        String string = statement.getAnnotations().getMapTo();
        String override = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        CharSequence charSequence = override;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return override;
        }
        return SharedResultTypeUtils.INSTANCE.createResultTypeString(namespace, statement);
    }

    private final ClassName resolveBaseResultType(String namespace, AnnotatedSelectStatement statement) {
        return SharedResultTypeUtils.INSTANCE.createResultTypeName(this.packageName, namespace, statement);
    }

    private final TypeName resolveMapToType(AnnotatedSelectStatement statement) {
        String string = statement.getAnnotations().getMapTo();
        if (string == null) {
            return null;
        }
        String target = string;
        return SqliteTypeToKotlinCodeConverter.Companion.parseCustomType(target, this.packageName);
    }

    private static final Unit addSqlStatementProcessing$lambda$0(QueryExecuteEmitter this$0, String $namespace, AnnotatedStatement $statement, String $capitalizedNamespace, String $className, String $functionName, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Iterable $this$forEach$iv = this$0.prepareAndMaybeBindParamsLines($namespace, $statement, $capitalizedNamespace, $className);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            $this$indent.line(it);
        }
        this$0.addSqlExecutionImplementationToBuilder($this$indent, $statement, $namespace, $className, $functionName);
        return Unit.INSTANCE;
    }

    private static final Unit addSelectExecutionImplementationToBuilder$lambda$0(String $functionName, AnnotatedSelectStatement $statement, QueryExecuteEmitter this$0, String $namespace, String $className, String $joinedParams, String $mapAdapterName, String $resultType, String $capitalizedNamespace, String $readParams, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        switch ($functionName) {
            case "executeAsList": {
                if ($statement.hasCollectionMapping()) {
                    this$0.collectionMappingBuilder.invoke((Object)$this$indent, (Object)$statement, (Object)$namespace, (Object)$className, (Object)$joinedParams, (Object)$mapAdapterName);
                    break;
                }
                $this$indent.line("val results = mutableListOf<" + $resultType + ">()");
                $this$indent.line("while (statement.step()) {");
                IndentedCodeBuilder.indent$default($this$indent, 0, arg_0 -> QueryExecuteEmitter.addSelectExecutionImplementationToBuilder$lambda$0$0($capitalizedNamespace, $className, $readParams, arg_0), 1, null);
                $this$indent.line("}");
                $this$indent.line("results");
                break;
            }
            case "executeAsOne": {
                if ($statement.hasCollectionMapping()) {
                    $this$indent.line("val results = run {");
                    IndentedCodeBuilder.indent$default($this$indent, 0, arg_0 -> QueryExecuteEmitter.addSelectExecutionImplementationToBuilder$lambda$0$1(this$0, $statement, $namespace, $className, $joinedParams, $mapAdapterName, arg_0), 1, null);
                    $this$indent.line("}");
                    $this$indent.line("when {");
                    IndentedCodeBuilder.indent$default($this$indent, 0, QueryExecuteEmitter::addSelectExecutionImplementationToBuilder$lambda$0$2, 1, null);
                    $this$indent.line("}");
                    break;
                }
                $this$indent.line("if (statement.step()) {");
                IndentedCodeBuilder.indent$default($this$indent, 0, arg_0 -> QueryExecuteEmitter.addSelectExecutionImplementationToBuilder$lambda$0$3($capitalizedNamespace, $className, $readParams, arg_0), 1, null);
                $this$indent.line("} else {");
                IndentedCodeBuilder.indent$default($this$indent, 0, QueryExecuteEmitter::addSelectExecutionImplementationToBuilder$lambda$0$4, 1, null);
                $this$indent.line("}");
                break;
            }
            case "executeAsOneOrNull": {
                if ($statement.hasCollectionMapping()) {
                    $this$indent.line("val results = run {");
                    IndentedCodeBuilder.indent$default($this$indent, 0, arg_0 -> QueryExecuteEmitter.addSelectExecutionImplementationToBuilder$lambda$0$5(this$0, $statement, $namespace, $className, $joinedParams, $mapAdapterName, arg_0), 1, null);
                    $this$indent.line("}");
                    $this$indent.line("when {");
                    IndentedCodeBuilder.indent$default($this$indent, 0, QueryExecuteEmitter::addSelectExecutionImplementationToBuilder$lambda$0$6, 1, null);
                    $this$indent.line("}");
                    break;
                }
                $this$indent.line("if (statement.step()) {");
                IndentedCodeBuilder.indent$default($this$indent, 0, arg_0 -> QueryExecuteEmitter.addSelectExecutionImplementationToBuilder$lambda$0$7($capitalizedNamespace, $className, $readParams, arg_0), 1, null);
                $this$indent.line("} else {");
                IndentedCodeBuilder.indent$default($this$indent, 0, QueryExecuteEmitter::addSelectExecutionImplementationToBuilder$lambda$0$8, 1, null);
                $this$indent.line("}");
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit addSelectExecutionImplementationToBuilder$lambda$0$0(String $capitalizedNamespace, String $className, String $readParams, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("results.add(" + $capitalizedNamespace + "." + $className + ".readStatementResult(" + $readParams + "))");
        return Unit.INSTANCE;
    }

    private static final Unit addSelectExecutionImplementationToBuilder$lambda$0$1(QueryExecuteEmitter this$0, AnnotatedSelectStatement $statement, String $namespace, String $className, String $joinedParams, String $mapAdapterName, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        this$0.collectionMappingBuilder.invoke((Object)$this$indent, (Object)$statement, (Object)$namespace, (Object)$className, (Object)$joinedParams, (Object)$mapAdapterName);
        return Unit.INSTANCE;
    }

    private static final Unit addSelectExecutionImplementationToBuilder$lambda$0$2(IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("results.isEmpty() -> throw IllegalStateException(\"Query returned no results, but exactly one result was expected\")");
        $this$indent.line("results.size > 1 -> throw IllegalStateException(\"Query returned more than one result, but exactly one result was expected\")");
        $this$indent.line("else -> results.first()");
        return Unit.INSTANCE;
    }

    private static final Unit addSelectExecutionImplementationToBuilder$lambda$0$3(String $capitalizedNamespace, String $className, String $readParams, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line($capitalizedNamespace + "." + $className + ".readStatementResult(" + $readParams + ")");
        return Unit.INSTANCE;
    }

    private static final Unit addSelectExecutionImplementationToBuilder$lambda$0$4(IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("throw IllegalStateException(\"Query returned no results, but exactly one result was expected\")");
        return Unit.INSTANCE;
    }

    private static final Unit addSelectExecutionImplementationToBuilder$lambda$0$5(QueryExecuteEmitter this$0, AnnotatedSelectStatement $statement, String $namespace, String $className, String $joinedParams, String $mapAdapterName, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        this$0.collectionMappingBuilder.invoke((Object)$this$indent, (Object)$statement, (Object)$namespace, (Object)$className, (Object)$joinedParams, (Object)$mapAdapterName);
        return Unit.INSTANCE;
    }

    private static final Unit addSelectExecutionImplementationToBuilder$lambda$0$6(IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("results.isEmpty() -> null");
        $this$indent.line("results.size > 1 -> throw IllegalStateException(\"Query returned more than one result, but at most one result was expected\")");
        $this$indent.line("else -> results.first()");
        return Unit.INSTANCE;
    }

    private static final Unit addSelectExecutionImplementationToBuilder$lambda$0$7(String $capitalizedNamespace, String $className, String $readParams, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line($capitalizedNamespace + "." + $className + ".readStatementResult(" + $readParams + ")");
        return Unit.INSTANCE;
    }

    private static final Unit addSelectExecutionImplementationToBuilder$lambda$0$8(IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("null");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteStatementImplementationToBuilder$lambda$0(IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("statement.step()");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteReturningStatementImplementationToBuilder$lambda$0(String $resultTypeString, String $capitalizedNamespace, String $className, String $paramsString, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("val results = mutableListOf<" + $resultTypeString + ">()");
        $this$indent.line("while (statement.step()) {");
        $this$indent.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> QueryExecuteEmitter.addExecuteReturningStatementImplementationToBuilder$lambda$0$0($capitalizedNamespace, $className, $paramsString, arg_0)));
        $this$indent.line("}");
        $this$indent.line("results");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteReturningStatementImplementationToBuilder$lambda$0$0(String $capitalizedNamespace, String $className, String $paramsString, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("results.add(" + $capitalizedNamespace + "." + $className + ".readStatementResult(" + $paramsString + "))");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteReturningStatementImplementationToBuilder$lambda$1(String $capitalizedNamespace, String $className, String $paramsString, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("if (statement.step()) {");
        $this$indent.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> QueryExecuteEmitter.addExecuteReturningStatementImplementationToBuilder$lambda$1$0($capitalizedNamespace, $className, $paramsString, arg_0)));
        $this$indent.line("} else {");
        $this$indent.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)QueryExecuteEmitter::addExecuteReturningStatementImplementationToBuilder$lambda$1$1));
        $this$indent.line("}");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteReturningStatementImplementationToBuilder$lambda$1$0(String $capitalizedNamespace, String $className, String $paramsString, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line($capitalizedNamespace + "." + $className + ".readStatementResult(" + $paramsString + ")");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteReturningStatementImplementationToBuilder$lambda$1$1(IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("throw IllegalStateException(\"Statement with RETURNING returned no results, but exactly one result was expected\")");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteReturningStatementImplementationToBuilder$lambda$2(String $capitalizedNamespace, String $className, String $paramsString, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("if (statement.step()) {");
        $this$indent.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> QueryExecuteEmitter.addExecuteReturningStatementImplementationToBuilder$lambda$2$0($capitalizedNamespace, $className, $paramsString, arg_0)));
        $this$indent.line("} else {");
        $this$indent.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)QueryExecuteEmitter::addExecuteReturningStatementImplementationToBuilder$lambda$2$1));
        $this$indent.line("}");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteReturningStatementImplementationToBuilder$lambda$2$0(String $capitalizedNamespace, String $className, String $paramsString, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line($capitalizedNamespace + "." + $className + ".readStatementResult(" + $paramsString + ")");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteReturningStatementImplementationToBuilder$lambda$2$1(IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("null");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteReturningStatementImplementationToBuilder$lambda$3(String $capitalizedNamespace, String $className, String $paramsString, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("if (statement.step()) {");
        $this$indent.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> QueryExecuteEmitter.addExecuteReturningStatementImplementationToBuilder$lambda$3$0($capitalizedNamespace, $className, $paramsString, arg_0)));
        $this$indent.line("} else {");
        $this$indent.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)QueryExecuteEmitter::addExecuteReturningStatementImplementationToBuilder$lambda$3$1));
        $this$indent.line("}");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteReturningStatementImplementationToBuilder$lambda$3$0(String $capitalizedNamespace, String $className, String $paramsString, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line($capitalizedNamespace + "." + $className + ".readStatementResult(" + $paramsString + ")");
        return Unit.INSTANCE;
    }

    private static final Unit addExecuteReturningStatementImplementationToBuilder$lambda$3$1(IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.line("throw IllegalStateException(\"Statement with RETURNING returned no results\")");
        return Unit.INSTANCE;
    }
}

