/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.sqlinspect;

import dev.goquick.sqlitenow.gradle.SqlFileProcessor;
import dev.goquick.sqlitenow.gradle.StandardErrorHandler;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.CreateTableStatementExecutor;
import dev.goquick.sqlitenow.gradle.sqlinspect.CreateViewStatementExecutor;
import dev.goquick.sqlitenow.gradle.sqlinspect.DeferredStatementExecutor;
import dev.goquick.sqlitenow.gradle.sqlite.SqlSingleStatement;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.CreateView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/goquick/sqlitenow/gradle/sqlinspect/SchemaInspector;", "", "schemaDirectory", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "statementExecutors", "", "Ldev/goquick/sqlitenow/gradle/sqlinspect/DeferredStatementExecutor;", "getStatementExecutors", "()Ljava/util/List;", "sqlStatements", "", "Ldev/goquick/sqlitenow/gradle/sqlite/SqlSingleStatement;", "getSqlStatements", "cachedCreateTableStatements", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateTableStatement;", "cachedCreateViewStatements", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateViewStatement;", "getCreateTableStatements", "conn", "Ljava/sql/Connection;", "getCreateViewStatements", "sortViewsByDependencies", "Ldev/goquick/sqlitenow/gradle/sqlinspect/CreateViewStatementExecutor;", "viewExecutors", "inspect", "", "sqlStatement", "normalizeForParser", "", "sql", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSchemaInspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaInspector.kt\ndev/goquick/sqlitenow/gradle/sqlinspect/SchemaInspector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,214:1\n1863#2,2:215\n808#2,11:217\n1557#2:228\n1628#2,3:229\n808#2,11:232\n1557#2:243\n1628#2,3:244\n1202#2,2:247\n1230#2,4:249\n1863#2,2:254\n1863#2:256\n774#2:257\n865#2,2:258\n1863#2:260\n1864#2:268\n1864#2:269\n1863#2,2:277\n1557#2:279\n1628#2,3:280\n774#2:283\n865#2,2:284\n1611#2,9:286\n1863#2:295\n1864#2:297\n1620#2:298\n1#3:253\n1#3:296\n381#4,7:261\n535#4:270\n520#4,6:271\n*S KotlinDebug\n*F\n+ 1 SchemaInspector.kt\ndev/goquick/sqlitenow/gradle/sqlinspect/SchemaInspector\n*L\n70#1:215,2\n45#1:217,11\n46#1:228\n46#1:229,3\n53#1:232,11\n56#1:243\n56#1:244,3\n78#1:247,2\n78#1:249,4\n83#1:254,2\n85#1:256\n87#1:257\n87#1:258,2\n88#1:260\n88#1:268\n85#1:269\n100#1:277,2\n108#1:279\n108#1:280,3\n108#1:283\n108#1:284,2\n112#1:286,9\n112#1:295\n112#1:297\n112#1:298\n112#1:296\n89#1:261,7\n95#1:270\n95#1:271,6\n*E\n"})
public final class SchemaInspector {
    @NotNull
    private final List<DeferredStatementExecutor> statementExecutors;
    @NotNull
    private final List<SqlSingleStatement> sqlStatements;
    @Nullable
    private List<AnnotatedCreateTableStatement> cachedCreateTableStatements;
    @Nullable
    private List<AnnotatedCreateViewStatement> cachedCreateViewStatements;

    public SchemaInspector(@NotNull File schemaDirectory) {
        Intrinsics.checkNotNullParameter((Object)schemaDirectory, (String)"schemaDirectory");
        this.statementExecutors = new ArrayList();
        SqlFileProcessor.INSTANCE.validateDirectory(schemaDirectory, "Schema", true);
        this.sqlStatements = SqlFileProcessor.INSTANCE.parseAllSqlFilesInDirectory(schemaDirectory);
        if (this.sqlStatements.isEmpty()) {
            throw new IllegalArgumentException("No .sql files found in Schema directory: " + schemaDirectory.getAbsolutePath());
        }
        Iterable $this$forEach$iv = this.sqlStatements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlSingleStatement sqlStatement = (SqlSingleStatement)element$iv;
            boolean bl = false;
            this.inspect(sqlStatement);
        }
    }

    @NotNull
    public final List<DeferredStatementExecutor> getStatementExecutors() {
        return this.statementExecutors;
    }

    @NotNull
    public final List<SqlSingleStatement> getSqlStatements() {
        return this.sqlStatements;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnnotatedCreateTableStatement> getCreateTableStatements(@NotNull Connection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        if (this.cachedCreateTableStatements == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Iterable iterable = this.statementExecutors;
            SchemaInspector schemaInspector = this;
            boolean $i$f$filterIsInstance = false;
            void var4_5 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CreateTableStatementExecutor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CreateTableStatementExecutor createTableStatementExecutor = (CreateTableStatementExecutor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                AnnotatedStatement annotatedStatement = it.execute(conn);
                Intrinsics.checkNotNull((Object)annotatedStatement, (String)"null cannot be cast to non-null type dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement");
                collection.add((AnnotatedCreateTableStatement)annotatedStatement);
            }
            schemaInspector.cachedCreateTableStatements = (List)destination$iv$iv;
        }
        List<AnnotatedCreateTableStatement> list = this.cachedCreateTableStatements;
        Intrinsics.checkNotNull(list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnnotatedCreateViewStatement> getCreateViewStatements(@NotNull Connection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        if (this.cachedCreateViewStatements == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.statementExecutors;
            boolean $i$f$filterIsInstance22 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CreateViewStatementExecutor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List viewExecutors = (List)destination$iv$iv;
            List<CreateViewStatementExecutor> sorted = this.sortViewsByDependencies(viewExecutors);
            Iterable $i$f$filterIsInstance22 = sorted;
            SchemaInspector schemaInspector = this;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CreateViewStatementExecutor createViewStatementExecutor = (CreateViewStatementExecutor)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                AnnotatedStatement annotatedStatement = it.execute(conn);
                Intrinsics.checkNotNull((Object)annotatedStatement, (String)"null cannot be cast to non-null type dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement");
                collection.add((AnnotatedCreateViewStatement)annotatedStatement);
            }
            schemaInspector.cachedCreateViewStatements = (List)destination$iv$iv2;
        }
        List<AnnotatedCreateViewStatement> list = this.cachedCreateViewStatements;
        Intrinsics.checkNotNull(list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CreateViewStatementExecutor> sortViewsByDependencies(List<CreateViewStatementExecutor> viewExecutors) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        Object element$iv;
        Object element$iv22;
        Object object;
        Map $this$associateByTo$iv$iv;
        if (viewExecutors.size() <= 1) {
            return viewExecutors;
        }
        Iterable $this$associateBy$iv = viewExecutors;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Iterator it;
            Object element$iv$iv = iterator.next();
            CreateViewStatementExecutor createViewStatementExecutor = (CreateViewStatementExecutor)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(((CreateViewStatementExecutor)((Object)it)).viewName(), element$iv$iv);
        }
        Map nameToExec = destination$iv$iv;
        Set viewNames = CollectionsKt.toSet((Iterable)nameToExec.keySet());
        Map adj = new LinkedHashMap();
        Map $this$sortViewsByDependencies_u24lambda_u241 = $this$associateByTo$iv$iv = (Map)new LinkedHashMap();
        boolean bl = false;
        Iterable $this$forEach$iv = viewNames;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            String it = (String)element$iv3;
            boolean bl2 = false;
            $this$sortViewsByDependencies_u24lambda_u241.put(it, 0);
        }
        Map indeg = $this$associateByTo$iv$iv;
        Iterable $this$forEach$iv2 = viewExecutors;
        boolean $i$f$forEach2 = false;
        for (Object element$iv22 : $this$forEach$iv2) {
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv2;
            CreateViewStatementExecutor exec = (CreateViewStatementExecutor)element$iv22;
            boolean bl3 = false;
            String v = exec.viewName();
            Iterable $this$filter$iv = exec.referencedTableOrViewNames();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                if (!viewNames.contains(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List deps = (List)destination$iv$iv2;
            Iterable $this$forEach$iv3 = deps;
            boolean $i$f$forEach3 = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv3.iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                Object object2;
                Map $this$getOrPut$iv;
                element$iv = $this$filterTo$iv$iv2.next();
                String dep = (String)element$iv;
                boolean bl5 = false;
                element$iv$iv = adj;
                Object key$iv = dep;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl6 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((List)object2).add(v);
                $this$getOrPut$iv = indeg;
                Integer n = (Integer)indeg.get(v);
                key$iv = (n != null ? n : 0) + 1;
                $this$getOrPut$iv.put(v, key$iv);
            }
        }
        Map $this$filter$iv = indeg;
        boolean $i$f$filter = false;
        element$iv22 = $this$filter$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator v = $this$filterTo$iv$iv.entrySet().iterator();
        while (v.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = v.next();
            boolean bl7 = false;
            if (!(((Number)it.getValue()).intValue() == 0)) continue;
            destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Collection collection = destination$iv$iv3.keySet();
        ArrayDeque queue = new ArrayDeque(collection);
        List orderedNames = new ArrayList();
        while (!((Collection)queue).isEmpty()) {
            String u = (String)queue.removeFirst();
            orderedNames.add(u);
            List list = (List)adj.get(u);
            if (list == null) continue;
            Iterable $this$forEach$iv4 = list;
            boolean $i$f$forEach4 = false;
            for (Map.Entry element$iv4 : $this$forEach$iv4) {
                String w = (String)((Object)element$iv4);
                boolean bl8 = false;
                element$iv = indeg;
                Integer n = (Integer)indeg.get(w);
                Integer dep = (n != null ? n : 0) - 1;
                element$iv.put((String)w, (Integer)dep);
                Integer n2 = (Integer)indeg.get(w);
                if ((n2 != null ? n2 : 0) != 0) continue;
                queue.add((Object)w);
            }
        }
        if (orderedNames.size() < viewExecutors.size()) {
            void $this$filterTo$iv$iv3;
            void $this$filter$iv2;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = viewExecutors;
            boolean $i$f$map = false;
            Iterable $i$f$forEach4 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                element$iv = (CreateViewStatementExecutor)item$iv$iv;
                object = destination$iv$iv4;
                boolean bl9 = false;
                object.add(((CreateViewStatementExecutor)((Object)it)).viewName());
            }
            $this$map$iv = (List)destination$iv$iv4;
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv2;
            destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                it = (String)element$iv$iv;
                boolean bl10 = false;
                if (!(!orderedNames.contains(it))) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List remaining = (List)destination$iv$iv4;
            orderedNames.addAll(remaining);
        }
        Iterable $this$mapNotNull$iv = orderedNames;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$filter2 = $this$mapNotNull$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach5 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            CreateViewStatementExecutor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl11 = false;
            String it = (String)element$iv$iv;
            boolean bl12 = false;
            if ((CreateViewStatementExecutor)nameToExec.get(it) == null) continue;
            boolean bl13 = false;
            destination$iv$iv5.add(it$iv$iv);
        }
        return (List)destination$iv$iv5;
    }

    private final void inspect(SqlSingleStatement sqlStatement) {
        try {
            Statement parsedStatement;
            Statement statement = parsedStatement = CCJSqlParserUtil.parse((String)this.normalizeForParser(sqlStatement.getSql()));
            if (statement instanceof CreateTable) {
                CreateTableStatementExecutor executor = new CreateTableStatementExecutor(sqlStatement, (CreateTable)parsedStatement);
                this.statementExecutors.add(executor);
            } else if (statement instanceof CreateView) {
                CreateViewStatementExecutor executor = new CreateViewStatementExecutor(sqlStatement, (CreateView)parsedStatement);
                this.statementExecutors.add(executor);
            }
        }
        catch (Exception e) {
            StandardErrorHandler.INSTANCE.handleSqlParsingError(sqlStatement.getSql(), e, "SchemaInspector");
            throw new KotlinNothingValueException();
        }
    }

    private final String normalizeForParser(String sql) {
        Regex regex = new Regex("(?is)\\s+WITHOUT\\s+ROWID\\s*;?\\s*$");
        CharSequence charSequence = sql;
        String string = ";";
        return regex.replace(charSequence, string);
    }
}

