/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.generator.query;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import dev.goquick.sqlitenow.gradle.context.AdapterConfig;
import dev.goquick.sqlitenow.gradle.context.AdapterParameterEmitter;
import dev.goquick.sqlitenow.gradle.context.AdapterParameterNameResolver;
import dev.goquick.sqlitenow.gradle.context.ColumnLookup;
import dev.goquick.sqlitenow.gradle.context.GeneratorContext;
import dev.goquick.sqlitenow.gradle.context.TypeMapping;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructCodeGenerator;
import dev.goquick.sqlitenow.gradle.generator.query.CollectionExecuteEmitter;
import dev.goquick.sqlitenow.gradle.generator.query.DynamicFieldInvocation;
import dev.goquick.sqlitenow.gradle.generator.query.GetterCallFactory;
import dev.goquick.sqlitenow.gradle.generator.query.ParameterBinding;
import dev.goquick.sqlitenow.gradle.generator.query.QueryBindEmitter;
import dev.goquick.sqlitenow.gradle.generator.query.QueryExecuteEmitter;
import dev.goquick.sqlitenow.gradle.generator.query.QueryFunctionScaffolder;
import dev.goquick.sqlitenow.gradle.generator.query.QueryReadEmitter;
import dev.goquick.sqlitenow.gradle.generator.query.ResultMappingHelper;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedExecuteStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.processing.PropertyNameGeneratorType;
import dev.goquick.sqlitenow.gradle.processing.ReturningColumnsResolver;
import dev.goquick.sqlitenow.gradle.processing.SelectFieldCodeGenerator;
import dev.goquick.sqlitenow.gradle.processing.StatementProcessor;
import dev.goquick.sqlitenow.gradle.util.IndentedCodeBuilder;
import dev.goquick.sqlitenow.gradle.util.StringUtilsKt;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0006\u0010,\u001a\u00020-J\u0018\u0010.\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010/\u001a\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ldev/goquick/sqlitenow/gradle/generator/query/QueryCodeGenerator;", "", "generatorContext", "Ldev/goquick/sqlitenow/gradle/context/GeneratorContext;", "dataStructCodeGenerator", "Ldev/goquick/sqlitenow/gradle/generator/data/DataStructCodeGenerator;", "debug", "", "<init>", "(Ldev/goquick/sqlitenow/gradle/context/GeneratorContext;Ldev/goquick/sqlitenow/gradle/generator/data/DataStructCodeGenerator;Z)V", "packageName", "", "outputDir", "Ljava/io/File;", "queryNamespaceName", "namespace", "columnLookup", "Ldev/goquick/sqlitenow/gradle/context/ColumnLookup;", "typeMapping", "Ldev/goquick/sqlitenow/gradle/context/TypeMapping;", "parameterBinding", "Ldev/goquick/sqlitenow/gradle/generator/query/ParameterBinding;", "adapterConfig", "Ldev/goquick/sqlitenow/gradle/context/AdapterConfig;", "adapterParameterEmitter", "Ldev/goquick/sqlitenow/gradle/context/AdapterParameterEmitter;", "queryFunctionScaffolder", "Ldev/goquick/sqlitenow/gradle/generator/query/QueryFunctionScaffolder;", "selectFieldGenerator", "Ldev/goquick/sqlitenow/gradle/processing/SelectFieldCodeGenerator;", "adapterNameResolver", "Ldev/goquick/sqlitenow/gradle/context/AdapterParameterNameResolver;", "getterCallFactory", "Ldev/goquick/sqlitenow/gradle/generator/query/GetterCallFactory;", "queryBindEmitter", "Ldev/goquick/sqlitenow/gradle/generator/query/QueryBindEmitter;", "resultMappingHelper", "Ldev/goquick/sqlitenow/gradle/generator/query/ResultMappingHelper;", "collectionExecuteEmitter", "Ldev/goquick/sqlitenow/gradle/generator/query/CollectionExecuteEmitter;", "queryExecuteEmitter", "Ldev/goquick/sqlitenow/gradle/generator/query/QueryExecuteEmitter;", "queryReadEmitter", "Ldev/goquick/sqlitenow/gradle/generator/query/QueryReadEmitter;", "generateCode", "", "emitQueryFile", "statement", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedStatement;", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nQueryCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/generator/query/QueryCodeGenerator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,217:1\n216#2,2:218\n*S KotlinDebug\n*F\n+ 1 QueryCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/generator/query/QueryCodeGenerator\n*L\n111#1:218,2\n*E\n"})
public final class QueryCodeGenerator {
    @NotNull
    private final GeneratorContext generatorContext;
    private final boolean debug;
    @NotNull
    private final String packageName;
    @NotNull
    private final File outputDir;
    @NotNull
    private final ColumnLookup columnLookup;
    @NotNull
    private final TypeMapping typeMapping;
    @NotNull
    private final ParameterBinding parameterBinding;
    @NotNull
    private final AdapterConfig adapterConfig;
    @NotNull
    private final AdapterParameterEmitter adapterParameterEmitter;
    @NotNull
    private final QueryFunctionScaffolder queryFunctionScaffolder;
    @NotNull
    private final SelectFieldCodeGenerator selectFieldGenerator;
    @NotNull
    private final AdapterParameterNameResolver adapterNameResolver;
    @NotNull
    private final GetterCallFactory getterCallFactory;
    @NotNull
    private final QueryBindEmitter queryBindEmitter;
    @NotNull
    private final ResultMappingHelper resultMappingHelper;
    @NotNull
    private final CollectionExecuteEmitter collectionExecuteEmitter;
    @NotNull
    private final QueryExecuteEmitter queryExecuteEmitter;
    @NotNull
    private final QueryReadEmitter queryReadEmitter;

    public QueryCodeGenerator(@NotNull GeneratorContext generatorContext, @NotNull DataStructCodeGenerator dataStructCodeGenerator, boolean debug) {
        Intrinsics.checkNotNullParameter((Object)generatorContext, (String)"generatorContext");
        Intrinsics.checkNotNullParameter((Object)dataStructCodeGenerator, (String)"dataStructCodeGenerator");
        this.generatorContext = generatorContext;
        this.debug = debug;
        this.packageName = this.generatorContext.getPackageName();
        this.outputDir = this.generatorContext.getOutputDir();
        this.columnLookup = this.generatorContext.getColumnLookup();
        this.typeMapping = this.generatorContext.getTypeMapping();
        this.parameterBinding = new ParameterBinding(this.columnLookup, this.typeMapping, dataStructCodeGenerator, this.debug);
        this.adapterConfig = this.generatorContext.getAdapterConfig();
        this.adapterParameterEmitter = new AdapterParameterEmitter(this.generatorContext);
        this.queryFunctionScaffolder = new QueryFunctionScaffolder(this.packageName, (Function1<? super String, String>)((Function1)arg_0 -> QueryCodeGenerator.queryFunctionScaffolder$lambda$0(this, arg_0)), this.adapterParameterEmitter);
        this.selectFieldGenerator = this.generatorContext.getSelectFieldGenerator();
        this.adapterNameResolver = this.generatorContext.getAdapterNameResolver();
        this.getterCallFactory = new GetterCallFactory(this.adapterConfig, this.adapterNameResolver, this.selectFieldGenerator, this.typeMapping);
        this.queryBindEmitter = new QueryBindEmitter(this.parameterBinding, this.queryFunctionScaffolder, this.debug);
        this.resultMappingHelper = new ResultMappingHelper(this.generatorContext, this.selectFieldGenerator, this.adapterConfig);
        this.collectionExecuteEmitter = new CollectionExecuteEmitter(this.resultMappingHelper, this.selectFieldGenerator, (Function1<? super String, String>)((Function1)arg_0 -> QueryCodeGenerator.collectionExecuteEmitter$lambda$0(this, arg_0)));
        this.queryExecuteEmitter = new QueryExecuteEmitter(this.packageName, this.debug, this.queryFunctionScaffolder, this.adapterParameterEmitter, (Function1<? super String, String>)((Function1)arg_0 -> QueryCodeGenerator.queryExecuteEmitter$lambda$0(this, arg_0)), (Function6<? super IndentedCodeBuilder, ? super AnnotatedSelectStatement, ? super String, ? super String, ? super String, ? super String, Unit>)((Function6)new Function6<IndentedCodeBuilder, AnnotatedSelectStatement, String, String, String, String, Unit>((Object)this.collectionExecuteEmitter){

            public final void invoke(IndentedCodeBuilder p0, AnnotatedSelectStatement p1, String p2, String p3, String p4, String p5) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
                ((CollectionExecuteEmitter)this.receiver).emitExecuteAsListImplementation(p0, p1, p2, p3, p4, p5);
            }
        }));
        this.queryReadEmitter = new QueryReadEmitter(this.packageName, (Function1<? super String, String>)((Function1)arg_0 -> QueryCodeGenerator.queryReadEmitter$lambda$0(this, arg_0)), this.queryFunctionScaffolder, this.adapterParameterEmitter, this.adapterConfig, this.selectFieldGenerator, this.typeMapping, this.resultMappingHelper, (Function7<? super AnnotatedSelectStatement, ? super AnnotatedSelectStatement.Field, ? super Integer, ? super PropertyNameGeneratorType, ? super Boolean, ? super Map<String, String>, ? super List<String>, String>)((Function7)new Function7<AnnotatedSelectStatement, AnnotatedSelectStatement.Field, Integer, PropertyNameGeneratorType, Boolean, Map<String, ? extends String>, List<? extends String>, String>((Object)this.getterCallFactory){

            public final String invoke(AnnotatedSelectStatement p0, AnnotatedSelectStatement.Field p1, int p2, PropertyNameGeneratorType p3, boolean p4, Map<String, String> p5, List<String> p6) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                Intrinsics.checkNotNullParameter(p5, (String)"p5");
                Intrinsics.checkNotNullParameter(p6, (String)"p6");
                return ((GetterCallFactory)this.receiver).buildGetterCall(p0, p1, p2, p3, p4, p5, p6);
            }
        }), (Function2<? super DynamicFieldInvocation, ? super String, String>)((Function2)(arg_0, arg_1) -> QueryCodeGenerator.queryReadEmitter$lambda$1(this, arg_0, arg_1)), (Function1<? super AnnotatedExecuteStatement, ? extends List<AnnotatedSelectStatement.Field>>)((Function1)arg_0 -> QueryCodeGenerator.queryReadEmitter$lambda$2(this, arg_0)), (Function1<? super List<AnnotatedSelectStatement.Field>, String>)((Function1)arg_0 -> QueryCodeGenerator.queryReadEmitter$lambda$3(this, arg_0)));
    }

    public /* synthetic */ QueryCodeGenerator(GeneratorContext generatorContext, DataStructCodeGenerator dataStructCodeGenerator, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(generatorContext, dataStructCodeGenerator, bl);
    }

    private final String queryNamespaceName(String namespace) {
        return StringUtilsKt.pascalize(namespace) + "Query";
    }

    public final void generateCode() {
        Map<String, List<AnnotatedStatement>> $this$forEach$iv = this.generatorContext.getNsWithStatements();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<AnnotatedStatement>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<AnnotatedStatement>> element$iv;
            Map.Entry<String, List<AnnotatedStatement>> entry = element$iv = iterator.next();
            boolean bl = false;
            String namespace = entry.getKey();
            List<AnnotatedStatement> statements = entry.getValue();
            StatementProcessor statementProcessor = new StatementProcessor(statements);
            statementProcessor.processStatements((Function1<? super AnnotatedSelectStatement, Unit>)((Function1)arg_0 -> QueryCodeGenerator.generateCode$lambda$0$0(this, namespace, arg_0)), (Function1<? super AnnotatedExecuteStatement, Unit>)((Function1)arg_0 -> QueryCodeGenerator.generateCode$lambda$0$1(this, namespace, arg_0)));
        }
    }

    private final void emitQueryFile(String namespace, AnnotatedStatement statement) {
        String className = statement.getDataClassName();
        String fileName = this.queryNamespaceName(namespace) + "_" + className;
        Object[] objectArray = new String[]{"Suppress"};
        ClassName className2 = new ClassName("kotlin", (String[])objectArray);
        objectArray = new Object[]{"UNNECESSARY_NOT_NULL_ASSERTION"};
        FileSpec.Builder builder = FileSpec.Companion.builder(this.packageName, fileName).addFileComment("Generated query extension functions for " + namespace + "." + className, new Object[0]).addFileComment("\nDO NOT MODIFY THIS FILE MANUALLY!", new Object[0]).addAnnotation(AnnotationSpec.Companion.builder(className2).addMember("%S", objectArray).build());
        objectArray = new String[]{"OptIn"};
        ClassName className3 = new ClassName("kotlin", (String[])objectArray);
        objectArray = new Object[1];
        Object object = new String[]{"ExperimentalUuidApi"};
        objectArray[0] = new ClassName("kotlin.uuid", object);
        FileSpec.Builder builder2 = builder.addAnnotation(AnnotationSpec.Companion.builder(className3).addMember("%T::class", objectArray).build());
        objectArray = new String[]{"encodeToString"};
        FileSpec.Builder builder3 = builder2.addImport("kotlinx.serialization", (String[])objectArray);
        objectArray = new String[]{"Json"};
        FileSpec.Builder builder4 = builder3.addImport("kotlinx.serialization.json", (String[])objectArray);
        objectArray = new String[]{"use"};
        FileSpec.Builder fileBuilder = builder4.addImport("dev.goquick.sqlitenow.core.sqlite", (String[])objectArray);
        if (!this.debug) {
            objectArray = new String[]{"withContext"};
            v6 = fileBuilder.addImport("kotlinx.coroutines", (String[])objectArray);
        } else {
            objectArray = new String[]{"sqliteNowLogger"};
            fileBuilder.addImport("dev.goquick.sqlitenow.common", (String[])objectArray);
            objectArray = new String[]{"sqliteNowPreview"};
            v6 = fileBuilder.addImport("dev.goquick.sqlitenow.core.util", (String[])objectArray);
        }
        FunSpec bindFunction = this.queryBindEmitter.generateBindStatementParamsFunction(namespace, statement);
        fileBuilder.addFunction(bindFunction);
        object = statement;
        if (object instanceof AnnotatedSelectStatement) {
            if (!((AnnotatedSelectStatement)statement).hasCollectionMapping()) {
                fileBuilder.addFunction(this.queryReadEmitter.generateReadStatementResultFunction(namespace, (AnnotatedSelectStatement)statement));
            }
            if (((AnnotatedSelectStatement)statement).hasDynamicFieldMapping()) {
                fileBuilder.addFunction(this.queryReadEmitter.generateReadJoinedStatementResultFunction(namespace, (AnnotatedSelectStatement)statement));
            }
        } else if (object instanceof AnnotatedExecuteStatement) {
            if (((AnnotatedExecuteStatement)statement).hasReturningClause()) {
                fileBuilder.addFunction(this.queryReadEmitter.generateReadStatementResultFunctionForExecute(namespace, (AnnotatedExecuteStatement)statement));
            }
        } else if (!(object instanceof AnnotatedCreateTableStatement) && !(object instanceof AnnotatedCreateViewStatement)) {
            throw new NoWhenBranchMatchedException();
        }
        if ((object = statement) instanceof AnnotatedSelectStatement) {
            fileBuilder.addFunction(this.queryExecuteEmitter.generateSelectQueryFunction(namespace, (AnnotatedSelectStatement)statement, "executeAsList"));
            fileBuilder.addFunction(this.queryExecuteEmitter.generateSelectQueryFunction(namespace, (AnnotatedSelectStatement)statement, "executeAsOne"));
            v7 = fileBuilder.addFunction(this.queryExecuteEmitter.generateSelectQueryFunction(namespace, (AnnotatedSelectStatement)statement, "executeAsOneOrNull"));
        } else if (object instanceof AnnotatedExecuteStatement) {
            if (((AnnotatedExecuteStatement)statement).hasReturningClause()) {
                fileBuilder.addFunction(this.queryExecuteEmitter.generateExecuteQueryFunction(namespace, (AnnotatedExecuteStatement)statement, "executeReturningList"));
                fileBuilder.addFunction(this.queryExecuteEmitter.generateExecuteQueryFunction(namespace, (AnnotatedExecuteStatement)statement, "executeReturningOne"));
                v7 = fileBuilder.addFunction(this.queryExecuteEmitter.generateExecuteQueryFunction(namespace, (AnnotatedExecuteStatement)statement, "executeReturningOneOrNull"));
            } else {
                v7 = fileBuilder.addFunction(this.queryExecuteEmitter.generateExecuteQueryFunction(namespace, (AnnotatedExecuteStatement)statement, "execute"));
            }
        } else {
            if (object instanceof AnnotatedCreateTableStatement || object instanceof AnnotatedCreateViewStatement) {
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        fileBuilder.build().writeTo(this.outputDir);
    }

    private static final String queryFunctionScaffolder$lambda$0(QueryCodeGenerator this$0, String namespaceValue) {
        Intrinsics.checkNotNullParameter((Object)namespaceValue, (String)"namespaceValue");
        return this$0.queryNamespaceName(namespaceValue);
    }

    private static final String collectionExecuteEmitter$lambda$0(QueryCodeGenerator this$0, String namespaceValue) {
        Intrinsics.checkNotNullParameter((Object)namespaceValue, (String)"namespaceValue");
        return this$0.queryNamespaceName(namespaceValue);
    }

    private static final String queryExecuteEmitter$lambda$0(QueryCodeGenerator this$0, String namespaceValue) {
        Intrinsics.checkNotNullParameter((Object)namespaceValue, (String)"namespaceValue");
        return this$0.queryNamespaceName(namespaceValue);
    }

    private static final String queryReadEmitter$lambda$0(QueryCodeGenerator this$0, String namespaceValue) {
        Intrinsics.checkNotNullParameter((Object)namespaceValue, (String)"namespaceValue");
        return this$0.queryNamespaceName(namespaceValue);
    }

    private static final String queryReadEmitter$lambda$1(QueryCodeGenerator this$0, DynamicFieldInvocation request, String rowsVar) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this$0.resultMappingHelper.generateDynamicFieldMappingCodeFromJoined(request, rowsVar);
    }

    private static final List queryReadEmitter$lambda$2(QueryCodeGenerator this$0, AnnotatedExecuteStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        return ReturningColumnsResolver.INSTANCE.createSelectLikeFields(this$0.generatorContext, statement);
    }

    private static final String queryReadEmitter$lambda$3(QueryCodeGenerator this$0, List fields) {
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        return this$0.generatorContext.findMainTableAlias(fields);
    }

    private static final Unit generateCode$lambda$0$0(QueryCodeGenerator this$0, String $namespace, AnnotatedSelectStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this$0.emitQueryFile($namespace, statement);
        return Unit.INSTANCE;
    }

    private static final Unit generateCode$lambda$0$1(QueryCodeGenerator this$0, String $namespace, AnnotatedExecuteStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this$0.emitQueryFile($namespace, statement);
        return Unit.INSTANCE;
    }
}

