/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.sqlinspect;

import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.CreateTableStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.DeferredStatementExecutor;
import dev.goquick.sqlitenow.gradle.sqlite.SqlSingleStatement;
import java.sql.Connection;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/goquick/sqlitenow/gradle/sqlinspect/CreateTableStatementExecutor;", "Ldev/goquick/sqlitenow/gradle/sqlinspect/DeferredStatementExecutor;", "sqlStatement", "Ldev/goquick/sqlitenow/gradle/sqlite/SqlSingleStatement;", "createTable", "Lnet/sf/jsqlparser/statement/create/table/CreateTable;", "<init>", "(Ldev/goquick/sqlitenow/gradle/sqlite/SqlSingleStatement;Lnet/sf/jsqlparser/statement/create/table/CreateTable;)V", "execute", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedStatement;", "conn", "Ljava/sql/Connection;", "reportContext", "", "sqlitenow-gradle-plugin"})
public final class CreateTableStatementExecutor
implements DeferredStatementExecutor {
    @NotNull
    private final SqlSingleStatement sqlStatement;
    @NotNull
    private final CreateTable createTable;

    public CreateTableStatementExecutor(@NotNull SqlSingleStatement sqlStatement, @NotNull CreateTable createTable) {
        Intrinsics.checkNotNullParameter((Object)sqlStatement, (String)"sqlStatement");
        Intrinsics.checkNotNullParameter((Object)createTable, (String)"createTable");
        this.sqlStatement = sqlStatement;
        this.createTable = createTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public AnnotatedStatement execute(@NotNull Connection conn) {
        AnnotatedCreateTableStatement annotatedCreateTableStatement;
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        AutoCloseable autoCloseable = conn.createStatement();
        Throwable throwable = null;
        try {
            Statement stmt = (Statement)autoCloseable;
            boolean bl = false;
            CreateTableStatement createTableStmt = CreateTableStatement.Companion.parse(this.sqlStatement.getSql(), this.createTable);
            AnnotatedCreateTableStatement annotatedCreateTableStatement2 = AnnotatedCreateTableStatement.Companion.parse(createTableStmt.getTableName(), createTableStmt, this.sqlStatement.getTopComments(), this.sqlStatement.getInnerComments());
            stmt.executeUpdate(annotatedCreateTableStatement2.getSrc().getSql());
            annotatedCreateTableStatement = annotatedCreateTableStatement2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return annotatedCreateTableStatement;
    }

    @Override
    @NotNull
    public String reportContext() {
        return this.sqlStatement.getSql();
    }
}

