/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.processing;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import dev.goquick.sqlitenow.gradle.LoggerKt;
import dev.goquick.sqlitenow.gradle.util.SqliteTypeToKotlinCodeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0002\u001a\"\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0002\u001a$\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\n2\u0006\u0010\r\u001a\u00020\u0002H\u0002\u001a\u001e\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\r\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002\u001a.\u0010\u0011\u001a\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u001a\u0012\u0010\u0012\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0002\u001a\f\u0010\u001a\u001a\u00020\u0002*\u00020\u0002H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"ALLOWED_FIELD_KEYS", "", "", "validateFieldAnnotationKeys", "", "annotations", "", "", "extractAnnotations", "comments", "", "cleanedUpComments", "iterateBlockAnnotations", "content", "parseHoconAnnotations", "normalizeAnnotationValue", "value", "extractFieldAssociatedAnnotations", "validateAdapterValue", "adapterValue", "shouldGenerateCustomAdapter", "", "propertyType", "parseNotNullValue", "isCustomType", "extractBaseTypeName", "stripSqliteDisambiguatorSuffix", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAnnotations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Annotations.kt\ndev/goquick/sqlitenow/gradle/processing/AnnotationsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,605:1\n774#2:606\n865#2,2:607\n774#2:609\n865#2,2:610\n1863#2,2:612\n1187#2,2:618\n1261#2,4:620\n1557#2:624\n1628#2,3:625\n1863#2,2:628\n126#3:614\n153#3,3:615\n1069#4,2:630\n*S KotlinDebug\n*F\n+ 1 Annotations.kt\ndev/goquick/sqlitenow/gradle/processing/AnnotationsKt\n*L\n92#1:606\n92#1:607,2\n95#1:609\n95#1:610,2\n110#1:612,2\n192#1:618,2\n192#1:620,4\n198#1:624\n198#1:625,3\n221#1:628,2\n173#1:614\n173#1:615,3\n464#1:630,2\n*E\n"})
public final class AnnotationsKt {
    @NotNull
    private static final Set<String> ALLOWED_FIELD_KEYS;

    /*
     * WARNING - void declaration
     */
    private static final void validateFieldAnnotationKeys(Map<String, ? extends Object> annotations) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = annotations.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!ALLOWED_FIELD_KEYS.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unknownKeys = (List)destination$iv$iv;
        if (!((Collection)unknownKeys).isEmpty()) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = ALLOWED_FIELD_KEYS;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)"_isDynamicField"))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            String supported = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalArgumentException("Unsupported field annotation(s) " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)unknownKeys), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ". Supported keys: " + supported);
        }
    }

    @NotNull
    public static final Map<String, Object> extractAnnotations(@NotNull List<String> comments) {
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        String combinedComment = AnnotationsKt.cleanedUpComments(comments);
        Map allAnnotations = new LinkedHashMap();
        List<Map<String, Object>> annotationBlocks = AnnotationsKt.iterateBlockAnnotations(combinedComment);
        Iterable $this$forEach$iv = annotationBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map blockAnnotations = (Map)element$iv;
            boolean bl = false;
            allAnnotations.putAll(blockAnnotations);
        }
        return allAnnotations;
    }

    private static final String cleanedUpComments(List<String> comments) {
        String cleanedComments = CollectionsKt.joinToString$default((Iterable)comments, (CharSequence)" ", null, null, (int)0, null, AnnotationsKt::cleanedUpComments$lambda$0, (int)30, null);
        return cleanedComments;
    }

    private static final List<Map<String, Object>> iterateBlockAnnotations(String content) {
        int startIndex;
        int searchStart = 0;
        List allAnnotations = new ArrayList();
        while ((startIndex = StringsKt.indexOf$default((CharSequence)content, (String)"@@{", (int)searchStart, (boolean)false, (int)4, null)) != -1) {
            int depth = 1;
            int endIndex = -1;
            for (int currentIndex = startIndex + 3; currentIndex < content.length() && depth > 0; ++currentIndex) {
                switch (content.charAt(currentIndex)) {
                    case '{': {
                        ++depth;
                        break;
                    }
                    case '}': {
                        --depth;
                    }
                }
                if (depth != 0) continue;
                endIndex = currentIndex;
                break;
            }
            if (endIndex == -1) break;
            String string = content.substring(startIndex + 3, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String hoconContent = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Map<String, Object> blockAnnotations = AnnotationsKt.parseHoconAnnotations(hoconContent);
            allAnnotations.add(blockAnnotations);
            searchStart = endIndex + 1;
        }
        return allAnnotations;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Object> parseHoconAnnotations(String content) {
        Map map;
        try {
            void $this$mapTo$iv$iv;
            Map root;
            String hoconText = "{ " + content + " }";
            Config config = ConfigFactory.parseString((String)hoconText, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false));
            Map map2 = config.root().unwrapped();
            Intrinsics.checkNotNull((Object)map2, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map $this$map$iv = root = map2;
            boolean $i$f$map = false;
            Map map3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                String keyString;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object key = entry.getKey();
                Object value = entry.getValue();
                if ((key instanceof String ? (String)key : null) == null) {
                    throw new IllegalArgumentException("Annotation keys must be strings. Found key: " + key);
                }
                keyString = keyString;
                collection.add(TuplesKt.to((Object)keyString, (Object)AnnotationsKt.normalizeAnnotationValue(value)));
            }
            map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
        catch (Exception e) {
            LoggerKt.getLogger().error(StringsKt.trimMargin$default((String)("|\n            |Failed to parse HOCON annotations\n            |---------------------------------\n            |" + content + "\n            |---------------------------------\n            "), null, (int)1, null));
            throw e;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object normalizeAnnotationValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Map) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ((Map)value).entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                String keyString;
                Map map = destination$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Object k = entry.getKey();
                Object v = entry.getValue();
                if ((k instanceof String ? (String)k : null) == null) {
                    throw new IllegalArgumentException("Annotation map keys must be strings. Found key: " + k);
                }
                keyString = keyString;
                entry = TuplesKt.to((Object)keyString, (Object)AnnotationsKt.normalizeAnnotationValue(v));
                map.put(entry.getFirst(), entry.getSecond());
            }
            object = destination$iv$iv;
        } else if (object2 instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)value;
            boolean $i$f$map = false;
            Iterable capacity$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object element$iv$iv = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(AnnotationsKt.normalizeAnnotationValue(it));
            }
            object = (List)destination$iv$iv;
        } else {
            object = object2 instanceof String || object2 instanceof Boolean ? value : (object2 == null ? null : value.toString());
        }
        return object;
    }

    @NotNull
    public static final Map<String, Map<String, Object>> extractFieldAssociatedAnnotations(@NotNull List<String> comments) {
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        String combinedComment = AnnotationsKt.cleanedUpComments(comments);
        List<Map<String, Object>> annotationBlocks = AnnotationsKt.iterateBlockAnnotations(combinedComment);
        Map result = new LinkedHashMap();
        Iterable $this$forEach$iv = annotationBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String adapterValue;
            String propertyType;
            Object v;
            String string;
            Map blockAnnotations = (Map)element$iv;
            boolean bl = false;
            Object v2 = blockAnnotations.get("field");
            String fieldName = v2 instanceof String ? (String)v2 : null;
            Object v3 = blockAnnotations.get("dynamicField");
            String dynamicFieldName = v3 instanceof String ? (String)v3 : null;
            if (fieldName != null && !StringsKt.isBlank((CharSequence)fieldName) && dynamicFieldName != null && !StringsKt.isBlank((CharSequence)dynamicFieldName)) {
                throw new IllegalArgumentException("Annotation block cannot contain both 'field' and 'dynamicField' annotations");
            }
            if (fieldName != null && !StringsKt.isBlank((CharSequence)fieldName)) {
                string = fieldName;
            } else if (dynamicFieldName != null && !StringsKt.isBlank((CharSequence)dynamicFieldName)) {
                string = dynamicFieldName;
            } else {
                throw new IllegalArgumentException("Annotation block must contain either a 'field' or 'dynamicField' annotation with a non-empty value");
            }
            String targetFieldName = string;
            Map fieldAnnotations = MapsKt.toMutableMap((Map)blockAnnotations);
            fieldAnnotations.remove("field");
            fieldAnnotations.remove("dynamicField");
            if (dynamicFieldName != null) {
                v = fieldAnnotations.get("propertyType");
                String string2 = propertyType = v instanceof String ? (String)v : null;
                if (propertyType == null || StringsKt.isBlank((CharSequence)propertyType)) {
                    throw new IllegalArgumentException("dynamicField annotation requires a 'propertyType' annotation with a non-empty value");
                }
                fieldAnnotations.put("_isDynamicField", true);
            }
            propertyType = (v = fieldAnnotations.get("propertyType")) instanceof String ? (String)v : null;
            Object v4 = fieldAnnotations.get("adapter");
            String string3 = adapterValue = v4 instanceof String ? (String)v4 : null;
            if (fieldAnnotations.containsKey("adapter")) {
                AnnotationsKt.validateAdapterValue(adapterValue);
            }
            if (AnnotationsKt.shouldGenerateCustomAdapter(adapterValue, propertyType)) {
                fieldAnnotations.put("adapter", "custom");
            } else {
                fieldAnnotations.remove("adapter");
            }
            result.put(targetFieldName, fieldAnnotations);
        }
        return result;
    }

    private static final void validateAdapterValue(String adapterValue) {
        if (!Intrinsics.areEqual((Object)adapterValue, (Object)"custom") && !Intrinsics.areEqual((Object)adapterValue, (Object)"default")) {
            throw new IllegalArgumentException("Adapter annotation can be adapter=\"default\" or adapter=\"custom\" only");
        }
    }

    private static final boolean shouldGenerateCustomAdapter(String adapterValue, String propertyType) {
        boolean bl;
        String string = adapterValue;
        if (Intrinsics.areEqual((Object)string, (Object)"custom")) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)string, (Object)"default")) {
            bl = propertyType != null && AnnotationsKt.isCustomType(propertyType);
        } else if (string == null) {
            bl = propertyType != null && AnnotationsKt.isCustomType(propertyType);
        } else {
            throw new IllegalArgumentException("Unexpected adapter value: \"" + adapterValue + "\"");
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean parseNotNullValue(@Nullable Object value) {
        Class<?> clazz = value;
        if (!(clazz instanceof Boolean)) {
            Class<?> clazz2 = value;
            if (!(clazz instanceof String)) throw new IllegalArgumentException("Invalid notNull value type: " + (clazz2 != null && (clazz2 = clazz2.getClass()) != null ? clazz2.getSimpleName() : null) + ". Must be boolean");
            String string = ((String)((Object)value)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = string;
            if (Intrinsics.areEqual((Object)string2, (Object)"true")) {
                return true;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)"false")) throw new IllegalArgumentException("Invalid notNull value: \"" + value + "\". Must be true or false");
            return false;
        }
        boolean bl = (Boolean)((Object)value);
        return bl;
    }

    private static final boolean isCustomType(String propertyType) {
        String baseType = AnnotationsKt.extractBaseTypeName(propertyType);
        return !SqliteTypeToKotlinCodeConverter.Companion.getKOTLIN_STDLIB_TYPES().contains(baseType);
    }

    private static final String extractBaseTypeName(String propertyType) {
        String withoutNullability = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)propertyType, (CharSequence)"?"))).toString();
        String withoutGenerics = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)withoutNullability, (char)'<', null, (int)2, null))).toString();
        return StringsKt.substringAfterLast$default((String)withoutGenerics, (char)'.', null, (int)2, null);
    }

    private static final String stripSqliteDisambiguatorSuffix(String $this$stripSqliteDisambiguatorSuffix) {
        int colonIndex = StringsKt.lastIndexOf$default((CharSequence)$this$stripSqliteDisambiguatorSuffix, (char)':', (int)0, (boolean)false, (int)6, null);
        if (colonIndex > 0) {
            String string = $this$stripSqliteDisambiguatorSuffix.substring(colonIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String suffix = string;
            if (((CharSequence)suffix).length() > 0) {
                boolean bl;
                block4: {
                    CharSequence $this$all$iv = suffix;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv;
                        char p0 = element$iv = $this$all$iv.charAt(i);
                        boolean bl2 = false;
                        if (Character.isDigit(p0)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
                if (bl) {
                    String string2 = $this$stripSqliteDisambiguatorSuffix.substring(0, colonIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    return string2;
                }
            }
        }
        return $this$stripSqliteDisambiguatorSuffix;
    }

    private static final CharSequence cleanedUpComments$lambda$0(String comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        CharSequence charSequence = comment;
        Regex regex = new Regex("^\\s*--\\s*");
        String string = "";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("/\\*|\\*/");
        string = "";
        return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString();
    }

    public static final /* synthetic */ void access$validateFieldAnnotationKeys(Map annotations) {
        AnnotationsKt.validateFieldAnnotationKeys(annotations);
    }

    public static final /* synthetic */ void access$validateAdapterValue(String adapterValue) {
        AnnotationsKt.validateAdapterValue(adapterValue);
    }

    public static final /* synthetic */ boolean access$shouldGenerateCustomAdapter(String adapterValue, String propertyType) {
        return AnnotationsKt.shouldGenerateCustomAdapter(adapterValue, propertyType);
    }

    public static final /* synthetic */ String access$stripSqliteDisambiguatorSuffix(String $receiver) {
        return AnnotationsKt.stripSqliteDisambiguatorSuffix($receiver);
    }

    static {
        Object[] objectArray = new String[]{"propertyName", "propertyType", "notNull", "adapter", "defaultValue", "aliasPrefix", "mappingType", "sourceTable", "collectionKey", "sqlTypeHint", "_isDynamicField"};
        ALLOWED_FIELD_KEYS = SetsKt.setOf((Object[])objectArray);
    }
}

