/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.database;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import dev.goquick.sqlitenow.gradle.context.AdapterConfig;
import dev.goquick.sqlitenow.gradle.context.AdapterParameterNameResolver;
import dev.goquick.sqlitenow.gradle.context.ColumnLookup;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedExecuteStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.processing.SharedResultManager;
import dev.goquick.sqlitenow.gradle.processing.SharedResultTypeUtils;
import dev.goquick.sqlitenow.gradle.processing.StatementAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.processing.StatementUtils;
import dev.goquick.sqlitenow.gradle.util.CaseInsensitiveMap;
import dev.goquick.sqlitenow.gradle.util.CaseInsensitiveSet;
import dev.goquick.sqlitenow.gradle.util.IndentedCodeBuilder;
import dev.goquick.sqlitenow.gradle.util.SqliteTypeToKotlinCodeConverter;
import dev.goquick.sqlitenow.gradle.util.StringUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0001fB_\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020$H\u0002J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0002J.\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0010\u00100\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0010\u00101\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\u001a\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020$0\u00052\f\u00104\u001a\b\u0012\u0004\u0012\u00020$0\u0005H\u0002J\u0010\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u001fH\u0002J:\u00107\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u001f2\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J8\u0010:\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020$\u0018\u00010;2\u0006\u00108\u001a\u00020\u00042\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J\u0006\u0010<\u001a\u00020=J\b\u0010>\u001a\u00020?H\u0002J\"\u0010@\u001a\u00020A2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J\u001e\u0010C\u001a\u00020=2\u0006\u0010D\u001a\u00020E2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00040GH\u0002J\u0010\u0010H\u001a\u00020=2\u0006\u0010D\u001a\u00020EH\u0002J*\u0010I\u001a\u00020=2\u0006\u0010D\u001a\u00020E2\u0018\u0010B\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J>\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040;2\u0006\u0010K\u001a\u00020L2\u0006\u0010&\u001a\u00020\u00042\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002JF\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00040\u00052\u0006\u0010N\u001a\u00020\u00102\f\u0010O\u001a\b\u0012\u0004\u0012\u00020L0\u00052\u0006\u0010&\u001a\u00020\u00042\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020L0\u00052\u0006\u0010Q\u001a\u00020RH\u0002J\u0012\u0010S\u001a\u0004\u0018\u00010\u00042\u0006\u0010T\u001a\u00020\bH\u0002J\u001e\u0010U\u001a\u00020?2\u0006\u0010&\u001a\u00020\u00042\f\u00104\u001a\b\u0012\u0004\u0012\u00020$0\u0005H\u0002J8\u0010V\u001a\u00020?2\u0006\u0010&\u001a\u00020\u00042\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J2\u0010X\u001a\u00020Y2\u0006\u0010Q\u001a\u00020Z2\u0006\u0010&\u001a\u00020\u00042\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002JB\u0010[\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020Z2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00102\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J2\u0010]\u001a\u00020Y2\u0006\u0010Q\u001a\u00020R2\u0006\u0010&\u001a\u00020\u00042\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J:\u0010^\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020R2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020\u00042\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J2\u0010_\u001a\u00020A2\u0006\u0010Q\u001a\u00020R2\u0006\u0010&\u001a\u00020\u00042\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J2\u0010`\u001a\u00020Y2\u0006\u0010Q\u001a\u00020R2\u0006\u0010&\u001a\u00020\u00042\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J:\u0010a\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020R2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020\u00042\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J8\u0010b\u001a\b\u0012\u0004\u0012\u00020A0\u00052\u0006\u0010Q\u001a\u00020R2\u0006\u0010&\u001a\u00020\u00042\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050\u0003H\u0002J\u0018\u0010c\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020ZH\u0002J\u0012\u0010d\u001a\u0004\u0018\u00010\u001f2\u0006\u0010Q\u001a\u00020ZH\u0002J\u0018\u0010e\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020ZH\u0002R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Ldev/goquick/sqlitenow/gradle/database/DatabaseCodeGenerator;", "", "nsWithStatements", "", "", "", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedStatement;", "createTableStatements", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateTableStatement;", "createViewStatements", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateViewStatement;", "packageName", "outputDir", "Ljava/io/File;", "databaseClassName", "debug", "", "<init>", "(Ljava/util/Map;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Z)V", "columnLookup", "Ldev/goquick/sqlitenow/gradle/context/ColumnLookup;", "adapterConfig", "Ldev/goquick/sqlitenow/gradle/context/AdapterConfig;", "tableLookup", "Ldev/goquick/sqlitenow/gradle/util/CaseInsensitiveMap;", "sharedResultManager", "Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager;", "adapterNameResolver", "Ldev/goquick/sqlitenow/gradle/context/AdapterParameterNameResolver;", "isCustomType", "t", "Lcom/squareup/kotlinpoet/TypeName;", "normalizedTypeString", "adapterScore", "", "u", "Ldev/goquick/sqlitenow/gradle/database/DatabaseCodeGenerator$UniqueAdapter;", "providerPreferenceScore", "namespace", "adapter", "baseFunctionKey", "name", "computeBestProviders", "adaptersByNamespace", "baseNameForNamespace", "adapterClassNameFor", "adapterPropertyNameFor", "queryNamespaceName", "routerClassNameFor", "routerPropertyNameFor", "collectAdaptersByNamespace", "deduplicateAdaptersForNamespace", "adapters", "sanitizeTypeLabel", "type", "findAdapterName", "expectedFunctionName", "expectedInputType", "findBestProviderByName", "Lkotlin/Pair;", "generateDatabaseClass", "", "generateMainDatabaseClass", "Lcom/squareup/kotlinpoet/TypeSpec;", "buildConstructorWithAdapters", "Lcom/squareup/kotlinpoet/FunSpec;", "namespacesWithAdapters", "addAdapterPrivateProperties", "classBuilder", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "namespaces", "", "addRouterProperties", "generateAdapterWrapperClasses", "resolveAdapterProvider", "config", "Ldev/goquick/sqlitenow/gradle/context/AdapterConfig$ParamConfig;", "buildCommonParamsLines", "hasParams", "statementAdapters", "collectOutputAdaptersForExecuteReturning", "statement", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedExecuteStatement;", "findPrimaryKeyColumn", "table", "generateAdapterClass", "generateRouterClass", "statements", "generateSelectRunnersProperty", "Lcom/squareup/kotlinpoet/PropertySpec;", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedSelectStatement;", "generateSelectRunnersObjectExpression", "className", "generateExecuteStatementProperty", "buildExecuteStatementInitializer", "generateExecuteFunctionWithoutParams", "generateExecuteReturningStatementProperty", "buildExecuteReturningInitializer", "generateExecuteReturningFunctionsWithoutParams", "resolvePublicResultType", "resolveMapToType", "resolvePublicResultTypeString", "UniqueAdapter", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDatabaseCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/database/DatabaseCodeGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1249:1\n1563#2:1250\n1634#2,3:1251\n1056#2:1255\n1869#2,2:1256\n1252#2,4:1261\n808#2,11:1266\n1869#2,2:1277\n1869#2:1279\n1869#2,2:1280\n1870#2:1282\n1491#2:1284\n1516#2,3:1285\n1519#2,3:1295\n1669#2,8:1299\n1999#2,14:1307\n774#2:1322\n865#2,2:1323\n1869#2,2:1325\n774#2:1329\n865#2,2:1330\n1869#2,2:1332\n1252#2,2:1337\n774#2:1339\n865#2,2:1340\n1255#2:1342\n774#2:1352\n865#2,2:1353\n1563#2:1355\n1634#2,3:1356\n1869#2,2:1359\n1869#2,2:1361\n1869#2,2:1363\n1869#2,2:1367\n774#2:1369\n865#2,2:1370\n1869#2,2:1372\n774#2:1374\n865#2,2:1375\n1869#2,2:1377\n1869#2:1379\n1869#2,2:1380\n1870#2:1382\n1878#2,3:1383\n1878#2,3:1386\n1878#2,3:1389\n1878#2,3:1392\n1878#2,3:1395\n1878#2,3:1398\n1878#2,3:1401\n1878#2,3:1404\n1878#2,3:1407\n1878#2,3:1410\n216#3:1254\n217#3:1258\n216#3:1265\n217#3:1283\n216#3:1298\n217#3:1327\n216#3:1328\n217#3:1334\n216#3,2:1350\n216#3,2:1365\n463#4:1259\n413#4:1260\n382#4,7:1288\n463#4:1335\n413#4:1336\n504#4,7:1343\n1#5:1321\n*S KotlinDebug\n*F\n+ 1 DatabaseCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/database/DatabaseCodeGenerator\n*L\n68#1:1250\n68#1:1251,3\n101#1:1255\n101#1:1256,2\n123#1:1261,4\n178#1:1266,11\n178#1:1277,2\n182#1:1279\n193#1:1280,2\n182#1:1282\n215#1:1284\n215#1:1285,3\n215#1:1295,3\n220#1:1299,8\n222#1:1307,14\n224#1:1322\n224#1:1323,2\n230#1:1325,2\n294#1:1329\n294#1:1330,2\n298#1:1332,2\n365#1:1337,2\n366#1:1339\n366#1:1340,2\n365#1:1342\n399#1:1352\n399#1:1353,2\n403#1:1355\n403#1:1356,3\n543#1:1359,2\n555#1:1361,2\n568#1:1363,2\n618#1:1367,2\n650#1:1369\n650#1:1370,2\n657#1:1372,2\n704#1:1374\n704#1:1375,2\n721#1:1377,2\n760#1:1379\n789#1:1380,2\n760#1:1382\n931#1:1383,3\n895#1:1386,3\n905#1:1389,3\n915#1:1392,3\n998#1:1395,3\n1035#1:1398,3\n1107#1:1401,3\n1125#1:1404,3\n1143#1:1407,3\n1189#1:1410,3\n99#1:1254\n99#1:1258\n173#1:1265\n173#1:1283\n218#1:1298\n218#1:1327\n293#1:1328\n293#1:1334\n392#1:1350,2\n583#1:1365,2\n123#1:1259\n123#1:1260\n215#1:1288,7\n365#1:1335\n365#1:1336\n372#1:1343,7\n*E\n"})
public final class DatabaseCodeGenerator {
    @NotNull
    private final Map<String, List<AnnotatedStatement>> nsWithStatements;
    @NotNull
    private final List<AnnotatedCreateTableStatement> createTableStatements;
    @NotNull
    private final String packageName;
    @NotNull
    private final File outputDir;
    @NotNull
    private final String databaseClassName;
    private final boolean debug;
    @NotNull
    private final ColumnLookup columnLookup;
    @NotNull
    private final AdapterConfig adapterConfig;
    @NotNull
    private final CaseInsensitiveMap<AnnotatedCreateTableStatement> tableLookup;
    @NotNull
    private final SharedResultManager sharedResultManager;
    @NotNull
    private final AdapterParameterNameResolver adapterNameResolver;

    /*
     * WARNING - void declaration
     */
    public DatabaseCodeGenerator(@NotNull Map<String, ? extends List<? extends AnnotatedStatement>> nsWithStatements, @NotNull List<AnnotatedCreateTableStatement> createTableStatements, @NotNull List<AnnotatedCreateViewStatement> createViewStatements, @NotNull String packageName, @NotNull File outputDir, @NotNull String databaseClassName, boolean debug) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(nsWithStatements, (String)"nsWithStatements");
        Intrinsics.checkNotNullParameter(createTableStatements, (String)"createTableStatements");
        Intrinsics.checkNotNullParameter(createViewStatements, (String)"createViewStatements");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)databaseClassName, (String)"databaseClassName");
        this.nsWithStatements = nsWithStatements;
        this.createTableStatements = createTableStatements;
        this.packageName = packageName;
        this.outputDir = outputDir;
        this.databaseClassName = databaseClassName;
        this.debug = debug;
        this.columnLookup = new ColumnLookup(this.createTableStatements, createViewStatements);
        this.adapterConfig = new AdapterConfig(this.columnLookup, this.createTableStatements, this.packageName);
        Iterable iterable = this.createTableStatements;
        DatabaseCodeGenerator databaseCodeGenerator = this;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AnnotatedCreateTableStatement annotatedCreateTableStatement = (AnnotatedCreateTableStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getSrc().getTableName(), (Object)it));
        }
        Iterable iterable2 = (List)destination$iv$iv;
        databaseCodeGenerator.tableLookup = new CaseInsensitiveMap(iterable2);
        this.sharedResultManager = new SharedResultManager();
        this.adapterNameResolver = new AdapterParameterNameResolver();
    }

    public /* synthetic */ DatabaseCodeGenerator(Map map, List list, List list2, String string, File file, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            bl = false;
        }
        this(map, list, list2, string, file, string2, bl);
    }

    private final boolean isCustomType(TypeName t) {
        String s = t.toString();
        return !StringsKt.startsWith$default((String)s, (String)"kotlin.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)s, (String)"kotlinx.", (boolean)false, (int)2, null);
    }

    private final String normalizedTypeString(TypeName t) {
        return StringsKt.removeSuffix((String)t.toString(), (CharSequence)"?");
    }

    private final int adapterScore(UniqueAdapter u) {
        int customScore = this.isCustomType(u.getOutputType()) ? 2 : 0;
        int nnInput = !u.getInputType().isNullable() ? 1 : 0;
        int nonIdentity = !Intrinsics.areEqual((Object)this.normalizedTypeString(u.getInputType()), (Object)this.normalizedTypeString(u.getOutputType())) ? 1 : 0;
        return customScore + nnInput + nonIdentity;
    }

    private final int providerPreferenceScore(String namespace, UniqueAdapter adapter) {
        String string = adapter.getProviderNamespace();
        return (string != null ? StringsKt.equals((String)string, (String)namespace, (boolean)true) : false) ? 1 : 0;
    }

    private final String baseFunctionKey(String name) {
        return StringsKt.substringBefore$default((String)name, (String)"For", null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> computeBestProviders(Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        void $this$mapValuesTo$iv$iv;
        Object ua;
        Map winners = new LinkedHashMap();
        Map $this$forEach$iv = MapsKt.toSortedMap(adaptersByNamespace);
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            void $this$forEach$iv2;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = object.next();
            boolean bl = false;
            String ns = (String)entry.getKey();
            List adapters = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)adapters);
            Iterable $this$sortedBy$iv = adapters;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    UniqueAdapter it = (UniqueAdapter)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getFunctionName());
                    it = (UniqueAdapter)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getFunctionName())));
                }
            });
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ua = (UniqueAdapter)element$iv2;
                boolean bl2 = false;
                String key = this.baseFunctionKey(((UniqueAdapter)ua).getFunctionName());
                Pair current = (Pair)winners.get(key);
                if (current == null) {
                    winners.put(key, TuplesKt.to((Object)ns, (Object)ua));
                    continue;
                }
                int currentPref = this.providerPreferenceScore((String)current.getFirst(), (UniqueAdapter)current.getSecond());
                Intrinsics.checkNotNull((Object)ns);
                int candidatePref = this.providerPreferenceScore(ns, (UniqueAdapter)ua);
                if (candidatePref > currentPref) {
                    winners.put(key, TuplesKt.to((Object)ns, (Object)ua));
                    continue;
                }
                if (candidatePref < currentPref) continue;
                int currentScore = this.adapterScore((UniqueAdapter)current.getSecond());
                int candidateScore = this.adapterScore((UniqueAdapter)ua);
                if (candidateScore <= currentScore && (candidateScore != currentScore || ns.compareTo((String)current.getFirst()) >= 0)) continue;
                winners.put(key, TuplesKt.to((Object)ns, (Object)ua));
            }
        }
        Map $this$mapValues$iv = winners;
        boolean $i$f$mapValues = false;
        object = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry $i$f$forEach2 = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            ua = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            String string = (String)((Pair)it.getValue()).getFirst();
            map2.put(k, string);
        }
        return destination$iv$iv;
    }

    private final String baseNameForNamespace(String namespace) {
        AnnotatedCreateTableStatement table = this.tableLookup.get(namespace);
        Object object = table;
        if (object == null || (object = ((AnnotatedCreateTableStatement)object).getAnnotations()) == null || (object = ((StatementAnnotationOverrides)object).getName()) == null) {
            object = StringUtilsKt.pascalize(namespace);
        }
        return object;
    }

    private final String adapterClassNameFor(String namespace) {
        return this.baseNameForNamespace(namespace) + "Adapters";
    }

    private final String adapterPropertyNameFor(String namespace) {
        String cls = this.adapterClassNameFor(namespace);
        return StringUtilsKt.lowercaseFirst(cls);
    }

    private final String queryNamespaceName(String namespace) {
        return StringUtilsKt.pascalize(namespace) + "Query";
    }

    private final String routerClassNameFor(String namespace) {
        return this.baseNameForNamespace(namespace) + "Router";
    }

    private final String routerPropertyNameFor(String namespace) {
        return StringUtilsKt.lowercaseFirst(this.baseNameForNamespace(namespace));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<UniqueAdapter>> collectAdaptersByNamespace() {
        Map adaptersByNamespace = new LinkedHashMap();
        Map<String, List<AnnotatedStatement>> $this$forEach$iv = this.nsWithStatements;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<AnnotatedStatement>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterable $this$forEach$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            Map.Entry<String, List<AnnotatedStatement>> element$iv;
            Map.Entry<String, List<AnnotatedStatement>> entry = element$iv = iterator.next();
            boolean bl = false;
            String namespace = entry.getKey();
            List<AnnotatedStatement> statements = entry.getValue();
            List namespaceAdapters = new ArrayList();
            Map processedSharedResults = new LinkedHashMap();
            Iterable $this$filterIsInstance$iv = statements;
            boolean $i$f$filterIsInstance = false;
            Iterator iterator2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof AnnotatedSelectStatement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AnnotatedSelectStatement statement = (AnnotatedSelectStatement)element$iv2;
                boolean bl2 = false;
                this.sharedResultManager.registerSharedResult(statement, namespace);
            }
            $this$forEach$iv2 = statements;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                AnnotatedStatement statement = (AnnotatedStatement)element$iv2;
                boolean bl3 = false;
                List statementAdapters = CollectionsKt.toMutableList((Collection)this.adapterConfig.collectAllParamConfigs(statement, namespace));
                if (statement instanceof AnnotatedSelectStatement && ((AnnotatedSelectStatement)statement).getAnnotations().getQueryResult() != null) {
                    boolean alreadyProcessed;
                    String sharedResultKey = namespace + "." + ((AnnotatedSelectStatement)statement).getAnnotations().getQueryResult();
                    Boolean bl4 = (Boolean)processedSharedResults.get(sharedResultKey);
                    boolean bl5 = alreadyProcessed = bl4 != null ? bl4 : false;
                    if (alreadyProcessed) {
                        statementAdapters.removeIf(arg_0 -> DatabaseCodeGenerator.collectAdaptersByNamespace$lambda$0$1$1(DatabaseCodeGenerator::collectAdaptersByNamespace$lambda$0$1$0, arg_0));
                    }
                    boolean mapCollected = ((AnnotatedSelectStatement)statement).getAnnotations().getMapTo() != null;
                    processedSharedResults.put(sharedResultKey, alreadyProcessed || mapCollected);
                }
                Iterable $this$forEach$iv3 = statementAdapters;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    AdapterConfig.ParamConfig config = (AdapterConfig.ParamConfig)element$iv3;
                    boolean bl6 = false;
                    namespaceAdapters.add(new UniqueAdapter(config.getAdapterFunctionName(), config.getInputType(), config.getOutputType(), config.isNullable(), config.getProviderNamespace()));
                }
            }
            List<UniqueAdapter> deduplicatedAdapters = this.deduplicateAdaptersForNamespace(namespaceAdapters);
            adaptersByNamespace.put(namespace, CollectionsKt.toMutableList((Collection)deduplicatedAdapters));
        }
        return adaptersByNamespace;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UniqueAdapter> deduplicateAdaptersForNamespace(List<UniqueAdapter> adapters) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = adapters;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            UniqueAdapter it = (UniqueAdapter)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getFunctionName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map adaptersByName = destination$iv$iv;
        List result = new ArrayList();
        Map $this$forEach$iv = adaptersByName;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            void $this$filterTo$iv$iv;
            int n;
            Object v1;
            Map.Entry entry = element$iv;
            boolean bl = false;
            String baseName = (String)entry.getKey();
            List adapterList = (List)entry.getValue();
            Iterable $this$distinctBy$iv = adapterList;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                UniqueAdapter it = (UniqueAdapter)e$iv;
                boolean bl3 = false;
                String key$iv = it.signatureKey();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            List uniqueBySignature = list$iv;
            Iterable $this$maxByOrNull$iv = uniqueBySignature;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    UniqueAdapter it = (UniqueAdapter)maxElem$iv;
                    boolean bl4 = false;
                    int maxValue$iv = this.adapterScore(it);
                    do {
                        Object e$iv = iterator$iv.next();
                        UniqueAdapter it2 = (UniqueAdapter)e$iv;
                        $i$a$-maxByOrNull-DatabaseCodeGenerator$deduplicateAdaptersForNamespace$1$best$1 = false;
                        int v$iv = this.adapterScore(it2);
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            UniqueAdapter best = v1;
            if (best != null) {
                UniqueAdapter it;
                boolean bl5 = false;
                n = this.adapterScore(it);
            } else {
                n = 0;
            }
            int bestScore = n;
            Iterable $this$filter$iv = uniqueBySignature;
            boolean $i$f$filter = false;
            Iterable bl5 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UniqueAdapter it = (UniqueAdapter)element$iv$iv;
                boolean bl6 = false;
                if (!(this.adapterScore(it) == bestScore)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List top = (List)destination$iv$iv2;
            if (top.size() == 1) {
                result.add(UniqueAdapter.copy$default((UniqueAdapter)CollectionsKt.first((List)top), baseName, null, null, false, null, 30, null));
                continue;
            }
            Iterable $this$forEach$iv2 = top;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                UniqueAdapter adapter = (UniqueAdapter)element$iv2;
                boolean bl7 = false;
                String inputLabel = this.sanitizeTypeLabel(adapter.getInputType());
                String outputLabel = this.sanitizeTypeLabel(adapter.getOutputType());
                String uniqueName = baseName + "For" + inputLabel + "To" + outputLabel;
                result.add(UniqueAdapter.copy$default(adapter, uniqueName, null, null, false, null, 30, null));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final String sanitizeTypeLabel(TypeName type) {
        Object object;
        String s = type.toString();
        Object object2 = new char[]{'.'};
        s = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)s, (char[])object2, (boolean)false, (int)0, (int)6, null));
        s = StringsKt.replace$default((String)s, (String)"?", (String)"Nullable", (boolean)false, (int)4, null);
        object2 = s;
        Regex regex = new Regex("[<>.,\\s]");
        String string = "";
        s = regex.replace((CharSequence)object2, string);
        if (((CharSequence)(object2 = (Object)s)).length() > 0) {
            void it;
            char c = object2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string2 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type java.lang.String");
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
            char[] cArray = object2;
            int n = 1;
            String string4 = cArray.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            object = stringBuilder2.append(string4).toString();
        } else {
            object = object2;
        }
        return object;
    }

    private final String findAdapterName(String namespace, String expectedFunctionName, TypeName expectedInputType, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        UniqueAdapter renamedMatch;
        Object object;
        Object v2;
        block6: {
            Object object2;
            Object object32;
            List<UniqueAdapter> deduplicatedAdapters;
            block5: {
                List<UniqueAdapter> list = adaptersByNamespace.get(namespace);
                if (list == null) {
                    return expectedFunctionName;
                }
                deduplicatedAdapters = list;
                Iterable iterable = deduplicatedAdapters;
                for (Object object32 : iterable) {
                    UniqueAdapter it = (UniqueAdapter)object32;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFunctionName(), (Object)expectedFunctionName)) continue;
                    object2 = object32;
                    break block5;
                }
                object2 = null;
            }
            UniqueAdapter exactMatch = (UniqueAdapter)object2;
            if (exactMatch != null) {
                return exactMatch.getFunctionName();
            }
            Iterable iterable = deduplicatedAdapters;
            object32 = iterable.iterator();
            while (object32.hasNext()) {
                Object e = object32.next();
                UniqueAdapter it = (UniqueAdapter)e;
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it.getFunctionName(), (String)(expectedFunctionName + "For"), (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)it.getInputType(), (Object)expectedInputType))) continue;
                v2 = e;
                break block6;
            }
            v2 = null;
        }
        if ((object = (renamedMatch = (UniqueAdapter)v2)) == null || (object = ((UniqueAdapter)object).getFunctionName()) == null) {
            object = expectedFunctionName;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, UniqueAdapter> findBestProviderByName(String expectedFunctionName, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        Pair best = null;
        Map<String, ? extends List<UniqueAdapter>> $this$forEach$iv = adaptersByNamespace;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<UniqueAdapter>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            Map.Entry<String, ? extends List<UniqueAdapter>> element$iv;
            Map.Entry<String, ? extends List<UniqueAdapter>> entry = element$iv = iterator.next();
            boolean bl = false;
            String ns = entry.getKey();
            List<UniqueAdapter> adapters = entry.getValue();
            Iterable $this$filter$iv = adapters;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UniqueAdapter it = (UniqueAdapter)element$iv$iv;
                boolean bl2 = false;
                boolean bl3 = Intrinsics.areEqual((Object)it.getFunctionName(), (Object)expectedFunctionName) || StringsKt.startsWith$default((String)it.getFunctionName(), (String)(expectedFunctionName + "For"), (boolean)false, (int)2, null);
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                UniqueAdapter cand = (UniqueAdapter)element$iv2;
                boolean bl4 = false;
                Pair cur = best;
                if (cur == null) {
                    best = TuplesKt.to((Object)ns, (Object)cand);
                    continue;
                }
                int currentPref = this.providerPreferenceScore((String)cur.getFirst(), (UniqueAdapter)cur.getSecond());
                int candidatePref = this.providerPreferenceScore(ns, cand);
                if (candidatePref > currentPref) {
                    best = TuplesKt.to((Object)ns, (Object)cand);
                    continue;
                }
                if (candidatePref < currentPref) continue;
                int currentScore = this.adapterScore((UniqueAdapter)cur.getSecond());
                int candidateScore = this.adapterScore(cand);
                if (candidateScore <= currentScore && (candidateScore != currentScore || ns.compareTo((String)cur.getFirst()) >= 0)) continue;
                best = TuplesKt.to((Object)ns, (Object)cand);
            }
        }
        return best;
    }

    public final void generateDatabaseClass() {
        Object[] objectArray = new String[]{"OptIn"};
        ClassName className = new ClassName("kotlin", (String[])objectArray);
        objectArray = new Object[1];
        String[] stringArray = new String[]{"ExperimentalUuidApi"};
        objectArray[0] = new ClassName("kotlin.uuid", stringArray);
        FileSpec.Builder fileBuilder = FileSpec.Companion.builder(this.packageName, this.databaseClassName).addFileComment("Generated database class with unified adapter management", new Object[0]).addFileComment("Do not modify this file manually", new Object[0]).addAnnotation(AnnotationSpec.Companion.builder(className).addMember("%T::class", objectArray).build());
        objectArray = new String[]{"DatabaseMigrations"};
        fileBuilder.addImport("dev.goquick.sqlitenow.core", (String[])objectArray);
        objectArray = new String[]{"SqliteNowDatabase"};
        fileBuilder.addImport("dev.goquick.sqlitenow.core", (String[])objectArray);
        objectArray = new String[]{"SelectRunners"};
        fileBuilder.addImport("dev.goquick.sqlitenow.core", (String[])objectArray);
        objectArray = new String[]{"ExecuteStatement"};
        fileBuilder.addImport("dev.goquick.sqlitenow.core", (String[])objectArray);
        objectArray = new String[]{"ExecuteReturningStatement"};
        fileBuilder.addImport("dev.goquick.sqlitenow.core", (String[])objectArray);
        objectArray = new String[]{"Flow"};
        fileBuilder.addImport("kotlinx.coroutines.flow", (String[])objectArray);
        if (this.debug) {
            objectArray = new String[]{"sqliteNowLogger"};
            fileBuilder.addImport("dev.goquick.sqlitenow.common", (String[])objectArray);
        }
        TypeSpec databaseClass = this.generateMainDatabaseClass();
        fileBuilder.addType(databaseClass);
        fileBuilder.build().writeTo(this.outputDir);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec generateMainDatabaseClass() {
        void $this$filter$iv;
        boolean bl;
        Object it;
        void $this$filterValues$iv;
        Object object;
        Object object2;
        Object object3;
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv;
        Object[] objectArray = new KModifier[]{KModifier.PUBLIC};
        TypeSpec.Builder builder = TypeSpec.Companion.classBuilder(this.databaseClassName).addModifiers(objectArray);
        objectArray = new String[]{"SqliteNowDatabase"};
        TypeSpec.Builder classBuilder = builder.superclass((TypeName)new ClassName("dev.goquick.sqlitenow.core", (String[])objectArray));
        Map<String, List<UniqueAdapter>> adaptersByNamespace = this.collectAdaptersByNamespace();
        Map<String, String> bestProviderForFunction = this.computeBestProviders(adaptersByNamespace);
        Map<String, List<UniqueAdapter>> map = adaptersByNamespace;
        boolean $i$f$mapValues = false;
        void var7_7 = $this$mapValues$iv;
        Iterator<Map.Entry<String, List<AnnotatedStatement>>> destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean bl2 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterTo$iv$iv2;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl3 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object3 = it$iv$iv.getKey();
            object2 = map2;
            boolean bl22 = false;
            String ns = (String)entry2.getKey();
            List adapters = (List)entry2.getValue();
            Iterable $this$filter$iv2 = adapters;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                UniqueAdapter it2 = (UniqueAdapter)element$iv$iv;
                boolean bl32 = false;
                if (!Intrinsics.areEqual((Object)bestProviderForFunction.get(this.baseFunctionKey(it2.getFunctionName())), (Object)ns)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            object = (List)destination$iv$iv2;
            object2.put(object3, object);
        }
        $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            it = (List)entry.getValue();
            bl = false;
            boolean bl4 = !((Collection)it).isEmpty();
            if (!bl4) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map namespacesWithFilteredAdapters = result$iv;
        FunSpec ctor = this.buildConstructorWithAdapters(namespacesWithFilteredAdapters);
        classBuilder.primaryConstructor(ctor);
        classBuilder.addSuperclassConstructorParameter("dbName = dbName", new Object[0]);
        classBuilder.addSuperclassConstructorParameter("migration = migration", new Object[0]);
        classBuilder.addSuperclassConstructorParameter("debug = debug", new Object[0]);
        this.addAdapterPrivateProperties(classBuilder, namespacesWithFilteredAdapters.keySet());
        this.addRouterProperties(classBuilder);
        this.generateAdapterWrapperClasses(classBuilder, namespacesWithFilteredAdapters);
        Map<String, List<AnnotatedStatement>> $this$forEach$iv = this.nsWithStatements;
        boolean $i$f$forEach232 = false;
        for (Map.Entry<String, List<AnnotatedStatement>> entry : $this$forEach$iv.entrySet()) {
            it = entry;
            bl = false;
            String namespace = (String)it.getKey();
            List statements = (List)it.getValue();
            TypeSpec routerClass = this.generateRouterClass(namespace, statements, adaptersByNamespace);
            classBuilder.addType(routerClass);
        }
        Iterable $i$f$forEach232 = this.createTableStatements;
        boolean $i$f$filter = false;
        void var9_16 = $this$filter$iv;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : var9_16) {
            AnnotatedCreateTableStatement it3 = (AnnotatedCreateTableStatement)element$iv$iv;
            boolean bl5 = false;
            if (!it3.getAnnotations().getEnableSync()) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List syncTables = CollectionsKt.distinct((Iterable)((List)destination$iv$iv3));
        if (!((Collection)syncTables).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = syncTables;
            boolean bl6 = false;
            destination$iv$iv3 = $this$map$iv;
            String[] destination$iv$iv322422 = (String[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo232 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String primaryKeyColumn;
                void table;
                AnnotatedCreateTableStatement bl5 = (AnnotatedCreateTableStatement)item$iv$iv;
                object2 = destination$iv$iv322422;
                boolean bl52 = false;
                String explicitSyncKey = table.getAnnotations().getSyncKeyColumnName();
                String string = explicitSyncKey;
                if (string == null) {
                    string = this.findPrimaryKeyColumn((AnnotatedCreateTableStatement)table);
                }
                Object syncKeyParam = (primaryKeyColumn = string) != null && !Intrinsics.areEqual((Object)primaryKeyColumn, (Object)"id") ? ", syncKeyColumnName = \"" + primaryKeyColumn + "\"" : (explicitSyncKey != null ? ", syncKeyColumnName = \"" + explicitSyncKey + "\"" : "");
                object2.add("%T(tableName = \"" + table.getName() + "\"" + (String)syncKeyParam + ")");
            }
            List syncTableInitializers = (List)destination$iv$iv322422;
            String listInitializer = CollectionsKt.joinToString$default((Iterable)syncTableInitializers, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            String[] stringArray = new String[]{"List"};
            ClassName className = new ClassName("kotlin.collections", stringArray);
            stringArray = new TypeName[1];
            destination$iv$iv322422 = new String[]{"SyncTable"};
            stringArray[0] = new ClassName("dev.goquick.sqlitenow.oversqlite", destination$iv$iv322422);
            int n = 0;
            int destination$iv$iv322422 = syncTables.size();
            Object[] $i$f$mapTo232 = new ClassName[destination$iv$iv322422];
            object = "listOf(" + listInitializer + ")";
            object3 = PropertySpec.Companion.builder("syncTables", (TypeName)ParameterizedTypeName.Companion.get(className, (TypeName[])stringArray), new KModifier[0]);
            object2 = TypeSpec.Companion.companionObjectBuilder$default((TypeSpec.Companion)TypeSpec.Companion, null, (int)1, null);
            while (n < destination$iv$iv322422) {
                Object item$iv$iv;
                int n2 = n++;
                item$iv$iv = new String[]{"SyncTable"};
                $i$f$mapTo232[n2] = new ClassName("dev.goquick.sqlitenow.oversqlite", item$iv$iv);
            }
            TypeSpec typeSpec = object2.addProperty(object3.initializer((String)object, $i$f$mapTo232).addKdoc("Tables annotated with enableSync in schema; used to configure oversqlite.", new Object[0]).build()).build();
            classBuilder.addType(typeSpec);
            String[] stringArray2 = new String[]{"OversqliteConfig"};
            ClassName className2 = new ClassName("dev.goquick.sqlitenow.oversqlite", stringArray2);
            stringArray2 = new Object[1];
            String[] destination$iv$iv322422 = new String[]{"OversqliteConfig"};
            stringArray2[0] = new ClassName("dev.goquick.sqlitenow.oversqlite", destination$iv$iv322422);
            classBuilder.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("buildOversqliteConfig").addKdoc("Builds oversqlite config using enableSync tables.", new Object[0]).addParameter("schema", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).addParameter(ParameterSpec.Companion.builder("uploadLimit", Reflection.getOrCreateKotlinClass(Integer.TYPE), new KModifier[0]).defaultValue("200", new Object[0]).build()).addParameter(ParameterSpec.Companion.builder("downloadLimit", Reflection.getOrCreateKotlinClass(Integer.TYPE), new KModifier[0]).defaultValue("1000", new Object[0]).build()).addParameter(ParameterSpec.Companion.builder("verboseLogs", Reflection.getOrCreateKotlinClass(Boolean.TYPE), new KModifier[0]).defaultValue("false", new Object[0]).build()), (TypeName)((TypeName)className2), null, (int)2, null).addStatement("return %T(schema, syncTables, uploadLimit, downloadLimit, verboseLogs = verboseLogs)", (Object[])stringArray2).build());
            stringArray2 = new String[]{"HttpClient"};
            ClassName className3 = new ClassName("io.ktor.client", stringArray2);
            stringArray2 = new String[]{"Resolver"};
            ClassName className4 = new ClassName("dev.goquick.sqlitenow.oversqlite", stringArray2);
            stringArray2 = new Object[1];
            destination$iv$iv322422 = new String[]{"ServerWinsResolver"};
            stringArray2[0] = new ClassName("dev.goquick.sqlitenow.oversqlite", destination$iv$iv322422);
            FunSpec.Builder builder2 = FunSpec.Companion.builder("newOversqliteClient").addKdoc("Creates a DefaultOversqliteClient bound to this DB using a pre-configured HttpClient with authentication and base URL.", new Object[0]).addParameter("schema", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).addParameter("httpClient", (TypeName)className3, new KModifier[0]).addParameter(ParameterSpec.Companion.builder("resolver", (TypeName)className4, new KModifier[0]).defaultValue("%T", (Object[])stringArray2).build()).addParameter(ParameterSpec.Companion.builder("uploadLimit", Reflection.getOrCreateKotlinClass(Integer.TYPE), new KModifier[0]).defaultValue("200", new Object[0]).build()).addParameter(ParameterSpec.Companion.builder("downloadLimit", Reflection.getOrCreateKotlinClass(Integer.TYPE), new KModifier[0]).defaultValue("1000", new Object[0]).build()).addParameter(ParameterSpec.Companion.builder("verboseLogs", Reflection.getOrCreateKotlinClass(Boolean.TYPE), new KModifier[0]).defaultValue("false", new Object[0]).build());
            stringArray2 = new String[]{"OversqliteClient"};
            destination$iv$iv322422 = stringArray2 = FunSpec.Builder.returns$default((FunSpec.Builder)builder2, (TypeName)((TypeName)new ClassName("dev.goquick.sqlitenow.oversqlite", stringArray2)), null, (int)2, null).addStatement("val cfg = buildOversqliteConfig(schema, uploadLimit, downloadLimit, verboseLogs)", new Object[0]);
            object2 = classBuilder;
            boolean bl7 = false;
            Object[] objectArray2 = new String[]{"DefaultOversqliteClient"};
            ClassName clientClass = new ClassName("dev.goquick.sqlitenow.oversqlite", (String[])objectArray2);
            if (this.debug) {
                objectArray2 = new Object[]{clientClass};
                v8 = $this$generateMainDatabaseClass_u24lambda_u245.addStatement("return %T(\n    db = this.connection(),\n    config = cfg,\n    http = httpClient,\n    resolver = resolver,\n    tablesUpdateListener = { tables ->\n        sqliteNowLogger.d { \"notifyTablesChanged -> \" + tables.joinToString(\", \") }\n        notifyTablesChanged(tables)\n    }\n)", objectArray2);
            } else {
                objectArray2 = new Object[]{clientClass};
                v8 = $this$generateMainDatabaseClass_u24lambda_u245.addStatement("return %T(db = this.connection(), config = cfg, http = httpClient, resolver = resolver, tablesUpdateListener = { notifyTablesChanged(it) })", objectArray2);
            }
            object2.addFunction(stringArray2.build());
        }
        return classBuilder.build();
    }

    private final FunSpec buildConstructorWithAdapters(Map<String, ? extends List<UniqueAdapter>> namespacesWithAdapters) {
        Object[] objectArray = new String[]{"DatabaseMigrations"};
        ClassName className = new ClassName("dev.goquick.sqlitenow.core", (String[])objectArray);
        objectArray = new Object[]{this.debug};
        FunSpec.Builder b = FunSpec.Companion.constructorBuilder().addParameter("dbName", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).addParameter("migration", (TypeName)className, new KModifier[0]).addParameter(ParameterSpec.Companion.builder("debug", Reflection.getOrCreateKotlinClass(Boolean.TYPE), new KModifier[0]).defaultValue("%L", objectArray).build());
        Iterable $this$forEach$iv = namespacesWithAdapters.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String ns = (String)element$iv;
            boolean bl = false;
            String adapterClassName = this.adapterClassNameFor(ns);
            String adapterPropName = this.adapterPropertyNameFor(ns);
            String[] stringArray = new String[]{adapterClassName};
            b.addParameter(adapterPropName, (TypeName)new ClassName("", stringArray), new KModifier[0]);
        }
        return b.build();
    }

    private final void addAdapterPrivateProperties(TypeSpec.Builder classBuilder, Set<String> namespaces) {
        Iterable $this$forEach$iv = namespaces;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String ns = (String)element$iv;
            boolean bl = false;
            String adapterClassName = this.adapterClassNameFor(ns);
            String adapterPropName = this.adapterPropertyNameFor(ns);
            String[] stringArray = new String[]{adapterClassName};
            ClassName className = new ClassName("", stringArray);
            stringArray = new KModifier[]{KModifier.PRIVATE};
            classBuilder.addProperty(PropertySpec.Companion.builder(adapterPropName, (TypeName)className, new KModifier[0]).addModifiers((KModifier[])stringArray).initializer(adapterPropName, new Object[0]).build());
        }
    }

    private final void addRouterProperties(TypeSpec.Builder classBuilder) {
        Iterable $this$forEach$iv = this.nsWithStatements.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String namespace = (String)element$iv;
            boolean bl = false;
            String routerClassName = this.routerClassNameFor(namespace);
            String routerPropName = this.routerPropertyNameFor(namespace);
            String[] stringArray = new String[]{routerClassName};
            classBuilder.addProperty(PropertySpec.Companion.builder(routerPropName, (TypeName)new ClassName("", stringArray), new KModifier[0]).initializer(routerClassName + "(ref = this)", new Object[0]).build());
        }
    }

    private final void generateAdapterWrapperClasses(TypeSpec.Builder classBuilder, Map<String, ? extends List<UniqueAdapter>> namespacesWithAdapters) {
        Map<String, ? extends List<UniqueAdapter>> $this$forEach$iv = namespacesWithAdapters;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends List<UniqueAdapter>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends List<UniqueAdapter>> element$iv;
            Map.Entry<String, ? extends List<UniqueAdapter>> entry = element$iv = iterator.next();
            boolean bl = false;
            String namespace = entry.getKey();
            List<UniqueAdapter> adapters = entry.getValue();
            TypeSpec adapterClass = this.generateAdapterClass(namespace, adapters);
            classBuilder.addType(adapterClass);
        }
    }

    private final Pair<String, String> resolveAdapterProvider(AdapterConfig.ParamConfig config, String namespace, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        Object object = this.findBestProviderByName(config.getAdapterFunctionName(), adaptersByNamespace);
        if (object == null || (object = (String)object.getFirst()) == null) {
            object = namespace;
        }
        Object providerNs = object;
        String providerProp = this.adapterPropertyNameFor((String)providerNs);
        String actualAdapterName = this.findAdapterName((String)providerNs, config.getAdapterFunctionName(), config.getInputType(), adaptersByNamespace);
        return TuplesKt.to((Object)providerProp, (Object)actualAdapterName);
    }

    private final List<String> buildCommonParamsLines(boolean hasParams, List<AdapterConfig.ParamConfig> statementAdapters, String namespace, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        List lines = new ArrayList();
        ((Collection)lines).add("conn = ref.connection()");
        if (hasParams) {
            ((Collection)lines).add("params = params");
        }
        Map<AdapterConfig.ParamConfig, String> chosenParamNames = this.adapterNameResolver.chooseAdapterParamNames(statementAdapters);
        Iterable $this$forEach$iv = statementAdapters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AdapterConfig.ParamConfig config = (AdapterConfig.ParamConfig)element$iv;
            boolean bl = false;
            Pair<String, String> pair = this.resolveAdapterProvider(config, namespace, adaptersByNamespace);
            String providerProp = (String)pair.component1();
            String adapterName = (String)pair.component2();
            String string = chosenParamNames.get(config);
            if (string == null) {
                string = config.getAdapterFunctionName();
            }
            String canonicalParamName = string;
            ((Collection)lines).add(canonicalParamName + " = ref." + providerProp + "." + adapterName);
        }
        return lines;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AdapterConfig.ParamConfig> collectOutputAdaptersForExecuteReturning(AnnotatedExecuteStatement statement) {
        List list;
        if (!statement.hasReturningClause()) {
            return CollectionsKt.emptyList();
        }
        AnnotatedCreateTableStatement annotatedCreateTableStatement = this.tableLookup.get(statement.getSrc().getTable());
        if (annotatedCreateTableStatement == null) {
            return CollectionsKt.emptyList();
        }
        AnnotatedCreateTableStatement tableStatement = annotatedCreateTableStatement;
        List<String> returningColumns = statement.getSrc().getReturningColumns();
        if (returningColumns.contains("*")) {
            list = tableStatement.getColumns();
        } else {
            void $this$filterTo$iv$iv;
            CaseInsensitiveSet caseInsensitiveSet;
            CaseInsensitiveSet $this$collectOutputAdaptersForExecuteReturning_u24lambda_u240 = caseInsensitiveSet = new CaseInsensitiveSet();
            boolean $i$a$-apply-DatabaseCodeGenerator$collectOutputAdaptersForExecuteReturning$columnsToInclude$returningSet$22 = false;
            $this$collectOutputAdaptersForExecuteReturning_u24lambda_u240.addAll((Iterable<String>)returningColumns);
            CaseInsensitiveSet returningSet = caseInsensitiveSet;
            Iterable $this$filter$iv = tableStatement.getColumns();
            boolean $i$f$filter = false;
            Iterable $i$a$-apply-DatabaseCodeGenerator$collectOutputAdaptersForExecuteReturning$columnsToInclude$returningSet$22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AnnotatedCreateTableStatement.Column column = (AnnotatedCreateTableStatement.Column)element$iv$iv;
                boolean bl = false;
                if (!returningSet.containsIgnoreCase(column.getSrc().getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List columnsToInclude = list;
        List configs = new ArrayList();
        Set processedAdapters = new LinkedHashSet();
        Iterable $this$forEach$iv = columnsToInclude;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String propertyName;
            String adapterFunctionName;
            AnnotatedCreateTableStatement.Column column = (AnnotatedCreateTableStatement.Column)element$iv;
            boolean bl = false;
            if (!column.getAnnotations().containsKey("adapter") || processedAdapters.contains(adapterFunctionName = this.adapterConfig.getOutputAdapterFunctionName(propertyName = statement.getAnnotations().getPropertyNameGenerator().convertToPropertyName(column.getSrc().getName())))) continue;
            processedAdapters.add(adapterFunctionName);
            TypeName baseType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(column.getSrc().getDataType());
            Object object = column.getAnnotations().get("propertyType");
            String propertyType = object instanceof String ? (String)object : null;
            boolean propertyNullable = column.isNullable();
            boolean sqlNullable = column.isSqlNullable();
            TypeName targetType = SqliteTypeToKotlinCodeConverter.Companion.determinePropertyType(baseType, propertyType, propertyNullable, this.packageName);
            TypeName inputType = TypeName.copy$default((TypeName)baseType, (boolean)sqlNullable, null, (int)2, null);
            TypeName outputType = TypeName.copy$default((TypeName)targetType, (boolean)propertyNullable, null, (int)2, null);
            AdapterConfig.ParamConfig config = new AdapterConfig.ParamConfig(column.getSrc().getName(), adapterFunctionName, inputType, outputType, propertyNullable, null, AdapterConfig.AdapterKind.RESULT_FIELD);
            configs.add(config);
        }
        return configs;
    }

    /*
     * WARNING - void declaration
     */
    private final String findPrimaryKeyColumn(AnnotatedCreateTableStatement table) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = table.getColumns();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnotatedCreateTableStatement.Column it = (AnnotatedCreateTableStatement.Column)element$iv$iv;
            boolean bl = false;
            if (!it.getSrc().getPrimaryKey()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List primaryKeyColumns = (List)destination$iv$iv;
        return primaryKeyColumns.size() == 1 ? ((AnnotatedCreateTableStatement.Column)CollectionsKt.first((List)primaryKeyColumns)).getSrc().getName() : null;
    }

    private final TypeSpec generateAdapterClass(String namespace, List<UniqueAdapter> adapters) {
        String adapterClassName = this.adapterClassNameFor(namespace);
        KModifier[] kModifierArray = new KModifier[]{KModifier.PUBLIC, KModifier.DATA};
        TypeSpec.Builder classBuilder = TypeSpec.Companion.classBuilder(adapterClassName).addModifiers(kModifierArray);
        FunSpec.Builder constructorBuilder = FunSpec.Companion.constructorBuilder();
        Iterable $this$forEach$iv = adapters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UniqueAdapter adapter = (UniqueAdapter)element$iv;
            boolean bl = false;
            ParameterSpec paramSpec = adapter.toParameterSpec();
            constructorBuilder.addParameter(paramSpec);
            PropertySpec propertySpec = PropertySpec.Companion.builder(adapter.getFunctionName(), adapter.toParameterSpec().getType(), new KModifier[0]).initializer(adapter.getFunctionName(), new Object[0]).build();
            classBuilder.addProperty(propertySpec);
        }
        classBuilder.primaryConstructor(constructorBuilder.build());
        return classBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec generateRouterClass(String namespace, List<? extends AnnotatedStatement> statements, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        String routerClassName = this.routerClassNameFor(namespace);
        KModifier[] kModifierArray = new KModifier[]{KModifier.PUBLIC};
        TypeSpec.Builder classBuilder = TypeSpec.Companion.classBuilder(routerClassName).addModifiers(kModifierArray);
        String[] stringArray = new String[]{this.databaseClassName};
        FunSpec.Builder constructorBuilder = FunSpec.Companion.constructorBuilder().addParameter("ref", (TypeName)new ClassName("", stringArray), new KModifier[0]);
        classBuilder.primaryConstructor(constructorBuilder.build());
        String[] stringArray2 = new String[]{this.databaseClassName};
        ClassName className = new ClassName("", stringArray2);
        stringArray2 = new KModifier[]{KModifier.PRIVATE};
        PropertySpec refProperty = PropertySpec.Companion.builder("ref", (TypeName)className, new KModifier[0]).initializer("ref", new Object[0]).addModifiers((KModifier[])stringArray2).build();
        classBuilder.addProperty(refProperty);
        Iterable $this$forEach$iv = statements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Unit unit;
            AnnotatedStatement statement = (AnnotatedStatement)element$iv;
            boolean bl = false;
            AnnotatedStatement annotatedStatement = statement;
            if (annotatedStatement instanceof AnnotatedSelectStatement) {
                unit = classBuilder.addProperty(this.generateSelectRunnersProperty((AnnotatedSelectStatement)statement, namespace, adaptersByNamespace));
                continue;
            }
            if (annotatedStatement instanceof AnnotatedExecuteStatement) {
                boolean hasParams;
                boolean bl2 = hasParams = !((Collection)StatementUtils.INSTANCE.getNamedParameters(statement)).isEmpty();
                if (((AnnotatedExecuteStatement)statement).hasReturningClause()) {
                    void $this$forEach$iv2;
                    if (hasParams) {
                        unit = classBuilder.addProperty(this.generateExecuteReturningStatementProperty((AnnotatedExecuteStatement)statement, namespace, adaptersByNamespace));
                        continue;
                    }
                    Iterable iterable = this.generateExecuteReturningFunctionsWithoutParams((AnnotatedExecuteStatement)statement, namespace, adaptersByNamespace);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        FunSpec functionSpec = (FunSpec)element$iv2;
                        boolean bl3 = false;
                        classBuilder.addFunction(functionSpec);
                    }
                    unit = Unit.INSTANCE;
                    continue;
                }
                if (hasParams) {
                    unit = classBuilder.addProperty(this.generateExecuteStatementProperty((AnnotatedExecuteStatement)statement, namespace, adaptersByNamespace));
                    continue;
                }
                unit = classBuilder.addFunction(this.generateExecuteFunctionWithoutParams((AnnotatedExecuteStatement)statement, namespace, adaptersByNamespace));
                continue;
            }
            unit = Unit.INSTANCE;
        }
        return classBuilder.build();
    }

    private final PropertySpec generateSelectRunnersProperty(AnnotatedSelectStatement statement, String namespace, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        TypeName typeName;
        boolean hasParams;
        String className = statement.getDataClassName();
        String propertyName = StringUtilsKt.lowercaseFirst(className);
        TypeName resultType = this.resolvePublicResultType(namespace, statement);
        List<String> namedParameters = StatementUtils.INSTANCE.getNamedParameters(statement);
        boolean bl = hasParams = !((Collection)namedParameters).isEmpty();
        if (hasParams) {
            String[] stringArray = new String[]{this.queryNamespaceName(namespace)};
            paramsType = new ClassName(this.packageName, stringArray).nestedClass(className).nestedClass("Params");
            String[] stringArray2 = new String[]{"SelectRunners"};
            ClassName className2 = new ClassName("dev.goquick.sqlitenow.core", stringArray2);
            stringArray2 = new TypeName[]{resultType};
            ParameterizedTypeName selectRunnersType = ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray2);
            stringArray2 = new TypeName[]{paramsType};
            typeName = (TypeName)LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, null, (TypeName[])stringArray2, (TypeName)((TypeName)selectRunnersType), (int)1, null);
        } else {
            paramsType = new String[]{"SelectRunners"};
            ClassName className3 = new ClassName("dev.goquick.sqlitenow.core", paramsType);
            paramsType = new TypeName[]{resultType};
            typeName = (TypeName)ParameterizedTypeName.Companion.get(className3, (TypeName[])paramsType);
        }
        TypeName propertyType = typeName;
        String objectExpression = this.generateSelectRunnersObjectExpression(statement, namespace, className, hasParams, adaptersByNamespace);
        return PropertySpec.Companion.builder(propertyName, propertyType, new KModifier[0]).initializer(objectExpression, new Object[0]).build();
    }

    private final String generateSelectRunnersObjectExpression(AnnotatedSelectStatement statement, String namespace, String className, boolean hasParams, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        String capitalizedNamespace = this.queryNamespaceName(namespace);
        List<AdapterConfig.ParamConfig> statementAdapters = this.adapterConfig.collectAllParamConfigs(statement, namespace);
        List<String> paramLines = this.buildCommonParamsLines(hasParams, statementAdapters, namespace, adaptersByNamespace);
        IndentedCodeBuilder b = new IndentedCodeBuilder(0, 1, null);
        String resultTypeName = this.resolvePublicResultTypeString(namespace, statement);
        if (hasParams) {
            b.line("{ params ->");
        }
        b.line("object : SelectRunners<" + resultTypeName + "> {");
        b.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> DatabaseCodeGenerator.generateSelectRunnersObjectExpression$lambda$0(b, capitalizedNamespace, className, paramLines, arg_0)));
        b.line("}");
        if (hasParams) {
            b.line("}");
        }
        return b.build();
    }

    private final PropertySpec generateExecuteStatementProperty(AnnotatedExecuteStatement statement, String namespace, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        String className = statement.getDataClassName();
        String propertyName = StringUtilsKt.lowercaseFirst(className);
        String[] stringArray = new String[]{this.queryNamespaceName(namespace)};
        ClassName paramsType = new ClassName(this.packageName, stringArray).nestedClass(className).nestedClass("Params");
        String[] stringArray2 = new String[]{"ExecuteStatement"};
        ClassName className2 = new ClassName("dev.goquick.sqlitenow.core", stringArray2);
        stringArray2 = new TypeName[]{paramsType};
        ParameterizedTypeName propertyType = ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray2);
        String initializer = this.buildExecuteStatementInitializer(statement, namespace, className, adaptersByNamespace);
        return PropertySpec.Companion.builder(propertyName, (TypeName)propertyType, new KModifier[0]).initializer(initializer, new Object[0]).build();
    }

    private final String buildExecuteStatementInitializer(AnnotatedExecuteStatement statement, String namespace, String className, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        String capitalizedNamespace = this.queryNamespaceName(namespace);
        List<AdapterConfig.ParamConfig> statementAdapters = this.adapterConfig.collectAllParamConfigs(statement, namespace);
        List<String> paramLines = this.buildCommonParamsLines(true, statementAdapters, namespace, adaptersByNamespace);
        IndentedCodeBuilder b = new IndentedCodeBuilder(0, 1, null);
        b.line("ExecuteStatement(");
        IndentedCodeBuilder.indent$default(b, 0, arg_0 -> DatabaseCodeGenerator.buildExecuteStatementInitializer$lambda$0(b, capitalizedNamespace, className, this, paramLines, arg_0), 1, null);
        b.line(")");
        return b.build();
    }

    private final FunSpec generateExecuteFunctionWithoutParams(AnnotatedExecuteStatement statement, String namespace, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        String className = statement.getDataClassName();
        String functionName = StringUtilsKt.lowercaseFirst(className);
        String capitalizedNamespace = this.queryNamespaceName(namespace);
        List<AdapterConfig.ParamConfig> statementAdapters = this.adapterConfig.collectAllParamConfigs(statement, namespace);
        List<String> paramLines = this.buildCommonParamsLines(false, statementAdapters, namespace, adaptersByNamespace);
        IndentedCodeBuilder body = new IndentedCodeBuilder(0, 1, null);
        body.line(capitalizedNamespace + "." + className + ".execute(");
        IndentedCodeBuilder.indent$default(body, 0, arg_0 -> DatabaseCodeGenerator.generateExecuteFunctionWithoutParams$lambda$0(paramLines, body, arg_0), 1, null);
        body.line(")");
        body.line("// Notify listeners that tables have changed");
        if (this.debug) {
            body.line("sqliteNowLogger.d { \"notifyTablesChanged -> \" + " + capitalizedNamespace + "." + className + ".affectedTables.joinToString(\", \") }");
        }
        body.line("ref.notifyTablesChanged(" + capitalizedNamespace + "." + className + ".affectedTables)");
        KModifier[] kModifierArray = new KModifier[]{KModifier.PUBLIC, KModifier.SUSPEND};
        return FunSpec.Companion.builder(functionName).addModifiers(kModifierArray).addKdoc("Executes the " + statement.getName() + " statement.", new Object[0]).addCode(body.build(), new Object[0]).build();
    }

    private final PropertySpec generateExecuteReturningStatementProperty(AnnotatedExecuteStatement statement, String namespace, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        String className = statement.getDataClassName();
        String propertyName = StringUtilsKt.lowercaseFirst(className);
        String[] stringArray = new String[]{this.queryNamespaceName(namespace)};
        ClassName paramsType = new ClassName(this.packageName, stringArray).nestedClass(className).nestedClass("Params");
        ClassName resultType = SharedResultTypeUtils.INSTANCE.createResultTypeNameForExecute(this.packageName, namespace, statement);
        String[] stringArray2 = new String[]{"ExecuteReturningStatement"};
        ClassName className2 = new ClassName("dev.goquick.sqlitenow.core", stringArray2);
        stringArray2 = new TypeName[]{paramsType, resultType};
        ParameterizedTypeName propertyType = ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray2);
        String initializer = this.buildExecuteReturningInitializer(statement, namespace, className, adaptersByNamespace);
        return PropertySpec.Companion.builder(propertyName, (TypeName)propertyType, new KModifier[0]).initializer(initializer, new Object[0]).build();
    }

    private final String buildExecuteReturningInitializer(AnnotatedExecuteStatement statement, String namespace, String className, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        String capitalizedNamespace = this.queryNamespaceName(namespace);
        List<AdapterConfig.ParamConfig> inputAdapters = this.adapterConfig.collectAllParamConfigs(statement, namespace);
        List<AdapterConfig.ParamConfig> outputAdapters = this.collectOutputAdaptersForExecuteReturning(statement);
        List allAdapters = CollectionsKt.plus((Collection)inputAdapters, (Iterable)outputAdapters);
        List<String> paramLines = this.buildCommonParamsLines(true, allAdapters, namespace, adaptersByNamespace);
        String resultTypeString = SharedResultTypeUtils.INSTANCE.createResultTypeStringForExecute(namespace, statement);
        IndentedCodeBuilder b = new IndentedCodeBuilder(0, 1, null);
        b.line("ExecuteReturningStatement(");
        IndentedCodeBuilder.indent$default(b, 0, arg_0 -> DatabaseCodeGenerator.buildExecuteReturningInitializer$lambda$0(b, capitalizedNamespace, className, this, paramLines, arg_0), 1, null);
        b.line(")");
        return b.build();
    }

    private final List<FunSpec> generateExecuteReturningFunctionsWithoutParams(AnnotatedExecuteStatement statement, String namespace, Map<String, ? extends List<UniqueAdapter>> adaptersByNamespace) {
        String className = statement.getDataClassName();
        String baseName = StringUtilsKt.lowercaseFirst(className);
        String capitalizedNamespace = this.queryNamespaceName(namespace);
        List<AdapterConfig.ParamConfig> inputAdapters = this.adapterConfig.collectAllParamConfigs(statement, namespace);
        List<AdapterConfig.ParamConfig> outputAdapters = this.collectOutputAdaptersForExecuteReturning(statement);
        List allAdapters = CollectionsKt.plus((Collection)inputAdapters, (Iterable)outputAdapters);
        List<String> paramLines = this.buildCommonParamsLines(false, allAdapters, namespace, adaptersByNamespace);
        ClassName resultTypeName = SharedResultTypeUtils.INSTANCE.createResultTypeNameForExecute(this.packageName, namespace, statement);
        String[] stringArray = new String[]{"List"};
        ClassName className2 = new ClassName("kotlin.collections", stringArray);
        stringArray = new TypeName[]{resultTypeName};
        ParameterizedTypeName listTypeName = ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray);
        TypeName resultTypeNullable = TypeName.copy$default((TypeName)((TypeName)resultTypeName), (boolean)true, null, (int)2, null);
        KModifier[] kModifierArray = new KModifier[]{KModifier.PUBLIC, KModifier.SUSPEND};
        FunSpec listFunction = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(baseName).addModifiers(kModifierArray), (TypeName)((TypeName)listTypeName), null, (int)2, null).addKdoc("Executes the " + statement.getName() + " statement and returns all rows.", new Object[0]).addCode(DatabaseCodeGenerator.generateExecuteReturningFunctionsWithoutParams$createBody(capitalizedNamespace, className, this, paramLines, "executeReturningList"), new Object[0]).build();
        KModifier[] kModifierArray2 = new KModifier[]{KModifier.PUBLIC, KModifier.SUSPEND};
        FunSpec oneFunction = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(baseName + "One").addModifiers(kModifierArray2), (TypeName)((TypeName)resultTypeName), null, (int)2, null).addKdoc("Executes the " + statement.getName() + " statement and returns exactly one row.", new Object[0]).addCode(DatabaseCodeGenerator.generateExecuteReturningFunctionsWithoutParams$createBody(capitalizedNamespace, className, this, paramLines, "executeReturningOne"), new Object[0]).build();
        Object[] objectArray = new KModifier[]{KModifier.PUBLIC, KModifier.SUSPEND};
        FunSpec oneOrNullFunction = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(baseName + "OneOrNull").addModifiers((KModifier[])objectArray), (TypeName)resultTypeNullable, null, (int)2, null).addKdoc("Executes the " + statement.getName() + " statement and returns one row or null when none match.", new Object[0]).addCode(DatabaseCodeGenerator.generateExecuteReturningFunctionsWithoutParams$createBody(capitalizedNamespace, className, this, paramLines, "executeReturningOneOrNull"), new Object[0]).build();
        objectArray = new FunSpec[]{listFunction, oneFunction, oneOrNullFunction};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final TypeName resolvePublicResultType(String namespace, AnnotatedSelectStatement statement) {
        TypeName typeName = this.resolveMapToType(statement);
        if (typeName == null) {
            typeName = (TypeName)SharedResultTypeUtils.INSTANCE.createResultTypeName(this.packageName, namespace, statement);
        }
        return typeName;
    }

    private final TypeName resolveMapToType(AnnotatedSelectStatement statement) {
        String string = statement.getAnnotations().getMapTo();
        if (string == null) {
            return null;
        }
        String target = string;
        return SqliteTypeToKotlinCodeConverter.Companion.parseCustomType(target, this.packageName);
    }

    private final String resolvePublicResultTypeString(String namespace, AnnotatedSelectStatement statement) {
        String string = statement.getAnnotations().getMapTo();
        String override = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        CharSequence charSequence = override;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return override;
        }
        return SharedResultTypeUtils.INSTANCE.createResultTypeString(namespace, statement);
    }

    private static final boolean collectAdaptersByNamespace$lambda$0$1$0(AdapterConfig.ParamConfig it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKind() == AdapterConfig.AdapterKind.MAP_RESULT;
    }

    private static final boolean collectAdaptersByNamespace$lambda$0$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean findBestProviderByName$isCustom(TypeName t) {
        String s = t.toString();
        return !StringsKt.startsWith$default((String)s, (String)"kotlin.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)s, (String)"kotlinx.", (boolean)false, (int)2, null);
    }

    private static final String findBestProviderByName$normalized(TypeName t) {
        return StringsKt.removeSuffix((String)t.toString(), (CharSequence)"?");
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateSelectRunnersObjectExpression$lambda$0$3$0$0(List $paramLines, IndentedCodeBuilder $b, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Iterable $this$forEachIndexed$iv = $paramLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int idx = n;
            boolean bl = false;
            String suffix = idx < CollectionsKt.getLastIndex((List)$paramLines) ? "," : "";
            $b.line((String)line + suffix);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateSelectRunnersObjectExpression$lambda$0$3$0(IndentedCodeBuilder $b, String $capitalizedNamespace, String $className, List $paramLines, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $b.line($capitalizedNamespace + "." + $className + ".executeAsList(");
        $b.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> DatabaseCodeGenerator.generateSelectRunnersObjectExpression$lambda$0$3$0$0($paramLines, $b, arg_0)));
        $b.line(")");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateSelectRunnersObjectExpression$lambda$0$0(List $paramLines, IndentedCodeBuilder $b, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Iterable $this$forEachIndexed$iv = $paramLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int idx = n;
            boolean bl = false;
            String suffix = idx < CollectionsKt.getLastIndex((List)$paramLines) ? "," : "";
            $b.line((String)line + suffix);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateSelectRunnersObjectExpression$lambda$0$1(List $paramLines, IndentedCodeBuilder $b, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Iterable $this$forEachIndexed$iv = $paramLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int idx = n;
            boolean bl = false;
            String suffix = idx < CollectionsKt.getLastIndex((List)$paramLines) ? "," : "";
            $b.line((String)line + suffix);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateSelectRunnersObjectExpression$lambda$0$2(List $paramLines, IndentedCodeBuilder $b, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Iterable $this$forEachIndexed$iv = $paramLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int idx = n;
            boolean bl = false;
            String suffix = idx < CollectionsKt.getLastIndex((List)$paramLines) ? "," : "";
            $b.line((String)line + suffix);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateSelectRunnersObjectExpression$lambda$0$3(IndentedCodeBuilder $b, String $capitalizedNamespace, String $className, List $paramLines, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $b.line("affectedTables = " + $capitalizedNamespace + "." + $className + ".affectedTables,");
        $b.line("queryExecutor = {");
        $b.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> DatabaseCodeGenerator.generateSelectRunnersObjectExpression$lambda$0$3$0($b, $capitalizedNamespace, $className, $paramLines, arg_0)));
        $b.line("}");
        return Unit.INSTANCE;
    }

    private static final Unit generateSelectRunnersObjectExpression$lambda$0(IndentedCodeBuilder $b, String $capitalizedNamespace, String $className, List $paramLines, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $b.line("override suspend fun asList() = " + $capitalizedNamespace + "." + $className + ".executeAsList(");
        $b.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> DatabaseCodeGenerator.generateSelectRunnersObjectExpression$lambda$0$0($paramLines, $b, arg_0)));
        $b.line(")");
        $b.line("");
        $b.line("override suspend fun asOne() = " + $capitalizedNamespace + "." + $className + ".executeAsOne(");
        $b.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> DatabaseCodeGenerator.generateSelectRunnersObjectExpression$lambda$0$1($paramLines, $b, arg_0)));
        $b.line(")");
        $b.line("");
        $b.line("override suspend fun asOneOrNull() = " + $capitalizedNamespace + "." + $className + ".executeAsOneOrNull(");
        $b.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> DatabaseCodeGenerator.generateSelectRunnersObjectExpression$lambda$0$2($paramLines, $b, arg_0)));
        $b.line(")");
        $b.line("");
        $b.line("override fun asFlow() = ref.createReactiveQueryFlow(");
        $b.indent(2, (Function1<? super IndentedCodeBuilder, Unit>)((Function1)arg_0 -> DatabaseCodeGenerator.generateSelectRunnersObjectExpression$lambda$0$3($b, $capitalizedNamespace, $className, $paramLines, arg_0)));
        $b.line(")");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit buildExecuteStatementInitializer$lambda$0$0$0(List $paramLines, IndentedCodeBuilder $b, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Iterable $this$forEachIndexed$iv = $paramLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int idx = n;
            boolean bl = false;
            String suffix = idx < CollectionsKt.getLastIndex((List)$paramLines) ? "," : "";
            $b.line((String)line + suffix);
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildExecuteStatementInitializer$lambda$0$0(IndentedCodeBuilder $b, String $capitalizedNamespace, String $className, DatabaseCodeGenerator this$0, List $paramLines, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $b.line($capitalizedNamespace + "." + $className + ".execute(");
        IndentedCodeBuilder.indent$default($b, 0, arg_0 -> DatabaseCodeGenerator.buildExecuteStatementInitializer$lambda$0$0$0($paramLines, $b, arg_0), 1, null);
        $b.line(")");
        $b.line("// Notify listeners that tables have changed");
        if (this$0.debug) {
            $b.line("sqliteNowLogger.d { \"notifyTablesChanged -> \" + " + $capitalizedNamespace + "." + $className + ".affectedTables.joinToString(\", \") }");
        }
        $b.line("ref.notifyTablesChanged(" + $capitalizedNamespace + "." + $className + ".affectedTables)");
        return Unit.INSTANCE;
    }

    private static final Unit buildExecuteStatementInitializer$lambda$0(IndentedCodeBuilder $b, String $capitalizedNamespace, String $className, DatabaseCodeGenerator this$0, List $paramLines, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $b.line("executeBlock = { params ->");
        IndentedCodeBuilder.indent$default($b, 0, arg_0 -> DatabaseCodeGenerator.buildExecuteStatementInitializer$lambda$0$0($b, $capitalizedNamespace, $className, this$0, $paramLines, arg_0), 1, null);
        $b.line("}");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateExecuteFunctionWithoutParams$lambda$0(List $paramLines, IndentedCodeBuilder $body, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Iterable $this$forEachIndexed$iv = $paramLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int idx = n;
            boolean bl = false;
            String suffix = idx < CollectionsKt.getLastIndex((List)$paramLines) ? "," : "";
            $body.line((String)line + suffix);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit buildExecuteReturningInitializer$lambda$0$0$0(List $paramLines, IndentedCodeBuilder $b, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Iterable $this$forEachIndexed$iv = $paramLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int idx = n;
            boolean bl = false;
            String suffix = idx < CollectionsKt.getLastIndex((List)$paramLines) ? "," : "";
            $b.line((String)line + suffix);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit buildExecuteReturningInitializer$lambda$0$1$0(List $paramLines, IndentedCodeBuilder $b, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Iterable $this$forEachIndexed$iv = $paramLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int idx = n;
            boolean bl = false;
            String suffix = idx < CollectionsKt.getLastIndex((List)$paramLines) ? "," : "";
            $b.line((String)line + suffix);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit buildExecuteReturningInitializer$lambda$0$2$0(List $paramLines, IndentedCodeBuilder $b, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Iterable $this$forEachIndexed$iv = $paramLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int idx = n;
            boolean bl = false;
            String suffix = idx < CollectionsKt.getLastIndex((List)$paramLines) ? "," : "";
            $b.line((String)line + suffix);
        }
        return Unit.INSTANCE;
    }

    private static final Unit buildExecuteReturningInitializer$lambda$0$0(IndentedCodeBuilder $b, String $capitalizedNamespace, String $className, DatabaseCodeGenerator this$0, List $paramLines, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $b.line("val result = " + $capitalizedNamespace + "." + $className + ".executeReturningList(");
        IndentedCodeBuilder.indent$default($b, 0, arg_0 -> DatabaseCodeGenerator.buildExecuteReturningInitializer$lambda$0$0$0($paramLines, $b, arg_0), 1, null);
        $b.line(")");
        $b.line("// Notify listeners that tables have changed");
        if (this$0.debug) {
            $b.line("sqliteNowLogger.d { \"notifyTablesChanged -> \" + " + $capitalizedNamespace + "." + $className + ".affectedTables.joinToString(\", \") }");
        }
        $b.line("ref.notifyTablesChanged(" + $capitalizedNamespace + "." + $className + ".affectedTables)");
        $b.line("result");
        return Unit.INSTANCE;
    }

    private static final Unit buildExecuteReturningInitializer$lambda$0$1(IndentedCodeBuilder $b, String $capitalizedNamespace, String $className, DatabaseCodeGenerator this$0, List $paramLines, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $b.line("val result = " + $capitalizedNamespace + "." + $className + ".executeReturningOne(");
        IndentedCodeBuilder.indent$default($b, 0, arg_0 -> DatabaseCodeGenerator.buildExecuteReturningInitializer$lambda$0$1$0($paramLines, $b, arg_0), 1, null);
        $b.line(")");
        $b.line("// Notify listeners that tables have changed");
        if (this$0.debug) {
            $b.line("sqliteNowLogger.d { \"notifyTablesChanged -> \" + " + $capitalizedNamespace + "." + $className + ".affectedTables.joinToString(\", \") }");
        }
        $b.line("ref.notifyTablesChanged(" + $capitalizedNamespace + "." + $className + ".affectedTables)");
        $b.line("result");
        return Unit.INSTANCE;
    }

    private static final Unit buildExecuteReturningInitializer$lambda$0$2(IndentedCodeBuilder $b, String $capitalizedNamespace, String $className, DatabaseCodeGenerator this$0, List $paramLines, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $b.line("val result = " + $capitalizedNamespace + "." + $className + ".executeReturningOneOrNull(");
        IndentedCodeBuilder.indent$default($b, 0, arg_0 -> DatabaseCodeGenerator.buildExecuteReturningInitializer$lambda$0$2$0($paramLines, $b, arg_0), 1, null);
        $b.line(")");
        $b.line("// Notify listeners that tables have changed");
        if (this$0.debug) {
            $b.line("sqliteNowLogger.d { \"notifyTablesChanged -> \" + " + $capitalizedNamespace + "." + $className + ".affectedTables.joinToString(\", \") }");
        }
        $b.line("ref.notifyTablesChanged(" + $capitalizedNamespace + "." + $className + ".affectedTables)");
        $b.line("result");
        return Unit.INSTANCE;
    }

    private static final Unit buildExecuteReturningInitializer$lambda$0(IndentedCodeBuilder $b, String $capitalizedNamespace, String $className, DatabaseCodeGenerator this$0, List $paramLines, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $b.line("listBlock = { params ->");
        IndentedCodeBuilder.indent$default($b, 0, arg_0 -> DatabaseCodeGenerator.buildExecuteReturningInitializer$lambda$0$0($b, $capitalizedNamespace, $className, this$0, $paramLines, arg_0), 1, null);
        $b.line("},");
        $b.line("oneBlock = { params ->");
        IndentedCodeBuilder.indent$default($b, 0, arg_0 -> DatabaseCodeGenerator.buildExecuteReturningInitializer$lambda$0$1($b, $capitalizedNamespace, $className, this$0, $paramLines, arg_0), 1, null);
        $b.line("},");
        $b.line("oneOrNullBlock = { params ->");
        IndentedCodeBuilder.indent$default($b, 0, arg_0 -> DatabaseCodeGenerator.buildExecuteReturningInitializer$lambda$0$2($b, $capitalizedNamespace, $className, this$0, $paramLines, arg_0), 1, null);
        $b.line("}");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit generateExecuteReturningFunctionsWithoutParams$createBody$lambda$0(List $paramLines, IndentedCodeBuilder $bodyBuilder, IndentedCodeBuilder $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Iterable $this$forEachIndexed$iv = $paramLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int idx = n;
            boolean bl = false;
            String suffix = idx < CollectionsKt.getLastIndex((List)$paramLines) ? "," : "";
            $bodyBuilder.line((String)line + suffix);
        }
        return Unit.INSTANCE;
    }

    private static final String generateExecuteReturningFunctionsWithoutParams$createBody(String capitalizedNamespace, String className, DatabaseCodeGenerator this$0, List<String> paramLines, String invocation) {
        IndentedCodeBuilder bodyBuilder = new IndentedCodeBuilder(0, 1, null);
        bodyBuilder.line("val result = " + capitalizedNamespace + "." + className + "." + invocation + "(");
        IndentedCodeBuilder.indent$default(bodyBuilder, 0, arg_0 -> DatabaseCodeGenerator.generateExecuteReturningFunctionsWithoutParams$createBody$lambda$0(paramLines, bodyBuilder, arg_0), 1, null);
        bodyBuilder.line(")");
        bodyBuilder.line("// Notify listeners that tables have changed");
        if (this$0.debug) {
            bodyBuilder.line("sqliteNowLogger.d { \"notifyTablesChanged -> \" + " + capitalizedNamespace + "." + className + ".affectedTables.joinToString(\", \") }");
        }
        bodyBuilder.line("ref.notifyTablesChanged(" + capitalizedNamespace + "." + className + ".affectedTables)");
        bodyBuilder.line("return result");
        return bodyBuilder.build();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J=\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004J\n\u0010 \u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006!"}, d2={"Ldev/goquick/sqlitenow/gradle/database/DatabaseCodeGenerator$UniqueAdapter;", "", "functionName", "", "inputType", "Lcom/squareup/kotlinpoet/TypeName;", "outputType", "isNullable", "", "providerNamespace", "<init>", "(Ljava/lang/String;Lcom/squareup/kotlinpoet/TypeName;Lcom/squareup/kotlinpoet/TypeName;ZLjava/lang/String;)V", "getFunctionName", "()Ljava/lang/String;", "getInputType", "()Lcom/squareup/kotlinpoet/TypeName;", "getOutputType", "()Z", "getProviderNamespace", "toParameterSpec", "Lcom/squareup/kotlinpoet/ParameterSpec;", "signatureKey", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "sqlitenow-gradle-plugin"})
    public static final class UniqueAdapter {
        @NotNull
        private final String functionName;
        @NotNull
        private final TypeName inputType;
        @NotNull
        private final TypeName outputType;
        private final boolean isNullable;
        @Nullable
        private final String providerNamespace;

        public UniqueAdapter(@NotNull String functionName, @NotNull TypeName inputType, @NotNull TypeName outputType, boolean isNullable, @Nullable String providerNamespace) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)inputType, (String)"inputType");
            Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
            this.functionName = functionName;
            this.inputType = inputType;
            this.outputType = outputType;
            this.isNullable = isNullable;
            this.providerNamespace = providerNamespace;
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        @NotNull
        public final TypeName getInputType() {
            return this.inputType;
        }

        @NotNull
        public final TypeName getOutputType() {
            return this.outputType;
        }

        public final boolean isNullable() {
            return this.isNullable;
        }

        @Nullable
        public final String getProviderNamespace() {
            return this.providerNamespace;
        }

        @NotNull
        public final ParameterSpec toParameterSpec() {
            TypeName[] typeNameArray = new TypeName[]{this.inputType};
            LambdaTypeName lambdaType = LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, null, (TypeName[])typeNameArray, (TypeName)this.outputType, (int)1, null);
            return ParameterSpec.Companion.builder(this.functionName, (TypeName)lambdaType, new KModifier[0]).build();
        }

        @NotNull
        public final String signatureKey() {
            return this.inputType + "__" + this.outputType;
        }

        @NotNull
        public final String component1() {
            return this.functionName;
        }

        @NotNull
        public final TypeName component2() {
            return this.inputType;
        }

        @NotNull
        public final TypeName component3() {
            return this.outputType;
        }

        public final boolean component4() {
            return this.isNullable;
        }

        @Nullable
        public final String component5() {
            return this.providerNamespace;
        }

        @NotNull
        public final UniqueAdapter copy(@NotNull String functionName, @NotNull TypeName inputType, @NotNull TypeName outputType, boolean isNullable, @Nullable String providerNamespace) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)inputType, (String)"inputType");
            Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
            return new UniqueAdapter(functionName, inputType, outputType, isNullable, providerNamespace);
        }

        public static /* synthetic */ UniqueAdapter copy$default(UniqueAdapter uniqueAdapter, String string, TypeName typeName, TypeName typeName2, boolean bl, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = uniqueAdapter.functionName;
            }
            if ((n & 2) != 0) {
                typeName = uniqueAdapter.inputType;
            }
            if ((n & 4) != 0) {
                typeName2 = uniqueAdapter.outputType;
            }
            if ((n & 8) != 0) {
                bl = uniqueAdapter.isNullable;
            }
            if ((n & 0x10) != 0) {
                string2 = uniqueAdapter.providerNamespace;
            }
            return uniqueAdapter.copy(string, typeName, typeName2, bl, string2);
        }

        @NotNull
        public String toString() {
            return "UniqueAdapter(functionName=" + this.functionName + ", inputType=" + this.inputType + ", outputType=" + this.outputType + ", isNullable=" + this.isNullable + ", providerNamespace=" + this.providerNamespace + ")";
        }

        public int hashCode() {
            int result = this.functionName.hashCode();
            result = result * 31 + this.inputType.hashCode();
            result = result * 31 + this.outputType.hashCode();
            result = result * 31 + Boolean.hashCode(this.isNullable);
            result = result * 31 + (this.providerNamespace == null ? 0 : this.providerNamespace.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UniqueAdapter)) {
                return false;
            }
            UniqueAdapter uniqueAdapter = (UniqueAdapter)other;
            if (!Intrinsics.areEqual((Object)this.functionName, (Object)uniqueAdapter.functionName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.inputType, (Object)uniqueAdapter.inputType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputType, (Object)uniqueAdapter.outputType)) {
                return false;
            }
            if (this.isNullable != uniqueAdapter.isNullable) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.providerNamespace, (Object)uniqueAdapter.providerNamespace);
        }
    }
}

