/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.generator.data;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import dev.goquick.sqlitenow.gradle.LoggerKt;
import dev.goquick.sqlitenow.gradle.context.GeneratorContext;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructJoinedEmitter;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructPropertyEmitter;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructResultEmitter;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructResultFileEmitter;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructUtils;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedExecuteStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.processing.FieldAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.processing.FieldAnnotationResolver;
import dev.goquick.sqlitenow.gradle.processing.PropertyNameGeneratorType;
import dev.goquick.sqlitenow.gradle.processing.SharedResultManager;
import dev.goquick.sqlitenow.gradle.processing.StatementAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.processing.StatementProcessingHelper;
import dev.goquick.sqlitenow.gradle.processing.StatementProcessor;
import dev.goquick.sqlitenow.gradle.processing.StatementUtils;
import dev.goquick.sqlitenow.gradle.sqlinspect.AssociatedColumn;
import dev.goquick.sqlitenow.gradle.sqlinspect.CreateTableStatementExecutor;
import dev.goquick.sqlitenow.gradle.sqlinspect.CreateViewStatementExecutor;
import dev.goquick.sqlitenow.gradle.sqlinspect.DeferredStatementExecutor;
import dev.goquick.sqlitenow.gradle.sqlinspect.DeleteStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.ExecuteStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.InsertStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.SelectStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.UpdateStatement;
import dev.goquick.sqlitenow.gradle.util.FileGenerationHelper;
import dev.goquick.sqlitenow.gradle.util.SqliteTypeToKotlinCodeConverter;
import dev.goquick.sqlitenow.gradle.util.StringUtilsKt;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001]BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\r2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020=0\rH\u0002J\u0016\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J \u0010B\u001a\u00020C2\u0006\u0010A\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010D\u001a\u00020.H\u0002J\u0006\u0010E\u001a\u00020FJ\u0012\u0010G\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020.H\u0002J\u0016\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u00072\u0006\u0010D\u001a\u00020.J\u001a\u0010K\u001a\u0004\u0018\u00010\u00072\u0006\u0010J\u001a\u00020\u00072\u0006\u0010D\u001a\u00020.H\u0002J\u0010\u0010L\u001a\u00020\u00072\u0006\u0010D\u001a\u00020.H\u0002J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010D\u001a\u00020.H\u0002J$\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010O\u001a\u00020\u00072\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00070QH\u0002J\u001e\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020$H\u0002J,\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010V\u001a\u00020\u00072\u0006\u0010T\u001a\u00020$2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00070QH\u0002J\u001a\u0010X\u001a\u0004\u0018\u00010Y2\u0006\u0010D\u001a\u00020.2\u0006\u0010J\u001a\u00020\u0007H\u0002J\u0012\u0010Z\u001a\u00020I2\b\u0010[\u001a\u0004\u0018\u00010\\H\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001a0\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020 0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010!\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020$0#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001a0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\r0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001cR\u0014\u00100\u001a\u000201X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Ldev/goquick/sqlitenow/gradle/generator/data/DataStructCodeGenerator;", "", "conn", "Ljava/sql/Connection;", "queriesDir", "Ljava/io/File;", "packageName", "", "outputDir", "statementExecutors", "", "Ldev/goquick/sqlitenow/gradle/sqlinspect/DeferredStatementExecutor;", "providedCreateTableStatements", "", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateTableStatement;", "<init>", "(Ljava/sql/Connection;Ljava/io/File;Ljava/lang/String;Ljava/io/File;Ljava/util/List;Ljava/util/List;)V", "createTableStatements", "getCreateTableStatements", "()Ljava/util/List;", "createViewStatements", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateViewStatement;", "getCreateViewStatements", "createViewStatementsByName", "", "viewTableDependencies", "", "getViewTableDependencies", "()Ljava/util/Map;", "viewTableDependencies$delegate", "Lkotlin/Lazy;", "cascadeNotifyByTable", "Ldev/goquick/sqlitenow/gradle/processing/StatementAnnotationOverrides$CascadeNotify;", "cascadeClosureCache", "", "Lkotlin/Pair;", "Ldev/goquick/sqlitenow/gradle/processing/StatementAnnotationOverrides$CascadeAction;", "annotationResolver", "Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationResolver;", "fileGenerationHelper", "Ldev/goquick/sqlitenow/gradle/util/FileGenerationHelper;", "stmtProcessingHelper", "Ldev/goquick/sqlitenow/gradle/processing/StatementProcessingHelper;", "sharedResultManager", "Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager;", "nsWithStatements", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedStatement;", "getNsWithStatements", "generatorContext", "Ldev/goquick/sqlitenow/gradle/context/GeneratorContext;", "getGeneratorContext$sqlitenow_gradle_plugin", "()Ldev/goquick/sqlitenow/gradle/context/GeneratorContext;", "propertyEmitter", "Ldev/goquick/sqlitenow/gradle/generator/data/DataStructPropertyEmitter;", "joinedEmitter", "Ldev/goquick/sqlitenow/gradle/generator/data/DataStructJoinedEmitter;", "resultEmitter", "Ldev/goquick/sqlitenow/gradle/generator/data/DataStructResultEmitter;", "resultFileEmitter", "Ldev/goquick/sqlitenow/gradle/generator/data/DataStructResultFileEmitter;", "sortViewsByDependencies", "Ldev/goquick/sqlitenow/gradle/sqlinspect/CreateViewStatementExecutor;", "viewExecutors", "generateNamespaceDataStructuresCode", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "namespace", "generateQueryObject", "Lcom/squareup/kotlinpoet/TypeSpec;", "statement", "generateCode", "", "generateParameterDefinitions", "inferParameterType", "Lcom/squareup/kotlinpoet/TypeName;", "paramName", "getCastTypeForParameter", "getSqlFromStatement", "getAffectedTablesFromStatement", "resolveViewDependencies", "viewName", "seen", "", "cascadeTablesFor", "tableName", "action", "computeCascadeClosure", "startTable", "visited", "getAssociatedColumn", "Ldev/goquick/sqlitenow/gradle/sqlinspect/AssociatedColumn;", "handleCollectionParameterType", "column", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateTableStatement$Column;", "ParameterDescriptor", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDataStructCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataStructCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/generator/data/DataStructCodeGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,605:1\n808#2,11:606\n1563#2:617\n1634#2,3:618\n808#2,11:621\n1563#2:632\n1634#2,3:633\n1208#2,2:636\n1236#2,4:638\n1869#2,2:642\n1208#2,2:644\n1236#2,4:646\n1869#2,2:651\n1869#2:653\n774#2:654\n865#2,2:655\n1869#2:657\n1870#2:665\n1870#2:666\n1869#2,2:674\n1563#2:676\n1634#2,3:677\n774#2:680\n865#2,2:681\n1617#2,9:683\n1869#2:692\n1870#2:694\n1626#2:695\n1869#2,2:696\n1563#2:698\n1634#2,3:699\n1869#2,2:702\n1869#2,2:704\n1193#2,2:706\n1267#2,4:708\n1869#2,2:712\n1#3:650\n1#3:693\n382#4,7:658\n536#4:667\n521#4,6:668\n*S KotlinDebug\n*F\n+ 1 DataStructCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/generator/data/DataStructCodeGenerator\n*L\n65#1:606,11\n66#1:617\n66#1:618,3\n80#1:621,11\n82#1:632\n82#1:633,3\n98#1:636,2\n98#1:638,4\n109#1:642,2\n142#1:644,2\n142#1:646,4\n146#1:651,2\n148#1:653\n150#1:654\n150#1:655,2\n151#1:657\n151#1:665\n148#1:666\n162#1:674,2\n169#1:676\n169#1:677,3\n169#1:680\n169#1:681,2\n173#1:683,9\n173#1:692\n173#1:694\n173#1:695\n317#1:696,2\n366#1:698\n366#1:699,3\n521#1:702,2\n556#1:704,2\n101#1:706,2\n101#1:708,4\n453#1:712,2\n173#1:693\n152#1:658,7\n157#1:667\n157#1:668,6\n*E\n"})
public class DataStructCodeGenerator {
    @NotNull
    private final File outputDir;
    @NotNull
    private final List<AnnotatedCreateTableStatement> createTableStatements;
    @NotNull
    private final List<AnnotatedCreateViewStatement> createViewStatements;
    @NotNull
    private final Map<String, AnnotatedCreateViewStatement> createViewStatementsByName;
    @NotNull
    private final Lazy viewTableDependencies$delegate;
    @NotNull
    private final Map<String, StatementAnnotationOverrides.CascadeNotify> cascadeNotifyByTable;
    @NotNull
    private final Map<Pair<String, StatementAnnotationOverrides.CascadeAction>, Set<String>> cascadeClosureCache;
    @NotNull
    private final FieldAnnotationResolver annotationResolver;
    @NotNull
    private final FileGenerationHelper fileGenerationHelper;
    @NotNull
    private final StatementProcessingHelper stmtProcessingHelper;
    @NotNull
    private final SharedResultManager sharedResultManager;
    @NotNull
    private final Map<String, List<AnnotatedStatement>> nsWithStatements;
    @NotNull
    private final GeneratorContext generatorContext;
    @NotNull
    private final DataStructPropertyEmitter propertyEmitter;
    @NotNull
    private final DataStructJoinedEmitter joinedEmitter;
    @NotNull
    private final DataStructResultEmitter resultEmitter;
    @NotNull
    private final DataStructResultFileEmitter resultFileEmitter;

    /*
     * WARNING - void declaration
     */
    public DataStructCodeGenerator(@NotNull Connection conn, @NotNull File queriesDir, @NotNull String packageName, @NotNull File outputDir, @NotNull List<DeferredStatementExecutor> statementExecutors, @Nullable List<AnnotatedCreateTableStatement> providedCreateTableStatements) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterator $this$mapTo$iv$iv;
        void $this$createViewStatements_u24lambda_u240;
        Object element$iv$iv3;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$map$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)queriesDir, (String)"queriesDir");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter(statementExecutors, (String)"statementExecutors");
        this.outputDir = outputDir;
        DataStructCodeGenerator dataStructCodeGenerator = this;
        List list = providedCreateTableStatements;
        if (list == null) {
            void $this$mapTo$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv2;
            Iterable $this$filterIsInstance$iv;
            object = statementExecutors;
            DataStructCodeGenerator dataStructCodeGenerator2 = dataStructCodeGenerator;
            boolean $i$f$filterIsInstance = false;
            void var9_13 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv2 instanceof CreateTableStatementExecutor)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                AnnotatedCreateTableStatement annotatedCreateTableStatement;
                void it;
                CreateTableStatementExecutor createTableStatementExecutor = (CreateTableStatementExecutor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                try {
                    AnnotatedStatement annotatedStatement = it.execute(conn);
                    Intrinsics.checkNotNull((Object)annotatedStatement, (String)"null cannot be cast to non-null type dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement");
                    annotatedCreateTableStatement = (AnnotatedCreateTableStatement)annotatedStatement;
                }
                catch (Exception e) {
                    LoggerKt.getLogger().error(StringsKt.trimMargin$default((String)("|\n                    |Failed to execute CREATE TABLE statement:\n                    |" + it.reportContext() + "\n                    "), null, (int)1, null));
                    throw e;
                }
                collection.add(annotatedCreateTableStatement);
            }
            list = (List)destination$iv$iv;
            dataStructCodeGenerator = dataStructCodeGenerator2;
        }
        dataStructCodeGenerator.createTableStatements = list;
        DataStructCodeGenerator $i$f$map = this;
        DataStructCodeGenerator dataStructCodeGenerator3 = this;
        boolean bl = false;
        Iterable $this$filterIsInstance$iv = statementExecutors;
        boolean $i$f$filterIsInstance = false;
        Iterator iterator = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv3 instanceof CreateViewStatementExecutor)) continue;
            destination$iv$iv.add(element$iv$iv3);
        }
        List viewExecs = (List)destination$iv$iv;
        List<CreateViewStatementExecutor> sorted = super.sortViewsByDependencies(viewExecs);
        Iterable $this$map$iv2 = sorted;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        element$iv$iv3 = $this$mapTo$iv$iv.iterator();
        while (element$iv$iv3.hasNext()) {
            AnnotatedCreateViewStatement annotatedCreateViewStatement;
            void it;
            Object item$iv$iv = element$iv$iv3.next();
            CreateViewStatementExecutor createViewStatementExecutor = (CreateViewStatementExecutor)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            try {
                AnnotatedStatement annotatedStatement = it.execute(conn);
                Intrinsics.checkNotNull((Object)annotatedStatement, (String)"null cannot be cast to non-null type dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement");
                annotatedCreateViewStatement = (AnnotatedCreateViewStatement)annotatedStatement;
            }
            catch (Exception e) {
                LoggerKt.getLogger().error(StringsKt.trimIndent((String)("\n                    |Failed to execute CREATE VIEW statement:\n                    |" + it.reportContext() + "\n                    ")));
                throw e;
            }
            collection.add(annotatedCreateViewStatement);
        }
        dataStructCodeGenerator3.createViewStatements = (List)destination$iv$iv2;
        $this$map$iv = this.createViewStatements;
        DataStructCodeGenerator dataStructCodeGenerator4 = this;
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        sorted = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv4 : $this$associateByTo$iv$iv) {
            void it;
            AnnotatedCreateViewStatement $i$f$mapTo2 = (AnnotatedCreateViewStatement)element$iv$iv4;
            Map map = destination$iv$iv3;
            boolean bl3 = false;
            String string = it.getSrc().getViewName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            map.put(string, element$iv$iv4);
        }
        dataStructCodeGenerator4.createViewStatementsByName = destination$iv$iv3;
        this.viewTableDependencies$delegate = LazyKt.lazy(() -> DataStructCodeGenerator.viewTableDependencies_delegate$lambda$0(this));
        Object $i$f$associateBy22 = object = MapsKt.createMapBuilder();
        dataStructCodeGenerator4 = this;
        boolean bl4 = false;
        Iterable $this$forEach$iv = this.getCreateTableStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatementAnnotationOverrides.CascadeNotify cascade;
            void $this$cascadeNotifyByTable_u24lambda_u240;
            AnnotatedCreateTableStatement table = (AnnotatedCreateTableStatement)element$iv;
            boolean bl5 = false;
            if (table.getAnnotations().getCascadeNotify() == null) continue;
            String string = table.getSrc().getTableName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            $this$cascadeNotifyByTable_u24lambda_u240.put(string, cascade);
        }
        dataStructCodeGenerator4.cascadeNotifyByTable = MapsKt.build((Map)object);
        this.cascadeClosureCache = new LinkedHashMap();
        this.annotationResolver = new FieldAnnotationResolver(this.getCreateTableStatements(), this.createViewStatements);
        this.fileGenerationHelper = new FileGenerationHelper(packageName, this.outputDir);
        this.stmtProcessingHelper = new StatementProcessingHelper(conn, this.annotationResolver);
        this.sharedResultManager = new SharedResultManager();
        this.nsWithStatements = this.stmtProcessingHelper.processQueriesDirectory(queriesDir);
        this.generatorContext = new GeneratorContext(packageName, this.outputDir, this.getCreateTableStatements(), this.createViewStatements, this.nsWithStatements);
        this.propertyEmitter = new DataStructPropertyEmitter();
        this.joinedEmitter = new DataStructJoinedEmitter(this.generatorContext);
        this.resultEmitter = new DataStructResultEmitter(this.generatorContext, this.propertyEmitter);
        this.resultFileEmitter = new DataStructResultFileEmitter(this.generatorContext, this.joinedEmitter, this.resultEmitter, this.outputDir);
    }

    public /* synthetic */ DataStructCodeGenerator(Connection connection, File file, String string, File file2, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            list2 = null;
        }
        this(connection, file, string, file2, list, list2);
    }

    @NotNull
    public List<AnnotatedCreateTableStatement> getCreateTableStatements() {
        return this.createTableStatements;
    }

    @NotNull
    public final List<AnnotatedCreateViewStatement> getCreateViewStatements() {
        return this.createViewStatements;
    }

    private final Map<String, Set<String>> getViewTableDependencies() {
        Lazy lazy = this.viewTableDependencies$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Map<String, List<AnnotatedStatement>> getNsWithStatements() {
        return this.nsWithStatements;
    }

    @NotNull
    public final GeneratorContext getGeneratorContext$sqlitenow_gradle_plugin() {
        return this.generatorContext;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CreateViewStatementExecutor> sortViewsByDependencies(List<CreateViewStatementExecutor> viewExecutors) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        Object element$iv;
        Object element$iv22;
        Object object;
        Map $this$associateByTo$iv$iv;
        if (viewExecutors.size() <= 1) {
            return viewExecutors;
        }
        Iterable $this$associateBy$iv = viewExecutors;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Iterator it;
            Object element$iv$iv = iterator.next();
            CreateViewStatementExecutor createViewStatementExecutor = (CreateViewStatementExecutor)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(((CreateViewStatementExecutor)((Object)it)).viewName(), element$iv$iv);
        }
        Map nameToExec = destination$iv$iv;
        Set viewNames = CollectionsKt.toSet((Iterable)nameToExec.keySet());
        Map adj = new LinkedHashMap();
        Map $this$sortViewsByDependencies_u24lambda_u241 = $this$associateByTo$iv$iv = (Map)new LinkedHashMap();
        boolean bl = false;
        Iterable $this$forEach$iv = viewNames;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            String it = (String)element$iv3;
            boolean bl2 = false;
            $this$sortViewsByDependencies_u24lambda_u241.put(it, 0);
        }
        Map indeg = $this$associateByTo$iv$iv;
        Iterable $this$forEach$iv2 = viewExecutors;
        boolean $i$f$forEach2 = false;
        for (Object element$iv22 : $this$forEach$iv2) {
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv2;
            CreateViewStatementExecutor exec = (CreateViewStatementExecutor)element$iv22;
            boolean bl3 = false;
            String v = exec.viewName();
            Iterable $this$filter$iv = exec.referencedTableOrViewNames();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                if (!viewNames.contains(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List deps = (List)destination$iv$iv2;
            Iterable $this$forEach$iv3 = deps;
            boolean $i$f$forEach3 = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv3.iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                Object object2;
                Map $this$getOrPut$iv;
                element$iv = $this$filterTo$iv$iv2.next();
                String dep = (String)element$iv;
                boolean bl5 = false;
                element$iv$iv = adj;
                Object key$iv = dep;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl6 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((List)object2).add(v);
                $this$getOrPut$iv = indeg;
                Integer n = (Integer)indeg.get(v);
                key$iv = (n != null ? n : 0) + 1;
                $this$getOrPut$iv.put(v, key$iv);
            }
        }
        Map $this$filter$iv = indeg;
        boolean $i$f$filter = false;
        element$iv22 = $this$filter$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator v = $this$filterTo$iv$iv.entrySet().iterator();
        while (v.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = v.next();
            boolean bl7 = false;
            if (!(((Number)it.getValue()).intValue() == 0)) continue;
            destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Collection collection = destination$iv$iv3.keySet();
        ArrayDeque queue = new ArrayDeque(collection);
        List orderedNames = new ArrayList();
        while (!((Collection)queue).isEmpty()) {
            String u = (String)queue.removeFirst();
            orderedNames.add(u);
            List list = (List)adj.get(u);
            if (list == null) continue;
            Iterable $this$forEach$iv4 = list;
            boolean $i$f$forEach4 = false;
            for (Map.Entry element$iv4 : $this$forEach$iv4) {
                String w = (String)((Object)element$iv4);
                boolean bl8 = false;
                element$iv = indeg;
                Integer n = (Integer)indeg.get(w);
                Integer dep = (n != null ? n : 0) - 1;
                element$iv.put((String)w, (Integer)dep);
                Integer n2 = (Integer)indeg.get(w);
                if ((n2 != null ? n2 : 0) != 0) continue;
                queue.add((Object)w);
            }
        }
        if (orderedNames.size() < viewExecutors.size()) {
            void $this$filterTo$iv$iv3;
            void $this$filter$iv2;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = viewExecutors;
            boolean $i$f$map = false;
            Iterable $i$f$forEach4 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                element$iv = (CreateViewStatementExecutor)item$iv$iv;
                object = destination$iv$iv4;
                boolean bl9 = false;
                object.add(((CreateViewStatementExecutor)((Object)it)).viewName());
            }
            $this$map$iv = (List)destination$iv$iv4;
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv2;
            destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                it = (String)element$iv$iv;
                boolean bl10 = false;
                if (!(!orderedNames.contains(it))) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List remaining = (List)destination$iv$iv4;
            orderedNames.addAll(remaining);
        }
        Iterable $this$mapNotNull$iv = orderedNames;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$filter2 = $this$mapNotNull$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach5 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            CreateViewStatementExecutor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl11 = false;
            String it = (String)element$iv$iv;
            boolean bl12 = false;
            if ((CreateViewStatementExecutor)nameToExec.get(it) == null) continue;
            boolean bl13 = false;
            destination$iv$iv5.add(it$iv$iv);
        }
        return (List)destination$iv$iv5;
    }

    @NotNull
    public final FileSpec.Builder generateNamespaceDataStructuresCode(@NotNull String namespace, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String fileName = StringUtilsKt.pascalize(namespace) + "Query";
        Object[] objectArray = new String[]{"Suppress"};
        ClassName className = new ClassName("kotlin", (String[])objectArray);
        objectArray = new Object[]{"UNNECESSARY_NOT_NULL_ASSERTION"};
        FileSpec.Builder builder = FileSpec.Companion.builder(packageName, fileName).addFileComment("Generated code for " + namespace + " namespace queries", new Object[0]).addFileComment("\nDo not modify this file manually", new Object[0]).addAnnotation(AnnotationSpec.Companion.builder(className).addMember("%S", objectArray).build());
        objectArray = new String[]{"OptIn"};
        ClassName className2 = new ClassName("kotlin", (String[])objectArray);
        objectArray = new Object[1];
        String[] stringArray = new String[]{"ExperimentalUuidApi"};
        objectArray[0] = new ClassName("kotlin.uuid", stringArray);
        FileSpec.Builder fileSpecBuilder = builder.addAnnotation(AnnotationSpec.Companion.builder(className2).addMember("%T::class", objectArray).build());
        String capitalizedNamespace = StringUtilsKt.pascalize(namespace) + "Query";
        TypeSpec.Builder namespaceObject = TypeSpec.Companion.objectBuilder(capitalizedNamespace).addKdoc("Contains queries for the " + namespace + " namespace", new Object[0]);
        List list = this.nsWithStatements.get(namespace);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List allStatements = list;
        StatementProcessor statementProcessor = new StatementProcessor(allStatements);
        Map sharedResultsWithContext = new LinkedHashMap();
        statementProcessor.processStatements((Function1<? super AnnotatedSelectStatement, Unit>)((Function1)arg_0 -> DataStructCodeGenerator.generateNamespaceDataStructuresCode$lambda$0(this, namespace, sharedResultsWithContext, packageName, namespaceObject, arg_0)), (Function1<? super AnnotatedExecuteStatement, Unit>)((Function1)arg_0 -> DataStructCodeGenerator.generateNamespaceDataStructuresCode$lambda$1(this, namespace, packageName, namespaceObject, arg_0)));
        statementProcessor.processStatements((Function1<? super AnnotatedSelectStatement, Unit>)((Function1)arg_0 -> DataStructCodeGenerator.generateNamespaceDataStructuresCode$lambda$2(this, namespace, packageName, arg_0)), (Function1<? super AnnotatedExecuteStatement, Unit>)((Function1)arg_0 -> DataStructCodeGenerator.generateNamespaceDataStructuresCode$lambda$3(this, namespace, packageName, arg_0)));
        fileSpecBuilder.addType(namespaceObject.build());
        return fileSpecBuilder;
    }

    private final TypeSpec generateQueryObject(String namespace, String packageName, AnnotatedStatement statement) {
        TypeSpec.Builder queryObjectBuilder;
        block0: {
            String className = statement.getDataClassName();
            queryObjectBuilder = TypeSpec.Companion.objectBuilder(className).addKdoc("Contains SQL, parameters, and result types for the " + statement.getName() + " query.", new Object[0]);
            String sql = this.getSqlFromStatement(statement);
            Object[] objectArray = new KModifier[]{KModifier.CONST};
            PropertySpec.Builder builder = PropertySpec.Companion.builder("SQL", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).addModifiers((KModifier[])objectArray);
            objectArray = new Object[]{sql};
            PropertySpec sqlProperty = builder.initializer("%S", objectArray).addKdoc("The SQL query string for " + statement.getName() + ".", new Object[0]).build();
            queryObjectBuilder.addProperty(sqlProperty);
            Set<String> affectedTables = this.getAffectedTablesFromStatement(statement);
            String[] stringArray = new String[]{"Set"};
            ClassName className2 = new ClassName("kotlin.collections", stringArray);
            stringArray = new TypeName[1];
            Object[] objectArray2 = new String[]{"String"};
            stringArray[0] = new ClassName("kotlin", (String[])objectArray2);
            ParameterizedTypeName affectedTablesType = ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray);
            objectArray2 = new Object[]{CollectionsKt.joinToString$default((Iterable)affectedTables, (CharSequence)", ", null, null, (int)0, null, DataStructCodeGenerator::generateQueryObject$lambda$0, (int)30, null)};
            PropertySpec affectedTablesProperty = PropertySpec.Companion.builder("affectedTables", (TypeName)affectedTablesType, new KModifier[0]).initializer("setOf(%L)", objectArray2).addKdoc("Set of table names that are affected by the " + statement.getName() + " query.", new Object[0]).build();
            queryObjectBuilder.addProperty(affectedTablesProperty);
            TypeSpec typeSpec = this.generateParameterDefinitions(statement);
            if (typeSpec == null) break block0;
            TypeSpec paramsType = typeSpec;
            boolean bl = false;
            queryObjectBuilder.addType(paramsType);
        }
        return queryObjectBuilder.build();
    }

    public final void generateCode() {
        this.fileGenerationHelper.generateFiles(this.nsWithStatements.keySet(), (Function2<? super String, ? super String, FileSpec.Builder>)((Function2)(arg_0, arg_1) -> DataStructCodeGenerator.generateCode$lambda$0(this, arg_0, arg_1)));
    }

    private final TypeSpec generateParameterDefinitions(AnnotatedStatement statement) {
        Set<String> uniqueParams = StatementUtils.INSTANCE.getAllNamedParameters(statement);
        if (uniqueParams.isEmpty()) {
            return null;
        }
        KModifier[] kModifierArray = new KModifier[]{KModifier.DATA};
        TypeSpec.Builder paramClassBuilder = TypeSpec.Companion.classBuilder("Params").addModifiers(kModifierArray).addKdoc("Data class for " + statement.getName() + " query parameters.", new Object[0]);
        FunSpec.Builder paramConstructorBuilder = FunSpec.Companion.constructorBuilder();
        PropertyNameGeneratorType propertyNameGeneratorType = statement.getAnnotations().getPropertyNameGenerator();
        List paramCollectedProps = new ArrayList();
        List descriptors = new ArrayList();
        Iterable $this$forEach$iv = uniqueParams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String paramName = (String)element$iv;
            boolean bl = false;
            String propertyName = propertyNameGeneratorType.convertToPropertyName(paramName);
            TypeName propertyType = this.inferParameterType(paramName, statement);
            ParameterSpec parameter = ParameterSpec.Companion.builder(propertyName, propertyType, new KModifier[0]).build();
            paramConstructorBuilder.addParameter(parameter);
            PropertySpec property = PropertySpec.Companion.builder(propertyName, propertyType, new KModifier[0]).initializer(propertyName, new Object[0]).build();
            paramCollectedProps.add(property);
            paramClassBuilder.addProperty(property);
            ((Collection)descriptors).add(new ParameterDescriptor(propertyName, propertyType, propertyType.isNullable()));
        }
        paramClassBuilder.primaryConstructor(paramConstructorBuilder.build());
        DataStructUtils.INSTANCE.addArraySafeEqualsAndHashCodeIfNeeded(paramClassBuilder, "Params", paramCollectedProps);
        return paramClassBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeName inferParameterType(@NotNull String paramName, @NotNull AnnotatedStatement statement) {
        SelectStatement selectStmt;
        AnnotatedCreateTableStatement.Column column;
        String castType;
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        if (statement instanceof AnnotatedExecuteStatement) {
            ExecuteStatement execStmt = ((AnnotatedExecuteStatement)statement).getSrc();
            for (SelectStatement withSelectStatement : execStmt.getWithSelectStatements()) {
                Collection<AnnotatedSelectStatement.Field> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (!withSelectStatement.getNamedParameters().contains(paramName)) continue;
                Iterable iterable = withSelectStatement.getFields();
                StatementAnnotationOverrides statementAnnotationOverrides = new StatementAnnotationOverrides(null, ((AnnotatedExecuteStatement)statement).getAnnotations().getPropertyNameGenerator(), null, null, false, null, null, null, 240, null);
                SelectStatement selectStatement = withSelectStatement;
                String string = "withClause";
                boolean $i$f$map = false;
                void var9_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void field;
                    SelectStatement.FieldSource fieldSource = (SelectStatement.FieldSource)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new AnnotatedSelectStatement.Field((SelectStatement.FieldSource)field, FieldAnnotationOverrides.Companion.parse(MapsKt.emptyMap()), null, 4, null));
                }
                collection = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 16;
                String string2 = null;
                Collection<AnnotatedSelectStatement.Field> collection2 = collection;
                StatementAnnotationOverrides statementAnnotationOverrides2 = statementAnnotationOverrides;
                SelectStatement selectStatement2 = selectStatement;
                String string3 = string;
                AnnotatedSelectStatement annotatedWithSelectStatement = new AnnotatedSelectStatement(string3, selectStatement2, statementAnnotationOverrides2, (List)collection2, string2, n, defaultConstructorMarker);
                return this.inferParameterType(paramName, annotatedWithSelectStatement);
            }
        }
        if ((castType = this.getCastTypeForParameter(paramName, statement)) != null) {
            return SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(castType);
        }
        AssociatedColumn associatedColumn = this.getAssociatedColumn(statement, paramName);
        if (associatedColumn instanceof AssociatedColumn.Collection) {
            column = this.generatorContext.getColumnLookup().findColumnForParameter(statement, paramName);
            return this.handleCollectionParameterType(column);
        }
        if (statement instanceof AnnotatedSelectStatement && (Intrinsics.areEqual((Object)paramName, (Object)(selectStmt = ((AnnotatedSelectStatement)statement).getSrc()).getLimitNamedParam()) || Intrinsics.areEqual((Object)paramName, (Object)selectStmt.getOffsetNamedParam()))) {
            String[] annotatedWithSelectStatement = new String[]{"Long"};
            return (TypeName)new ClassName("kotlin", annotatedWithSelectStatement);
        }
        column = this.generatorContext.getColumnLookup().findColumnForParameter(statement, paramName);
        if (column != null) {
            TypeName baseType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(column.getSrc().getDataType());
            Object $i$f$map = column.getAnnotations().get("propertyType");
            String propertyType = $i$f$map instanceof String ? (String)$i$f$map : null;
            boolean isNullable = column.isNullable();
            return SqliteTypeToKotlinCodeConverter.Companion.determinePropertyType(baseType, propertyType, isNullable, this.fileGenerationHelper.getPackageName());
        }
        String[] stringArray = new String[]{"String"};
        return (TypeName)new ClassName("kotlin", stringArray);
    }

    private final String getCastTypeForParameter(String paramName, AnnotatedStatement statement) {
        AnnotatedStatement annotatedStatement = statement;
        return annotatedStatement instanceof AnnotatedSelectStatement ? ((AnnotatedSelectStatement)statement).getSrc().getParameterCastTypes().get(paramName) : (annotatedStatement instanceof AnnotatedExecuteStatement ? ((AnnotatedExecuteStatement)statement).getSrc().getParameterCastTypes().get(paramName) : null);
    }

    private final String getSqlFromStatement(AnnotatedStatement statement) {
        String string;
        AnnotatedStatement annotatedStatement = statement;
        if (annotatedStatement instanceof AnnotatedSelectStatement) {
            string = ((AnnotatedSelectStatement)statement).getSrc().getSql();
        } else if (annotatedStatement instanceof AnnotatedExecuteStatement) {
            string = ((AnnotatedExecuteStatement)statement).getSrc().getSql();
        } else if (annotatedStatement instanceof AnnotatedCreateTableStatement) {
            string = ((AnnotatedCreateTableStatement)statement).getSrc().getSql();
        } else if (annotatedStatement instanceof AnnotatedCreateViewStatement) {
            string = ((AnnotatedCreateViewStatement)statement).getSrc().getSql();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final Set<String> getAffectedTablesFromStatement(AnnotatedStatement statement) {
        Set<String> set;
        AnnotatedStatement annotatedStatement = statement;
        if (annotatedStatement instanceof AnnotatedSelectStatement) {
            Set tables = new LinkedHashSet();
            String string = ((AnnotatedSelectStatement)statement).getSrc().getFromTable();
            if (string != null) {
                String it = string;
                boolean bl = false;
                tables.add(it);
            }
            tables.addAll((Collection)((AnnotatedSelectStatement)statement).getSrc().getJoinTables());
            set = DataStructCodeGenerator.getAffectedTablesFromStatement$expandTables(this, tables);
        } else if (annotatedStatement instanceof AnnotatedExecuteStatement) {
            Set<String> set2;
            String baseTable = ((AnnotatedExecuteStatement)statement).getSrc().getTable();
            ExecuteStatement executeStatement = ((AnnotatedExecuteStatement)statement).getSrc();
            if (executeStatement instanceof InsertStatement) {
                set2 = this.cascadeTablesFor(baseTable, StatementAnnotationOverrides.CascadeAction.INSERT);
            } else if (executeStatement instanceof UpdateStatement) {
                set2 = this.cascadeTablesFor(baseTable, StatementAnnotationOverrides.CascadeAction.UPDATE);
            } else if (executeStatement instanceof DeleteStatement) {
                set2 = this.cascadeTablesFor(baseTable, StatementAnnotationOverrides.CascadeAction.DELETE);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Set<String> cascadeTables = set2;
            set = DataStructCodeGenerator.getAffectedTablesFromStatement$expandTables(this, SetsKt.plus((Set)SetsKt.setOf((Object)baseTable), (Iterable)cascadeTables));
        } else if (annotatedStatement instanceof AnnotatedCreateTableStatement) {
            set = SetsKt.setOf((Object)((AnnotatedCreateTableStatement)statement).getSrc().getTableName());
        } else if (annotatedStatement instanceof AnnotatedCreateViewStatement) {
            set = SetsKt.emptySet();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set;
    }

    private final Set<String> resolveViewDependencies(String viewName, Set<String> seen) {
        List list;
        if (!seen.add(viewName)) {
            return SetsKt.emptySet();
        }
        AnnotatedCreateViewStatement annotatedCreateViewStatement = this.createViewStatementsByName.get(viewName);
        if (annotatedCreateViewStatement == null) {
            return SetsKt.emptySet();
        }
        AnnotatedCreateViewStatement view = annotatedCreateViewStatement;
        Set dependencies = new LinkedHashSet();
        SelectStatement select = view.getSrc().getSelectStatement();
        List $this$resolveViewDependencies_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        String string = select.getFromTable();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$resolveViewDependencies_u24lambda_u240.add(it);
        }
        $this$resolveViewDependencies_u24lambda_u240.addAll((Collection)select.getJoinTables());
        List referencedTables = CollectionsKt.build((List)list);
        Iterable $this$forEach$iv = referencedTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key;
            String table = (String)element$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)table.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            ((Collection)dependencies).add(key);
            CollectionsKt.addAll((Collection)dependencies, (Iterable)this.resolveViewDependencies(key, seen));
        }
        return dependencies;
    }

    private final Set<String> cascadeTablesFor(String tableName, StatementAnnotationOverrides.CascadeAction action) {
        String string = tableName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowercase = string;
        Pair cacheKey = TuplesKt.to((Object)lowercase, (Object)((Object)action));
        Set<String> set = this.cascadeClosureCache.get(cacheKey);
        if (set != null) {
            Set<String> it = set;
            boolean bl = false;
            return it;
        }
        Set<String> closure = this.computeCascadeClosure(lowercase, action, new LinkedHashSet());
        this.cascadeClosureCache.put((Pair<String, StatementAnnotationOverrides.CascadeAction>)cacheKey, closure);
        return closure;
    }

    private final Set<String> computeCascadeClosure(String startTable, StatementAnnotationOverrides.CascadeAction action, Set<String> visited) {
        Set<String> direct;
        if (!visited.add(startTable)) {
            return SetsKt.emptySet();
        }
        Object object = this.cascadeNotifyByTable.get(startTable);
        if (object == null || (object = ((StatementAnnotationOverrides.CascadeNotify)object).tablesFor(action)) == null) {
            object = SetsKt.emptySet();
        }
        if ((direct = object).isEmpty()) {
            return SetsKt.emptySet();
        }
        Set result = new LinkedHashSet();
        Iterable $this$forEach$iv = direct;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String child;
            String childRaw = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)childRaw.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (!result.add(child)) continue;
            CollectionsKt.addAll((Collection)result, (Iterable)this.computeCascadeClosure(child, action, visited));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final AssociatedColumn getAssociatedColumn(AnnotatedStatement statement, String paramName) {
        AssociatedColumn associatedColumn;
        AnnotatedStatement annotatedStatement = statement;
        if (annotatedStatement instanceof AnnotatedExecuteStatement) {
            ExecuteStatement src = ((AnnotatedExecuteStatement)statement).getSrc();
            if (src instanceof DeleteStatement) {
                associatedColumn = ((DeleteStatement)src).getNamedParametersToColumns().get(paramName);
                return associatedColumn;
            }
            if (src instanceof UpdateStatement) {
                associatedColumn = ((UpdateStatement)src).getNamedParametersToColumns().get(paramName);
                return associatedColumn;
            }
            if (!(src instanceof InsertStatement)) throw new NoWhenBranchMatchedException();
            return null;
        }
        if (!(annotatedStatement instanceof AnnotatedSelectStatement)) return null;
        associatedColumn = ((AnnotatedSelectStatement)statement).getSrc().getNamedParametersToColumns().get(paramName);
        return associatedColumn;
    }

    private final TypeName handleCollectionParameterType(AnnotatedCreateTableStatement.Column column) {
        if (column != null) {
            TypeName baseType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(column.getSrc().getDataType());
            Object object = column.getAnnotations().get("propertyType");
            String propertyType = object instanceof String ? (String)object : null;
            TypeName elementType = SqliteTypeToKotlinCodeConverter.Companion.determinePropertyType$default(SqliteTypeToKotlinCodeConverter.Companion, baseType, propertyType, column.isNullable(), null, 8, null);
            String[] stringArray = new String[]{"Collection"};
            ClassName className = new ClassName("kotlin.collections", stringArray);
            stringArray = new TypeName[]{elementType};
            return (TypeName)ParameterizedTypeName.Companion.get(className, (TypeName[])stringArray);
        }
        String[] stringArray = new String[]{"Collection"};
        ClassName className = new ClassName("kotlin.collections", stringArray);
        stringArray = new TypeName[1];
        String[] stringArray2 = new String[]{"String"};
        stringArray[0] = new ClassName("kotlin", stringArray2);
        return (TypeName)ParameterizedTypeName.Companion.get(className, (TypeName[])stringArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map viewTableDependencies_delegate$lambda$0(DataStructCodeGenerator this$0) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = this$0.createViewStatements;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            AnnotatedCreateViewStatement view = (AnnotatedCreateViewStatement)element$iv$iv;
            boolean bl = false;
            String string = view.getSrc().getViewName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Set<String> resolved = this$0.resolveViewDependencies(string, new LinkedHashSet());
            String string2 = view.getSrc().getViewName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            Pair pair = TuplesKt.to((Object)string2, resolved);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final Unit generateNamespaceDataStructuresCode$lambda$0(DataStructCodeGenerator this$0, String $namespace, Map $sharedResultsWithContext, String $packageName, TypeSpec.Builder $namespaceObject, AnnotatedSelectStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this$0.sharedResultManager.registerSharedResult(statement, $namespace);
        if (statement.getAnnotations().getQueryResult() != null) {
            $sharedResultsWithContext.put(statement.getAnnotations().getQueryResult(), statement);
        }
        TypeSpec queryObject = this$0.generateQueryObject($namespace, $packageName, statement);
        $namespaceObject.addType(queryObject);
        return Unit.INSTANCE;
    }

    private static final Unit generateNamespaceDataStructuresCode$lambda$1(DataStructCodeGenerator this$0, String $namespace, String $packageName, TypeSpec.Builder $namespaceObject, AnnotatedExecuteStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        TypeSpec queryObject = this$0.generateQueryObject($namespace, $packageName, statement);
        $namespaceObject.addType(queryObject);
        return Unit.INSTANCE;
    }

    private static final Unit generateNamespaceDataStructuresCode$lambda$2(DataStructCodeGenerator this$0, String $namespace, String $packageName, AnnotatedSelectStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this$0.resultFileEmitter.writeSelectResultFile(statement, $namespace, $packageName);
        if (statement.hasDynamicFieldMapping()) {
            this$0.resultFileEmitter.writeJoinedClassFile(statement, $namespace, $packageName);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateNamespaceDataStructuresCode$lambda$3(DataStructCodeGenerator this$0, String $namespace, String $packageName, AnnotatedExecuteStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        if (statement.hasReturningClause()) {
            this$0.resultFileEmitter.writeExecuteResultFile(statement, $namespace, $packageName);
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence generateQueryObject$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    private static final FileSpec.Builder generateCode$lambda$0(DataStructCodeGenerator this$0, String namespace, String packageName) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this$0.generateNamespaceDataStructuresCode(namespace, packageName);
    }

    private static final Set<String> getAffectedTablesFromStatement$expandTables(DataStructCodeGenerator this$0, Set<String> tables) {
        Set expanded = new LinkedHashSet();
        Iterable $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key;
            String table = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)table.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            ((Collection)expanded).add(key);
            Set<String> viewDeps = this$0.getViewTableDependencies().get(key);
            if (viewDeps == null) continue;
            CollectionsKt.addAll((Collection)expanded, (Iterable)viewDeps);
        }
        return expanded;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000e\u00a8\u0006\u0018"}, d2={"Ldev/goquick/sqlitenow/gradle/generator/data/DataStructCodeGenerator$ParameterDescriptor;", "", "propertyName", "", "type", "Lcom/squareup/kotlinpoet/TypeName;", "isNullable", "", "<init>", "(Ljava/lang/String;Lcom/squareup/kotlinpoet/TypeName;Z)V", "getPropertyName", "()Ljava/lang/String;", "getType", "()Lcom/squareup/kotlinpoet/TypeName;", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "sqlitenow-gradle-plugin"})
    private static final class ParameterDescriptor {
        @NotNull
        private final String propertyName;
        @NotNull
        private final TypeName type;
        private final boolean isNullable;

        public ParameterDescriptor(@NotNull String propertyName, @NotNull TypeName type, boolean isNullable) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.propertyName = propertyName;
            this.type = type;
            this.isNullable = isNullable;
        }

        @NotNull
        public final String getPropertyName() {
            return this.propertyName;
        }

        @NotNull
        public final TypeName getType() {
            return this.type;
        }

        public final boolean isNullable() {
            return this.isNullable;
        }

        @NotNull
        public final String component1() {
            return this.propertyName;
        }

        @NotNull
        public final TypeName component2() {
            return this.type;
        }

        public final boolean component3() {
            return this.isNullable;
        }

        @NotNull
        public final ParameterDescriptor copy(@NotNull String propertyName, @NotNull TypeName type, boolean isNullable) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new ParameterDescriptor(propertyName, type, isNullable);
        }

        public static /* synthetic */ ParameterDescriptor copy$default(ParameterDescriptor parameterDescriptor, String string, TypeName typeName, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameterDescriptor.propertyName;
            }
            if ((n & 2) != 0) {
                typeName = parameterDescriptor.type;
            }
            if ((n & 4) != 0) {
                bl = parameterDescriptor.isNullable;
            }
            return parameterDescriptor.copy(string, typeName, bl);
        }

        @NotNull
        public String toString() {
            return "ParameterDescriptor(propertyName=" + this.propertyName + ", type=" + this.type + ", isNullable=" + this.isNullable + ")";
        }

        public int hashCode() {
            int result = this.propertyName.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + Boolean.hashCode(this.isNullable);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParameterDescriptor)) {
                return false;
            }
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.propertyName, (Object)parameterDescriptor.propertyName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)parameterDescriptor.type)) {
                return false;
            }
            return this.isNullable == parameterDescriptor.isNullable;
        }
    }
}

