/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.processing;

import dev.goquick.sqlitenow.gradle.model.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.processing.PropertyNameGeneratorType;
import dev.goquick.sqlitenow.gradle.processing.SelectFieldCodeGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a8\u0006\u0017"}, d2={"Ldev/goquick/sqlitenow/gradle/processing/JoinedPropertyNameResolver;", "", "<init>", "()V", "computeNameMap", "", "Ldev/goquick/sqlitenow/gradle/processing/JoinedPropertyNameResolver$JoinedFieldKey;", "", "fields", "", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedSelectStatement$Field;", "propertyNameGenerator", "Ldev/goquick/sqlitenow/gradle/processing/PropertyNameGeneratorType;", "selectFieldGenerator", "Ldev/goquick/sqlitenow/gradle/processing/SelectFieldCodeGenerator;", "createUniqueName", "baseName", "tableAlias", "used", "", "sanitizeAliasPart", "raw", "JoinedFieldKey", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nJoinedPropertyNameResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JoinedPropertyNameResolver.kt\ndev/goquick/sqlitenow/gradle/processing/JoinedPropertyNameResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,96:1\n774#2:97\n865#2,2:98\n1869#2,2:100\n1#3:102\n975#4:103\n1046#4,3:104\n*S KotlinDebug\n*F\n+ 1 JoinedPropertyNameResolver.kt\ndev/goquick/sqlitenow/gradle/processing/JoinedPropertyNameResolver\n*L\n46#1:97\n46#1:98,2\n48#1:100,2\n87#1:103\n87#1:104,3\n*E\n"})
public final class JoinedPropertyNameResolver {
    @NotNull
    public static final JoinedPropertyNameResolver INSTANCE = new JoinedPropertyNameResolver();

    private JoinedPropertyNameResolver() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<JoinedFieldKey, String> computeNameMap(@NotNull List<AnnotatedSelectStatement.Field> fields, @NotNull PropertyNameGeneratorType propertyNameGenerator, @NotNull SelectFieldCodeGenerator selectFieldGenerator) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)((Object)propertyNameGenerator), (String)"propertyNameGenerator");
        Intrinsics.checkNotNullParameter((Object)selectFieldGenerator, (String)"selectFieldGenerator");
        LinkedHashMap<JoinedFieldKey, String> result = new LinkedHashMap<JoinedFieldKey, String>();
        HashSet used = new HashSet();
        Iterable $this$filter$iv = fields;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnotatedSelectStatement.Field it = (AnnotatedSelectStatement.Field)element$iv$iv;
            boolean bl = false;
            if (!(!it.getAnnotations().isDynamicField())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List materialFields = (List)destination$iv$iv;
        Iterable $this$forEach$iv = materialFields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnnotatedSelectStatement.Field field = (AnnotatedSelectStatement.Field)element$iv;
            boolean bl = false;
            String baseName = selectFieldGenerator.generateProperty(field, propertyNameGenerator).getName();
            String tableAlias = field.getSrc().getTableName();
            JoinedFieldKey key = new JoinedFieldKey(tableAlias, field.getSrc().getFieldName());
            String candidate = INSTANCE.createUniqueName(baseName, tableAlias, used);
            ((Map)result).put(key, candidate);
            ((Collection)used).add(candidate);
            String originalName = field.getSrc().getOriginalColumnName();
            if (!(!StringsKt.isBlank((CharSequence)originalName))) continue;
            JoinedFieldKey originalKey = new JoinedFieldKey(tableAlias, originalName);
            result.putIfAbsent(originalKey, candidate);
        }
        return result;
    }

    private final String createUniqueName(String baseName, String tableAlias, Set<String> used) {
        String aliasSuffix;
        Object object;
        block6: {
            block5: {
                String string;
                if (!used.contains(baseName)) {
                    return baseName;
                }
                String it = string = tableAlias;
                boolean bl = false;
                object = !StringsKt.isBlank((CharSequence)it) ? string : null;
                if (object == null) break block5;
                String it2 = object;
                boolean bl2 = false;
                String string2 = "_" + INSTANCE.sanitizeAliasPart(it2);
                object = string2;
                if (string2 != null) break block6;
            }
            object = "";
        }
        Object candidate = !StringsKt.isBlank((CharSequence)(aliasSuffix = object)) ? baseName + aliasSuffix : baseName;
        int index = 2;
        while (used.contains(candidate)) {
            candidate = !StringsKt.isBlank((CharSequence)aliasSuffix) ? baseName + aliasSuffix + index : baseName + index;
            ++index;
        }
        return candidate;
    }

    /*
     * WARNING - void declaration
     */
    private final String sanitizeAliasPart(String raw) {
        Object object;
        void $this$mapTo$iv$iv;
        String string = raw.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        CharSequence $this$map$iv = string;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            char ch;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(Character.isLetterOrDigit(ch) ? ch : (char)'_'));
        }
        String cleaned = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        String result = StringsKt.trim((String)cleaned, (char[])(object = new char[]{'_'}));
        if (((CharSequence)result).length() == 0) {
            result = "source";
        }
        object = result;
        charSequence = new Regex("_+");
        String string2 = "_";
        return charSequence.replace((CharSequence)object, string2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Ldev/goquick/sqlitenow/gradle/processing/JoinedPropertyNameResolver$JoinedFieldKey;", "", "tableAlias", "", "fieldName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getTableAlias", "()Ljava/lang/String;", "getFieldName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "sqlitenow-gradle-plugin"})
    public static final class JoinedFieldKey {
        @NotNull
        private final String tableAlias;
        @NotNull
        private final String fieldName;

        public JoinedFieldKey(@NotNull String tableAlias, @NotNull String fieldName) {
            Intrinsics.checkNotNullParameter((Object)tableAlias, (String)"tableAlias");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            this.tableAlias = tableAlias;
            this.fieldName = fieldName;
        }

        @NotNull
        public final String getTableAlias() {
            return this.tableAlias;
        }

        @NotNull
        public final String getFieldName() {
            return this.fieldName;
        }

        @NotNull
        public final String component1() {
            return this.tableAlias;
        }

        @NotNull
        public final String component2() {
            return this.fieldName;
        }

        @NotNull
        public final JoinedFieldKey copy(@NotNull String tableAlias, @NotNull String fieldName) {
            Intrinsics.checkNotNullParameter((Object)tableAlias, (String)"tableAlias");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            return new JoinedFieldKey(tableAlias, fieldName);
        }

        public static /* synthetic */ JoinedFieldKey copy$default(JoinedFieldKey joinedFieldKey, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = joinedFieldKey.tableAlias;
            }
            if ((n & 2) != 0) {
                string2 = joinedFieldKey.fieldName;
            }
            return joinedFieldKey.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "JoinedFieldKey(tableAlias=" + this.tableAlias + ", fieldName=" + this.fieldName + ")";
        }

        public int hashCode() {
            int result = this.tableAlias.hashCode();
            result = result * 31 + this.fieldName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JoinedFieldKey)) {
                return false;
            }
            JoinedFieldKey joinedFieldKey = (JoinedFieldKey)other;
            if (!Intrinsics.areEqual((Object)this.tableAlias, (Object)joinedFieldKey.tableAlias)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fieldName, (Object)joinedFieldKey.fieldName);
        }
    }
}

