/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.processing;

import com.squareup.kotlinpoet.TypeName;
import dev.goquick.sqlitenow.gradle.model.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.processing.PropertyNameGeneratorType;
import dev.goquick.sqlitenow.gradle.util.SqliteTypeToKotlinCodeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0003$%&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000f0\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006JV\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fH\u0002J$\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0018H\u0002J\u0016\u0010\"\u001a\u00020\u00062\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager;", "", "<init>", "()V", "sharedResults", "", "", "Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager$SharedResult;", "structureValidation", "registerSharedResult", "statement", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedSelectStatement;", "namespace", "getSharedResultsByNamespace", "", "", "isSharedResult", "", "getSharedResult", "buildStructureMismatchMessage", "sharedResultName", "existingSharedResult", "existingStructureKey", "existingFields", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedSelectStatement$Field;", "newStructureKey", "newStatement", "newFields", "computeFieldDiff", "Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager$FieldDiffResult;", "describeField", "Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager$FieldDescriptor;", "field", "determineKotlinType", "createStructureKey", "fields", "SharedResult", "FieldDescriptor", "FieldDiffResult", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSharedResultManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedResultManager.kt\ndev/goquick/sqlitenow/gradle/processing/SharedResultManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1491#2:416\n1516#2,3:417\n1519#2,3:427\n1869#2,2:430\n1869#2,2:432\n1869#2,2:434\n1222#2,2:436\n1252#2,4:438\n1222#2,2:442\n1252#2,4:444\n1617#2,9:448\n1869#2:457\n1870#2:459\n1626#2:460\n1056#2:461\n1617#2,9:462\n1869#2:471\n1870#2:473\n1626#2:474\n1056#2:475\n1617#2,9:476\n1869#2:485\n1870#2:487\n1626#2:488\n1056#2:489\n1563#2:491\n1634#2,3:492\n382#3,7:420\n1#4:458\n1#4:472\n1#4:486\n1#4:490\n*S KotlinDebug\n*F\n+ 1 SharedResultManager.kt\ndev/goquick/sqlitenow/gradle/processing/SharedResultManager\n*L\n221#1:416\n221#1:417,3\n221#1:427,3\n273#1:430,2\n281#1:432,2\n289#1:434,2\n311#1:436,2\n311#1:438,4\n315#1:442,2\n315#1:444,4\n321#1:448,9\n321#1:457\n321#1:459\n321#1:460\n322#1:461\n325#1:462,9\n325#1:471\n325#1:473\n325#1:474\n326#1:475\n329#1:476,9\n329#1:485\n329#1:487\n329#1:488\n338#1:489\n406#1:491\n406#1:492,3\n221#1:420,7\n321#1:458\n325#1:472\n329#1:486\n*E\n"})
public final class SharedResultManager {
    @NotNull
    private final Map<String, SharedResult> sharedResults = new LinkedHashMap();
    @NotNull
    private final Map<String, String> structureValidation = new LinkedHashMap();

    @Nullable
    public final SharedResult registerSharedResult(@NotNull AnnotatedSelectStatement statement, @NotNull String namespace) {
        SharedResult sharedResult;
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        String string = statement.getAnnotations().getQueryResult();
        if (string == null) {
            return null;
        }
        String sharedResultName = string;
        String sharedResultKey = namespace + "." + sharedResultName;
        String structureKey = this.createStructureKey(statement.getFields());
        String existingStructureKey = this.structureValidation.get(sharedResultKey);
        if (existingStructureKey != null && !Intrinsics.areEqual((Object)existingStructureKey, (Object)structureKey)) {
            SharedResult existingSharedResult = this.sharedResults.get(sharedResultKey);
            Object object = existingSharedResult;
            if (object == null || (object = ((SharedResult)object).getFields()) == null) {
                object = CollectionsKt.emptyList();
            }
            String message = this.buildStructureMismatchMessage(sharedResultName, namespace, existingSharedResult, existingStructureKey, (List<AnnotatedSelectStatement.Field>)object, structureKey, statement, statement.getFields());
            throw new IllegalArgumentException(message);
        }
        SharedResult existingSharedResult = this.sharedResults.get(sharedResultKey);
        if (existingSharedResult != null) {
            if (existingSharedResult.getPropertyNameGenerator() != statement.getAnnotations().getPropertyNameGenerator()) {
                throw new IllegalArgumentException("Conflicting propertyNameGenerator annotations for shared result '" + sharedResultKey + "'.\nExisting: " + existingSharedResult.getPropertyNameGenerator() + "\nNew statement '" + statement.getName() + "': " + statement.getAnnotations().getPropertyNameGenerator() + "\nAll SELECT statements using the same sharedResult must use the same propertyNameGenerator.");
            }
            sharedResult = existingSharedResult;
        } else {
            SharedResult newSharedResult = new SharedResult(sharedResultName, namespace, statement.getFields(), statement.getAnnotations().getPropertyNameGenerator(), statement.getName(), statement.getSourceFile());
            this.sharedResults.put(sharedResultKey, newSharedResult);
            sharedResult = newSharedResult;
        }
        SharedResult sharedResult2 = sharedResult;
        this.structureValidation.put(sharedResultKey, structureKey);
        return sharedResult2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<SharedResult>> getSharedResultsByNamespace() {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.sharedResults.values();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SharedResult it = (SharedResult)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getNamespace();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    public final boolean isSharedResult(@NotNull AnnotatedSelectStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        return statement.getAnnotations().getQueryResult() != null;
    }

    @Nullable
    public final SharedResult getSharedResult(@NotNull AnnotatedSelectStatement statement, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        String string = statement.getAnnotations().getQueryResult();
        if (string == null) {
            return null;
        }
        String sharedResultName = string;
        String sharedResultKey = namespace + "." + sharedResultName;
        return this.sharedResults.get(sharedResultKey);
    }

    private final String buildStructureMismatchMessage(String sharedResultName, String namespace, SharedResult existingSharedResult, String existingStructureKey, List<AnnotatedSelectStatement.Field> existingFields, String newStructureKey, AnnotatedSelectStatement newStatement, List<AnnotatedSelectStatement.Field> newFields) {
        FieldDescriptor descriptor;
        Iterable $this$forEach$iv;
        Object object;
        FieldDiffResult diff = this.computeFieldDiff(existingFields, newFields);
        StringBuilder builder = new StringBuilder();
        builder.append("Query result '" + sharedResultName + "' in namespace '" + namespace + "' has inconsistent field structure.").append('\n');
        builder.append("All SELECT statements that share the same queryResult must expose identical field aliases, Kotlin types, and overrides.").append('\n');
        builder.append('\n');
        StringBuilder stringBuilder = builder;
        Object object2 = existingSharedResult;
        if (object2 == null || (object2 = ((SharedResult)object2).getStatementName()) == null) {
            object2 = "unknown";
        }
        if ((object = existingSharedResult) == null || (object = ((SharedResult)object).getSourceFile()) == null) {
            object = "unknown file";
        }
        String string = "Existing statement: " + (String)object2 + " (" + (String)object + ")";
        stringBuilder.append(string).append('\n');
        builder.append("Existing structure key: " + existingStructureKey).append('\n');
        stringBuilder = builder;
        String string2 = newStatement.getName();
        String string3 = newStatement.getSourceFile();
        if (string3 == null) {
            string3 = "unknown file";
        }
        string = "New statement: " + string2 + " (" + string3 + ")";
        stringBuilder.append(string).append('\n');
        builder.append("New structure key: " + newStructureKey).append('\n');
        builder.append('\n');
        if (!((Collection)diff.getOnlyInExisting()).isEmpty()) {
            builder.append("Fields missing from the new statement:").append('\n');
            $this$forEach$iv = diff.getOnlyInExisting();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                descriptor = (FieldDescriptor)element$iv;
                boolean bl = false;
                builder.append("  - " + descriptor.getAlias() + ": " + descriptor.summary()).append('\n');
            }
            builder.append('\n');
        }
        if (!((Collection)diff.getOnlyInNew()).isEmpty()) {
            builder.append("New fields not present in the existing statement:").append('\n');
            $this$forEach$iv = diff.getOnlyInNew();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                descriptor = (FieldDescriptor)element$iv;
                boolean bl = false;
                builder.append("  + " + descriptor.getAlias() + ": " + descriptor.summary()).append('\n');
            }
            builder.append('\n');
        }
        if (!((Collection)diff.getChanged()).isEmpty()) {
            builder.append("Fields with conflicting definitions:").append('\n');
            $this$forEach$iv = diff.getChanged();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                FieldDescriptor existingDescriptor = (FieldDescriptor)pair.component1();
                FieldDescriptor newDescriptor = (FieldDescriptor)pair.component2();
                builder.append("  * " + existingDescriptor.getAlias() + ":").append('\n');
                builder.append("      existing -> " + existingDescriptor.summary()).append('\n');
                builder.append("      new      -> " + newDescriptor.summary()).append('\n');
            }
            builder.append('\n');
        }
        if (diff.getOnlyInExisting().isEmpty() && diff.getOnlyInNew().isEmpty() && diff.getChanged().isEmpty()) {
            v4 = builder.append("No alias-level differences detected, but structure hashes diverge.").append('\n');
        } else {
            int compared = Math.max(existingFields.size(), newFields.size());
            v4 = builder.append("Compared " + compared + " field definitions.").append('\n');
        }
        String string4 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return ((Object)StringsKt.trimEnd((CharSequence)string4)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final FieldDiffResult computeFieldDiff(List<AnnotatedSelectStatement.Field> existingFields, List<AnnotatedSelectStatement.Field> newFields) {
        void $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$sortedBy$iv2;
        void $this$mapNotNullTo$iv$iv2;
        Iterable $this$mapNotNull$iv2;
        void $this$sortedBy$iv3;
        void $this$mapNotNullTo$iv$iv3;
        Iterable $this$mapNotNull$iv3;
        Object object;
        void $this$associateByTo$iv$iv;
        String string;
        FieldDescriptor fieldDescriptor;
        Map map;
        void $this$associateByTo$iv$iv2;
        Iterable $this$associateBy$iv = existingFields;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            AnnotatedSelectStatement.Field it;
            AnnotatedSelectStatement.Field field = (AnnotatedSelectStatement.Field)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getSrc().getFieldName();
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(locale), (String)"toLowerCase(...)");
            it = (AnnotatedSelectStatement.Field)element$iv$iv;
            boolean bl2 = false;
            fieldDescriptor = this.describeField(it);
            map.put(string, fieldDescriptor);
        }
        Map existingDescriptors = destination$iv$iv;
        Iterable $this$associateBy$iv2 = newFields;
        boolean $i$f$associateBy22 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv2;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            AnnotatedSelectStatement.Field it;
            AnnotatedSelectStatement.Field bl2 = (AnnotatedSelectStatement.Field)element$iv$iv;
            map = destination$iv$iv2;
            boolean bl = false;
            object = it.getSrc().getFieldName();
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            Intrinsics.checkNotNullExpressionValue((Object)((String)object).toLowerCase(locale), (String)"toLowerCase(...)");
            it = (AnnotatedSelectStatement.Field)element$iv$iv;
            boolean bl3 = false;
            fieldDescriptor = this.describeField(it);
            map.put(string, fieldDescriptor);
        }
        Map newDescriptors = destination$iv$iv2;
        Iterable $i$f$associateBy22 = SetsKt.minus(existingDescriptors.keySet(), (Iterable)newDescriptors.keySet());
        boolean $i$f$mapNotNull = false;
        $this$associateByTo$iv$iv = $this$mapNotNull$iv3;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv3;
        boolean $i$f$forEach = false;
        Iterator it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            FieldDescriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            String p0 = (String)element$iv$iv;
            boolean bl4 = false;
            if ((FieldDescriptor)existingDescriptors.get(p0) == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv3 = (List)destination$iv$iv2;
        boolean $i$f$sortedBy22 = false;
        List onlyExisting = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv3, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FieldDescriptor it = (FieldDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getAlias());
                it = (FieldDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getAlias())));
            }
        });
        Iterable $i$f$sortedBy22 = SetsKt.minus(newDescriptors.keySet(), (Iterable)existingDescriptors.keySet());
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv2 = $this$mapNotNull$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        Iterator element$iv$iv$iv = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv.hasNext()) {
            FieldDescriptor it$iv$iv;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = element$iv$iv$iv.next();
            boolean bl = false;
            String p0 = (String)element$iv$iv;
            boolean bl6 = false;
            if ((FieldDescriptor)newDescriptors.get(p0) == null) continue;
            boolean bl7 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        $this$mapNotNull$iv2 = (List)destination$iv$iv3;
        boolean $i$f$sortedBy32 = false;
        List onlyNew = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FieldDescriptor it = (FieldDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getAlias());
                it = (FieldDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getAlias())));
            }
        });
        Iterable $i$f$sortedBy32 = CollectionsKt.intersect((Iterable)existingDescriptors.keySet(), (Iterable)newDescriptors.keySet());
        boolean $i$f$mapNotNull3 = false;
        destination$iv$iv3 = $this$mapNotNull$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        object = $this$forEach$iv$iv$iv3.iterator();
        while (object.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = object.next();
            boolean bl = false;
            String alias = (String)element$iv$iv;
            boolean bl8 = false;
            FieldDescriptor existingDescriptor = (FieldDescriptor)existingDescriptors.get(alias);
            FieldDescriptor newDescriptor = (FieldDescriptor)newDescriptors.get(alias);
            if ((existingDescriptor != null && newDescriptor != null && !Intrinsics.areEqual((Object)existingDescriptor, (Object)newDescriptor) ? TuplesKt.to((Object)existingDescriptor, (Object)newDescriptor) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl9 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv4;
        boolean $i$f$sortedBy = false;
        List changed = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((FieldDescriptor)it.getFirst()).getAlias());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((FieldDescriptor)it.getFirst()).getAlias())));
            }
        });
        return new FieldDiffResult(onlyExisting, onlyNew, changed);
    }

    /*
     * WARNING - void declaration
     */
    private final FieldDescriptor describeField(AnnotatedSelectStatement.Field field) {
        void it;
        String string;
        String alias = field.getSrc().getFieldName();
        String kotlinType = this.determineKotlinType(field);
        String propertyType = field.getAnnotations().getPropertyType();
        Boolean bl = field.getAnnotations().getNotNull();
        if (bl == null) {
            bl = field.getAnnotations().isDynamicField() ? null : Boolean.valueOf(!field.getSrc().isNullable());
        }
        Boolean normalizedNotNull = bl;
        String string2 = string = field.getSrc().getTableName();
        Boolean bl2 = normalizedNotNull;
        String string3 = propertyType;
        String string4 = kotlinType;
        String string5 = alias;
        boolean bl3 = false;
        boolean bl4 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
        String string6 = bl4 ? string : null;
        String string7 = field.getAnnotations().getAliasPrefix();
        String string8 = field.getAnnotations().getMappingType();
        String string9 = string6;
        Boolean bl5 = bl2;
        String string10 = string3;
        String string11 = string4;
        String string12 = string5;
        return new FieldDescriptor(string12, string11, string10, bl5, string9, string8, string7);
    }

    private final String determineKotlinType(AnnotatedSelectStatement.Field field) {
        String string = field.getAnnotations().getPropertyType();
        if (string == null) {
            string = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(field.getSrc().getDataType()).toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String createStructureKey(List<AnnotatedSelectStatement.Field> fields) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = fields;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void field;
            AnnotatedSelectStatement.Field field2 = (AnnotatedSelectStatement.Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeName kotlinType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(field.getSrc().getDataType());
            String kotlinTypeString = kotlinType.toString();
            String string = field.getSrc().getFieldName();
            String string2 = field.getAnnotations().getPropertyType();
            if (string2 == null) {
                string2 = "default";
            }
            collection.add(string + ":" + kotlinTypeString + ":" + string2);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0017\u001a\u00020\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J^\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010 J\u0014\u0010!\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010#\u001a\u00020$H\u00d6\u0081\u0004J\n\u0010%\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006&"}, d2={"Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager$FieldDescriptor;", "", "alias", "", "kotlinType", "propertyType", "notNull", "", "sourceTable", "mappingType", "aliasPrefix", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAlias", "()Ljava/lang/String;", "getKotlinType", "getPropertyType", "getNotNull", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getSourceTable", "getMappingType", "getAliasPrefix", "summary", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager$FieldDescriptor;", "equals", "other", "hashCode", "", "toString", "sqlitenow-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nSharedResultManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedResultManager.kt\ndev/goquick/sqlitenow/gradle/processing/SharedResultManager$FieldDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,415:1\n1#2:416\n*E\n"})
    private static final class FieldDescriptor {
        @NotNull
        private final String alias;
        @NotNull
        private final String kotlinType;
        @Nullable
        private final String propertyType;
        @Nullable
        private final Boolean notNull;
        @Nullable
        private final String sourceTable;
        @Nullable
        private final String mappingType;
        @Nullable
        private final String aliasPrefix;

        public FieldDescriptor(@NotNull String alias, @NotNull String kotlinType, @Nullable String propertyType, @Nullable Boolean notNull, @Nullable String sourceTable, @Nullable String mappingType, @Nullable String aliasPrefix) {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
            this.alias = alias;
            this.kotlinType = kotlinType;
            this.propertyType = propertyType;
            this.notNull = notNull;
            this.sourceTable = sourceTable;
            this.mappingType = mappingType;
            this.aliasPrefix = aliasPrefix;
        }

        @NotNull
        public final String getAlias() {
            return this.alias;
        }

        @NotNull
        public final String getKotlinType() {
            return this.kotlinType;
        }

        @Nullable
        public final String getPropertyType() {
            return this.propertyType;
        }

        @Nullable
        public final Boolean getNotNull() {
            return this.notNull;
        }

        @Nullable
        public final String getSourceTable() {
            return this.sourceTable;
        }

        @Nullable
        public final String getMappingType() {
            return this.mappingType;
        }

        @Nullable
        public final String getAliasPrefix() {
            return this.aliasPrefix;
        }

        @NotNull
        public final String summary() {
            List parts;
            block5: {
                String string;
                String string2;
                Object[] objectArray = new String[]{"type=" + this.kotlinType};
                parts = CollectionsKt.mutableListOf((Object[])objectArray);
                String string3 = this.propertyType;
                if (string3 != null) {
                    String it = string3;
                    boolean bl = false;
                    ((Collection)parts).add("propertyType=" + it);
                }
                Boolean bl = this.notNull;
                if (bl != null) {
                    boolean it = bl;
                    boolean bl2 = false;
                    ((Collection)parts).add("notNull=" + it);
                }
                String string4 = this.sourceTable;
                if (string4 != null) {
                    String it = string4;
                    boolean bl3 = false;
                    ((Collection)parts).add("source=" + it);
                }
                String string5 = this.mappingType;
                if (string5 != null) {
                    String it = string5;
                    boolean bl4 = false;
                    ((Collection)parts).add("mappingType=" + it);
                }
                if ((string2 = this.aliasPrefix) == null) break block5;
                String it = string = string2;
                boolean bl5 = false;
                string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
                if (string2 != null) {
                    it = string2;
                    boolean bl6 = false;
                    ((Collection)parts).add("aliasPrefix=" + it);
                }
            }
            return CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final String component1() {
            return this.alias;
        }

        @NotNull
        public final String component2() {
            return this.kotlinType;
        }

        @Nullable
        public final String component3() {
            return this.propertyType;
        }

        @Nullable
        public final Boolean component4() {
            return this.notNull;
        }

        @Nullable
        public final String component5() {
            return this.sourceTable;
        }

        @Nullable
        public final String component6() {
            return this.mappingType;
        }

        @Nullable
        public final String component7() {
            return this.aliasPrefix;
        }

        @NotNull
        public final FieldDescriptor copy(@NotNull String alias, @NotNull String kotlinType, @Nullable String propertyType, @Nullable Boolean notNull, @Nullable String sourceTable, @Nullable String mappingType, @Nullable String aliasPrefix) {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
            return new FieldDescriptor(alias, kotlinType, propertyType, notNull, sourceTable, mappingType, aliasPrefix);
        }

        public static /* synthetic */ FieldDescriptor copy$default(FieldDescriptor fieldDescriptor, String string, String string2, String string3, Boolean bl, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = fieldDescriptor.alias;
            }
            if ((n & 2) != 0) {
                string2 = fieldDescriptor.kotlinType;
            }
            if ((n & 4) != 0) {
                string3 = fieldDescriptor.propertyType;
            }
            if ((n & 8) != 0) {
                bl = fieldDescriptor.notNull;
            }
            if ((n & 0x10) != 0) {
                string4 = fieldDescriptor.sourceTable;
            }
            if ((n & 0x20) != 0) {
                string5 = fieldDescriptor.mappingType;
            }
            if ((n & 0x40) != 0) {
                string6 = fieldDescriptor.aliasPrefix;
            }
            return fieldDescriptor.copy(string, string2, string3, bl, string4, string5, string6);
        }

        @NotNull
        public String toString() {
            return "FieldDescriptor(alias=" + this.alias + ", kotlinType=" + this.kotlinType + ", propertyType=" + this.propertyType + ", notNull=" + this.notNull + ", sourceTable=" + this.sourceTable + ", mappingType=" + this.mappingType + ", aliasPrefix=" + this.aliasPrefix + ")";
        }

        public int hashCode() {
            int result = this.alias.hashCode();
            result = result * 31 + this.kotlinType.hashCode();
            result = result * 31 + (this.propertyType == null ? 0 : this.propertyType.hashCode());
            result = result * 31 + (this.notNull == null ? 0 : ((Object)this.notNull).hashCode());
            result = result * 31 + (this.sourceTable == null ? 0 : this.sourceTable.hashCode());
            result = result * 31 + (this.mappingType == null ? 0 : this.mappingType.hashCode());
            result = result * 31 + (this.aliasPrefix == null ? 0 : this.aliasPrefix.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldDescriptor)) {
                return false;
            }
            FieldDescriptor fieldDescriptor = (FieldDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.alias, (Object)fieldDescriptor.alias)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kotlinType, (Object)fieldDescriptor.kotlinType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.propertyType, (Object)fieldDescriptor.propertyType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.notNull, (Object)fieldDescriptor.notNull)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sourceTable, (Object)fieldDescriptor.sourceTable)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mappingType, (Object)fieldDescriptor.mappingType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.aliasPrefix, (Object)fieldDescriptor.aliasPrefix);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001b\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00070\u0003H\u00c6\u0003JE\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00070\u0003H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0019"}, d2={"Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager$FieldDiffResult;", "", "onlyInExisting", "", "Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager$FieldDescriptor;", "onlyInNew", "changed", "Lkotlin/Pair;", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getOnlyInExisting", "()Ljava/util/List;", "getOnlyInNew", "getChanged", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "sqlitenow-gradle-plugin"})
    private static final class FieldDiffResult {
        @NotNull
        private final List<FieldDescriptor> onlyInExisting;
        @NotNull
        private final List<FieldDescriptor> onlyInNew;
        @NotNull
        private final List<Pair<FieldDescriptor, FieldDescriptor>> changed;

        public FieldDiffResult(@NotNull List<FieldDescriptor> onlyInExisting, @NotNull List<FieldDescriptor> onlyInNew, @NotNull List<Pair<FieldDescriptor, FieldDescriptor>> changed) {
            Intrinsics.checkNotNullParameter(onlyInExisting, (String)"onlyInExisting");
            Intrinsics.checkNotNullParameter(onlyInNew, (String)"onlyInNew");
            Intrinsics.checkNotNullParameter(changed, (String)"changed");
            this.onlyInExisting = onlyInExisting;
            this.onlyInNew = onlyInNew;
            this.changed = changed;
        }

        @NotNull
        public final List<FieldDescriptor> getOnlyInExisting() {
            return this.onlyInExisting;
        }

        @NotNull
        public final List<FieldDescriptor> getOnlyInNew() {
            return this.onlyInNew;
        }

        @NotNull
        public final List<Pair<FieldDescriptor, FieldDescriptor>> getChanged() {
            return this.changed;
        }

        @NotNull
        public final List<FieldDescriptor> component1() {
            return this.onlyInExisting;
        }

        @NotNull
        public final List<FieldDescriptor> component2() {
            return this.onlyInNew;
        }

        @NotNull
        public final List<Pair<FieldDescriptor, FieldDescriptor>> component3() {
            return this.changed;
        }

        @NotNull
        public final FieldDiffResult copy(@NotNull List<FieldDescriptor> onlyInExisting, @NotNull List<FieldDescriptor> onlyInNew, @NotNull List<Pair<FieldDescriptor, FieldDescriptor>> changed) {
            Intrinsics.checkNotNullParameter(onlyInExisting, (String)"onlyInExisting");
            Intrinsics.checkNotNullParameter(onlyInNew, (String)"onlyInNew");
            Intrinsics.checkNotNullParameter(changed, (String)"changed");
            return new FieldDiffResult(onlyInExisting, onlyInNew, changed);
        }

        public static /* synthetic */ FieldDiffResult copy$default(FieldDiffResult fieldDiffResult, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list = fieldDiffResult.onlyInExisting;
            }
            if ((n & 2) != 0) {
                list2 = fieldDiffResult.onlyInNew;
            }
            if ((n & 4) != 0) {
                list3 = fieldDiffResult.changed;
            }
            return fieldDiffResult.copy(list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "FieldDiffResult(onlyInExisting=" + this.onlyInExisting + ", onlyInNew=" + this.onlyInNew + ", changed=" + this.changed + ")";
        }

        public int hashCode() {
            int result = ((Object)this.onlyInExisting).hashCode();
            result = result * 31 + ((Object)this.onlyInNew).hashCode();
            result = result * 31 + ((Object)this.changed).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldDiffResult)) {
                return false;
            }
            FieldDiffResult fieldDiffResult = (FieldDiffResult)other;
            if (!Intrinsics.areEqual(this.onlyInExisting, fieldDiffResult.onlyInExisting)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onlyInNew, fieldDiffResult.onlyInNew)) {
                return false;
            }
            return Intrinsics.areEqual(this.changed, fieldDiffResult.changed);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JM\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010!\u001a\u00020\"H\u00d6\u0081\u0004J\n\u0010#\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000f\u00a8\u0006$"}, d2={"Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager$SharedResult;", "", "name", "", "namespace", "fields", "", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedSelectStatement$Field;", "propertyNameGenerator", "Ldev/goquick/sqlitenow/gradle/processing/PropertyNameGeneratorType;", "statementName", "sourceFile", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ldev/goquick/sqlitenow/gradle/processing/PropertyNameGeneratorType;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getNamespace", "getFields", "()Ljava/util/List;", "getPropertyNameGenerator", "()Ldev/goquick/sqlitenow/gradle/processing/PropertyNameGeneratorType;", "getStatementName", "getSourceFile", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "sqlitenow-gradle-plugin"})
    public static final class SharedResult {
        @NotNull
        private final String name;
        @NotNull
        private final String namespace;
        @NotNull
        private final List<AnnotatedSelectStatement.Field> fields;
        @NotNull
        private final PropertyNameGeneratorType propertyNameGenerator;
        @NotNull
        private final String statementName;
        @Nullable
        private final String sourceFile;

        public SharedResult(@NotNull String name, @NotNull String namespace, @NotNull List<AnnotatedSelectStatement.Field> fields, @NotNull PropertyNameGeneratorType propertyNameGenerator, @NotNull String statementName, @Nullable String sourceFile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            Intrinsics.checkNotNullParameter((Object)((Object)propertyNameGenerator), (String)"propertyNameGenerator");
            Intrinsics.checkNotNullParameter((Object)statementName, (String)"statementName");
            this.name = name;
            this.namespace = namespace;
            this.fields = fields;
            this.propertyNameGenerator = propertyNameGenerator;
            this.statementName = statementName;
            this.sourceFile = sourceFile;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getNamespace() {
            return this.namespace;
        }

        @NotNull
        public final List<AnnotatedSelectStatement.Field> getFields() {
            return this.fields;
        }

        @NotNull
        public final PropertyNameGeneratorType getPropertyNameGenerator() {
            return this.propertyNameGenerator;
        }

        @NotNull
        public final String getStatementName() {
            return this.statementName;
        }

        @Nullable
        public final String getSourceFile() {
            return this.sourceFile;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.namespace;
        }

        @NotNull
        public final List<AnnotatedSelectStatement.Field> component3() {
            return this.fields;
        }

        @NotNull
        public final PropertyNameGeneratorType component4() {
            return this.propertyNameGenerator;
        }

        @NotNull
        public final String component5() {
            return this.statementName;
        }

        @Nullable
        public final String component6() {
            return this.sourceFile;
        }

        @NotNull
        public final SharedResult copy(@NotNull String name, @NotNull String namespace, @NotNull List<AnnotatedSelectStatement.Field> fields, @NotNull PropertyNameGeneratorType propertyNameGenerator, @NotNull String statementName, @Nullable String sourceFile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            Intrinsics.checkNotNullParameter((Object)((Object)propertyNameGenerator), (String)"propertyNameGenerator");
            Intrinsics.checkNotNullParameter((Object)statementName, (String)"statementName");
            return new SharedResult(name, namespace, fields, propertyNameGenerator, statementName, sourceFile);
        }

        public static /* synthetic */ SharedResult copy$default(SharedResult sharedResult, String string, String string2, List list, PropertyNameGeneratorType propertyNameGeneratorType, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = sharedResult.name;
            }
            if ((n & 2) != 0) {
                string2 = sharedResult.namespace;
            }
            if ((n & 4) != 0) {
                list = sharedResult.fields;
            }
            if ((n & 8) != 0) {
                propertyNameGeneratorType = sharedResult.propertyNameGenerator;
            }
            if ((n & 0x10) != 0) {
                string3 = sharedResult.statementName;
            }
            if ((n & 0x20) != 0) {
                string4 = sharedResult.sourceFile;
            }
            return sharedResult.copy(string, string2, list, propertyNameGeneratorType, string3, string4);
        }

        @NotNull
        public String toString() {
            return "SharedResult(name=" + this.name + ", namespace=" + this.namespace + ", fields=" + this.fields + ", propertyNameGenerator=" + this.propertyNameGenerator + ", statementName=" + this.statementName + ", sourceFile=" + this.sourceFile + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.namespace.hashCode();
            result = result * 31 + ((Object)this.fields).hashCode();
            result = result * 31 + this.propertyNameGenerator.hashCode();
            result = result * 31 + this.statementName.hashCode();
            result = result * 31 + (this.sourceFile == null ? 0 : this.sourceFile.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SharedResult)) {
                return false;
            }
            SharedResult sharedResult = (SharedResult)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)sharedResult.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.namespace, (Object)sharedResult.namespace)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.fields, sharedResult.fields)) {
                return false;
            }
            if (this.propertyNameGenerator != sharedResult.propertyNameGenerator) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.statementName, (Object)sharedResult.statementName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sourceFile, (Object)sharedResult.sourceFile);
        }
    }
}

