/*
 * Decompiled with CFR 0.152.
 */
package api.quotation.module;

import api.quotation.bean.Candle;
import api.quotation.bean.DayCandle;
import api.quotation.bean.MinuteCandle;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import util.bean.UpbitResponse;
import util.constant.ApiList;
import util.module.Util;

public class CandlesApi {
    public UpbitResponse<MinuteCandle[]> getMinuteCandles(int unit, String market) throws IOException {
        return this.getMinuteCandles(unit, market, "", 1);
    }

    public UpbitResponse<MinuteCandle[]> getMinuteCandles(int unit, String market, String to, int count) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("market", market);
        params.put("to", to);
        params.put("count", String.valueOf(count));
        URL url = new URL(Util.builder(ApiList.CANDLES.getUrl(), "/minutes/", unit, "?", Util.queryBuilder(params)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.addRequestProperty("Accept", "application/json");
        UpbitResponse<MinuteCandle[]> response = new UpbitResponse<MinuteCandle[]>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 200) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            MinuteCandle[] candles = (MinuteCandle[])new Gson().fromJson(responseBuilder.toString(), MinuteCandle[].class);
            response.setSuccess(true);
            response.setBody(candles);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }

    public UpbitResponse<DayCandle[]> getDayCandles(String market) throws IOException {
        return this.getDayCandles(market, "", 1, "");
    }

    public UpbitResponse<DayCandle[]> getDayCandles(String market, String to, int count, String convertingPriceUnit) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("market", market);
        params.put("to", to);
        params.put("count", String.valueOf(count));
        params.put("convertingPriceUnit", convertingPriceUnit);
        URL url = new URL(Util.builder(ApiList.CANDLES.getUrl(), "/days?", Util.queryBuilder(params)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.addRequestProperty("Accept", "application/json");
        UpbitResponse<DayCandle[]> response = new UpbitResponse<DayCandle[]>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 200) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            DayCandle[] array = (DayCandle[])new Gson().fromJson(responseBuilder.toString(), DayCandle[].class);
            response.setSuccess(true);
            response.setBody(array);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }

    public UpbitResponse<Candle[]> getWeekCandles(String market) throws IOException {
        return this.getWeekCandles(market, "", 1);
    }

    public UpbitResponse<Candle[]> getWeekCandles(String market, String to, int count) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("market", market);
        params.put("to", to);
        params.put("count", String.valueOf(count));
        URL url = new URL(Util.builder(ApiList.CANDLES.getUrl(), "/weeks?", Util.queryBuilder(params)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.addRequestProperty("Accept", "application/json");
        UpbitResponse<Candle[]> response = new UpbitResponse<Candle[]>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 200) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            Candle[] candles = (Candle[])new Gson().fromJson(responseBuilder.toString(), Candle[].class);
            response.setSuccess(true);
            response.setBody(candles);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }

    public UpbitResponse<Candle[]> getMonthCandles(String market) throws IOException {
        return this.getMonthCandles(market, "", 1);
    }

    public UpbitResponse<Candle[]> getMonthCandles(String market, String to, int count) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("market", market);
        params.put("to", to);
        params.put("count", String.valueOf(count));
        URL url = new URL(Util.builder(ApiList.CANDLES.getUrl(), "/months?", Util.queryBuilder(params)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.addRequestProperty("Accept", "application/json");
        UpbitResponse<Candle[]> response = new UpbitResponse<Candle[]>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 200) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            Candle[] candles = (Candle[])new Gson().fromJson(responseBuilder.toString(), Candle[].class);
            response.setSuccess(true);
            response.setBody(candles);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }
}

