/*
 * Decompiled with CFR 0.152.
 */
package api.exchange.module;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.UUID;
import util.module.Util;

public class AuthApi {
    private final String api;
    private final String secret;

    protected AuthApi(String api, String secret) {
        this.api = api;
        this.secret = secret;
    }

    protected String getAuthToken() {
        return JWT.create().withClaim("access_key", this.api).withClaim("nonce", UUID.randomUUID().toString()).sign(Algorithm.HMAC256((String)this.secret));
    }

    protected String getAuthToken(HashMap<String, String> params) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String query = Util.queryBuilder(params);
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        md.update(query.getBytes("UTF-8"));
        String queryHash = String.format("%0128x", new BigInteger(1, md.digest()));
        return JWT.create().withClaim("access_key", this.api).withClaim("nonce", UUID.randomUUID().toString()).withClaim("query_hash", queryHash).withClaim("query_hash_alg", "SHA512").sign(Algorithm.HMAC256((String)this.secret));
    }

    protected String getAuthToken(String query) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        md.update(query.getBytes("UTF-8"));
        String queryHash = String.format("%0128x", new BigInteger(1, md.digest()));
        return JWT.create().withClaim("access_key", this.api).withClaim("nonce", UUID.randomUUID().toString()).withClaim("query_hash", queryHash).withClaim("query_hash_alg", "SHA512").sign(Algorithm.HMAC256((String)this.secret));
    }
}

