/*
 * Decompiled with CFR 0.152.
 */
package io.pdfapi.client.http;

import io.pdfapi.client.http.HttpResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StreamingHttpResponse
implements HttpResponse {
    private final int statusCode;
    private final InputStream bodyStream;
    private final AutoCloseable responseToClose;
    private final Map<String, List<String>> headers;

    public StreamingHttpResponse(int statusCode, InputStream bodyStream, AutoCloseable responseToClose, Map<String, List<String>> headers) {
        this.statusCode = statusCode;
        this.bodyStream = bodyStream;
        this.responseToClose = responseToClose;
        this.headers = headers;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public InputStream getBodyAsStream() {
        return this.bodyStream;
    }

    @Override
    public Optional<String> getLocationHeader() {
        return this.headers.get("Location").stream().findFirst();
    }

    @Override
    public void close() {
        try {
            if (this.bodyStream != null) {
                this.bodyStream.close();
            }
            if (this.responseToClose != null) {
                this.responseToClose.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close response", e);
        }
    }
}

