/*
 * Decompiled with CFR 0.152.
 */
package dev.themeinerlp.plugindebug;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.themeinerlp.plugindebug.DebugFile;
import dev.themeinerlp.plugindebug.DebugFileAdapter;
import dev.themeinerlp.plugindebug.DebugUploadResult;
import dev.themeinerlp.plugindebug.FileType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.lingala.zip4j.ZipFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/themeinerlp/plugindebug/DebugBuilder;", "", "uploadServer", "", "<init>", "(Ljava/lang/String;)V", "addFile", "file", "Ldev/themeinerlp/plugindebug/DebugFile;", "filePath", "Ljava/nio/file/Path;", "fileType", "Ldev/themeinerlp/plugindebug/FileType;", "uiTabName", "addJson", "json", "addText", "text", "addYAML", "yaml", "upload", "Ldev/themeinerlp/plugindebug/DebugUploadResult;", "fileToUpload", "", "gson", "Lcom/google/gson/Gson;", "maxPartFileSize", "", "maxZipFileSize", "tempPrefix", "userAgent", "Companion", "plugin-debug"})
@SourceDebugExtension(value={"SMAP\nDebugBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugBuilder.kt\ndev/themeinerlp/plugindebug/DebugBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1855#2,2:137\n*S KotlinDebug\n*F\n+ 1 DebugBuilder.kt\ndev/themeinerlp/plugindebug/DebugBuilder\n*L\n104#1:137,2\n*E\n"})
public final class DebugBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String uploadServer;
    @NotNull
    private final List<DebugFile> fileToUpload;
    private long maxPartFileSize;
    @NotNull
    private String tempPrefix;
    private long maxZipFileSize;
    @NotNull
    private String userAgent;
    @NotNull
    private final Gson gson;

    private DebugBuilder(String uploadServer) {
        this.uploadServer = uploadServer;
        this.fileToUpload = new ArrayList();
        this.maxPartFileSize = 0x200000L;
        this.tempPrefix = "plugin-debug";
        this.maxZipFileSize = 0x200000L;
        this.userAgent = "plugin-debug";
        Gson gson = new Gson().newBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)DebugFile.class), (Object)new DebugFileAdapter()).setLenient().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"<init>");
        this.gson = gson;
    }

    @NotNull
    public final DebugBuilder addFile(@NotNull DebugFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.fileToUpload.add(file);
        return this;
    }

    @NotNull
    public final DebugBuilder addFile(@NotNull Path filePath, @NotNull FileType fileType, @NotNull String uiTabName) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)uiTabName, (String)"uiTabName");
        this.fileToUpload.add(new DebugFile(filePath, fileType, uiTabName));
        return this;
    }

    @NotNull
    public final DebugBuilder addText(@NotNull String text, @NotNull String uiTabName) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)uiTabName, (String)"uiTabName");
        Path textFile = Files.createTempFile(this.tempPrefix, ".txt", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)textFile, (String)"addText");
        PathsKt.writeText$default((Path)textFile, (CharSequence)text, null, (OpenOption[])new OpenOption[0], (int)2, null);
        this.fileToUpload.add(new DebugFile(textFile, FileType.TEXT, uiTabName));
        return this;
    }

    @NotNull
    public final DebugBuilder addJson(@NotNull String json, @NotNull String uiTabName) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)uiTabName, (String)"uiTabName");
        Path textFile = Files.createTempFile(this.tempPrefix, ".json", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)textFile, (String)"addJson");
        PathsKt.writeText$default((Path)textFile, (CharSequence)json, null, (OpenOption[])new OpenOption[0], (int)2, null);
        this.fileToUpload.add(new DebugFile(textFile, FileType.JSON, uiTabName));
        return this;
    }

    @NotNull
    public final DebugBuilder addYAML(@NotNull String yaml, @NotNull String uiTabName) {
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        Intrinsics.checkNotNullParameter((Object)uiTabName, (String)"uiTabName");
        Path textFile = Files.createTempFile(this.tempPrefix, ".yml", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)textFile, (String)"addYAML");
        PathsKt.writeText$default((Path)textFile, (CharSequence)yaml, null, (OpenOption[])new OpenOption[0], (int)2, null);
        this.fileToUpload.add(new DebugFile(textFile, FileType.YAML, uiTabName));
        return this;
    }

    @NotNull
    public final DebugUploadResult upload() throws IllegalStateException {
        Path tempFolder = Files.createTempDirectory(this.tempPrefix, new FileAttribute[0]);
        Path zipFile = tempFolder.resolve("debug.zip");
        ZipFile zipContainer = new ZipFile(zipFile.toFile());
        JsonArray jsonArray = new JsonArray();
        Iterable $this$forEach$iv = this.fileToUpload;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            DebugFile it = (DebugFile)element$iv;
            boolean bl = false;
            zipContainer.addFile(it.getFilePath().toFile());
            jsonArray.add(this.gson.toJsonTree((Object)it));
        }
        Path debugJson = tempFolder.resolve("debug.json");
        Intrinsics.checkNotNullExpressionValue((Object)debugJson, (String)"upload");
        String string = this.gson.toJson((JsonElement)jsonArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"upload");
        PathsKt.writeText$default((Path)debugJson, (CharSequence)string, null, (OpenOption[])new OpenOption[0], (int)2, null);
        zipContainer.addFile(debugJson.toFile());
        Intrinsics.checkNotNullExpressionValue((Object)zipFile, (String)"upload");
        if (Files.size(zipFile) >= this.maxZipFileSize) {
            String $i$f$forEach2 = "Zip file is to big only {} bytes allowed";
            Object[] objectArray = new Object[]{this.maxZipFileSize};
            String string2 = String.format($i$f$forEach2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            throw new IllegalStateException(string2);
        }
        HttpClient client = HttpClient.newBuilder().build();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.uploadServer + "/post")).timeout(Duration.ofMinutes(2L)).header("User-Agent", this.userAgent).header("Content-Type", "application/zip").POST(HttpRequest.BodyPublishers.ofFile(zipFile)).build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"upload");
        HttpRequest request = httpRequest;
        HttpResponse<String> httpResponse = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"upload");
        HttpResponse<String> response = httpResponse;
        Optional<String> optional = response.headers().firstValue("Location");
        Intrinsics.checkNotNullExpressionValue(optional, (String)"upload");
        String string3 = (String)OptionalsKt.getOrNull(optional);
        if (string3 == null) {
            throw new IllegalStateException("Key not returned");
        }
        String code = string3;
        return new DebugUploadResult(code, this.uploadServer);
    }

    @JvmStatic
    @NotNull
    public static final DebugBuilder builder(@NotNull String uploadServer) {
        return Companion.builder(uploadServer);
    }

    public /* synthetic */ DebugBuilder(String uploadServer, DefaultConstructorMarker $constructor_marker) {
        this(uploadServer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Ldev/themeinerlp/plugindebug/DebugBuilder$Companion;", "", "<init>", "()V", "builder", "Ldev/themeinerlp/plugindebug/DebugBuilder;", "uploadServer", "", "plugin-debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DebugBuilder builder(@NotNull String uploadServer) {
            Intrinsics.checkNotNullParameter((Object)uploadServer, (String)"uploadServer");
            return new DebugBuilder(uploadServer, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

