/*
 * Decompiled with CFR 0.152.
 */
package dev.themeinerlp.plugindebug;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.themeinerlp.plugindebug.DebugFile;
import dev.themeinerlp.plugindebug.DebugFileAdapter;
import dev.themeinerlp.plugindebug.DebugUploadResult;
import dev.themeinerlp.plugindebug.FileType;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.lingala.zip4j.ZipFile;

public class DebugBuilder<T extends DebugBuilder<T>> {
    private final String uploadServer;
    protected final List<DebugFile> fileToUpload = new ArrayList<DebugFile>();
    protected final String tempFile = "plugin-debug";
    protected Gson gson = new Gson().newBuilder().setPrettyPrinting().registerTypeAdapter(DebugFile.class, (Object)new DebugFileAdapter()).setLenient().create();
    private final String userAgent = "plugin-debug";
    protected final long maxZipFileSize = 0x200000L;

    protected DebugBuilder(String uploadServer) {
        this.uploadServer = uploadServer;
    }

    public T addFile(DebugFile file) {
        this.fileToUpload.add(file);
        return (T)this;
    }

    public T addFile(Path filePath, FileType fileType, String uiTabName) {
        this.fileToUpload.add(new DebugFile(filePath, fileType, uiTabName));
        return (T)this;
    }

    public T addText(String text, String uiTabName) throws IOException {
        Path textFile = Files.createTempFile("plugin-debug", ".txt", new FileAttribute[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(textFile, new OpenOption[0]));){
            writer.append(text);
        }
        this.addFile(textFile, FileType.TEXT, uiTabName);
        return (T)this;
    }

    public T addJson(String json, String uiTabName) throws IOException {
        Path textFile = Files.createTempFile("plugin-debug", ".json", new FileAttribute[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(textFile, new OpenOption[0]));){
            writer.append(json);
        }
        this.addFile(textFile, FileType.JSON, uiTabName);
        return (T)this;
    }

    public T addYAML(String yaml, String uiTabName) throws IOException {
        Path textFile = Files.createTempFile("plugin-debug", ".json", new FileAttribute[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(textFile, new OpenOption[0]));){
            writer.append(yaml);
        }
        this.addFile(textFile, FileType.YAML, uiTabName);
        return (T)this;
    }

    public DebugUploadResult upload() throws IOException {
        Path tempFolder = Files.createTempDirectory("plugin-debug", new FileAttribute[0]);
        Path zipFile = tempFolder.resolve("debug.zip");
        try (ZipFile zipContainer = new ZipFile(zipFile.toFile());){
            JsonArray jsonArray = new JsonArray();
            for (DebugFile debugFile : this.fileToUpload) {
                zipContainer.addFile(debugFile.filePath().toFile());
                jsonArray.add(this.gson.toJsonTree((Object)debugFile));
            }
            Path debugJson = tempFolder.resolve("debug.json");
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(debugJson, new OpenOption[0]));){
                writer.append(this.gson.toJson((JsonElement)jsonArray));
            }
            zipContainer.addFile(debugJson.toFile());
            if (Files.size(zipFile) >= 0x200000L) {
                throw new IllegalStateException(String.format("Zip file is to big only %d bytes allowed", 0x200000L));
            }
        }
        HttpClient client = HttpClient.newBuilder().build();
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(String.format("%s/post", this.uploadServer))).timeout(Duration.ofMinutes(2L));
        Objects.requireNonNull(this);
        HttpRequest request = builder.header("User-Agent", "plugin-debug").POST(HttpRequest.BodyPublishers.ofFile(zipFile)).build();
        HttpResponse<String> response = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join();
        String code = response.headers().firstValue("Location").orElseThrow();
        return new DebugUploadResult(code, this.uploadServer);
    }

    public static DebugBuilder<?> builder(String uploadServer) {
        return new DebugBuilder(uploadServer);
    }
}

