/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.cache.engine;

import dev.voidframework.cache.engine.CacheEngine;
import dev.voidframework.core.utils.KryoUtils;
import java.util.Arrays;
import java.util.Objects;

public abstract class AbstractCacheEngine
implements CacheEngine {
    protected AbstractCacheEngine() {
    }

    public CachedElement wrap(Object obj) {
        Class classType = obj != null ? obj.getClass() : Object.class;
        byte[] serializedContent = KryoUtils.serializeWithoutException((Object)obj);
        return new CachedElement(classType, serializedContent);
    }

    public Object unwrap(CachedElement cachedElement) {
        if (cachedElement == null) {
            return null;
        }
        return KryoUtils.deserializeWithoutException((byte[])cachedElement.content, cachedElement.classType);
    }

    public record CachedElement(Class<?> classType, byte[] content) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedElement that = (CachedElement)o;
            return this.classType.equals(that.classType) && Arrays.equals(this.content, that.content);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.classType);
            result = 31 * result + Arrays.hashCode(this.content);
            return result;
        }

        @Override
        public String toString() {
            return "CachedElement{classType='" + this.classType + "', content='<binaryOfLength=" + this.content.length + ">'}";
        }
    }
}

