/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.cache.module;

import dev.voidframework.cache.annotation.CacheRemove;
import dev.voidframework.cache.module.CacheInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public final class CacheInterceptorRemove
extends CacheInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (this.cacheEngine == null) {
            return methodInvocation.proceed();
        }
        CacheRemove cacheRemove = methodInvocation.getMethod().getAnnotation(CacheRemove.class);
        String cacheKey = this.resolveCacheKey(methodInvocation, cacheRemove.key());
        try {
            Object value = methodInvocation.proceed();
            if (cacheRemove.evictOn().length == 0) {
                this.cacheEngine.remove(cacheKey);
            }
            return value;
        }
        catch (Throwable throwable) {
            if (this.hasToEvict(cacheRemove, throwable.getClass())) {
                this.cacheEngine.remove(cacheKey);
            }
            throw throwable;
        }
    }

    private boolean hasToEvict(CacheRemove cacheRemove, Class<?> throwableClass) {
        for (Class noEvictOn : cacheRemove.noEvictOn()) {
            if (noEvictOn != throwableClass) continue;
            return false;
        }
        if (cacheRemove.evictOn().length == 0) {
            return true;
        }
        for (Class noEvictOn : cacheRemove.evictOn()) {
            if (noEvictOn != throwableClass) continue;
            return true;
        }
        return false;
    }
}

