/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.telenordigital.nbiot.ClientException;
import com.telenordigital.nbiot.Collection;
import com.telenordigital.nbiot.Config;
import com.telenordigital.nbiot.Device;
import com.telenordigital.nbiot.Output;
import com.telenordigital.nbiot.OutputDataMessage;
import com.telenordigital.nbiot.OutputStream;
import com.telenordigital.nbiot.Team;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;

public class Client {
    private static final Logger logger = Logger.getLogger(Client.class.getName());
    private static final String TOKEN_HEADER = "X-API-Token";
    private final String endpoint;
    private final String token;

    public Client() throws ClientException {
        Config cfg = new Config();
        this.token = cfg.token();
        this.endpoint = cfg.endpoint();
        this.ping();
    }

    public Client(String endpoint, String token) {
        this.endpoint = endpoint;
        this.token = token;
    }

    private void ping() throws ClientException {
        try {
            HttpResponse resp = Unirest.get((String)(this.endpoint + "/")).header(TOKEN_HEADER, this.token).asString();
            if (resp.getStatus() == 403) {
                throw new ClientException((String)resp.getBody(), resp.getStatus());
            }
        }
        catch (UnirestException ex) {
            throw new ClientException(ex);
        }
    }

    private <T> T get(String path, Class<T> cls) throws ClientException {
        try {
            return (T)Unirest.get((String)(this.endpoint + path)).header(TOKEN_HEADER, this.token).asObject(cls).getBody();
        }
        catch (UnirestException ue) {
            throw new ClientException(ue);
        }
    }

    private <T> T create(String path, T template, Class<T> cls) throws ClientException {
        try {
            return (T)Unirest.post((String)(this.endpoint + path)).header(TOKEN_HEADER, this.token).body(template).asObject(cls).getBody();
        }
        catch (UnirestException ue) {
            throw new ClientException(ue);
        }
    }

    private <T> T update(String path, T updated, Class<T> cls) throws ClientException {
        try {
            return (T)Unirest.patch((String)(this.endpoint + path)).header(TOKEN_HEADER, this.token).body(updated).asObject(cls).getBody();
        }
        catch (UnirestException ue) {
            throw new ClientException(ue);
        }
    }

    private void delete(String path) throws ClientException {
        try {
            Unirest.delete((String)(this.endpoint + path)).header(TOKEN_HEADER, this.token).asString();
        }
        catch (UnirestException ue) {
            throw new ClientException(ue);
        }
    }

    public Team team(String teamID) throws ClientException {
        return this.get("/teams/" + teamID, Team.class);
    }

    public Team[] teams() throws ClientException {
        return this.get("/teams", Team.TeamList.class).teams();
    }

    public Team createTeam(Team template) throws ClientException {
        return this.create("/teams", template, Team.class);
    }

    public Team updateTeam(Team team) throws ClientException {
        return this.update("/teams/" + team.id(), team, Team.class);
    }

    public void deleteTeam(String teamID) throws ClientException {
        this.delete("/teams/" + teamID);
    }

    public Collection collection(String collectionID) throws ClientException {
        return this.get("/collections/" + collectionID, Collection.class);
    }

    public Collection[] collections() throws ClientException {
        return this.get("/collections", Collection.CollectionList.class).collections();
    }

    public Collection createCollection(Collection template) throws ClientException {
        return this.create("/collections", template, Collection.class);
    }

    public Collection updateCollection(Collection collection) throws ClientException {
        return this.update("/collections/" + collection.id(), collection, Collection.class);
    }

    public void deleteCollection(String collectionID) throws ClientException {
        this.delete("/collections/" + collectionID);
    }

    public Device device(String collectionID, String deviceID) throws ClientException {
        return this.get("/collections/" + collectionID + "/devices/" + deviceID, Device.class);
    }

    public Device[] devices(String collectionID) throws ClientException {
        return this.get("/collections/" + collectionID + "/devices", Device.DeviceList.class).devices();
    }

    public Device createDevice(String collectionID, Device template) throws ClientException {
        return this.create("/collections/" + collectionID + "/devices", template, Device.class);
    }

    public Device updateDevice(String collectionID, Device device) throws ClientException {
        return this.update("/collections/" + collectionID + "/devices/" + device.id(), device, Device.class);
    }

    public void deleteDevice(String collectionID, String deviceID) throws ClientException {
        this.delete("/collections/" + collectionID + "/devices/" + deviceID);
    }

    public Output output(String collectionID, String outputID) throws ClientException {
        return this.get("/collections/" + collectionID + "/outputs/" + outputID, Output.class);
    }

    public Output[] outputs(String collectionID) throws ClientException {
        return this.get("/collections/" + collectionID + "/outputs", Output.OutputList.class).outputs();
    }

    public Output createOutput(String collectionID, Output template) throws ClientException {
        return this.create("/collections/" + collectionID + "/outputs", template, Output.class);
    }

    public Output updateOutput(String collectionID, Output output) throws ClientException {
        return this.update("/collections/" + collectionID + "/outputs/" + output.id(), output, Output.class);
    }

    public void deleteOutput(String collectionID, String outputID) throws ClientException {
        this.delete("/collections/" + collectionID + "/outputs/" + outputID);
    }

    public OutputStream collectionOutput(String collectionID, OutputHandler handler) throws ClientException {
        return this.output("/collections/" + collectionID, handler);
    }

    public OutputStream deviceOutput(String collectionID, String deviceID, OutputHandler handler) throws ClientException {
        return this.output("/collections/" + collectionID + "/devices/" + deviceID, handler);
    }

    private OutputStream output(String path, OutputHandler handler) throws ClientException {
        URI uri = null;
        String scheme = "wss";
        try {
            URI endpointURI = new URI(this.endpoint);
            if (endpointURI.getScheme().equals("http")) {
                scheme = "ws";
            }
            uri = new URI(scheme, null, endpointURI.getHost(), endpointURI.getPort(), path + "/from", null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new OutputStream(uri, this.token, handler);
    }

    static {
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)new com.mashape.unirest.http.ObjectMapper(){
            private ObjectMapper jacksonObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)this.jacksonObjectMapper.readValue(value, valueType);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public String writeValue(Object value) {
                try {
                    return this.jacksonObjectMapper.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static interface OutputHandler {
        public void onData(OutputDataMessage var1);

        public void onEnd();
    }
}

