/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.telenordigital.nbiot.Device;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableDevice
implements Device {
    @Nullable
    private final String id;
    @Nullable
    private final String collectionID;
    @Nullable
    private final String imei;
    @Nullable
    private final String imsi;
    @Nullable
    private final Map<String, String> tags;

    private ImmutableDevice(@Nullable String id, @Nullable String collectionID, @Nullable String imei, @Nullable String imsi, @Nullable Map<String, String> tags) {
        this.id = id;
        this.collectionID = collectionID;
        this.imei = imei;
        this.imsi = imsi;
        this.tags = tags;
    }

    @Override
    @JsonProperty(value="deviceId")
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="collectionId")
    @Nullable
    public String collectionID() {
        return this.collectionID;
    }

    @Override
    @JsonProperty(value="imei")
    @Nullable
    public String imei() {
        return this.imei;
    }

    @Override
    @JsonProperty(value="imsi")
    @Nullable
    public String imsi() {
        return this.imsi;
    }

    @Override
    @JsonProperty(value="tags")
    @Nullable
    public Map<String, String> tags() {
        return this.tags;
    }

    public final ImmutableDevice withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableDevice(value, this.collectionID, this.imei, this.imsi, this.tags);
    }

    public final ImmutableDevice withCollectionID(@Nullable String value) {
        if (Objects.equals(this.collectionID, value)) {
            return this;
        }
        return new ImmutableDevice(this.id, value, this.imei, this.imsi, this.tags);
    }

    public final ImmutableDevice withImei(@Nullable String value) {
        if (Objects.equals(this.imei, value)) {
            return this;
        }
        return new ImmutableDevice(this.id, this.collectionID, value, this.imsi, this.tags);
    }

    public final ImmutableDevice withImsi(@Nullable String value) {
        if (Objects.equals(this.imsi, value)) {
            return this;
        }
        return new ImmutableDevice(this.id, this.collectionID, this.imei, value, this.tags);
    }

    public final ImmutableDevice withTags(@Nullable Map<String, ? extends String> entries) {
        if (this.tags == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableDevice.createUnmodifiableMap(true, false, entries);
        return new ImmutableDevice(this.id, this.collectionID, this.imei, this.imsi, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDevice && this.equalTo((ImmutableDevice)another);
    }

    private boolean equalTo(ImmutableDevice another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.collectionID, another.collectionID) && Objects.equals(this.imei, another.imei) && Objects.equals(this.imsi, another.imsi) && Objects.equals(this.tags, another.tags);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.collectionID);
        h += (h << 5) + Objects.hashCode(this.imei);
        h += (h << 5) + Objects.hashCode(this.imsi);
        h += (h << 5) + Objects.hashCode(this.tags);
        return h;
    }

    public String toString() {
        return "Device{id=" + this.id + ", collectionID=" + this.collectionID + ", imei=" + this.imei + ", imsi=" + this.imsi + ", tags=" + this.tags + "}";
    }

    public static ImmutableDevice copyOf(Device instance) {
        if (instance instanceof ImmutableDevice) {
            return (ImmutableDevice)instance;
        }
        return new Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String collectionID;
        @Nullable
        private String imei;
        @Nullable
        private String imsi;
        private Map<String, String> tags = null;

        public final Builder from(Device instance) {
            Map<String, String> tagsValue;
            String imsiValue;
            String imeiValue;
            String collectionIDValue;
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.id();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((collectionIDValue = instance.collectionID()) != null) {
                this.collectionID(collectionIDValue);
            }
            if ((imeiValue = instance.imei()) != null) {
                this.imei(imeiValue);
            }
            if ((imsiValue = instance.imsi()) != null) {
                this.imsi(imsiValue);
            }
            if ((tagsValue = instance.tags()) != null) {
                this.putAllTags(tagsValue);
            }
            return this;
        }

        @JsonProperty(value="deviceId")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="collectionId")
        public final Builder collectionID(@Nullable String collectionID) {
            this.collectionID = collectionID;
            return this;
        }

        @JsonProperty(value="imei")
        public final Builder imei(@Nullable String imei) {
            this.imei = imei;
            return this;
        }

        @JsonProperty(value="imsi")
        public final Builder imsi(@Nullable String imsi) {
            this.imsi = imsi;
            return this;
        }

        public final Builder putTags(String key, String value) {
            if (this.tags == null) {
                this.tags = new LinkedHashMap<String, String>();
            }
            this.tags.put(Objects.requireNonNull(key, "tags key"), Objects.requireNonNull(value, "tags value"));
            return this;
        }

        public final Builder putTags(Map.Entry<String, ? extends String> entry) {
            if (this.tags == null) {
                this.tags = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.tags.put(Objects.requireNonNull(k, "tags key"), Objects.requireNonNull(v, "tags value"));
            return this;
        }

        @JsonProperty(value="tags")
        public final Builder tags(@Nullable Map<String, ? extends String> tags) {
            if (tags == null) {
                this.tags = null;
                return this;
            }
            this.tags = new LinkedHashMap<String, String>();
            return this.putAllTags(tags);
        }

        public final Builder putAllTags(Map<String, ? extends String> tags) {
            if (this.tags == null) {
                this.tags = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> entry : tags.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.tags.put(Objects.requireNonNull(k, "tags key"), Objects.requireNonNull(v, "tags value"));
            }
            return this;
        }

        public ImmutableDevice build() {
            return new ImmutableDevice(this.id, this.collectionID, this.imei, this.imsi, this.tags == null ? null : ImmutableDevice.createUnmodifiableMap(false, false, this.tags));
        }
    }
}

