/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.telenordigital.nbiot.Client;
import com.telenordigital.nbiot.OutputDataMessage;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public class OutputStream
extends Endpoint {
    private static final Logger logger = Logger.getLogger(OutputStream.class.getName());
    private final String token;
    private Client.OutputHandler handler = null;
    private Session session;
    private ObjectMapper jacksonObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public OutputStream(URI uri, String token, Client.OutputHandler handler) {
        this.token = token;
        this.handler = handler;
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)new Config()).build();
            this.session = container.connectToServer((Endpoint)this, config, uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.session.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String text) {
                try {
                    OutputDataMessage msg = (OutputDataMessage)OutputStream.this.jacksonObjectMapper.readValue(text, OutputDataMessage.class);
                    if (!msg.keepAlive()) {
                        OutputStream.this.handler.onData(msg);
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Error parsing message: {0}", e.toString());
                    logger.log(Level.WARNING, "Message was: {0}", text);
                }
            }
        });
    }

    public void onClose(Session session, CloseReason reason) {
        this.handler.onEnd();
    }

    public void onError(Session session, Throwable thr) {
        logger.log(Level.WARNING, "{0}", thr);
    }

    public class Config
    extends ClientEndpointConfig.Configurator {
        public void beforeRequest(Map<String, List<String>> headers) {
            headers.put("X-API-Token", Arrays.asList(OutputStream.this.token));
        }
    }
}

