package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Device.DeviceList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableDeviceList.Builder()}.
 */
@Generated(from = "Device.DeviceList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDeviceList implements Device.DeviceList {
  private final @Nullable Device[] devices;

  private ImmutableDeviceList(@Nullable Device[] devices) {
    this.devices = devices;
  }

  /**
   * @return A cloned {@code devices} array
   */
  @JsonProperty("devices")
  @Override
  public @Nullable Device[] devices() {
    return devices;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Device.DeviceList#devices() devices}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for devices
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeviceList withDevices(@Nullable Device... elements) {
    @Nullable Device[] newValue = elements == null ? null : elements.clone();
    return new ImmutableDeviceList(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeviceList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeviceList
        && equalTo((ImmutableDeviceList) another);
  }

  private boolean equalTo(ImmutableDeviceList another) {
    return Arrays.equals(devices, another.devices);
  }

  /**
   * Computes a hash code from attributes: {@code devices}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Arrays.hashCode(devices);
    return h;
  }

  /**
   * Prints the immutable value {@code DeviceList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeviceList{"
        + "devices=" + Arrays.toString(devices)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Device.DeviceList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeviceList instance
   */
  public static ImmutableDeviceList copyOf(Device.DeviceList instance) {
    if (instance instanceof ImmutableDeviceList) {
      return (ImmutableDeviceList) instance;
    }
    return new ImmutableDeviceList.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableDeviceList ImmutableDeviceList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Device.DeviceList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Device[] devices;

    /**
     * Creates a builder for {@link ImmutableDeviceList ImmutableDeviceList} instances.
     * <pre>
     * new ImmutableDeviceList.Builder()
     *    .devices(com.telenordigital.nbiot.Device[] | null) // nullable {@link Device.DeviceList#devices() devices}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeviceList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Device.DeviceList instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Device[] devicesValue = instance.devices();
      if (devicesValue != null) {
        devices(devicesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Device.DeviceList#devices() devices} attribute.
     * @param devices The elements for devices
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("devices")
    public final Builder devices(Device... devices) {
      this.devices = devices;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeviceList ImmutableDeviceList}.
     * @return An immutable instance of DeviceList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeviceList build() {
      return new ImmutableDeviceList(devices);
    }
  }
}
