package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Member}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableMember.Builder()}.
 */
@Generated(from = "Member", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableMember implements Member {
  private final @Nullable String userID;
  private final @Nullable String role;

  private ImmutableMember(
      @Nullable String userID,
      @Nullable String role) {
    this.userID = userID;
    this.role = role;
  }

  /**
   * The user's ID
   */
  @JsonProperty("userId")
  @Override
  public @Nullable String userID() {
    return userID;
  }

  /**
   * The user's role
   */
  @JsonProperty("role")
  @Override
  public @Nullable String role() {
    return role;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#userID() userID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userID (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withUserID(@Nullable String value) {
    if (Objects.equals(this.userID, value)) return this;
    return new ImmutableMember(value, this.role);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Member#role() role} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for role (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMember withRole(@Nullable String value) {
    if (Objects.equals(this.role, value)) return this;
    return new ImmutableMember(this.userID, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMember} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMember
        && equalTo((ImmutableMember) another);
  }

  private boolean equalTo(ImmutableMember another) {
    return Objects.equals(userID, another.userID)
        && Objects.equals(role, another.role);
  }

  /**
   * Computes a hash code from attributes: {@code userID}, {@code role}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(userID);
    h += (h << 5) + Objects.hashCode(role);
    return h;
  }

  /**
   * Prints the immutable value {@code Member} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Member{"
        + "userID=" + userID
        + ", role=" + role
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Member} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Member instance
   */
  public static ImmutableMember copyOf(Member instance) {
    if (instance instanceof ImmutableMember) {
      return (ImmutableMember) instance;
    }
    return new ImmutableMember.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableMember ImmutableMember}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Member", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String userID;
    private @Nullable String role;

    /**
     * Creates a builder for {@link ImmutableMember ImmutableMember} instances.
     * <pre>
     * new ImmutableMember.Builder()
     *    .userID(String | null) // nullable {@link Member#userID() userID}
     *    .role(String | null) // nullable {@link Member#role() role}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Member} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Member instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String userIDValue = instance.userID();
      if (userIDValue != null) {
        userID(userIDValue);
      }
      @Nullable String roleValue = instance.role();
      if (roleValue != null) {
        role(roleValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Member#userID() userID} attribute.
     * @param userID The value for userID (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userId")
    public final Builder userID(@Nullable String userID) {
      this.userID = userID;
      return this;
    }

    /**
     * Initializes the value for the {@link Member#role() role} attribute.
     * @param role The value for role (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("role")
    public final Builder role(@Nullable String role) {
      this.role = role;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMember ImmutableMember}.
     * @return An immutable instance of Member
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMember build() {
      return new ImmutableMember(userID, role);
    }
  }
}
