package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Output}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableOutput.Builder()}.
 */
@Generated(from = "Output", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableOutput implements Output {
  private final @Nullable String id;
  private final @Nullable String collectionID;
  private final @Nullable String type;
  private final @Nullable Map<String, Object> config;

  private ImmutableOutput(
      @Nullable String id,
      @Nullable String collectionID,
      @Nullable String type,
      @Nullable Map<String, Object> config) {
    this.id = id;
    this.collectionID = collectionID;
    this.type = type;
    this.config = config;
  }

  /**
   * The output's ID.
   */
  @JsonProperty("outputId")
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * The collection the output belongs to.
   */
  @JsonProperty("collectionId")
  @Override
  public @Nullable String collectionID() {
    return collectionID;
  }

  /**
   * The output's type.
   */
  @JsonProperty("type")
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   * The type-specific configuration.
   */
  @JsonProperty("config")
  @Override
  public @Nullable Map<String, Object> config() {
    return config;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Output#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutput withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableOutput(value, this.collectionID, this.type, this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Output#collectionID() collectionID} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for collectionID (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutput withCollectionID(@Nullable String value) {
    if (Objects.equals(this.collectionID, value)) return this;
    return new ImmutableOutput(this.id, value, this.type, this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Output#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutput withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableOutput(this.id, this.collectionID, value, this.config);
  }

  /**
   * Copy the current immutable object by replacing the {@link Output#config() config} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the config map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOutput withConfig(@Nullable Map<String, ? extends Object> entries) {
    if (this.config == entries) return this;
    @Nullable Map<String, Object> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableOutput(this.id, this.collectionID, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOutput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOutput
        && equalTo((ImmutableOutput) another);
  }

  private boolean equalTo(ImmutableOutput another) {
    return Objects.equals(id, another.id)
        && Objects.equals(collectionID, another.collectionID)
        && Objects.equals(type, another.type)
        && Objects.equals(config, another.config);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code collectionID}, {@code type}, {@code config}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(collectionID);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(config);
    return h;
  }

  /**
   * Prints the immutable value {@code Output} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Output{"
        + "id=" + id
        + ", collectionID=" + collectionID
        + ", type=" + type
        + ", config=" + config
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Output} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Output instance
   */
  public static ImmutableOutput copyOf(Output instance) {
    if (instance instanceof ImmutableOutput) {
      return (ImmutableOutput) instance;
    }
    return new ImmutableOutput.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOutput ImmutableOutput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Output", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String collectionID;
    private @Nullable String type;
    private Map<String, Object> config = null;

    /**
     * Creates a builder for {@link ImmutableOutput ImmutableOutput} instances.
     * <pre>
     * new ImmutableOutput.Builder()
     *    .id(String | null) // nullable {@link Output#id() id}
     *    .collectionID(String | null) // nullable {@link Output#collectionID() collectionID}
     *    .type(String | null) // nullable {@link Output#type() type}
     *    .config(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link Output#config() config}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Output} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Output instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String collectionIDValue = instance.collectionID();
      if (collectionIDValue != null) {
        collectionID(collectionIDValue);
      }
      @Nullable String typeValue = instance.type();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable Map<String, Object> configValue = instance.config();
      if (configValue != null) {
        putAllConfig(configValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Output#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("outputId")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Output#collectionID() collectionID} attribute.
     * @param collectionID The value for collectionID (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("collectionId")
    public final Builder collectionID(@Nullable String collectionID) {
      this.collectionID = collectionID;
      return this;
    }

    /**
     * Initializes the value for the {@link Output#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link Output#config() config} map.
     * @param key The key in the config map
     * @param value The associated value in the config map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putConfig(String key, Object value) {
      if (this.config == null) {
        this.config = new LinkedHashMap<String, Object>();
      }
      this.config.put(
          Objects.requireNonNull(key, "config key"),
          Objects.requireNonNull(value, "config value"));
      return this;
    }

    /**
     * Put one entry to the {@link Output#config() config} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putConfig(Map.Entry<String, ? extends Object> entry) {
      if (this.config == null) {
        this.config = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.config.put(
          Objects.requireNonNull(k, "config key"),
          Objects.requireNonNull(v, "config value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Output#config() config} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the config map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("config")
    public final Builder config(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.config = null;
        return this;
      }
      this.config = new LinkedHashMap<String, Object>();
      return putAllConfig(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Output#config() config} map. Nulls are not permitted
     * @param entries The entries that will be added to the config map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllConfig(Map<String, ? extends Object> entries) {
      if (this.config == null) {
        this.config = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.config.put(
            Objects.requireNonNull(k, "config key"),
            Objects.requireNonNull(v, "config value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableOutput ImmutableOutput}.
     * @return An immutable instance of Output
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOutput build() {
      return new ImmutableOutput(id, collectionID, type, config == null ? null : createUnmodifiableMap(false, false, config));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
