package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OutputDataMessageInternal}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableOutputDataMessageInternal.Builder()}.
 */
@Generated(from = "OutputDataMessageInternal", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableOutputDataMessageInternal
    implements OutputDataMessageInternal {
  private final String type;
  private final @Nullable Device device;
  private final @Nullable byte[] payload;
  private final @Nullable Long received;

  private ImmutableOutputDataMessageInternal(
      String type,
      @Nullable Device device,
      @Nullable byte[] payload,
      @Nullable Long received) {
    this.type = type;
    this.device = device;
    this.payload = payload;
    this.received = received;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  /**
   * @return The value of the {@code device} attribute
   */
  @JsonProperty("device")
  @Override
  public @Nullable Device device() {
    return device;
  }

  /**
   * @return A cloned {@code payload} array
   */
  @JsonProperty("payload")
  @Override
  public @Nullable byte[] payload() {
    return payload;
  }

  /**
   * @return The value of the {@code received} attribute
   */
  @JsonProperty("received")
  @Override
  public @Nullable Long received() {
    return received;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputDataMessageInternal#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputDataMessageInternal withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableOutputDataMessageInternal(newValue, this.device, this.payload, this.received);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputDataMessageInternal#device() device} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for device (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputDataMessageInternal withDevice(@Nullable Device value) {
    if (this.device == value) return this;
    return new ImmutableOutputDataMessageInternal(this.type, value, this.payload, this.received);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link OutputDataMessageInternal#payload() payload}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for payload
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOutputDataMessageInternal withPayload(@Nullable byte... elements) {
    @Nullable byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableOutputDataMessageInternal(this.type, this.device, newValue, this.received);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OutputDataMessageInternal#received() received} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for received (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOutputDataMessageInternal withReceived(@Nullable Long value) {
    if (Objects.equals(this.received, value)) return this;
    return new ImmutableOutputDataMessageInternal(this.type, this.device, this.payload, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOutputDataMessageInternal} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOutputDataMessageInternal
        && equalTo((ImmutableOutputDataMessageInternal) another);
  }

  private boolean equalTo(ImmutableOutputDataMessageInternal another) {
    return type.equals(another.type)
        && Objects.equals(device, another.device)
        && Arrays.equals(payload, another.payload)
        && Objects.equals(received, another.received);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code device}, {@code payload}, {@code received}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(device);
    h += (h << 5) + Arrays.hashCode(payload);
    h += (h << 5) + Objects.hashCode(received);
    return h;
  }

  /**
   * Prints the immutable value {@code OutputDataMessageInternal} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OutputDataMessageInternal{"
        + "type=" + type
        + ", device=" + device
        + ", payload=" + Arrays.toString(payload)
        + ", received=" + received
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OutputDataMessageInternal} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OutputDataMessageInternal instance
   */
  public static ImmutableOutputDataMessageInternal copyOf(OutputDataMessageInternal instance) {
    if (instance instanceof ImmutableOutputDataMessageInternal) {
      return (ImmutableOutputDataMessageInternal) instance;
    }
    return new ImmutableOutputDataMessageInternal.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOutputDataMessageInternal ImmutableOutputDataMessageInternal}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OutputDataMessageInternal", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String type;
    private @Nullable Device device;
    private @Nullable byte[] payload;
    private @Nullable Long received;

    /**
     * Creates a builder for {@link ImmutableOutputDataMessageInternal ImmutableOutputDataMessageInternal} instances.
     * <pre>
     * new ImmutableOutputDataMessageInternal.Builder()
     *    .type(String) // required {@link OutputDataMessageInternal#type() type}
     *    .device(com.telenordigital.nbiot.Device | null) // nullable {@link OutputDataMessageInternal#device() device}
     *    .payload(byte[] | null) // nullable {@link OutputDataMessageInternal#payload() payload}
     *    .received(Long | null) // nullable {@link OutputDataMessageInternal#received() received}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OutputDataMessageInternal} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OutputDataMessageInternal instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.type());
      @Nullable Device deviceValue = instance.device();
      if (deviceValue != null) {
        device(deviceValue);
      }
      @Nullable byte[] payloadValue = instance.payload();
      if (payloadValue != null) {
        payload(payloadValue);
      }
      @Nullable Long receivedValue = instance.received();
      if (receivedValue != null) {
        received(receivedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OutputDataMessageInternal#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputDataMessageInternal#device() device} attribute.
     * @param device The value for device (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("device")
    public final Builder device(@Nullable Device device) {
      this.device = device;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputDataMessageInternal#payload() payload} attribute.
     * @param payload The elements for payload
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("payload")
    public final Builder payload(byte... payload) {
      this.payload = payload;
      return this;
    }

    /**
     * Initializes the value for the {@link OutputDataMessageInternal#received() received} attribute.
     * @param received The value for received (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("received")
    public final Builder received(@Nullable Long received) {
      this.received = received;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOutputDataMessageInternal ImmutableOutputDataMessageInternal}.
     * @return An immutable instance of OutputDataMessageInternal
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOutputDataMessageInternal build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOutputDataMessageInternal(type, device, payload, received);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build OutputDataMessageInternal, some of required attributes are not set " + attributes;
    }
  }
}
